/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.api.data.IRefItem;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.data.utils.Gears;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.strategy.api.PositionNewServiceApi;
import cms.tmx.http.api.strategy.dto.AccntType;
import cms.tmx.http.api.strategy.dto.GetExtPositionsResp;
import cms.tmx.http.api.strategy.dto.GetPositionsReq;
import cms.tmx.http.api.strategy.dto.ObPosition;
import cms.tmx.http.api.strategy.dto.Position;
import cms.tmx.http.api.strategy.dto.PositionNew;
import cms.tmx.http.api.strategy.dto.Positions;
import cms.tmx.http.base.AccntLevel;
import cms.tmx.http.query.QueryFilter;
import cms.tmx.http.utils.GsonFactory;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import com.google.gson.Gson;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

@Creatable
@Singleton
public class NewPositionModel<T extends ObPosition>
extends MxModel {
    @Inject
    private EPartService eps;
    @Inject
    protected MEventService es;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    protected IMarketDataMng mktMng;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MScheduler sdSpecQuery;
    @Inject
    protected ExecutorService exe;
    @Inject
    protected CcsAccountMap accntMap;
    @Inject
    private HttpBaseApi baseApi;
    @Inject
    private PositionNewServiceApi api;
    private String marketGrp;
    private String marketIndicator = "";
    private List<String> markets = new LinkedList<String>();
    protected MxList<T> list = new MxList();
    protected Gson gson = GsonFactory.getInstance();
    protected static final int FULL_QUERY_INTERVAL = 3000;
    protected static final int SPEC_QUERY_INTERVAL = 1000;
    private MEventHandler handlerPush = event -> this.onPush(event);
    private MEventHandler handlerQueryPrice = event -> this.queryNewPrice();
    private MEventHandler handlerRequery = event -> this.query();

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.sdSpecQuery.setInterval(1000);
        this.es.subscribe("uap.push.PosEvent", this.handlerPush);
        this.es.subscribe("query_new_price", this.handlerQueryPrice);
        this.es.subscribe("requery_data", this.handlerRequery);
    }

    @PreDestroy
    private void destory() {
        this.es.unSubscribe("uap.push.PosEvent", this.handlerPush);
        this.es.unSubscribe("query_new_price", this.handlerQueryPrice);
        this.es.unSubscribe("requery_data", this.handlerRequery);
    }

    public void initQuery() {
        if (this.getList().isEmpty()) {
            this.query();
        } else {
            this.changed();
        }
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException e) {
                this.logger.error("full query position failed", (Throwable)e);
            }
            catch (Exception ee) {
                this.logger.error("full query position failed", (Throwable)ee);
            }
        });
    }

    private void fullQuery() throws MException, IOException {
        LinkedList<String> listId = new LinkedList<String>(this.getNewSecAccntIds());
        if (listId.isEmpty()) {
            return;
        }
        GetPositionsReq req = new GetPositionsReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGroup(this.getMarketGrp());
        if (this.getQueryFilter() != null) {
            req.setFilter(this.getQueryFilter());
        }
        req.setAccntType(AccntType.ACCNT_TYPE_SEC);
        req.setIncludeZero(Boolean.valueOf(false));
        req.setAccntLevel(AccntLevel.ACCNT_LEVEL_EXT);
        req.setAccntId(listId);
        String today = LocalDate.now().toString().replace("-", "");
        req.setStartDate(today);
        req.setEndDate(today);
        LinkedList<PositionNew> listResp = new LinkedList<PositionNew>();
        Page page = this.baseApi.getHttpDefPage();
        req.setPage(page);
        int startRow = page.getStartRow();
        GetExtPositionsResp resp = null;
        do {
            page.setStartRow(startRow);
            req.setPage(page);
            resp = this.api.getPositions(req);
            listResp.addAll(resp.getPosData());
            startRow += resp.getSize();
        } while (!resp.isLast());
        this.update(listResp);
    }

    protected void onPush(MEvent event) {
    }

    protected boolean careReport(Positions position) {
        if (AccntType.ACCNT_TYPE_SEC != position.getAccntType()) {
            return false;
        }
        return this.markets.contains(position.getInstrument().getMarket());
    }

    protected void update(List<PositionNew> listSrc) {
        this.changed();
    }

    protected void updatePosition(Position position) {
        this.changed();
    }

    public void queryNewPrice() {
        try {
            boolean isVisible = false;
            for (String partId : this.getParts()) {
                MPart findPart = this.eps.findPart(partId);
                if (findPart == null || !this.eps.isPartVisible(findPart)) continue;
                isVisible = true;
                this.logger.info(String.valueOf(partId) + "\u53ef\u89c1");
                break;
            }
            if (isVisible) {
                this.queryAndGetNewPrice(this.getList());
            } else {
                this.logger.info("\u65e0\u8d44\u91d1\u8d26\u53f7\u6301\u4ed3\u9875\u9762\u53ef\u89c1");
            }
        }
        catch (Exception e) {
            this.logger.error("\u6301\u4ed3\u8f6e\u8be2\u6700\u65b0\u4ef7\u5931\u8d25", (Throwable)e);
        }
    }

    protected List<String> getParts() {
        return new LinkedList<String>();
    }

    public void changed() {
        this.sdSpecQuery.schedule(event -> super.changed());
    }

    public synchronized void queryAndGetNewPrice(List<T> posList) {
        LinkedList<RefItem> listItem = new LinkedList<RefItem>();
        for (ObPosition posi : posList) {
            RefItem item = this.refMng.getItem(posi.getSecType(), posi.getMarket().getRaw(), posi.getSecurityId());
            if (item == null) continue;
            listItem.add(item);
        }
        Gears gears = new Gears();
        gears.setBuy(new int[]{0});
        if (!listItem.isEmpty()) {
            this.mktMng.queryNewPriceIn5Seconds(listItem, gears);
        }
        for (ObPosition posi : posList) {
            RefItem refItem = this.refMng.getItem(posi.getSecType(), posi.getMarket().getRaw(), posi.getSecurityId());
            if (refItem == null) {
                if ("STD_BOND".equals(posi.getSecType())) {
                    posi.setNowPrice(100.0);
                    posi.setClosePrice(100.0);
                }
            } else {
                MarketItem marketItem = this.mktMng.getInfo((IRefItem)refItem);
                if (marketItem != null) {
                    posi.setClosePrice(marketItem.getClosePrice());
                    if (marketItem.getNowPrice() == 0.0) {
                        posi.setNowPrice(marketItem.getClosePrice());
                    } else {
                        posi.setNowPrice(marketItem.getNowPrice());
                    }
                } else {
                    this.logger.error(String.valueOf(posi.getSecurityId()) + "\u6ca1\u6709\u83b7\u53d6\u5230\u52a8\u6001\u884c\u60c5");
                }
            }
            BigDecimal buy = new BigDecimal(posi.getBuyCost());
            double buyCost = buy.setScale(4, 4).doubleValue();
            if (posi.getNowPrice() == 0.0 || buyCost == 0.0 || "STD_BOND".equals(posi.getSecType())) {
                posi.setYield(0.0);
            } else {
                double yield = (posi.getNowPrice() - buyCost) * 100.0 / buyCost;
                posi.setYield(Double.parseDouble(StringUtils.toStr((double)yield, (int)2).replaceAll(",", "")));
            }
            BigDecimal b = new BigDecimal(posi.getCost());
            double cost = b.setScale(4, 4).doubleValue();
            if (posi.getNowPrice() == 0.0 || cost == 0.0 || "STD_BOND".equals(posi.getSecType())) {
                posi.setPercent(0.0);
            } else {
                double percent = (posi.getNowPrice() - cost) * 100.0 / cost;
                posi.setPercent(Double.parseDouble(StringUtils.toStr((double)percent, (int)2).replaceAll(",", "")));
            }
            if (refItem != null && posi.getNowPrice() != 0.0) {
                double capitalization = QueryUtils.calAmountByMarketAndSecType(posi.getMarket().getRaw(), posi.getSecType(), posi.getSecBalance(), posi.getNowPrice());
                posi.setMarketValue(this.formatScale(capitalization, 4));
            }
            posi.updateProfit();
        }
        this.changed();
    }

    private double formatScale(double d, int scale) {
        return new BigDecimal(d).setScale(scale, 4).doubleValue();
    }

    public Set<String> getNewSecAccntIds() {
        return this.accntMap.getNewSecAccntIds(new String[0]);
    }

    public QueryFilter getQueryFilter() {
        return null;
    }

    public List<String> getMarkets() {
        return this.markets;
    }

    public void setMarkets(String ... markets) {
        this.markets.addAll(Arrays.asList(markets));
    }

    public String getMarketGrp() {
        return this.marketGrp;
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGrp = marketGrp;
    }

    public String getMarketIndicator() {
        return this.marketIndicator;
    }

    public void setMarketIndicator(String marketIndicator) {
        this.marketIndicator = marketIndicator;
    }

    public T getPositionInMap(SecAccount account, String code) {
        return null;
    }

    public List<T> getList() {
        return this.list.getList();
    }
}

