/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.Result;
import cms.tmx.entity.factory.PositionFactory;
import cms.tmx.entity.notice.ExecutionReport;
import cms.tmx.entity.notice.MxNotice;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionExec;
import cms.tmx.entity.trade.instruction.ObInstruction;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.entity.web.resp.ResponseData;
import cms.tmx.entity.web.workflow.CancelWorkflowReq;
import cms.tmx.entity.web.workflow.ComplateTaskReq;
import cms.tmx.entity.web.workflow.ComplateTaskResp;
import cms.tmx.entity.web.workflow.WorkflowAttachment;
import cms.tmx.entity.web.workflow.WorkflowTask;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.base.AccntLevel;
import cms.tmx.http.base.AccountId;
import cms.tmx.http.instruction.api.ExecutionServiceApi;
import cms.tmx.http.instruction.api.InstructionServiceApi;
import cms.tmx.http.instruction.dto.AccntSecInfo;
import cms.tmx.http.instruction.dto.ConfirmExecutionReq;
import cms.tmx.http.instruction.dto.ExecTask;
import cms.tmx.http.instruction.dto.ExecuteTaskReq;
import cms.tmx.http.instruction.dto.TaskArgument;
import cms.tmx.http.workflow.api.WorkflowServiceApi;
import cms.tmx.http.workflow.dto.CompleteTaskNewReq;
import cms.tmx.http.workflow.dto.HttpInsPushMessage;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.mng.InstructionExecMng;
import cms.tmx.query.current.mng.NewInstructionMng;
import cms.tmx.query.current.models.OtcPortfolioAccountModel;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.web.api.workflow.WorkflowTemplateApi;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class NewInstructionModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(NewInstructionModel.class);
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MScheduler sdSpecQuery;
    private static final int FULL_QUERY_INTERVAL = 3000;
    private static final int SPEC_QUERY_INTERVAL = 1000;
    @Inject
    private NewInstructionMng insMng;
    private MEventHandler handler = event -> this.onPush(event);
    @Inject
    protected InstructionExecMng resourceDetailMng;
    @Inject
    protected PositionFactory fPos;
    @Inject
    protected IFundAccountService fundAccService;
    @Inject
    private HttpBaseApi httpBaseApi;
    private String marketGroup;
    @Inject
    private OtcPortfolioAccountModel portfModel;
    @Inject
    protected IFundAccountService faccService;
    @Inject
    protected MObjFactory of;
    protected MxList<ObInstruction> list = new MxList();
    @Inject
    protected MEventService es;
    @Inject
    @Named(value="base.path")
    private String pathBase;
    @Inject
    private WorkflowTemplateApi workflowApi;
    @Inject
    private InstructionServiceApi insApi;
    @Inject
    private ExecutionServiceApi execApi;
    @Inject
    private WorkflowServiceApi api;
    private Gson gson = new Gson();

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.sdSpecQuery.setInterval(1000);
        this.es.subscribe("uap.push.InsEvent", this.handler);
        this.es.subscribe("uap.push.TradeReport", e -> this.onERPush(e));
    }

    private void onERPush(MEvent e) {
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("server.sub", this.handler);
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                logger.error("instruction query failed", e);
            }
        });
    }

    private void runSpecQuery() {
        this.sdSpecQuery.schedule(event -> {
            try {
                this.specQuery();
            }
            catch (MException | Exception e) {
                logger.error("instruction query failed", e);
            }
        });
    }

    private void specQuery() throws MException {
        List<ObInstruction> listInstruction = this.insMng.queryToBeQuery();
        if (listInstruction.isEmpty()) {
            return;
        }
        this.updateDirty(listInstruction);
    }

    protected void updateDirty(List<ObInstruction> listInstruction) {
        this.list.updatePart(listInstruction);
        this.changed();
    }

    private void onPush(MEvent event) {
        this.onInstructionPush(event);
    }

    private void onInstructionPush(MEvent event) {
        JsonObject pushMsg = (JsonObject)event.getObj(JsonObject.class);
        logger.info("instruction push :" + pushMsg.toString());
        HttpInsPushMessage insPushMsg = (HttpInsPushMessage)this.gson.fromJson(pushMsg.toString(), HttpInsPushMessage.class);
        if (insPushMsg != null && insPushMsg.getInstruction() != null && "FundDetail".equals(insPushMsg.getInstruction().getType())) {
            ObInstruction obIns = new ObInstruction();
            obIns.setId(insPushMsg.getInstruction().getId());
            this.insMng.addToBeQuery(obIns);
            this.runSpecQuery();
        }
    }

    public void addToDirty(ObInstruction instruction) {
        this.insMng.addToBeQuery(instruction);
        this.runSpecQuery();
    }

    private void addToDirty(List<ObInstruction> dirtyList) {
        dirtyList.stream().forEach(each -> this.insMng.addToBeQuery((ObInstruction)each));
        this.runSpecQuery();
    }

    private void onExecutionPush(MEvent event) {
        String type;
        if (!(event.getObj() instanceof ExecutionReport)) {
            return;
        }
        ExecutionReport report = (ExecutionReport)ExecutionReport.class.cast(event.getObj());
        String resourceId = report.getReport().getResourceId();
        String instructionId = report.getReport().getReference();
        if (!this.careReport(instructionId, resourceId, type = Integer.toString(report.getType()))) {
            return;
        }
        ObInstruction ins = new ObInstruction();
        ins.setId(instructionId);
        this.insMng.addToBeQuery((MxNotice)report);
        this.runSpecQuery();
    }

    private boolean careReport(String instructionId, String resourceId, String type) {
        if (resourceId.isEmpty()) {
            return false;
        }
        return type.equals("52") || type.equals("56") || type.equals("70");
    }

    public void update(ObInstruction instruction, int actionId) throws MException {
    }

    private void fullQuery() throws MException {
        this.getList().update(this.insMng.query(this.portfModel.getPortfolioIds()));
        this.changed();
    }

    public MxList<ObInstruction> getList() {
        return this.list;
    }

    public String getMarketGrp() {
        return this.marketGroup;
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGroup = marketGrp;
    }

    protected String getUnit(String secType, String market) {
        return QueryUtils.getUnit(secType, market);
    }

    public void refreshResource(Instruction instruction) throws MException {
        this.udpateAvailableOrderQty(instruction);
    }

    public long udpateAvailableOrderQty(Instruction instruction) throws MException {
        long availableOrderQty = 0L;
        this.resourceDetailMng.setInstruction(instruction);
        List<InstructionExec> detailList = this.resourceDetailMng.query(2, "");
        if (instruction.isRegular()) {
            for (InstructionExec detail : detailList) {
                String secAcc = instruction.getOrderAdvice().isSub() ? detail.getSubSecAccntId() : detail.getExtSecAccntId();
                instruction.getOrderAdvice().getAccSecInfoList().forEach(each -> {
                    if (each.getSecAccntId().equals(secAcc)) {
                        each.setOrderAvailableQuantity(detail.getAvailableQty());
                    }
                });
            }
            for (cms.tmx.entity.trade.instruction.AccntSecInfo accntSecInfo : instruction.getOrderAdvice().getAccSecInfoList()) {
                availableOrderQty += accntSecInfo.getOrderAvailableQuantity();
            }
            instruction.getOrderAdvice().setOrderAvailableQuantity(availableOrderQty);
        } else if (instruction.isAlgo()) {
            for (InstructionExec detail : detailList) {
                String secAcc = instruction.getAlgoParam().isSub() ? detail.getSubSecAccntId() : detail.getExtSecAccntId();
                instruction.getAlgoParam().getAccSecInfoList().forEach(each -> {
                    if (each.getSecAccntId().equals(secAcc)) {
                        each.setOrderAvailableQuantity(detail.getAvailableQty());
                    }
                });
            }
            for (cms.tmx.entity.trade.instruction.AccntSecInfo accntSecInfo : instruction.getAlgoParam().getAccSecInfoList()) {
                availableOrderQty += accntSecInfo.getOrderAvailableQuantity();
            }
            instruction.getAlgoParam().setOrderAvailableQuantity(Long.valueOf(availableOrderQty).intValue());
        } else if (instruction.isBlock()) {
            instruction.getTrdCtrRptAdvice().setOrderAvailableQuantity(instruction.getResource().getAvailOrderQty());
        } else if (instruction.isFutures()) {
            long avail = 0L;
            for (InstructionExec detail : detailList) {
                String secAcc = detail.getExtSecAccntId();
                for (cms.tmx.entity.trade.instruction.AccntSecInfo each2 : instruction.getOrderAdvice().getAccSecInfoList()) {
                    if (!each2.getSecAccntId().equals(secAcc)) continue;
                    avail += detail.getAvailableQty();
                }
            }
            for (cms.tmx.entity.trade.instruction.AccntSecInfo each3 : instruction.getOrderAdvice().getAccSecInfoList()) {
                each3.setOrderAvailableQuantity(avail);
            }
            for (cms.tmx.entity.trade.instruction.AccntSecInfo accntSecInfo : instruction.getOrderAdvice().getAccSecInfoList()) {
                availableOrderQty += accntSecInfo.getOrderAvailableQuantity();
            }
            instruction.getOrderAdvice().setOrderAvailableQuantity(availableOrderQty);
        }
        return availableOrderQty;
    }

    public Result batchApprove(List<Instruction> instructionsCanBeApproved) {
        Result result = new Result();
        for (Instruction instruction : instructionsCanBeApproved) {
            try {
                result.operate(true);
            }
            catch (Exception e) {
                result.operate(false);
                logger.error("\u6279\u91cf\u5ba1\u6279\u4e2d" + instruction.getId() + "\u5ba1\u6279\u5931\u8d25: ", (Throwable)e);
            }
        }
        return result;
    }

    public void audit(ObInstruction instruction, String action, WorkflowTask task, List<WorkflowAttachment> attachments) throws MException {
        this.complateTask(instruction.getId(), instruction.getEntryId(), action, task, attachments);
    }

    public void audit(ObSimpleInstruction instruction, String action, WorkflowTask task, List<WorkflowAttachment> attachments) throws MException {
        this.complateTask(instruction.getId(), instruction.getEntryId(), action, task, attachments);
    }

    public void execInsTask(ObInstruction instruction) throws MException {
        ExecuteTaskReq req = new ExecuteTaskReq();
        req.setInstructionId(instruction.getId());
        ExecTask execTask = new ExecTask();
        execTask.setInstructionId(instruction.getId());
        TaskArgument taskArg = new TaskArgument();
        taskArg.setAccntLevel(AccntLevel.ACCNT_LEVEL_SUB);
        taskArg.setType("type.googleapis.com/proto.instruction.TaskArgument");
        taskArg.setInstrument(instruction.getOtcOrderDetail().getInstrument());
        taskArg.setOrderQty(instruction.getOtcOrderDetail().getOrderQty());
        taskArg.setPrice(instruction.getOtcOrderDetail().getPrice());
        taskArg.setSide(Side.valueOf((String)instruction.getSide()));
        AccountId accountId = new AccountId();
        accountId.setCashAccntId(((AccntSecInfo)instruction.getOtcOrderDetail().getAccntSecInfo().get(0)).getAccountId().getCashAccntId());
        accountId.setSecAccntId(((AccntSecInfo)instruction.getOtcOrderDetail().getAccntSecInfo().get(0)).getAccountId().getSecAccntId());
        taskArg.setAccountId(accountId);
        if ("SIDE_TRANSFER".equals(instruction.getSide())) {
            TaskArgument underlying = new TaskArgument();
            underlying.setAccntLevel(AccntLevel.ACCNT_LEVEL_SUB);
            underlying.setType("type.googleapis.com/proto.instruction.TaskArgument");
            underlying.setInstrument(instruction.getOtcOrderDetail().getUnderlying());
            underlying.setOrderQty(instruction.getOtcOrderDetail().getOrderQty());
            underlying.setPrice(instruction.getOtcOrderDetail().getPrice());
            underlying.setAccountId(accountId);
            taskArg.setSide(Side.SIDE_TRANSFER_OUT);
            underlying.setSide(Side.SIDE_TRANSFER_IN);
            execTask.setArgument(Arrays.asList(taskArg, underlying));
        } else {
            execTask.setArgument(Arrays.asList(taskArg));
        }
        req.getTask().add(execTask);
        this.insApi.execInstructionTask(req);
    }

    public void reject(ObInstruction instruction, String action, WorkflowTask task, List<WorkflowAttachment> attachments) throws MException {
        this.complateTask(instruction.getId(), instruction.getEntryId(), action, task, attachments);
    }

    public void confirm(ObInstruction instruction, String action, WorkflowTask task, List<WorkflowAttachment> attachments) throws MException {
        this.complateTask(instruction.getId(), instruction.getEntryId(), action, task, attachments);
    }

    public void complateTask(String instructionId, String entryId, String action, WorkflowTask task, List<WorkflowAttachment> attachments) throws MException {
        ComplateTaskResp auditRes;
        ResponseData resp;
        ComplateTaskReq req = new ComplateTaskReq();
        req.setTaskId(task.getTaskId());
        req.setOperate(action);
        req.setWorkflowId(entryId);
        if (attachments != null) {
            req.setAttachment(this.gson.toJson(attachments));
        }
        if ((resp = this.workflowApi.complateTask(req)).getRes() != null && !(auditRes = (ComplateTaskResp)this.gson.fromJson(resp.getRes().toString(), ComplateTaskResp.class)).isApproved()) {
            return;
        }
        ObInstruction obIns = new ObInstruction();
        obIns.setId(instructionId);
        this.insMng.addToBeQuery(obIns);
        this.runSpecQuery();
    }

    public void confirmExecution(ConfirmExecutionReq req) throws MException {
        this.execApi.confirmExecution(req);
    }

    public void cancel(ObInstruction instruction) throws MException {
        CancelWorkflowReq req = new CancelWorkflowReq();
        req.setWorkflowId(instruction.getEntryId());
        this.workflowApi.cancelWorkflow(req);
    }

    public void complateTaskNew(String instructionId, String entryId, String action, WorkflowTask task, List<WorkflowAttachment> attachments) throws MException {
        String resp;
        ComplateTaskResp auditRes;
        CompleteTaskNewReq req = new CompleteTaskNewReq();
        req.setTaskId(task.getTaskId());
        req.setOperate(action);
        req.setWorkflowId(entryId);
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        if (attachments != null) {
            req.setAttachment(this.gson.toJson(attachments));
        }
        if (!(auditRes = (ComplateTaskResp)this.gson.fromJson(resp = this.api.complateTaskNew(Arrays.asList(req)), ComplateTaskResp.class)).isApproved()) {
            return;
        }
        ObInstruction obIns = new ObInstruction();
        obIns.setId(instructionId);
        this.insMng.addToBeQuery(obIns);
        this.runSpecQuery();
    }
}

