/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Result;
import cms.tmx.entity.factory.PositionFactory;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.entity.web.resp.ResponseData;
import cms.tmx.entity.web.workflow.CancelWorkflowReq;
import cms.tmx.entity.web.workflow.ComplateTaskReq;
import cms.tmx.entity.web.workflow.ComplateTaskResp;
import cms.tmx.entity.web.workflow.WorkflowAttachment;
import cms.tmx.entity.web.workflow.WorkflowTask;
import cms.tmx.http.api.datahub.QueryType;
import cms.tmx.http.api.datahub.Type;
import cms.tmx.http.instruction.api.ExecutionServiceApi;
import cms.tmx.http.instruction.api.InstructionServiceApi;
import cms.tmx.http.instruction.dto.AccntSecInfo;
import cms.tmx.http.instruction.dto.ConfirmExecutionReq;
import cms.tmx.http.instruction.dto.GetLegDetailsReq;
import cms.tmx.http.instruction.dto.LegDetail;
import cms.tmx.http.workflow.dto.ExecJob;
import cms.tmx.http.workflow.dto.HttpInsPushMessage;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.mng.InstructionExecMng;
import cms.tmx.query.current.mng.NeeqInstructionMng;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.web.api.workflow.WorkflowTemplateApi;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class NeeqInstructionModel
extends MxModel {
    @Inject
    @Named(value="base.path")
    protected String pathBase;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MScheduler sdSpecQuery;
    @Inject
    protected NeeqInstructionMng insMng;
    @Inject
    protected InstructionExecMng resourceDetailMng;
    @Inject
    protected PositionFactory fPos;
    @Inject
    protected IFundAccountService fundAccService;
    @Inject
    protected IFundAccountService faccService;
    @Inject
    protected MObjFactory of;
    @Inject
    protected MEventService es;
    @Inject
    protected WorkflowTemplateApi workflowApi;
    @Inject
    protected InstructionServiceApi insApi;
    @Inject
    protected ExecutionServiceApi execApi;
    protected MxList<ObSimpleInstruction> list = new MxList();
    protected Gson gson = new Gson();
    protected String marketGroup;
    protected MEventHandler handler = event -> this.onPush(event);
    protected static final int FULL_QUERY_INTERVAL = 3000;
    protected static final int SPEC_QUERY_INTERVAL = 1000;

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.sdSpecQuery.setInterval(1000);
        this.es.subscribe("uap.push.InsEvent", this.handler);
    }

    @PreDestroy
    protected void close() {
        this.es.unSubscribe("uap.push.InsEvent", this.handler);
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                this.logger.error("instruction query failed", e);
            }
        });
    }

    protected void runSpecQuery() {
        this.sdSpecQuery.schedule(event -> {
            try {
                this.specQuery();
            }
            catch (MException | Exception e) {
                this.logger.error("instruction query failed", e);
            }
        });
    }

    protected void specQuery() throws MException {
        List<ObSimpleInstruction> listInstruction = this.getInsMng().queryToBeQuery();
        if (listInstruction.isEmpty()) {
            return;
        }
        this.updateDirty(listInstruction);
    }

    protected void updateDirty(List<ObSimpleInstruction> listInstruction) {
        this.list.updatePart(listInstruction);
        this.changed();
    }

    protected void onPush(MEvent event) {
        this.onInstructionPush(event);
    }

    protected void onInstructionPush(MEvent event) {
        JsonObject pushMsg = (JsonObject)event.getObj(JsonObject.class);
        this.logger.info("instruction push :" + pushMsg.toString());
        HttpInsPushMessage insPushMsg = (HttpInsPushMessage)this.gson.fromJson(pushMsg.toString(), HttpInsPushMessage.class);
        if (insPushMsg != null && insPushMsg.getInstruction() != null && "SimpleDetail".equals(insPushMsg.getInstruction().getType())) {
            ObSimpleInstruction obIns = new ObSimpleInstruction();
            obIns.setId(insPushMsg.getInstruction().getId());
            ObSimpleInstruction obNeeqInstruction = (ObSimpleInstruction)this.list.get((MxObject)obIns);
            if ("OTC".equals(insPushMsg.getMarketGroup())) {
                return;
            }
            if (obNeeqInstruction != null) {
                obNeeqInstruction.update((Object)insPushMsg);
            }
            this.getInsMng().addToBeQuery(obIns);
            this.runSpecQuery();
        }
    }

    public void addToDirty(ObSimpleInstruction instruction) {
        this.getInsMng().addToBeQuery(instruction);
        this.runSpecQuery();
    }

    protected void addToDirty(List<ObSimpleInstruction> dirtyList) {
        dirtyList.stream().forEach(each -> this.getInsMng().addToBeQuery((ObSimpleInstruction)each));
        this.runSpecQuery();
    }

    protected boolean careReport(String instructionId, String resourceId, String type) {
        if (resourceId.isEmpty()) {
            return false;
        }
        return type.equals("52") || type.equals("56") || type.equals("70");
    }

    public void update(ObSimpleInstruction instruction, int actionId) throws MException {
    }

    protected void fullQuery() throws MException {
        this.getList().update(this.getInsMng().query((List<FundAccount>)this.fundAccService.getFundAccountList(), "CCS"));
        this.changed();
    }

    public MxList<ObSimpleInstruction> getList() {
        return this.list;
    }

    public String getMarketGrp() {
        return this.marketGroup;
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGroup = marketGrp;
    }

    protected String getUnit(String secType, String market) {
        return QueryUtils.getUnit(secType, market);
    }

    public Result batchApprove(List<Instruction> instructionsCanBeApproved) {
        Result result = new Result();
        for (Instruction instruction : instructionsCanBeApproved) {
            try {
                result.operate(true);
            }
            catch (Exception e) {
                result.operate(false);
                this.logger.error("\u6279\u91cf\u5ba1\u6279\u4e2d" + instruction.getId() + "\u5ba1\u6279\u5931\u8d25: ", (Throwable)e);
            }
        }
        return result;
    }

    public void audit(ObSimpleInstruction instruction, String action, WorkflowTask task, List<WorkflowAttachment> attachments) throws MException {
        this.complateTask(instruction, action, task, attachments);
    }

    public void execInsTask(ObSimpleInstruction instruction) throws MException {
    }

    public void reject(ObSimpleInstruction instruction, String action, WorkflowTask task, List<WorkflowAttachment> attachments) throws MException {
        this.complateTask(instruction, action, task, attachments);
    }

    public void confirm(ObSimpleInstruction instruction, String action, WorkflowTask task, List<WorkflowAttachment> attachments) throws MException {
        this.complateTask(instruction, action, task, attachments);
    }

    public void complateTask(ObSimpleInstruction instruction, String action, WorkflowTask task, List<WorkflowAttachment> attachments) throws MException {
        ComplateTaskResp auditRes;
        ResponseData resp;
        ComplateTaskReq req = new ComplateTaskReq();
        req.setTaskId(task.getTaskId());
        req.setOperate(action);
        req.setWorkflowId(instruction.getEntryId());
        if (attachments != null) {
            req.setAttachment(this.gson.toJson(attachments));
        }
        if ((resp = this.workflowApi.complateTask(req)).getRes() != null && !(auditRes = (ComplateTaskResp)this.gson.fromJson(resp.getRes().toString(), ComplateTaskResp.class)).isApproved()) {
            return;
        }
        ObSimpleInstruction obIns = new ObSimpleInstruction();
        obIns.setId(instruction.getId());
        this.insMng.addToBeQuery(obIns);
        this.runSpecQuery();
    }

    public void confirmExecution(ConfirmExecutionReq req) throws MException {
        this.execApi.confirmExecution(req);
    }

    public void cancel(ObSimpleInstruction instruction) throws MException {
        CancelWorkflowReq req = new CancelWorkflowReq();
        req.setWorkflowId(instruction.getEntryId());
        this.workflowApi.cancelWorkflow(req);
    }

    public void udpateAvailableOrderQty(ObSimpleInstruction instruction) throws MException {
        GetLegDetailsReq req = new GetLegDetailsReq();
        req.setMarketGroup("CCS");
        req.setQueryType(QueryType.QUERY_TYPE_DETAIL);
        req.setType(Type.CURRENT);
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(instruction.getId());
        req.setInstructionId(ids);
        List legDetails = this.insApi.getLegDetails(req);
        List accSecInfo = instruction.getOrderDetail().getAccntSecInfo();
        long availableQty = 0L;
        for (AccntSecInfo accntSecInfo : accSecInfo) {
            for (LegDetail leg : legDetails) {
                if (!accntSecInfo.getAccountId().getCashAccntId().equals(leg.getExtCashAccntId()) || !accntSecInfo.getAccountId().getSecAccntId().equals(leg.getExtSecAccntId())) continue;
                if (instruction.isIsApproveStep()) {
                    accntSecInfo.setAvailableQty(leg.getTargetQty());
                    continue;
                }
                accntSecInfo.setAvailableQty(leg.getAvailOrderQty());
            }
            availableQty = (long)((double)availableQty + accntSecInfo.getAvailableQty());
        }
        if (instruction.getJobs() != null && instruction.getJobs().size() > 0) {
            ExecJob job = (ExecJob)instruction.getJobs().get(0);
            job.setAvailOrderQty((double)availableQty);
        }
        instruction.setAvailOrderQty(availableQty);
    }

    public NeeqInstructionMng getInsMng() {
        return this.insMng;
    }

    public void setInsMng(NeeqInstructionMng insMng) {
        this.insMng = insMng;
    }
}

