/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.http.api.strategy.api.AlgoOrderServiceApi;
import cms.tmx.http.api.strategy.dto.AlgoBaseOrder;
import cms.tmx.http.api.strategy.dto.EntrustInfo;
import cms.tmx.http.api.strategy.dto.ExecutionInfo;
import cms.tmx.http.api.strategy.dto.ExecutionReqInfo;
import cms.tmx.http.api.strategy.dto.QueryEntrustReq;
import cms.tmx.http.api.strategy.dto.QueryEntrustReqInfo;
import cms.tmx.http.api.strategy.dto.QueryEntrustRspInfo;
import cms.tmx.http.api.strategy.dto.QueryExecutionRep;
import cms.tmx.http.api.strategy.dto.QueryExecutionReq;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.javafx.MxModel;
import cms.tmx.query.margin.models.MarginOrderModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MarginAlgoDetailModel
extends MxModel {
    @Inject
    AlgoOrderServiceApi api;
    @Inject
    private MarginOrderModel ordModel;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MScheduler sdDealQuery;
    private static final int FULL_QUERY_INTERVAL = 3000;
    private AlgoBaseOrder baseOrder;
    List<EntrustInfo> orderList = new ArrayList<EntrustInfo>();
    List<ExecutionInfo> dealList = new ArrayList<ExecutionInfo>();

    @PostConstruct
    private void init() {
        this.sdFullQuery.setInterval(3000);
        this.sdDealQuery.setInterval(3000);
        this.query();
        this.queryDeal();
        this.ordModel.query();
    }

    public void query() {
        this.sdFullQuery.schedule(event -> this.fullQuery());
    }

    private void fullQuery() {
        QueryEntrustRspInfo order = new QueryEntrustRspInfo();
        this.orderList.clear();
        try {
            QueryEntrustReq req = new QueryEntrustReq();
            req.setAlgoOrderId(this.baseOrder.getAlgoOrderId());
            req.setReqInfo(new QueryEntrustReqInfo());
            req.getReqInfo().setAccount(this.baseOrder.getBizAcct());
            req.getReqInfo().setAlgoName(this.baseOrder.getAlgoName());
            order = this.api.algoEntrustQuery(req);
        }
        catch (MException | IOException e) {
            e.printStackTrace();
        }
        for (EntrustInfo info : order.getData()) {
            this.beforeAdd(info);
            this.orderList.add(info);
        }
        this.changed();
    }

    private void beforeAdd(EntrustInfo info) {
        List<SingleOrder> list = this.ordModel.getList();
        for (SingleOrder ord : list) {
            if (!info.getEntrustNo().equals(ord.getExtOrderId())) continue;
            info.setType(ord.getOrdTypeDesc());
            info.setUnit(ord.getUnit());
            info.setOrdAmt(ord.getOrderAmount());
            info.setFrozenAmt(ord.getFrozenMargin());
            info.setPercent(ord.getDonePercent());
            info.setAvgPrice(ord.getAvgPx());
            info.setUser(ord.getUserId());
            info.setUserName(ord.getUserName());
            break;
        }
    }

    public void queryDeal() {
        this.sdDealQuery.schedule(event -> this.fullQueryDeal());
    }

    private void fullQueryDeal() {
        QueryExecutionRep deal = new QueryExecutionRep();
        try {
            QueryExecutionReq req = new QueryExecutionReq();
            req.setAlgoOrderId(this.baseOrder.getAlgoOrderId());
            req.setReqInfo(new ExecutionReqInfo());
            req.getReqInfo().setAlgoName(this.baseOrder.getAlgoName());
            deal = this.api.algoExecutionQuery(req);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MException e) {
            e.printStackTrace();
        }
        for (ExecutionInfo info : deal.getRspInfo().getData()) {
            info.setEngineName(deal.getEngineName());
            this.dealList.add(info);
        }
        this.changed();
    }

    public AlgoBaseOrder getBaseOrder() {
        return this.baseOrder;
    }

    public void SetBaseOrder(AlgoBaseOrder baseOrder) {
        this.baseOrder = baseOrder;
    }

    public List<EntrustInfo> getList() {
        return this.orderList;
    }

    public List<ExecutionInfo> getDealList() {
        return this.dealList;
    }
}

