/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.http.accnt.AccountServiceApi;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.ISecAccountService;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.query.current.models.CcsAccountMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MarginAccountMap
extends MxModel {
    @Inject
    private ISecAccountService secAccService;
    private Map<CcsFundAccount, List<SecAccount>> marginMapAccount = FxUtils.newMap();
    private Map<String, CcsFundAccount> mapFundAcc = new HashMap<String, CcsFundAccount>();
    private Map<String, SecAccount> mapSecAcc = new HashMap<String, SecAccount>();
    private Map<String, CcsFundAccount> mapExtFundAcc = new HashMap<String, CcsFundAccount>();
    private Map<String, SecAccount> mapExtSecAcc = new HashMap<String, SecAccount>();
    private Map<String, CcsFundAccount> marginAccountMap = FxUtils.newMap();
    private Map<String, SecAccount> marginSecAccountMap = FxUtils.newMap();
    private static final Logger logger = LogManager.getLogger(CcsAccountMap.class);
    private MEventHandler handler = event -> this.initAccount(event);
    @Inject
    private FundAccountMngServiceImpl fundService;
    @Inject
    private AccountServiceApi secServiceApi;
    @Inject
    private HttpBaseApi apiBase;
    @Inject
    private MEventService es;
    private MxList<SecAccount> listNewSecAccnt = new MxList();

    @PostConstruct
    public void init() {
        this.es.subscribe("stage.after.login", this.handler);
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("stage.after.login", this.handler);
    }

    private void initAccount(MEvent event) {
        try {
            Map<CcsFundAccount, List<SecAccount>> mapAcc = this.getAccountMap();
            for (CcsFundAccount fund : mapAcc.keySet()) {
                if (mapAcc.get(fund) == null || mapAcc.get(fund).size() == 0) continue;
                this.mapFundAcc.put(fund.getInvestId(), fund);
                this.mapExtFundAcc.put(fund.getNewCashAccntId(), fund);
                for (SecAccount sec : mapAcc.get(fund)) {
                    this.mapSecAcc.put(sec.getInverstorSecId(), sec);
                    this.mapExtSecAcc.put(sec.getExtSecAccntId(), sec);
                }
            }
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public synchronized Map<CcsFundAccount, List<SecAccount>> getAccountMap() throws MException {
        LinkedList list = new LinkedList();
        if (this.marginMapAccount.isEmpty()) {
            logger.info("create margin account map");
            Map mapAccount = this.secAccService.getMarginSecAccountMap();
            mapAccount.keySet().forEach(account -> {
                CcsFundAccount ccsAccount;
                if ("99999-02-01".equals(account.getCounterId()) && "CCS".equals(account.getMarketGrp()) && account instanceof CcsFundAccount && !account.isExternalAsset()) {
                    ccsAccount = (CcsFundAccount)CcsFundAccount.class.cast(account);
                    this.marginMapAccount.put(ccsAccount, (List)mapAccount.get(account));
                    list.add(ccsAccount.getParentId());
                }
                if ("99999-02-02".equals(account.getCounterId()) && "CCS".equals(account.getMarketGrp()) && account instanceof CcsFundAccount && !account.isExternalAsset()) {
                    ccsAccount = (CcsFundAccount)CcsFundAccount.class.cast(account);
                    this.marginMapAccount.put(ccsAccount, (List)mapAccount.get(account));
                    list.add(ccsAccount.getParentId());
                }
                if ("99999-02-03".equals(account.getCounterId()) && "CCS".equals(account.getMarketGrp()) && account instanceof CcsFundAccount && !account.isExternalAsset()) {
                    ccsAccount = (CcsFundAccount)CcsFundAccount.class.cast(account);
                    this.marginMapAccount.put(ccsAccount, (List)mapAccount.get(account));
                    list.add(ccsAccount.getParentId());
                }
            });
            MEvent event = new MEvent();
            event.put((Object)"MARGIN_ACCNT", list);
            this.es.postEvent("margin.accnt.sub", event);
        }
        return this.marginMapAccount;
    }

    public CcsFundAccount getFundAcc(String investorId) {
        return this.mapFundAcc.get(investorId);
    }

    public SecAccount getSecAcc(String investorSecId) {
        return this.mapSecAcc.get(investorSecId);
    }

    public List<String> getFundAccList() {
        ArrayList<String> list = new ArrayList<String>();
        this.mapFundAcc.keySet().forEach(each -> {
            boolean bl = list.add((String)each);
        });
        return list;
    }

    public List<String> getExtAccList() throws MException {
        ArrayList<String> list = new ArrayList<String>();
        this.getAccountMap().keySet().forEach(each -> {
            boolean bl = list.add(each.getNewCashAccntId());
        });
        return list;
    }

    public List<String> getSecAccIdList(String fundAccId) throws MException {
        ArrayList<String> list = new ArrayList<String>();
        CcsFundAccount account = this.getFundAcc(fundAccId);
        for (SecAccount sec : this.getAccountMap().get(account)) {
            list.add(sec.getInverstorSecId());
        }
        return list;
    }

    public List<SecAccount> getSecAccntsByFundAccnt(FundAccount accnt) throws MException {
        List<SecAccount> secAccnts = this.getAccountMap().get(accnt);
        if (secAccnts == null) {
            return new ArrayList<SecAccount>();
        }
        return secAccnts;
    }

    public SecAccount getSecAccntByFundAccnt(FundAccount accnt, String market) throws MException {
        List<SecAccount> secAccnts = this.getAccountMap().get(accnt);
        if (secAccnts == null) {
            return new SecAccount();
        }
        for (SecAccount secAccount : secAccnts) {
            if (!market.equals(secAccount.getExchange().getRaw())) continue;
            return secAccount;
        }
        return new SecAccount();
    }

    public synchronized Map<String, CcsFundAccount> getCcsAccountMap() {
        if (this.marginAccountMap.isEmpty()) {
            try {
                Map mapAccount = this.secAccService.getSecAccountMap();
                mapAccount.keySet().forEach(account -> {
                    if (account.getMarketGrp().equals("CCS") && account instanceof CcsFundAccount && !account.isExternalAsset()) {
                        CcsFundAccount ccsAccount = (CcsFundAccount)CcsFundAccount.class.cast(account);
                        this.marginAccountMap.put(ccsAccount.getNewCashAccntId(), ccsAccount);
                    }
                });
            }
            catch (MException e) {
                logger.error("\u83b7\u53d6\u4e00\u7ea7\u8d44\u91d1\u8d26\u53f7map\u5931\u8d25", (Throwable)e);
            }
        }
        return this.marginAccountMap;
    }

    public synchronized Map<String, SecAccount> getCcsSecAccountMap() {
        if (this.marginSecAccountMap.isEmpty()) {
            try {
                Map mapAccount = this.secAccService.getMarginSecAccountMap();
                mapAccount.keySet().forEach(account -> {
                    if (account.getMarketGrp().equals("CCS") && account instanceof CcsFundAccount && !account.isExternalAsset()) {
                        List secList = (List)mapAccount.get(account);
                        secList.forEach(sec -> this.marginSecAccountMap.put(sec.getExtSecAccntId(), (SecAccount)sec));
                    }
                });
            }
            catch (MException e) {
                logger.error("\u83b7\u53d6\u4e00\u7ea7\u8bc1\u5238\u8d26\u53f7map\u5931\u8d25", (Throwable)e);
            }
        }
        return this.marginSecAccountMap;
    }

    public String getCcsInvestId(String extAccntId) {
        CcsFundAccount account = this.getCcsAccountMap().get(extAccntId);
        if (account != null && !account.getInvestId().isEmpty()) {
            return account.getInvestId();
        }
        return extAccntId;
    }

    public String getCcsInverstorSecId(String extSecAccntId) {
        SecAccount account = this.getCcsSecAccountMap().get(extSecAccntId);
        if (account != null && !account.getInverstorSecId().isEmpty()) {
            return account.getInverstorSecId();
        }
        return extSecAccntId;
    }

    public Set<String> getInvestorSecIds() {
        Collection<SecAccount> secAccs = this.getCcsSecAccountMap().values();
        HashSet<String> ids = new HashSet<String>();
        for (SecAccount sec : secAccs) {
            ids.add(sec.getInverstorSecId());
        }
        return ids;
    }

    public String getExtSecAccntId(String investorSecId) {
        SecAccount account = this.getSecAcc(investorSecId);
        if (account != null && !account.getExtSecAccntId().isEmpty()) {
            return account.getExtSecAccntId();
        }
        return "";
    }

    public String getMarginInvestorSec(String extSecAccntId) {
        SecAccount account;
        if (this.mapExtSecAcc.isEmpty()) {
            this.initAccount(null);
        }
        if ((account = this.mapExtSecAcc.get(extSecAccntId)) != null && !account.getInverstorSecId().isEmpty()) {
            return account.getInverstorSecId();
        }
        return extSecAccntId;
    }

    public List<String> getParentId() throws MException {
        ArrayList<String> list = new ArrayList<String>();
        this.getAccountMap().keySet().forEach(each -> {
            boolean bl = list.add(each.getParentId());
        });
        return list;
    }
}

