/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.javafx.MxModel;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

@Creatable
@Singleton
public class InstructionShortcutModel
extends MxModel {
    @Inject
    private EPartService eps;
    @Inject
    private EModelService ms;
    @Inject
    private MApplication app;
    private StringProperty keyCode = new SimpleStringProperty("");
    private StringProperty selectedPart = new SimpleStringProperty("");
    private List<TextField> listSearch = new LinkedList<TextField>();

    @PostConstruct
    public void init() {
        MWindow mainWin = (MWindow)this.ms.findElements((MUIElement)this.app, "cms.tmx.twin.main", MWindow.class, null).get(0);
        Stage stage = (Stage)mainWin.getContext().get(Stage.class);
        stage.addEventFilter(KeyEvent.ANY, keyEvent -> this.shortPart((KeyEvent)keyEvent));
    }

    private boolean checkPartstack(String avtivePart) {
        for (TextField txt : this.listSearch) {
            if (!txt.isFocused()) continue;
            return false;
        }
        switch (avtivePart) {
            case "cms.tmx.instructions.cp.shortcut": 
            case "cms.tmx.instructions.part.shortcut.unfinished.query": 
            case "cms.tmx.instructions.part.shortcut.instruct.query": 
            case "cms.tmx.instructions.part.shortcut.position.query": 
            case "cms.tmx.instructions.part.shortcut.basketorder.query": 
            case "cms.tmx.instructions.part.shortcut.account.query": 
            case "cms.tmx.instructions.part.shortcut.deal.query": 
            case "cms.tmx.instructions.part.shortcut.ordersum.query": 
            case "cms.tmx.instructions.part.shortcut.order.query": {
                return true;
            }
        }
        return false;
    }

    private MPart findPart(String partId, String nowId) {
        MPart newPart = null;
        if (!partId.equals(nowId)) {
            newPart = this.eps.findPart(partId);
        }
        return newPart;
    }

    private void shortPart(KeyEvent keyEvent) {
        MPart activePart = this.eps.getActivePart();
        String nowId = activePart.getElementId();
        if (!this.checkPartstack(nowId)) {
            return;
        }
        String key = keyEvent.getText().toUpperCase();
        MPart newPart = null;
        boolean change = false;
        switch (key) {
            case "1": {
                newPart = this.findPart("cms.tmx.instructions.part.shortcut.instruct.query", nowId);
                break;
            }
            case "2": {
                newPart = this.findPart("cms.tmx.instructions.part.shortcut.order.query", nowId);
                break;
            }
            case "3": {
                newPart = this.findPart("cms.tmx.instructions.part.shortcut.deal.query", nowId);
                break;
            }
            case "4": {
                newPart = this.findPart("cms.tmx.instructions.part.shortcut.account.query", nowId);
                break;
            }
            case "5": {
                newPart = this.findPart("cms.tmx.instructions.part.shortcut.unfinished.query", nowId);
                break;
            }
            case "C": {
                newPart = this.findPart("cms.tmx.instructions.part.shortcut.position.query", nowId);
                break;
            }
            case "T": {
                newPart = this.findPart("cms.tmx.instructions.part.shortcut.ordersum.query", nowId);
                break;
            }
            case "S": {
                newPart = this.findPart("cms.tmx.instructions.part.shortcut.basketorder.query", nowId);
                break;
            }
            case "8": 
            case "E": 
            case "F": 
            case "K": 
            case "M": 
            case "R": 
            case "W": {
                MPart instQuery = this.eps.findPart("cms.tmx.instructions.part.shortcut.instruct.query");
                if (!activePart.equals(instQuery)) break;
                change = true;
            }
        }
        if (newPart != null) {
            this.eps.showPart(newPart, EPartService.PartState.ACTIVATE);
            this.selectedPart.set((Object)newPart.getElementId());
        }
        if (change) {
            this.keyCode.set((Object)key);
            this.changed();
        }
    }

    public String getKeyCode() {
        return (String)this.keyCode.get();
    }

    public StringProperty keyCodeProperty() {
        return this.keyCode;
    }

    public String getSelectedPart() {
        return (String)this.selectedPart.get();
    }

    public StringProperty selectedPartProperty() {
        return this.selectedPart;
    }

    public void addSearch(TextField tf) {
        this.listSearch.add(tf);
    }

    public void removeSearch(TextField tf) {
        this.listSearch.remove(tf);
    }
}

