/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.api.data.IRefItem;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.data.utils.Gears;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.notice.ExecutionReport;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.Order;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.query.current.mng.OrderMng;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.OrderModel;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.history.ICcsOrderHisService;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionOrderModel
extends OrderModel<Order> {
    private FundAccount fundAccount;
    private Instruction instruction;
    private int type;
    @Inject
    private PortfolioAccountModel portAccModel;
    @Inject
    private ICcsOrderHisService ccsOrderHisService;
    private Map<String, OrderMng> instQuery = new HashMap<String, OrderMng>();
    protected static final Logger logger = LogManager.getLogger(InstructionOrderModel.class);
    private static final String DELIMITER = ",";
    @Inject
    private CcsAccountMap accMng;
    @Inject
    private IRefDataMng refMng;
    @Inject
    protected IMarketDataMng marketMng;
    private static final String FORMAT_HOUR = "yyyyMMdd HH:mm:ss";
    private DateTimeFormatter formatHour = DateTimeFormatter.ofPattern("yyyyMMdd HH:mm:ss");

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public void fullQuery() throws MException {
        String raw;
        LinkedList<Order> listOrder = new LinkedList();
        HashSet<String> accntIdSet = new HashSet<String>();
        if (this.instruction == null) {
            return;
        }
        switch (raw = this.instruction.getType().getRaw()) {
            case "2": 
            case "3": 
            case "64": {
                if (this.instruction.getOrderAdvice() == null) break;
                this.instruction.getOrderAdvice().getAccSecInfoList().forEach(item -> accntIdSet.add(item.getAccntId()));
                break;
            }
            case "4": 
            case "5": 
            case "12": 
            case "13": {
                if (this.instruction.getBasketOrderAdvice() == null) break;
                if (!StringUtils.isEmpty((String)this.instruction.getPortfolioId())) {
                    this.instruction.getBasketOrderAdvice().getItemList().forEach(item -> accntIdSet.add(item.getSubAccntId()));
                    break;
                }
                if (StringUtils.isEmpty((String)this.instruction.getProductId())) break;
                this.instruction.getBasketOrderAdvice().getItemList().forEach(item -> accntIdSet.add(item.getExtAccntId()));
                break;
            }
            case "8": 
            case "9": {
                if (this.instruction.getAlgoParam() == null) break;
                this.instruction.getAlgoParam().getAccSecInfoList().forEach(item -> accntIdSet.add(item.getAccntId()));
                break;
            }
            case "16": {
                String investorId = this.instruction.getAdjustPosAdvice().getInvestorId();
                String accntId = this.accMng.getFundAcc(investorId).getExtAccntId();
                accntIdSet.add(accntId);
                break;
            }
            case "17": {
                String subFundAccntId = this.instruction.getAdjustPosAdvice().getInvestorId();
                CcsSubFundAccount subFund = this.portAccModel.getFundAccount(subFundAccntId, "CCS");
                accntIdSet.add(subFund.getSubAccntId());
                break;
            }
            case "32": {
                if (this.instruction.getTrdCtrRptAdvice() == null) break;
                this.instruction.getTrdCtrRptAdvice().getAccSecInfoList().forEach(item -> accntIdSet.add(item.getAccntId()));
                break;
            }
        }
        listOrder = this.queryOrder(accntIdSet);
        this.update(listOrder);
    }

    private List<Order> queryOrder(Set<String> accntIdSet) throws MException {
        LinkedList<Order> listOrder = new LinkedList<Order>();
        if (accntIdSet.isEmpty()) {
            return listOrder;
        }
        Set<Order> setQuery = null;
        LocalDate now = LocalDate.now();
        LocalDate begin = LocalDate.parse(this.instruction.getBeginTime(), this.formatHour);
        if (begin.isEqual(now)) {
            for (String accId : accntIdSet) {
                if (!StringUtils.isEmpty((String)this.instruction.getPortfolioId())) {
                    this.setSubAccount(accId);
                } else {
                    this.setAccount(accId);
                }
                OrderMng orderMng = this.getQuery(this.fundAccount);
                if (orderMng == null) continue;
                setQuery = orderMng.queryInstrustion(this.isUnfinishedOrder);
                listOrder.addAll(setQuery);
            }
        } else {
            String beginDate = begin.toString().replaceAll("-", "");
            String endDate = now.toString().replaceAll("-", "");
            setQuery = StringUtils.isEmpty((String)this.instruction.getPortfolioId()) ? this.ccsOrderHisService.queryInstuctionOrder(new ArrayList<String>(accntIdSet), "1", this.instruction, beginDate, endDate) : this.ccsOrderHisService.queryInstuctionOrder(new ArrayList<String>(accntIdSet), "2", this.instruction, beginDate, endDate);
            listOrder.addAll(setQuery);
        }
        return listOrder;
    }

    @Override
    public synchronized OrderMng getQuery(FundAccount fundAccount) {
        if (fundAccount == null || this.instruction == null || this.instruction.getResource() == null || !fundAccount.getMarketGrp().equals(this.getMarketGrp())) {
            return null;
        }
        String key = String.join((CharSequence)DELIMITER, this.instruction.getId(), fundAccount.getExtAccntId());
        if (this.instQuery.containsKey(key)) {
            return this.instQuery.get(key);
        }
        OrderMng query = (OrderMng)((Object)this.of.create(OrderMng.class));
        query.setFund(fundAccount);
        if (fundAccount instanceof CcsSubFundAccount) {
            query.setSubAccId(((CcsSubFundAccount)fundAccount).getSubAccntId());
        } else {
            query.setSubAccId("");
        }
        query.setResourceId(this.instruction.getResource().getId());
        query.setReference(this.instruction.getId());
        this.instQuery.put(key, query);
        return query;
    }

    @Override
    protected void onPush(MEvent event) {
        if (!(event.getObj() instanceof ExecutionReport)) {
            return;
        }
        ExecutionReport report = (ExecutionReport)ExecutionReport.class.cast(event.getObj());
        String market = report.getReport().getInstrument().getMarket();
        String marketGroup = MarketUtils.getMarketGroup((String)market);
        String type = Integer.toString(report.getType());
        String id = report.getReport().getOrderId();
        String date = report.getReport().getTradeDate();
        Order order = this.fOrder.create(marketGroup);
        order.setSysOrderId(id);
        order.setOrdDate(date);
        if (!this.careReport(marketGroup, type)) {
            return;
        }
        if (StringUtils.isEmpty((String)report.getReport().getReference()) || this.instruction == null || !this.instruction.getId().equals(report.getReport().getReference())) {
            return;
        }
        if (!StringUtils.isEmpty((String)report.getReport().getSubAccntId())) {
            this.setSubAccount(report.getReport().getSubAccntId());
        } else {
            this.setAccount(report.getReport().getExtAccntId());
        }
        OrderMng query = this.getQuery(this.fundAccount);
        if (query != null) {
            query.addToBeQuery(report);
        }
        this.runSpecQuery();
    }

    @Override
    protected void specQuery() throws MException {
        LinkedList<Order> listOrder = new LinkedList<Order>();
        for (OrderMng orderMng : this.instQuery.values()) {
            List<Order> listQuery = null;
            try {
                listQuery = orderMng.queryToBeQuery(false);
            }
            catch (MException e) {
                logger.error("query fund account order failed: ", (Throwable)e);
            }
            if (listQuery == null) continue;
            listOrder.addAll(listQuery);
        }
        this.updateDirty(listOrder);
    }

    @Override
    public ObservableList<Order> getList() {
        return this.list.getList();
    }

    @Override
    protected synchronized void update(List<Order> listOrder) {
        this.list.setAll(this.updateOrder(listOrder));
        this.changed();
    }

    private List<Order> updateOrder(List<Order> listOrder) {
        LinkedList<Order> listInstructionOrder = new LinkedList<Order>();
        for (Order order : listOrder) {
            if (order instanceof CcsOrder) {
                CcsOrder ccs = (CcsOrder)CcsOrder.class.cast(order);
                this.queryModel.getOrderPrice((Order)ccs);
                this.queryModel.afterUpdate(ccs);
                listInstructionOrder.add((Order)ccs);
                continue;
            }
            if (!(order instanceof CtpOrder)) continue;
            CtpOrder ctp = (CtpOrder)CtpOrder.class.cast(order);
            this.queryModel.getOrderPrice(order);
            this.queryModel.afterUpdate(ctp);
            listInstructionOrder.add((Order)ctp);
        }
        return listInstructionOrder;
    }

    @Override
    protected synchronized void updateDirty(List<Order> listOrder) {
        this.list.updatePart(this.updateOrder(listOrder));
        this.changed();
    }

    public FundAccount getFundAccount() {
        return this.fundAccount;
    }

    private void setSubAccount(String subAccntId) {
        this.fundAccount = this.portAccModel.getSubFundAccountById(subAccntId);
    }

    public void setAccount(String accntId) {
        if ("CCS".equals(this.getMarketGrp())) {
            this.fundAccount = (FundAccount)this.ccsAccSecMap.getCcsAccountMap().get(accntId);
        } else if ("FUTURES".equals(this.getMarketGrp())) {
            this.fundAccount = (FundAccount)this.ctpAccSecMap.getCtpAccountMap().get(accntId);
        }
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(Instruction instruction) {
        this.instruction = instruction;
    }

    public void setInstruction(Instruction instruction, int type, String marketGrp) {
        this.instruction = instruction;
        this.type = type;
        this.setMarketGrp(marketGrp);
    }

    public int getType() {
        return this.type;
    }

    public void queryNewPrice() {
        try {
            this.queryAndGetNewPrice();
        }
        catch (Exception e) {
            logger.error("\u6301\u4ed3\u8f6e\u8be2\u6700\u65b0\u4ef7\u5931\u8d25", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryAndGetNewPrice() {
        ObservableList neworderList;
        ObservableList observableList = neworderList = this.list.getList();
        synchronized (observableList) {
            LinkedList<RefItem> listItem = new LinkedList<RefItem>();
            for (Order order : neworderList) {
                RefItem item = this.refMng.getItem(order.getMarket(), order.getSecId());
                if (item == null || item == null) continue;
                listItem.add(item);
            }
            Gears gears = new Gears();
            gears.setBuy(new int[]{0});
            if (!listItem.isEmpty()) {
                this.marketMng.queryNewPriceIn5Seconds(listItem, gears);
            }
            for (Order ord : this.list.getList()) {
                MarketItem marketItem;
                RefItem item = this.refMng.getItem(ord.getInstrument().getMarket().getRaw(), ord.getSecId());
                if (item == null || (marketItem = this.marketMng.getInfo((IRefItem)item)) == null) continue;
                if (marketItem.getNowPrice() == 0.0) {
                    ord.setNowPrice(marketItem.getClosePrice());
                    continue;
                }
                ord.setNowPrice(marketItem.getNowPrice());
            }
        }
    }
}

