/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.trade.ObSingleOrderNeeq;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.strategy.api.OrderServiceApi;
import cms.tmx.http.api.strategy.api.OrderServiceNewApi;
import cms.tmx.http.api.strategy.dto.GetOrdersReq;
import cms.tmx.http.api.strategy.dto.GetOrdersResp;
import cms.tmx.http.api.strategy.dto.GetSingleOrdersReq;
import cms.tmx.http.api.strategy.dto.GetSingleOrdersResp;
import cms.tmx.http.api.strategy.dto.OrdEvent;
import cms.tmx.http.api.strategy.dto.Order;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.http.data.dto.Fragment;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.IUserService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class InstructionNeeqOrderModel
extends MxModel {
    @Inject
    private OrderServiceApi api;
    @Inject
    private OrderServiceNewApi newApi;
    @Inject
    protected MScheduler sdPushChange;
    @Inject
    private HttpBaseApi baseApi;
    @Inject
    private MEventService es;
    @Inject
    protected IUserService userService;
    @Inject
    private IFundAccountService fundApi;
    @Inject
    private CcsAccountMap accntMap;
    @Inject
    protected ScheduledExecutorService ses;
    protected MxList<ObSingleOrderNeeq> list = new MxList();
    private static final int FULL_PUSH_CHANGE_INTERVAL = 1000;
    private MEventHandler handler = event -> this.onPush(event);
    protected Gson gson = new Gson();
    private ConcurrentHashMap<String, Integer> statusMap = new ConcurrentHashMap();
    private ObSimpleInstruction instruction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        OrdEvent ordEvent = (OrdEvent)this.gson.fromJson((JsonElement)obj, OrdEvent.class);
        for (SingleOrder order : ordEvent.getOrder()) {
            if (!"NEEQ".equals(order.getInstrument().getMarket())) {
                return;
            }
            if (this.instruction == null || StringUtils.isEmpty((String)this.instruction.getId()) || !this.instruction.getId().equals(order.getReference())) {
                return;
            }
            order.setExtraFields();
            order.setUnit("\u80a1");
            order.setUserName((String)this.userService.getUserName(order.getUserId()).get());
            this.logger.error("\u59d4\u6258+++ (sysOrderId:" + order.getOrderId() + ", orderId:" + order.getOrderId() + ", price:" + order.getPrice() + ", status:" + order.getOrdStatus() + ", qty:" + order.getOrderQty() + ", dealQty:" + order.getCumQty() + ")" + " hashCode:" + System.identityHashCode((Object)this) + "_" + order.getOrderId());
            ConcurrentHashMap<String, Integer> concurrentHashMap = this.statusMap;
            synchronized (concurrentHashMap) {
                String sysOrderId = order.getOrderId();
                Integer statusOld = this.statusMap.get(sysOrderId);
                Integer statusNow = this.getStatusNo(order);
                this.logger.error("\u59d4\u6258---, sysOrderId:" + sysOrderId + ", statusOld:" + statusOld + ", statusNow:" + statusNow + " hashCode:" + System.identityHashCode((Object)this) + "_" + order.getOrderId());
                if (statusOld == null) {
                    this.statusMap.put(sysOrderId, statusNow);
                } else {
                    if (statusNow < statusOld) {
                        this.logger.error("\u59d4\u6258\u63a8\u9001, \u4e22\u5f03\u672c\u6b21\u63a8\u9001: hashCode:" + System.identityHashCode((Object)this) + "_" + order.getOrderId());
                        return;
                    }
                    this.statusMap.put(sysOrderId, statusNow);
                }
                ObSingleOrderNeeq neeq = new ObSingleOrderNeeq();
                neeq.update(order);
                this.list.updatePart((MxObject)neeq);
            }
        }
        this.changed();
    }

    public void changed() {
        this.sdPushChange.schedule(e -> super.changed());
    }

    private Integer getStatusNo(SingleOrder order) {
        if (order.getCanCancelFlag() != 1) {
            return 99999999;
        }
        if (order.getOrdStatus() == null) {
            return -1;
        }
        if (order.getOrdStatus().getValue().equals("87")) {
            return 0;
        }
        if (order.getOrdStatus().getValue().equals("65")) {
            return 1;
        }
        if (order.getOrdStatus().getValue().equals("48")) {
            return 2;
        }
        if (order.getOrdStatus().getValue().equals("49")) {
            return (int)(1000.0 + order.getCumQty());
        }
        return -1;
    }

    @PostConstruct
    protected void init() {
        this.sdPushChange.setInterval(1000);
        this.es.subscribe("uap.push.OrdEvent", this.handler);
    }

    @PreDestroy
    private void destory() {
        this.es.unSubscribe("uap.push.OrdEvent", this.handler);
    }

    public void query(ObSimpleInstruction instr) throws IOException, MException {
        GetSingleOrdersReq req = new GetSingleOrdersReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGrp("CCS");
        if (instr.getMarket().getRaw().equals("XHKG")) {
            req.setMarketGrp("OTC");
        }
        req.setApplId("800");
        req.setReference(instr.getId());
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String today = format.format(new Date());
        req.setBeginDate(today);
        req.setEndDate(today);
        Page pageReq = this.baseApi.getHttpDefPage();
        req.setPage(pageReq);
        GetSingleOrdersResp resp = this.api.getOrders(req);
        this.list.clear();
        ArrayList listOrder = new ArrayList();
        Page pageResp = resp.getPage();
        listOrder.addAll(resp.getOrder());
        int queryTimes = (int)Math.ceil((double)pageResp.getTotalRow() * 1.0 / (double)pageReq.getPageSize());
        while (--queryTimes > 0) {
            pageReq.setStartRow(pageReq.getPageSize() + pageReq.getStartRow());
            req.setPage(pageReq);
            GetSingleOrdersResp res = this.api.getOrders(req);
            listOrder.addAll(res.getOrder());
        }
        for (SingleOrder order : listOrder) {
            order.setExtraFields();
            order.setUnit(QueryUtils.getUnit(order.getInstrument().getSecurityType(), order.getInstrument().getMarket()));
            order.setUserName((String)this.userService.getUserName(order.getUserId()).get());
            ObSingleOrderNeeq neeq = new ObSingleOrderNeeq();
            neeq.update(order);
            this.list.add((MxObject)neeq);
        }
        this.changed();
    }

    public void queryHis(ObSimpleInstruction instr) throws IOException, MException {
        GetOrdersReq req = new GetOrdersReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGroup(instr.getMarketGrp());
        if ("NEEQ".equals(instr.getMarket().getRaw())) {
            req.setApplId("800");
        } else if ("XOTC".equals(instr.getMarket().getRaw())) {
            req.setApplId("810");
        } else if ("XSHG".equals(instr.getMarket().getRaw()) || "XSHE".equals(instr.getMarket().getRaw())) {
            req.setApplId("010");
        }
        req.setInstructionId(instr.getId());
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String today = format.format(new Date());
        req.setBeginDate(instr.getBeginDate());
        req.setEndDate(instr.getExpireDate());
        if (StringUtils.isEmpty((String)instr.getBeginDate())) {
            req.setBeginDate(today);
        }
        if (StringUtils.isEmpty((String)instr.getExpireDate()) || "0".equals(instr.getExpireDate())) {
            req.setEndDate(today);
        }
        Fragment fragment = this.getFragment(req);
        GetOrdersResp resp = this.newApi.getOrders(req);
        this.list.clear();
        ArrayList listOrder = new ArrayList();
        listOrder.addAll(resp.getData());
        int queryTimes = (int)Math.ceil((double)resp.getTotal() * 1.0 / (double)fragment.getSize());
        while (--queryTimes > 0) {
            fragment.setOffset(fragment.getSize() + fragment.getOffset());
            req.setFragment(fragment);
            GetOrdersResp res = this.newApi.getOrders(req);
            listOrder.addAll(res.getData());
        }
        for (Order order : listOrder) {
            order.setExtraFields();
            order.setUnit("\u80a1");
            order.setUserName((String)this.userService.getUserName(order.getUserId()).get());
            ObSingleOrderNeeq neeq = new ObSingleOrderNeeq();
            neeq.update(order);
            this.list.add((MxObject)neeq);
        }
        this.changed();
    }

    public List<ObSingleOrderNeeq> getList() {
        return this.list.getList();
    }

    public ObSimpleInstruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(ObSimpleInstruction instruction) {
        this.instruction = instruction;
    }

    private Fragment getFragment(GetOrdersReq req) {
        Fragment fragment = new Fragment();
        fragment.setOffset(1);
        fragment.setSize(200);
        req.setFragment(fragment);
        return fragment;
    }
}

