/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.datahub.QueryType;
import cms.tmx.http.api.datahub.Type;
import cms.tmx.http.api.strategy.api.OrderServiceApi;
import cms.tmx.http.instruction.api.InstructionServiceApi;
import cms.tmx.http.instruction.dto.GetLegDetailsReq;
import cms.tmx.http.instruction.dto.LegDetail;
import cms.tmx.http.instruction.dto.ObLegDetail;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.IUserService;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionNeeqDealModel
extends MxModel {
    @Inject
    private OrderServiceApi api;
    @Inject
    private HttpBaseApi baseApi;
    @Inject
    private MEventService es;
    @Inject
    private IFundAccountService fundApi;
    @Inject
    protected ScheduledExecutorService ses;
    private Gson gson = new Gson();
    protected MxList<ObLegDetail> list = new MxList();
    @Inject
    private IUserService userService;
    private ObSimpleInstruction instruction;
    @Inject
    private InstructionServiceApi instrApi;

    @PostConstruct
    private void init() {
    }

    @PreDestroy
    private void destory() {
    }

    public void query() throws IOException, MException {
        GetLegDetailsReq req = new GetLegDetailsReq();
        req.setMarketGroup("CCS");
        if (this.instruction.getMarket().getRaw().equals("XHKG")) {
            req.setMarketGroup("OTC");
        }
        req.setQueryType(QueryType.QUERY_TYPE_SUMMARY);
        req.setType(Type.CURRENT);
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.instruction.getId());
        req.setInstructionId(ids);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        String date = LocalDate.now().format(formatter);
        req.setBeginDate(date);
        req.setEndDate(date);
        Page pageReq = this.baseApi.getHttpDefPage();
        req.setPage(pageReq);
        List legDetails = this.instrApi.getLegDetails(req);
        for (LegDetail leg : legDetails) {
            ObLegDetail exec = new ObLegDetail();
            exec.update((Object)leg);
            this.list.add((MxObject)exec);
        }
        this.changed();
    }

    public void queryHis() throws IOException, MException {
        GetLegDetailsReq req = new GetLegDetailsReq();
        req.setQueryType(QueryType.QUERY_TYPE_SUMMARY);
        req.setType(Type.HISTORY);
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.instruction.getId());
        req.setInstructionId(ids);
        req.setMarketGroup(this.instruction.getMarketGrp());
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String today = format.format(new Date());
        req.setBeginDate(this.instruction.getBeginDate());
        req.setEndDate(this.instruction.getExpireDate());
        if (StringUtils.isEmpty((String)this.instruction.getBeginDate())) {
            req.setBeginDate(today);
        }
        if (StringUtils.isEmpty((String)this.instruction.getExpireDate()) || "0".equals(this.instruction.getExpireDate())) {
            req.setEndDate(today);
        }
        Page pageReq = this.baseApi.getHttpDefPage();
        req.setPage(pageReq);
        List legDetails = this.instrApi.getLegDetails(req);
        for (LegDetail leg : legDetails) {
            ObLegDetail exec = new ObLegDetail();
            exec.update((Object)leg);
            this.list.add((MxObject)exec);
        }
        this.changed();
    }

    public List<ObLegDetail> getList() {
        return this.list.getList();
    }

    public ObSimpleInstruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(ObSimpleInstruction instruction) {
        this.instruction = instruction;
    }
}

