/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.api.basket.IBasketCancelOrderApi;
import cms.tmx.api.basket.imp.QueryBasketOrderImpl;
import cms.tmx.api.data.IRefItem;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.INewOrderSingleApi;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.data.utils.Gears;
import cms.tmx.datatype.message.PCcsExtra;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.datatype.proto.PResource;
import cms.tmx.datatype.proto.workflow.PInstructionManagement;
import cms.tmx.define.MxDict;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.CcsSubSecAccount;
import cms.tmx.entity.CtpFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Result;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.WorkFlowDescriptor;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.factory.BasketTradeItemFactory;
import cms.tmx.entity.factory.PositionFactory;
import cms.tmx.entity.notice.InstructionReport;
import cms.tmx.entity.notice.MxNotice;
import cms.tmx.entity.notice.ResourceReport;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.CcsPortfPosition;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.Order;
import cms.tmx.entity.trade.Position;
import cms.tmx.entity.trade.PreFrozenFundAccnt;
import cms.tmx.entity.trade.PreFrozenPositions;
import cms.tmx.entity.trade.basket.Basket;
import cms.tmx.entity.trade.basket.BasketAlgoItem;
import cms.tmx.entity.trade.basket.BasketAlgoStrategy;
import cms.tmx.entity.trade.basket.BasketItem;
import cms.tmx.entity.trade.basket.BasketSubmitResult;
import cms.tmx.entity.trade.basket.BasketTradeItem;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.entity.trade.instruction.ActionInfo;
import cms.tmx.entity.trade.instruction.AdjustPosAdvice;
import cms.tmx.entity.trade.instruction.BasketOrderAdvice;
import cms.tmx.entity.trade.instruction.BasketSecurityInst;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionCancelResult;
import cms.tmx.entity.trade.instruction.InstructionExec;
import cms.tmx.javafx.MxListDirty;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxDirtyObj;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.ISecAccountService;
import cms.tmx.manage.IWorkFlowService;
import cms.tmx.query.current.mng.InstructionExecMng;
import cms.tmx.query.current.mng.InstructionMng;
import cms.tmx.query.current.models.CtpAccountMap;
import cms.tmx.query.current.models.InstructionOrderModel;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.current.models.ResourceModel;
import cms.tmx.query.current.models.block.BlockUnfinishedModel;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class InstructionModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(InstructionModel.class);
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MScheduler sdResourceUpdate;
    @Inject
    protected MScheduler sdSpecQuery;
    @Inject
    protected MScheduler sdInsQuery;
    @Inject
    protected MScheduler sdPushChange;
    @Inject
    private ScheduledExecutorService ses;
    @Inject
    protected IMarketDataMng marketMng;
    private static final int FULL_QUERY_INTERVAL = 3000;
    private static final int INS_QUERY_INTERVAL = 1000;
    @Inject
    private InstructionMng insMng;
    @Inject
    private IWorkFlowService wfService;
    @Inject
    private QueryBasketOrderImpl basketApi;
    @Inject
    private IBasketCancelOrderApi basketCancelApi;
    @Inject
    private ResourceModel resourceModel;
    @Inject
    private InstructionOrderModel insOrderModel;
    @Inject
    private BlockUnfinishedModel blockUnfinishedOrderModel;
    @Inject
    private IWorkFlowService workflowService;
    private MEventHandler handler = event -> this.onPush(event);
    private MEventHandler handlerAdj = event -> this.onAdjRefresh(event);
    @Inject
    protected InstructionExecMng resourceDetailMng;
    @Inject
    protected PositionFactory fPos;
    @Inject
    private PortfolioAccountModel portFolioModel;
    @Inject
    private IFundAccountService fundModel;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private IBaseApi baseApi;
    @Inject
    private INewOrderSingleApi orderApi;
    @Inject
    protected IFundAccountService fundAccService;
    @Inject
    private ISecAccountService secAccService;
    @Inject
    protected BasketTradeItemFactory bskTradeItemFactory;
    @Inject
    @Named(value="fixed.fileorder.pool")
    protected ExecutorService fixedPool;
    @Inject
    private MxAlert alert;
    private volatile boolean shortcutVisible = false;
    @Inject
    private CtpAccountMap ctpAccntMap;
    private Set<String> executedInsIds = new HashSet<String>();
    private Set<String> canceledInsIds = new HashSet<String>();
    private Map<String, ResourceReport> resourceMap = new HashMap<String, ResourceReport>();
    private ReentrantLock resourceLock = new ReentrantLock();
    private String marketGroup;
    @Inject
    protected IFundAccountService faccService;
    @Inject
    protected MObjFactory of;
    protected MxListDirty<Instruction> list = new MxListDirty();
    private Map<String, Instruction> mapValid = new ConcurrentHashMap<String, Instruction>();
    @Inject
    protected MEventService es;
    @Inject
    @Named(value="base.path")
    private String pathBase;
    private List<String> updatePosList = Collections.synchronizedList(new ArrayList());

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.sdSpecQuery.setInterval(1000);
        this.sdInsQuery.setInterval(1000);
        this.sdPushChange.setInterval(1000);
        this.sdResourceUpdate.setInterval(1000);
        this.es.subscribe("server.sub", this.handler);
        this.es.subscribe("requery_data", event -> {
            ScheduledFuture<?> scheduledFuture = this.ses.schedule(() -> this.query(), 240L, TimeUnit.SECONDS);
        });
        this.es.subscribe("adj.algo.refresh", this.handlerAdj);
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("server.sub", this.handler);
        this.es.unSubscribe("adj.algo.refresh", this.handlerAdj);
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                logger.error("instruction query failed", e);
            }
        });
    }

    private void runSpecQuery() {
        this.sdSpecQuery.schedule(event -> {
            try {
                this.specQuery();
            }
            catch (MException | Exception e) {
                logger.error("instruction query failed", e);
            }
        });
    }

    private void runInsQuery() {
        this.sdInsQuery.schedule(event -> {
            try {
                this.specQuery();
            }
            catch (MException | Exception e) {
                logger.error("instruction query failed", e);
            }
        });
    }

    private void specQuery() throws MException {
        List<Instruction> listInstruction = this.insMng.queryToBeQuery();
        this.updateDirty(listInstruction);
    }

    protected void updateDirty(List<Instruction> listInstruction) {
        this.list.updateDirty(listInstruction);
        this.updatePositionAndFund(listInstruction);
        this.valid(listInstruction);
        this.queryAndGetNewPrice();
        this.changed();
    }

    private void addExtInfo(CcsPortfPosition pos) {
        CcsSubFundAccount fundAcc = this.portFolioModel.getSubFundAccountById(pos.getSubAccntId());
        pos.setExtAccId(fundAcc == null ? "" : fundAcc.getExtAccntId());
        CcsSubSecAccount subSecAccnt = this.portFolioModel.getSubSecAccountByIdAndMarket(pos.getSubSecAccntId(), pos.getMarket().getRaw());
        pos.setExtSecAccId(subSecAccnt == null ? "" : subSecAccnt.getExtSecAccntId());
        pos.setTradingDay(fundAcc == null ? "" : fundAcc.getTradingDay());
    }

    private void updatePositionAndFund(List<Instruction> listInstruction) {
        MEvent event;
        LinkedList<Position> positionsToUpdate = new LinkedList<Position>();
        LinkedList<CcsPortfPosition> subPositionsToUpdate = new LinkedList<CcsPortfPosition>();
        HashSet<FundAccount> fundAccntsToUpdate = new HashSet<FundAccount>();
        HashSet<CcsSubFundAccount> subFundAccntsToUpdate = new HashSet<CcsSubFundAccount>();
        for (Instruction instruction : listInstruction) {
            if (!this.updatePosList.contains(instruction.getId())) continue;
            this.updatePosList.remove(instruction.getId());
            Instruction ins = (Instruction)this.list.getListMap().get(instruction);
            switch (ins.getType().getRaw()) {
                case "4": 
                case "5": 
                case "12": 
                case "13": {
                    if (ins.getBasketOrderAdvice() == null) break;
                    this.getPositionFromBasketAdvice(positionsToUpdate, subPositionsToUpdate, fundAccntsToUpdate, subFundAccntsToUpdate, ins);
                    break;
                }
                case "8": 
                case "9": {
                    if (ins.getAlgoParam() == null) break;
                    this.getPositionFromAccntSecInfo(positionsToUpdate, subPositionsToUpdate, fundAccntsToUpdate, subFundAccntsToUpdate, ins.getMarketGrp(), ins.getAlgoParam().getCode(), ins.getAlgoParam().getType(), ins.getAlgoParam().getAccSecInfoList(), ins.getAlgoParam().getAccntLevel());
                    break;
                }
                case "16": 
                case "17": {
                    if (ins.getAdjustPosAdvice() == null) break;
                    this.getPositionFromAdjAdvice(positionsToUpdate, subPositionsToUpdate, fundAccntsToUpdate, subFundAccntsToUpdate, ins);
                    break;
                }
                case "2": 
                case "3": {
                    if (ins.getOrderAdvice() == null) break;
                    this.getPositionFromAccntSecInfo(positionsToUpdate, subPositionsToUpdate, fundAccntsToUpdate, subFundAccntsToUpdate, ins.getMarketGrp(), ins.getOrderAdvice().getSec(), ins.getOrderAdvice().getSecType(), ins.getOrderAdvice().getAccSecInfoList(), ins.getOrderAdvice().getAccntLevel());
                    break;
                }
                case "32": {
                    if (ins.getTrdCtrRptAdvice() == null) break;
                    this.getPositionFromAccntSecInfo(positionsToUpdate, subPositionsToUpdate, fundAccntsToUpdate, subFundAccntsToUpdate, ins.getMarketGrp(), ins.getTrdCtrRptAdvice().getSecId(), ins.getTrdCtrRptAdvice().getSecType(), ins.getTrdCtrRptAdvice().getAccSecInfoList(), ins.getTrdCtrRptAdvice().getAccntLevel());
                    break;
                }
                case "64": {
                    if (ins.getOrderAdvice() == null) break;
                    this.getFuturesPositionFromAccntSecInfo(positionsToUpdate, fundAccntsToUpdate, ins.getMarketGrp(), ins.getOrderAdvice().getSec(), ins.getOrderAdvice().getSecType(), ins.getOrderAdvice().getAccSecInfoList(), ins.getOrderAdvice().getAccntLevel());
                    break;
                }
            }
        }
        if (!positionsToUpdate.isEmpty() || !subPositionsToUpdate.isEmpty()) {
            PreFrozenPositions positions = new PreFrozenPositions();
            positions.setPositionsToUpdate(positionsToUpdate);
            positions.setSubPositionsToUpdate(subPositionsToUpdate);
            event = new MEvent();
            event.setObj((Object)positions);
            this.es.postEvent("pre_frozen_position", event);
        }
        if (!fundAccntsToUpdate.isEmpty() || !subFundAccntsToUpdate.isEmpty()) {
            PreFrozenFundAccnt fundAccnts = new PreFrozenFundAccnt();
            fundAccnts.setFundAccntsToUpdate(fundAccntsToUpdate);
            fundAccnts.setSubFundAccntsToUpdate(subFundAccntsToUpdate);
            event = new MEvent();
            event.setObj((Object)fundAccnts);
            this.es.postEvent("pre_frozen_fund", event);
        }
    }

    private void getPositionFromAdjAdvice(List<Position> positionsToUpdate, List<CcsPortfPosition> subPositionsToUpdate, Set<FundAccount> fundAccntsToUpdate, Set<CcsSubFundAccount> subFundAccntsToUpdate, Instruction ins) {
        if (ins.getAdjustPosAdvice().getItems().isEmpty()) {
            ins.getAdjustPosAdvice().setItems(this.getInsAdjItems(ins.getId()));
        }
        for (BasketAlgoItem item : ins.getAdjustPosAdvice().getItems()) {
            Position pos = this.fPos.create(ins.getMarketGrp());
            pos.setMarketGrp(ins.getMarketGrp());
            pos.update((Object)item);
            this.addFundAccntToUpdate(fundAccntsToUpdate, pos);
            positionsToUpdate.add(pos);
            if (StringUtils.isEmpty((String)item.getSubAccntId())) continue;
            CcsPortfPosition subPos = this.fPos.createCcsPortfolio();
            subPos.update((Object)item);
            subPos.setMarketGrp(ins.getMarketGrp());
            this.addSubFundAccntToUpdate(subFundAccntsToUpdate, fundAccntsToUpdate, subPos);
            subPositionsToUpdate.add(subPos);
        }
    }

    private void getPositionFromBasketAdvice(List<Position> positionsToUpdate, List<CcsPortfPosition> subPositionsToUpdate, Set<FundAccount> fundAccntsToUpdate, Set<CcsSubFundAccount> subFundAccntsToUpdate, Instruction ins) {
        if (ins.getBasketOrderAdvice().getItemList().isEmpty()) {
            ins.getBasketOrderAdvice().setItemList(this.getInsBasketItems(ins.getId()));
        }
        for (BasketSecurityInst inst : ins.getBasketOrderAdvice().getItemList()) {
            Position pos = this.fPos.create(ins.getMarketGrp());
            pos.update((Object)inst);
            pos.setMarketGrp(ins.getMarketGrp());
            this.addFundAccntToUpdate(fundAccntsToUpdate, pos);
            positionsToUpdate.add(pos);
            if (StringUtils.isEmpty((String)inst.getSubAccntId())) continue;
            CcsPortfPosition subPos = this.fPos.createCcsPortfolio();
            subPos.update((Object)inst);
            subPos.setMarketGrp(ins.getMarketGrp());
            this.addSubFundAccntToUpdate(subFundAccntsToUpdate, fundAccntsToUpdate, subPos);
            subPositionsToUpdate.add(subPos);
        }
    }

    private void addSubFundAccntToUpdate(Set<CcsSubFundAccount> subFundAccntsToUpdate, Set<FundAccount> fundAccntsToUpdate, CcsPortfPosition subPos) {
        FundAccount fundAccount;
        CcsSubFundAccount subAccnt = this.portFolioModel.getSubFundAccountById(subPos.getSubAccntId());
        if (subAccnt != null) {
            subFundAccntsToUpdate.add(subAccnt);
        }
        if ((fundAccount = this.fundModel.getFundAccount(subPos.getExtAccId(), subPos.getMarketGrp())) != null) {
            fundAccntsToUpdate.add(fundAccount);
        }
    }

    private void addFundAccntToUpdate(Set<FundAccount> fundAccntsToUpdate, Position pos) {
        FundAccount fundAccount = this.fundModel.getFundAccount(pos.getExtAccId(), pos.getMarketGrp());
        if (fundAccount != null) {
            fundAccntsToUpdate.add(fundAccount);
        }
    }

    private void getPositionFromAccntSecInfo(List<Position> positionsToUpdate, List<CcsPortfPosition> subPositionsToUpdate, Set<FundAccount> fundAccntsToUpdate, Set<CcsSubFundAccount> subFundAccntsToUpdate, String marketGrp, String secId, String secType, List<AccntSecInfo> items, int accntLevel) {
        for (AccntSecInfo info : items) {
            Position pos = this.fPos.create(marketGrp);
            pos.setSecId(secId);
            pos.setSecType(secType);
            pos.setMarketGrp(marketGrp);
            pos.getMarket().setRaw(info.getMarket());
            if (accntLevel == 0) {
                pos.setExtAccId(info.getAccntId());
                pos.setExtSecAccId(info.getSecAccntId());
            } else if (accntLevel == 1) {
                CcsPortfPosition subPos = this.fPos.createCcsPortfolio();
                subPos.setSubAccntId(info.getAccntId());
                subPos.setSubSecAccntId(info.getSecAccntId());
                subPos.setSecId(secId);
                subPos.getMarket().setRaw(info.getMarket());
                subPos.setMarketGrp(marketGrp);
                subPos.setSecType(secType);
                this.addExtInfo(subPos);
                this.addSubFundAccntToUpdate(subFundAccntsToUpdate, fundAccntsToUpdate, subPos);
                subPositionsToUpdate.add(subPos);
                pos.setExtAccId(subPos.getExtAccId());
                pos.setExtSecAccId(subPos.getExtSecAccId());
                pos.setTradingDay(subPos.getTradingDay());
            }
            this.addFundAccntToUpdate(fundAccntsToUpdate, pos);
            positionsToUpdate.add(pos);
        }
    }

    private void getFuturesPositionFromAccntSecInfo(List<Position> positionsToUpdate, Set<FundAccount> fundAccntsToUpdate, String marketGrp, String secId, String secType, List<AccntSecInfo> items, int accntLevel) {
        for (AccntSecInfo info : items) {
            Position pos = this.fPos.create(marketGrp);
            pos.setSecId(secId);
            pos.setSecType(secType);
            pos.setMarketGrp(marketGrp);
            pos.getMarket().setRaw(info.getMarket());
            if (accntLevel == 0) {
                pos.setExtAccId(info.getAccntId());
                pos.setExtSecAccId(info.getSecAccntId());
            }
            this.addFundAccntToUpdate(fundAccntsToUpdate, pos);
            positionsToUpdate.add(pos);
        }
    }

    private void onPush(MEvent event) {
        this.onInstructionPush(event);
        this.onResourcePush(event);
    }

    private void onResourcePush(MEvent event) {
        if (!(event.getObj() instanceof ResourceReport)) {
            return;
        }
        ResourceReport resourceReport = (ResourceReport)ResourceReport.class.cast(event.getObj());
        if (event.getInt("push_type") == 600) {
            this.resourceLock.lock();
            try {
                this.resourceMap.put(resourceReport.getReport().getReference(), resourceReport);
            }
            finally {
                this.resourceLock.unlock();
            }
            this.runResourceUpdate();
        } else if (event.getInt("push_type") == 601) {
            this.insMng.addToBeQuery((MxNotice)resourceReport);
            this.runSpecQuery();
        }
    }

    private void runResourceUpdate() {
        this.sdResourceUpdate.schedule(event -> {
            this.resourceLock.lock();
            try {
                HashMap<String, ResourceReport> rm = new HashMap<String, ResourceReport>(this.resourceMap);
                this.resourceMap.clear();
                logger.info("\u8d44\u6e90\u63a8\u9001\u66f4\u65b0\uff0csize\uff1a" + rm.size());
                if (rm.isEmpty()) {
                    return;
                }
                for (Map.Entry<String, ResourceReport> entry : rm.entrySet()) {
                    PResource.Resource resource = entry.getValue().getReport();
                    Instruction ins = new Instruction();
                    ins.setId(resource.getReference());
                    Instruction instruction = (Instruction)this.list.get((MxDirtyObj)ins);
                    if (instruction == null) continue;
                    instruction.getResource().update((Object)resource);
                    try {
                        this.insMng.transferField(instruction);
                    }
                    catch (MException e) {
                        logger.error("\u8d44\u6e90\u63a8\u9001\u66f4\u65b0\u6307\u4ee4\u5931\u8d25\uff0c id\uff1a" + resource.getReference(), (Throwable)e);
                    }
                }
            }
            finally {
                this.resourceLock.unlock();
            }
        });
    }

    private void onInstructionPush(MEvent event) {
        if (!(event.getObj() instanceof InstructionReport)) {
            return;
        }
        InstructionReport report = (InstructionReport)InstructionReport.class.cast(event.getObj());
        report.getReport().getInstructionList().forEach(each -> {
            Instruction ins = new Instruction();
            logger.info("instruction push :" + each.getInstructionId() + "|" + each.getStatusValue() + "|" + each.getClInstructionId());
            ins.setId(each.getInstructionId());
            this.updatePosList.add(each.getInstructionId());
            Instruction instruction = (Instruction)this.list.get((MxDirtyObj)ins);
            if (instruction != null) {
                instruction.setDirty(true);
            }
            this.insMng.addToBeQuery((MxNotice)report);
            if (!(each.getStatusValue() != 59 && each.getStatusValue() != 7 && each.getStatusValue() != 12 || StringUtils.isEmpty((String)each.getErrInfo()) || each.getErrInfo().contains("\u98ce\u63a7\u89e6\u53d1\u8b66\u544a"))) {
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4" + each.getInstructionId() + "\u4e0b\u8fbe\u5931\u8d25," + each.getErrInfo()));
            }
        });
        this.runInsQuery();
    }

    public void addToDirty(Instruction instruction) {
        this.insMng.addToBeQuery(instruction);
        this.runSpecQuery();
    }

    private boolean careReport(String instructionId, String resourceId, String type) {
        if (resourceId.isEmpty()) {
            return false;
        }
        return type.equals("52") || type.equals("56") || type.equals("70");
    }

    public void updateResource(Instruction instruction) {
        try {
            this.resourceModel.refreshResource(instruction);
            this.insMng.transferField(instruction);
        }
        catch (MException e) {
            logger.error("\u66f4\u65b0\u6307\u4ee4\u8d44\u6e90\u5931\u8d25\uff0c id\uff1a" + instruction.getId(), (Throwable)e);
        }
    }

    public void approve(Instruction instruction, int actionId, String remark) throws MException {
        this.wfService.doAction(instruction, actionId, remark);
    }

    public void execute(Instruction instruction, int actionId, String remark) throws MException {
        if (!instruction.isWorkFlowDone()) {
            this.wfService.doAction(instruction, actionId, remark);
        }
    }

    public void update(Instruction instruction, int actionId) throws MException {
        this.insMng.updateInstruction(instruction, actionId);
    }

    public void cancel(Instruction instruction, int actionId, String remark) throws MException {
        this.wfService.doAction(instruction, actionId, remark);
    }

    public void reject(Instruction instruction, int actionId, String remark) throws MException {
        this.wfService.doAction(instruction, actionId, remark);
    }

    public List<BasketSecurityInst> getInsBasketItems(String instructionId) {
        try {
            return this.insMng.getInsBasketItems(instructionId, 1);
        }
        catch (MException e) {
            logger.error("\u6307\u4ee4" + instructionId + "\u67e5\u8be2\u7bee\u5b50\u6210\u5206\u80a1\u8be6\u60c5\u5931\u8d25", (Throwable)e);
            return new ArrayList<BasketSecurityInst>();
        }
    }

    public List<BasketAlgoItem> getInsAdjItems(String instructionId) {
        try {
            return this.insMng.getInsAdjuctItems(instructionId, 1);
        }
        catch (MException e) {
            logger.error("\u6307\u4ee4" + instructionId + "\u67e5\u8be2\u8c03\u4ed3\u6210\u5206\u80a1\u8be6\u60c5\u5931\u8d25", (Throwable)e);
            return new ArrayList<BasketAlgoItem>();
        }
    }

    public void queryAdjItems(Instruction instruction) throws MException {
        List<Object> exeList = new ArrayList();
        if (instruction.getAdjustPosAdvice().getItems().isEmpty()) {
            instruction.getAdjustPosAdvice().setItems(this.getInsAdjItems(instruction.getId()));
        }
        exeList = this.resourceDetailMng.query(instruction, 2, "");
        instruction.getAdjustPosAdvice().setExes(exeList);
    }

    public Instruction getInstByEntryId(long entryId) {
        for (Instruction inst : this.list.getList()) {
            if (inst.getEntryId() != entryId) continue;
            return inst;
        }
        return null;
    }

    public void basketCancel(Instruction instruction, boolean cancelResource) throws MException {
        ArrayList<String> resourceIds = new ArrayList<String>();
        resourceIds.add(instruction.getResource().getId());
        List listOrder = this.basketApi.queryOrderByResource(resourceIds);
        String listId = "";
        if (listOrder != null && !listOrder.isEmpty()) {
            listId = ((POrderService.ListOrder)listOrder.get(0)).getListId();
        }
        if (cancelResource) {
            this.cancelResource(instruction);
        }
        if (StringUtils.isEmpty((String)listId)) {
            return;
        }
        this.basketCancelApi.cancelSingleOrder(listId, instruction.getMarketGrp(), "");
    }

    public void cancelResource(Instruction instruction) throws MException {
        this.resourceModel.cancelResource(instruction);
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        this.updatePosList.add(instruction.getId());
        this.updatePositionAndFund(instructions);
    }

    public MEvent orderCancel(Instruction instruction, boolean cancelResource) throws MException {
        if (cancelResource) {
            this.cancelResource(instruction);
        }
        return this.cancelOrder(instruction);
    }

    public MEvent cancelOrder(Instruction instruction) throws MException {
        this.insOrderModel.setInstruction(instruction, 1, instruction.getMarketGrp());
        this.insOrderModel.fullQuery();
        ObservableList<Order> ccsOrderList = this.insOrderModel.getList();
        ArrayList<CcsOrder> orderList = new ArrayList<CcsOrder>();
        for (Order ccsOrder : ccsOrderList) {
            if (!(ccsOrder instanceof CcsOrder) || !ccsOrder.isCanCancel()) continue;
            orderList.add((CcsOrder)CcsOrder.class.cast(ccsOrder));
        }
        MEvent event = new MEvent();
        if (orderList.size() > 0) {
            event.setObj(orderList);
            this.es.sendEvent("ccs.cancel.order", event);
        }
        return event;
    }

    public MEvent cancelAllOrder(Instruction instruction) throws MException {
        this.insOrderModel.setInstruction(instruction, 1, instruction.getMarketGrp());
        this.insOrderModel.fullQuery();
        ObservableList<Order> ccsOrderList = this.insOrderModel.getList();
        ArrayList<CcsOrder> orderList = new ArrayList<CcsOrder>();
        for (Order ccsOrder : ccsOrderList) {
            if (!(ccsOrder instanceof CcsOrder) || !ccsOrder.isCanCancel()) continue;
            orderList.add((CcsOrder)CcsOrder.class.cast(ccsOrder));
        }
        MEvent event = new MEvent();
        if (orderList.size() > 0) {
            event.setObj(orderList);
            this.es.sendEvent("ccs.cancel.order", event);
        }
        return event;
    }

    public List<CcsOrder> unfinishOrder(Instruction instruction) throws MException {
        this.insOrderModel.setInstruction(instruction, 1, instruction.getMarketGrp());
        this.insOrderModel.fullQuery();
        ObservableList<Order> ccsOrderList = this.insOrderModel.getList();
        ArrayList<CcsOrder> orderList = new ArrayList<CcsOrder>();
        for (Order ccsOrder : ccsOrderList) {
            if (!(ccsOrder instanceof CcsOrder) || !ccsOrder.isCanCancel()) continue;
            orderList.add((CcsOrder)CcsOrder.class.cast(ccsOrder));
        }
        return orderList;
    }

    public Instruction instructionCancelById(String instructionId) throws MException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(instructionId);
        List<Instruction> instructions = this.insMng.query(ids);
        if (instructions.size() > 0) {
            Instruction instruction = instructions.get(0);
            if (!this.baseApi.getPostId().equals(instruction.getFirstOne())) {
                throw new MException(-1, "\u6ca1\u6709\u6743\u9650\u64a4\u9500\u8be5\u6307\u4ee4");
            }
            if (instruction.getResource() != null) {
                if ("61".equals(instruction.getResource().getStatus())) {
                    throw new MException(-1, "\u6307\u4ee4\u5df2\u64a4\u9500");
                }
                if ("4".equals(instruction.getResource().getStatus())) {
                    throw new MException(-1, "\u6307\u4ee4\u5df2\u6267\u884c\u5b8c\u6210");
                }
            }
            if (1 == instruction.getDescId() || 2 == instruction.getDescId()) {
                this.applyCancel(instruction, 13, "");
                return instruction;
            }
            if (!instruction.isWorkFlowDone()) {
                this.cancel(instruction, 6, "");
            } else if ("2".equals(instruction.getType().getRaw())) {
                this.orderCancel(instruction, true);
            } else if ("4".equals(instruction.getType().getRaw())) {
                this.basketCancel(instruction, true);
            }
            return instruction;
        }
        throw new MException(1, "\u672a\u67e5\u8be2\u5230\u6307\u4ee4");
    }

    public void blockOrderCancel(Instruction instruction, boolean cancelResource) throws MException {
        if (cancelResource) {
            this.cancelResource(instruction);
        }
        this.blockUnfinishedOrderModel.cancelInstruction(instruction);
    }

    public MEvent futuresOrderCancel(Instruction instruction, boolean cancelResource) throws MException {
        if (cancelResource) {
            this.cancelResource(instruction);
        }
        this.insOrderModel.setInstruction(instruction, 1, instruction.getMarketGrp());
        this.insOrderModel.fullQuery();
        ObservableList<Order> ctpOrderList = this.insOrderModel.getList();
        ArrayList<CtpOrder> orderList = new ArrayList<CtpOrder>();
        for (Order ctpOrder : ctpOrderList) {
            if (!(ctpOrder instanceof CtpOrder) || !ctpOrder.isCanCancel()) continue;
            orderList.add((CtpOrder)CtpOrder.class.cast(ctpOrder));
        }
        MEvent event = new MEvent();
        if (orderList.size() > 0) {
            event.setObj(orderList);
            this.es.sendEvent("ctp.cancel.order", event);
        }
        return event;
    }

    public void adjustCancel(Instruction instruction) throws MException {
        MEvent event = new MEvent();
        event.setObj((Object)instruction);
        this.es.sendEvent("adjust.cancel.order", event);
        Object obj = event.getObj();
        if (obj instanceof MException) {
            throw (MException)((Object)MException.class.cast(obj));
        }
        this.cancelResource(instruction);
    }

    private void fullQuery() throws MException {
        this.getList().update(this.insMng.query());
        this.mapValid.clear();
        this.valid((List<Instruction>)this.getList().getList());
        this.queryAndGetNewPrice();
        this.changed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAdjRefresh(MEvent event) {
        ObservableList observableList = this.list.getList();
        synchronized (observableList) {
            for (Instruction ins : this.list.getList()) {
                BasketAlgoStrategy adj = (BasketAlgoStrategy)event.get(ins.getId(), BasketAlgoStrategy.class);
                if (adj != null) continue;
                try {
                    this.insMng.transferField(ins);
                }
                catch (MException | Exception e) {
                    logger.error("\u7b97\u6cd5\u6307\u4ee4\u72b6\u6001\u5237\u65b0\u5f02\u5e38\uff0cinstructionId:" + ins.getId(), e);
                }
            }
        }
        this.changed();
    }

    private void valid(List<Instruction> listResp) {
        for (Instruction inst : listResp) {
            AdjustPosAdvice advice = inst.getAdjustPosAdvice();
            if (advice == null || "1".equals(advice.getAdjType().getRaw())) continue;
            MxNode status = inst.getStatus();
            switch (status.getRaw()) {
                case "4": 
                case "6": 
                case "7": 
                case "59": 
                case "61": {
                    this.mapValid.remove(advice.getInvestorId(), inst);
                    break;
                }
                default: {
                    this.mapValid.put(advice.getInvestorId(), inst);
                }
            }
        }
    }

    public boolean isRunningStatus(String accntId) {
        return this.mapValid.get(accntId) != null;
    }

    public MxListDirty<Instruction> getList() {
        return this.list;
    }

    public String getMarketGrp() {
        return this.marketGroup;
    }

    public void setMarketGrp(String marketGrp) {
        this.marketGroup = marketGrp;
    }

    protected String getUnit(String secType, String market) {
        return QueryUtils.getUnit(secType, market);
    }

    public void refreshResource(Instruction instruction) throws MException {
        this.resourceModel.refreshResource(instruction);
        this.udpateAvailableOrderQty(instruction);
    }

    public long udpateAvailableOrderQty(Instruction instruction) throws MException {
        long availableOrderQty = 0L;
        this.resourceDetailMng.setInstruction(instruction);
        List<InstructionExec> detailList = this.resourceDetailMng.query(2, "");
        if (instruction.isRegular()) {
            for (InstructionExec detail : detailList) {
                String secAcc = instruction.getOrderAdvice().isSub() ? detail.getSubSecAccntId() : detail.getExtSecAccntId();
                instruction.getOrderAdvice().getAccSecInfoList().forEach(each -> {
                    if (each.getSecAccntId().equals(secAcc)) {
                        each.setOrderAvailableQuantity(detail.getAvailableQty());
                    }
                });
            }
            for (AccntSecInfo accntSecInfo : instruction.getOrderAdvice().getAccSecInfoList()) {
                availableOrderQty += accntSecInfo.getOrderAvailableQuantity();
            }
            instruction.getOrderAdvice().setOrderAvailableQuantity(availableOrderQty);
        } else if (instruction.isAlgo()) {
            for (InstructionExec detail : detailList) {
                String secAcc = instruction.getAlgoParam().isSub() ? detail.getSubSecAccntId() : detail.getExtSecAccntId();
                instruction.getAlgoParam().getAccSecInfoList().forEach(each -> {
                    if (each.getSecAccntId().equals(secAcc)) {
                        each.setOrderAvailableQuantity(detail.getAvailableQty());
                    }
                });
            }
            for (AccntSecInfo accntSecInfo : instruction.getAlgoParam().getAccSecInfoList()) {
                availableOrderQty += accntSecInfo.getOrderAvailableQuantity();
            }
            instruction.getAlgoParam().setOrderAvailableQuantity(Long.valueOf(availableOrderQty).intValue());
        } else if (instruction.isBlock()) {
            instruction.getTrdCtrRptAdvice().setOrderAvailableQuantity(instruction.getResource().getAvailOrderQty());
        } else if (instruction.isFutures()) {
            long avail = 0L;
            for (InstructionExec detail : detailList) {
                String secAcc = detail.getExtSecAccntId();
                for (AccntSecInfo each2 : instruction.getOrderAdvice().getAccSecInfoList()) {
                    if (!each2.getSecAccntId().equals(secAcc)) continue;
                    avail += detail.getAvailableQty();
                }
            }
            for (AccntSecInfo each3 : instruction.getOrderAdvice().getAccSecInfoList()) {
                each3.setOrderAvailableQuantity(avail);
            }
            for (AccntSecInfo accntSecInfo : instruction.getOrderAdvice().getAccSecInfoList()) {
                availableOrderQty += accntSecInfo.getOrderAvailableQuantity();
            }
            instruction.getOrderAdvice().setOrderAvailableQuantity(availableOrderQty);
        }
        return availableOrderQty;
    }

    public Result batchApprove(List<Instruction> instructionsCanBeApproved) {
        Result result = new Result();
        for (Instruction instruction : instructionsCanBeApproved) {
            try {
                this.wfService.doAction(instruction, MxDict.WORKFLOW_APPROVE, "");
                result.operate(true);
            }
            catch (MException e) {
                result.operate(false);
                logger.error("\u6279\u91cf\u5ba1\u6279\u4e2d" + instruction.getId() + "\u5ba1\u6279\u5931\u8d25: ", (Throwable)e);
            }
        }
        return result;
    }

    public Result batchReject(List<Instruction> instructionsCanBeApproved) {
        Result result = new Result();
        for (Instruction instruction : instructionsCanBeApproved) {
            try {
                this.wfService.doAction(instruction, MxDict.WORKFLOW_REJECT, "");
                result.operate(true);
            }
            catch (MException e) {
                result.operate(false);
                logger.error("\u6279\u91cf\u9a73\u56de" + instruction.getId() + "\u9a73\u56de\u5931\u8d25: ", (Throwable)e);
            }
        }
        return result;
    }

    public Result batchExe(List<Instruction> instructionsCanBeExe) {
        Result result = new Result();
        CountDownLatch cdl = new CountDownLatch(instructionsCanBeExe.size());
        for (Instruction instruction : instructionsCanBeExe) {
            this.fixedPool.execute(() -> {
                block18: {
                    instruction.getLock().lock();
                    try {
                        List actions = instruction.getTransferInfo().getActionInfoList();
                        boolean hasApproveCancel = false;
                        for (ActionInfo info : actions) {
                            if (info.getActionId() != 14) continue;
                            hasApproveCancel = true;
                            break;
                        }
                        if (hasApproveCancel && !this.canceledInsIds.contains(instruction.getId())) {
                            logger.info("\u6307\u4ee4\u5ba1\u6279\u64a4\u9500|" + instruction.getId());
                            try {
                                this.cancel(instruction, 14, "");
                            }
                            catch (MException | Exception e) {
                                logger.error("\u7ba1\u7406\u7aef\u6307\u4ee4\u64a4\u9500\u5931\u8d25", e);
                            }
                            this.cancelResourceAndOrder(instruction);
                            this.canceledInsIds.add(instruction.getId());
                            result.operate(true);
                            return;
                        }
                        try {
                            if (instruction.isProductRegular() && !this.executedInsIds.contains(instruction.getId())) {
                                try {
                                    logger.info("\u6307\u4ee4\u5feb\u6377\u6267\u884c\u5f00\u59cb,\u6307\u4ee4id\u4e3a\uff1a" + instruction.getId());
                                    this.execute(instruction, MxDict.WORKFLOW_EXECUTE, "");
                                    this.executedInsIds.add(instruction.getId());
                                    this.newOrderSingle(instruction);
                                    result.operate(true);
                                }
                                catch (MException e) {
                                    result.operate(false);
                                    logger.error("\u6279\u91cf\u6267\u884c" + instruction.getId() + ",\u59d4\u6258\u5931\u8d25: ", (Throwable)e);
                                }
                                break block18;
                            }
                            if (instruction.isProductBasket() && !this.executedInsIds.contains(instruction.getId())) {
                                try {
                                    logger.info("\u6307\u4ee4\u5feb\u6377\u6267\u884c\u5f00\u59cb,\u6307\u4ee4id\u4e3a\uff1a" + instruction.getId());
                                    this.execute(instruction, MxDict.WORKFLOW_EXECUTE, instruction.getPostil());
                                    this.executedInsIds.add(instruction.getId());
                                    this.newOrderBasket(instruction);
                                    result.operate(true);
                                }
                                catch (MException e) {
                                    result.operate(false);
                                    logger.error("\u6279\u91cf\u6267\u884c" + instruction.getId() + ",\u59d4\u6258\u5931\u8d25: ", (Throwable)e);
                                }
                                break block18;
                            }
                            if (!instruction.isFutures() || this.executedInsIds.contains(instruction.getId())) break block18;
                            try {
                                logger.info("\u6307\u4ee4\u5feb\u6377\u6267\u884c\u5f00\u59cb,\u6307\u4ee4id\u4e3a\uff1a" + instruction.getId());
                                this.execute(instruction, MxDict.WORKFLOW_EXECUTE, instruction.getPostil());
                                this.executedInsIds.add(instruction.getId());
                                this.newOrderFuture(instruction);
                                result.operate(true);
                            }
                            catch (MException e) {
                                result.operate(false);
                                logger.error("\u6279\u91cf\u6267\u884c" + instruction.getId() + ",\u59d4\u6258\u5931\u8d25: ", (Throwable)e);
                            }
                        }
                        catch (MException | Exception e) {
                            result.operate(false);
                            logger.error("\u6279\u91cf\u6267\u884c" + instruction.getId() + ",\u5931\u8d25: ", e);
                        }
                    }
                    finally {
                        cdl.countDown();
                        instruction.getLock().unlock();
                    }
                }
            });
        }
        return result;
    }

    private void newOrderFuture(Instruction instruction) throws MException {
        for (AccntSecInfo accntSecInfo : instruction.getOrderAdvice().getAccSecInfoList()) {
            CtpFundAccount ctpFundAccnt = this.ctpAccntMap.getCtpAccountByExtAccntId(accntSecInfo.getAccntId());
            if (ctpFundAccnt == null) {
                throw new MException(1, "\u672a\u83b7\u53d6\u5230\u8d44\u91d1\u8d26\u53f7" + accntSecInfo.getAccntId());
            }
            String market = instruction.getOrderAdvice().getMarket();
            double price = instruction.getOrderAdvice().getPrice();
            int bstype = instruction.getOrderAdvice().getSide();
            String sec_code = instruction.getOrderAdvice().getSec();
            long count = accntSecInfo.getOrderQty();
            if (count <= 0L) continue;
            RefItem item = this.refMng.getItem(market, sec_code);
            PComponent.Instrument.Builder builderI = PComponent.Instrument.newBuilder();
            builderI.setSecurityId(sec_code);
            builderI.setMarket(market);
            if (item != null) {
                builderI.setSecurityType(item.getType());
            }
            if ("XSHG".equals(market) && sec_code.startsWith("688")) {
                builderI.setApplId("700");
            } else if (item != null && item.isGem()) {
                builderI.setApplId("GEM");
            } else {
                builderI.setApplId("010");
            }
            builderI.setMarketGroup("FUTURES");
            PComponent.Instrument instrument = builderI.build();
            PMessage.NewOrderSingle.Builder builderO = PMessage.NewOrderSingle.newBuilder();
            builderO.setOpUser(this.baseApi.getOpUser());
            builderO.setInstrument(instrument);
            builderO.setOrdTypeValue(50);
            builderO.setSideValue(bstype);
            builderO.setOrderQty((double)count);
            builderO.setPrice(price);
            builderO.setClOrdId(instruction.getClInstructionId());
            builderO.setExtAccntId(accntSecInfo.getAccntId());
            builderO.setExtSecAccntId(accntSecInfo.getSecAccntId());
            builderO.setInstructionId(instruction.getId());
            builderO.setReference(instruction.getId());
            builderO.setResourceId(instruction.getResource().getId());
            builderO.setAccount(ctpFundAccnt.getInvestId());
            builderO.setBrokerId(ctpFundAccnt.getBrokerId());
            builderO.setInvestorId(ctpFundAccnt.getInvestId());
            builderO.setPurpose(instruction.getOrderAdvice().getShFlag());
            if (instruction.getOrderAdvice().getOcFlag() > 0) {
                builderO.setPositionEffectValue(instruction.getOrderAdvice().getOcFlag());
            }
            PMessage.NewOrderSingle order = builderO.build();
            this.orderApi.submit(order);
        }
    }

    private void cancelResourceAndOrder(Instruction instruction) throws MException {
        switch (instruction.getType().getRaw()) {
            case "4": 
            case "5": {
                this.basketCancel(instruction, true);
                break;
            }
            case "2": 
            case "3": {
                if (instruction.getSecurityType().equals("OIS")) {
                    this.cancelResource(instruction);
                    break;
                }
                this.orderCancel(instruction, true);
                break;
            }
            case "64": {
                this.futuresOrderCancel(instruction, true);
                break;
            }
        }
        this.addToDirty(instruction);
    }

    private void newOrderSingle(Instruction instruction) throws MException {
        this.udpateAvailableOrderQty(instruction);
        List accSecInfoList = instruction.getOrderAdvice().getAccSecInfoList();
        for (AccntSecInfo accntSecInfo : accSecInfoList) {
            String market = instruction.getOrderAdvice().getMarket();
            double price = instruction.getOrderAdvice().getPrice();
            int bstype = instruction.getOrderAdvice().getSide();
            String sec_code = instruction.getOrderAdvice().getSec();
            long count = accntSecInfo.getOrderAvailableQuantity();
            if (count <= 0L) continue;
            RefItem item = this.refMng.getItem(market, sec_code);
            PComponent.Instrument.Builder builderI = PComponent.Instrument.newBuilder();
            builderI.setSecurityId(sec_code);
            builderI.setMarket(market);
            if (item != null) {
                builderI.setSecurityType(item.getType());
            }
            if ("XSHG".equals(market) && sec_code.startsWith("688")) {
                builderI.setApplId("700");
            } else if (item != null && item.isGem()) {
                builderI.setApplId("GEM");
            } else {
                builderI.setApplId("010");
            }
            builderI.setMarketGroup("CCS");
            PComponent.Instrument instrument = builderI.build();
            PMessage.NewOrderSingle.Builder builderO = PMessage.NewOrderSingle.newBuilder();
            builderO.setOpUser(this.baseApi.getOpUser());
            builderO.setInstrument(instrument);
            builderO.setOrdTypeValue(50);
            builderO.setSideValue(bstype);
            builderO.setOrderQty((double)count);
            builderO.setPrice(price);
            builderO.setClOrdId(instruction.getClInstructionId());
            builderO.setExtAccntId(accntSecInfo.getAccntId());
            builderO.setExtSecAccntId(accntSecInfo.getSecAccntId());
            builderO.setInstructionId(instruction.getId());
            builderO.setReference(instruction.getId());
            builderO.setResourceId(instruction.getResource().getId());
            PMessage.NewOrderSingle order = builderO.build();
            this.orderApi.submit(order);
        }
    }

    private void newOrderBasket(Instruction instruction) throws MException {
        BasketOrderAdvice basketOrderAdvice = instruction.getBasketOrderAdvice();
        List<InstructionExec> exeList = basketOrderAdvice.getExeList();
        if (exeList.isEmpty()) {
            exeList = this.resourceDetailMng.query(instruction, 2, "");
        }
        Map<InstructionExec, InstructionExec> exeMap = exeList.stream().collect(Collectors.toMap(t -> t, t -> t));
        this.queryBasketItems(instruction);
        List itemList = basketOrderAdvice.getItemList();
        Map<String, List<BasketSecurityInst>> accBasketMap = itemList.stream().collect(Collectors.groupingBy(BasketSecurityInst::getExtAccntId));
        ArrayList<BasketTradeItem> bsTradeItems = new ArrayList<BasketTradeItem>();
        for (String extAccId : accBasketMap.keySet()) {
            List<BasketSecurityInst> list = accBasketMap.get(extAccId);
            FundAccount fundAccount = this.fundAccService.getFundAccount(extAccId, instruction.getMarketGrp());
            if (!(fundAccount instanceof CcsFundAccount)) {
                logger.error("\u7bee\u5b50\u6279\u91cf\u5feb\u6377\u952e\u6267\u884c\u672a\u53d6\u5230\u8d44\u91d1\u8d26\u53f7" + extAccId);
                continue;
            }
            CcsFundAccount acc = (CcsFundAccount)CcsFundAccount.class.cast(fundAccount);
            Map<String, SecAccount> secMap = ((List)this.secAccService.getSecAccountMap().get(acc)).stream().collect(Collectors.toMap(SecAccount::getExtSecAccntId, t -> t));
            for (BasketSecurityInst basketInst : list) {
                InstructionExec instructionExec = this.getExeLeg(instruction, basketOrderAdvice, exeMap, basketInst);
                BasketTradeItem btItem = this.bskTradeItemFactory.create();
                btItem.setAcc(acc);
                btItem.setBasketName(basketOrderAdvice.getBasketName());
                btItem.setTargetCount(Double.valueOf(basketInst.getOrderQty()).longValue());
                btItem.setSecAcc(secMap.get(basketInst.getExtSecAccntId()));
                btItem.setSelected(basketInst.isSelected());
                btItem.setUnPickInAdvice(!basketInst.isSelected());
                btItem.setPrice("49".equals(String.valueOf(basketInst.getSide())), basketInst.getOrderPrice());
                btItem.setClOrderId(basketInst.getClOrderId());
                BasketItem bti = new BasketItem();
                bti.setSecurityId(basketInst.getSecurityId());
                bti.setSecurityType(basketInst.getSecurityType());
                bti.getBs().setRaw(String.valueOf(basketInst.getSide()));
                bti.setWeight(basketInst.getRelativeWeight());
                bti.setPrice(basketInst.getFixedPrice());
                bti.setCount(Double.valueOf(basketInst.getSampleQty()).longValue());
                RefItem refItem = this.refMng.getItem(basketInst.getSecurityType(), basketInst.getMarket(), basketInst.getSecurityId());
                if (refItem == null) {
                    logger.error("\u7bee\u5b50\u6279\u91cf\u5feb\u6377\u952e\u6267\u884c\u672a\u53d6\u5230\u9759\u6001\u884c\u60c5" + basketInst.getSecurityType() + basketInst.getMarket() + basketInst.getSecurityId());
                    continue;
                }
                bti.setRefItem(refItem);
                btItem.setItem(bti);
                btItem.getBsTrade().setRaw(String.valueOf(basketInst.getSide()));
                if (instructionExec == null) {
                    btItem.setCount("49".equals(String.valueOf(basketInst.getSide())), 0);
                    btItem.setAvailableQty(0L);
                } else {
                    btItem.setCount("49".equals(String.valueOf(basketInst.getSide())), Double.valueOf(instructionExec.getAvailableQty()).intValue());
                    btItem.setAvailableQty(instructionExec.getAvailableQty());
                }
                btItem.setTargetCount(Double.valueOf(basketInst.getOrderQty()).longValue());
                btItem.setAbWeight(basketInst.getWeight());
                if (btItem.getAvailableQty() <= 0L) continue;
                bsTradeItems.add(btItem);
            }
        }
        if (bsTradeItems.isEmpty()) {
            logger.error("instructionid:" + instruction.getId() + "\u6210\u5206\u80a1\u4e3a\u7a7a");
            return;
        }
        MEvent enEvent = new MEvent();
        enEvent.put((Object)"instruction", (Object)instruction);
        enEvent.put((Object)"clInstructionId", (Object)instruction.getClInstructionId());
        enEvent.put((Object)"entrustList", bsTradeItems);
        Basket basket = new Basket();
        basket.setId(basketOrderAdvice.getBasketId());
        basket.setName(basketOrderAdvice.getBasketName());
        enEvent.put((Object)"basket", (Object)basket);
        enEvent.setCode(-1);
        enEvent.put((Object)"items", bsTradeItems);
        this.es.sendEvent("basket.entrust", enEvent);
        if (enEvent.isOK()) {
            BasketSubmitResult result = (BasketSubmitResult)enEvent.get((Object)"result");
            for (String id : result.getSuccessedIds()) {
                MEvent event = new MEvent();
                event.put((Object)"listId", (Object)id);
                event.put((Object)"isPortfolio", (Object)false);
                this.es.postEvent("basket.submit", event);
            }
        }
    }

    private InstructionExec getExeLeg(Instruction instruction, BasketOrderAdvice basketOrderAdvice, Map<InstructionExec, InstructionExec> exeMap, BasketSecurityInst basketInst) {
        InstructionExec exeItem = new InstructionExec();
        exeItem.setSecId(basketInst.getSecurityId());
        exeItem.setInstructId(instruction.getId());
        exeItem.setMarket(basketInst.getMarket());
        exeItem.setExtAccntId(basketInst.getExtAccntId());
        exeItem.setExtSecAccntId(basketInst.getExtSecAccntId());
        exeItem.setSubAccntId(basketInst.getSubAccntId());
        exeItem.setSubSecAccntId(basketInst.getSubSecAccntId());
        exeItem.setPeFlag(0);
        return exeMap.get(exeItem);
    }

    public void queryBasketItems(Instruction instruction) throws MException {
        List<Object> exeList = new ArrayList();
        if (instruction.getBasketOrderAdvice().getItemList().isEmpty()) {
            instruction.getBasketOrderAdvice().setItemList(this.getInsBasketItems(instruction.getId()));
        }
        exeList = this.resourceDetailMng.query(instruction, 2, "");
        instruction.getBasketOrderAdvice().setExeList(exeList);
    }

    public void queryBasketItemsWithoutResource(Instruction instruction) throws MException {
        if (instruction.getBasketOrderAdvice().getItemList().isEmpty()) {
            instruction.getBasketOrderAdvice().setItemList(this.getInsBasketItems(instruction.getId()));
        }
    }

    public void reviewed(Instruction instruction, int actionId, String postil) throws MException {
        this.wfService.doAction(instruction, actionId, postil);
    }

    public InstructionCancelResult instructionCancelByClId(String clInstructionId) throws MException {
        InstructionCancelResult res = new InstructionCancelResult();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(clInstructionId);
        List<Instruction> instructions = this.insMng.queryByClInsIds(ids);
        switch (instructions.size()) {
            case 0: {
                res.setCode("0");
                res.setErrMsg("\u672a\u67e5\u8be2\u5230\u6307\u4ee4");
                return res;
            }
            case 1: {
                Instruction ins = this.instructionCancelById(instructions.get(0).getId());
                res.setLastOne(ins);
                res.setCode("1");
                res.setErrMsg("\u6307\u4ee4\u64a4\u9500\u6210\u529f");
                return res;
            }
        }
        String insIdsAll = "";
        String insIdsSuccess = "";
        HashSet<Instruction> hashSet = new HashSet<Instruction>();
        hashSet.addAll(instructions);
        for (Instruction instruction : hashSet) {
            try {
                res.setLastOne(instruction);
                insIdsAll = String.valueOf(insIdsAll) + instruction.getId() + "|";
                this.instructionCancelById(instruction.getId());
                insIdsSuccess = String.valueOf(insIdsSuccess) + instruction.getId() + "|";
            }
            catch (MException | Exception e) {
                logger.error("\u524d\u7aef\u6d41\u6c34\u53f7\u67e5\u8be2\u5e76\u64a4\u6307\u4ee4\u51fa\u9519\uff0cid\u4e3a\uff1a" + insIdsAll + "\uff0c\u64a4\u5355\u6210\u529f\u7684\u4e3a\uff1a" + insIdsSuccess, e);
            }
        }
        res.setCode("0");
        res.setErrMsg("\u67e5\u8be2\u5230\u591a\u6761\u6307\u4ee4\uff0cid\u4e3a:" + insIdsAll);
        return res;
    }

    public void queryNewPrice() {
        try {
            this.queryAndGetNewPrice();
        }
        catch (Exception e) {
            logger.error("\u6301\u4ed3\u8f6e\u8be2\u6700\u65b0\u4ef7\u5931\u8d25", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryAndGetNewPrice() {
        ObservableList insList;
        if (!this.shortcutVisible) {
            return;
        }
        ObservableList observableList = insList = this.list.getList();
        synchronized (observableList) {
            LinkedList<RefItem> listItem = new LinkedList<RefItem>();
            for (Instruction ins : insList) {
                RefItem item;
                if (!ins.getType().getRaw().equals("2") || (item = this.refMng.getItem(ins.getOrderAdvice().getMarket(), ins.getOrderAdvice().getSec())) == null || item == null) continue;
                listItem.add(item);
            }
            Gears gears = new Gears();
            gears.setBuy(new int[]{0});
            if (!listItem.isEmpty()) {
                this.marketMng.queryNewPriceIn5Seconds(listItem, gears);
            }
            for (Instruction ins : insList) {
                MarketItem marketItem;
                RefItem item = new RefItem();
                item = "SHSC".equals(ins.getOrderAdvice().getMarket()) || "SZSC".equals(ins.getOrderAdvice().getMarket()) ? this.refMng.getItem(String.valueOf(ins.getOrderAdvice().getSecType()) + ins.getOrderAdvice().getMarket(), ins.getOrderAdvice().getMarket(), ins.getOrderAdvice().getSec()) : this.refMng.getItem(ins.getOrderAdvice().getMarket(), ins.getOrderAdvice().getSec());
                if (item == null || (marketItem = this.marketMng.getInfo((IRefItem)item)) == null) continue;
                if (marketItem.getNowPrice() == 0.0) {
                    ins.setNowPrice(marketItem.getClosePrice());
                    continue;
                }
                ins.setNowPrice(marketItem.getNowPrice());
            }
        }
    }

    public void fairTradeOrderSingle(Instruction instruction) throws MException {
        this.udpateAvailableOrderQty(instruction);
        int orderType = 50;
        List accSecInfoList = instruction.getOrderAdvice().getAccSecInfoList();
        for (AccntSecInfo accntSecInfo : accSecInfoList) {
            String market = instruction.getOrderAdvice().getMarket();
            double price = instruction.getOrderPrice();
            int bstype = instruction.getOrderAdvice().getSide();
            String sec_code = instruction.getOrderAdvice().getSec();
            long count = instruction.getOrderQty();
            if (count <= 0L) continue;
            RefItem item = this.refMng.getItem(market, sec_code);
            PComponent.Instrument.Builder builderI = PComponent.Instrument.newBuilder();
            builderI.setSecurityId(sec_code);
            builderI.setMarket(market);
            if (item != null) {
                builderI.setSecurityType(item.getType());
            }
            if ("XSHG".equals(market) && sec_code.startsWith("688")) {
                builderI.setApplId("700");
            } else if ("SHSC".equals(market) || "SZSC".equals(market)) {
                String applId = "HKN";
                String maxLevels = String.valueOf(instruction.getOrderAdvice().getMaxLevels());
                if (maxLevels.equals("2")) {
                    applId = "HKO";
                }
                builderI.setApplId(applId);
            } else if (item != null && item.isGem()) {
                builderI.setApplId("GEM");
            } else if ("\u9006\u56de\u8d2d".equals(instruction.getSide())) {
                builderI.setApplId("110");
            } else {
                builderI.setApplId("010");
            }
            builderI.setMarketGroup("CCS");
            PComponent.Instrument instrument = builderI.build();
            PMessage.NewOrderSingle.Builder builderO = PMessage.NewOrderSingle.newBuilder();
            builderO.setOpUser(this.baseApi.getOpUser());
            builderO.setInstrument(instrument);
            if (instruction.getOrderAdvice().getOrdType() == 49) {
                orderType = 49;
                builderO.setTifValue(instruction.getOrderAdvice().getTif());
                PCcsExtra.CcsNewOrderSingleExtra.Builder builder = PCcsExtra.CcsNewOrderSingleExtra.newBuilder();
                builder.setMaxPriceLevels(instruction.getOrderAdvice().getMaxLevels());
                builderO.setObject(Any.pack((Message)builder.build()));
            } else if (instruction.getOrderAdvice().getOrdType() == 50 || instruction.getOrderAdvice().getOrdType() == 0) {
                orderType = 50;
            } else if (instruction.getOrderAdvice().getOrdType() == 99) {
                orderType = 99;
            }
            builderO.setOrdTypeValue(orderType);
            builderO.setSideValue(bstype);
            builderO.setOrderQty((double)count);
            builderO.setPrice(price);
            builderO.setClOrdId(instruction.getClInstructionId());
            builderO.setSubAccntId(accntSecInfo.getAccntId());
            builderO.setSubSecAccntId(accntSecInfo.getSecAccntId());
            builderO.setInstructionId(instruction.getId());
            builderO.setReference(instruction.getId());
            builderO.setResourceId(instruction.getResource().getId());
            PMessage.NewOrderSingle order = builderO.build();
            this.orderApi.submit(order);
        }
    }

    public List<PInstructionManagement.CheckResult> checkAvalidPosition(String portfolioId, String extAccntId, String subAccntId, List<PInstructionManagement.CheckItem> items) throws MException {
        return this.insMng.checkAvalidPosition(portfolioId, extAccntId, subAccntId, items);
    }

    public boolean permitOrder(String portfolioId) throws MException {
        WorkFlowDescriptor workflowAttr = this.workflowService.getFlowAssignInfoViaAccntId(portfolioId, 2);
        return workflowAttr.isPermitOrder();
    }

    public void changed() {
        this.sdPushChange.schedule(e -> super.changed());
    }

    public void setShortcutVisible(boolean shortcutVisible) {
        this.shortcutVisible = shortcutVisible;
    }

    public void applyCancel(Instruction instruction, int actionId, String postil) throws MException {
        this.wfService.doAction(instruction, actionId, postil);
    }

    public void denyCancel(Instruction instruction, int actionId, String postil) throws MException {
        this.wfService.doAction(instruction, actionId, postil);
    }

    public void doDistribute(Instruction instruction, int actionId, String userId, String postil) throws MException {
        this.wfService.doDistribute(instruction, actionId, userId, postil);
    }
}

