/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.api.instruction.IInstructionApi;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.datatype.proto.workflow.PInstructionManagement;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubSecAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.MailPosition;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.utils.MarketUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class InstructionMailPositionModel
extends MxModel {
    @Inject
    private IFundAccountService faccService;
    @Inject
    private MScheduler sdFullQuery;
    @Inject
    private MScheduler sdSpecQuery;
    @Inject
    private PortfolioAccountModel portfAcc;
    @Inject
    private IInstructionApi<?> api;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private MEventService es;
    private static final int FULL_QUERY_INTERVAL = 5000;
    private static final int SPEC_QUERY_INTERVAL = 1000;
    private MxList<MailPosition> list = new MxList();
    private volatile boolean working = false;
    private Map<String, CcsSubSecAccount> secMap = new ConcurrentHashMap<String, CcsSubSecAccount>();

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(5000);
        this.sdSpecQuery.setInterval(1000);
        this.es.subscribe("refresh.mail.position", event -> this.query());
    }

    public void query() {
        if (this.working) {
            return;
        }
        try {
            try {
                this.working = true;
                this.fullQuery();
            }
            catch (MException | Exception e) {
                this.logger.error("instruction position query failed: ", e);
                this.working = false;
            }
        }
        finally {
            this.working = false;
        }
    }

    private void fullQuery() throws MException {
        PInstructionManagement.GetSubSecAccntAvalidPositionReq.Builder gb = PInstructionManagement.GetSubSecAccntAvalidPositionReq.newBuilder();
        List<Portfolio> portfolios = this.portfAcc.getPortfoliosAll();
        HashMap<CcsFundAccount, List<SecAccount>> subFundSecMap = new HashMap<CcsFundAccount, List<SecAccount>>();
        for (Portfolio portfolio : portfolios) {
            if (!portfolio.isExternalAsset() || this.portfAcc.getMap(portfolio) == null) continue;
            subFundSecMap.putAll(this.portfAcc.getMap(portfolio));
        }
        for (Map.Entry entry : subFundSecMap.entrySet()) {
            if (entry.getValue() == null) continue;
            for (SecAccount secAccount : (List)entry.getValue()) {
                if (!(secAccount instanceof CcsSubSecAccount)) continue;
                CcsSubSecAccount subSec = (CcsSubSecAccount)CcsSubSecAccount.class.cast(secAccount);
                gb.addSubSecAccnts(subSec.getSubSecAccntId());
                if (this.secMap.containsKey(subSec.getSubSecAccntId())) continue;
                this.secMap.put(subSec.getSubSecAccntId(), subSec);
            }
        }
        List list = this.api.getSubSecAccntAvalidPosition(gb);
        ArrayList<MailPosition> positions = new ArrayList<MailPosition>();
        for (PInstructionManagement.GetPositionResult getPositionResult : list) {
            MailPosition mailPosition = new MailPosition();
            mailPosition.update((Object)getPositionResult);
            this.afterUpdate(mailPosition);
            positions.add(mailPosition);
        }
        this.update(positions);
    }

    private void afterUpdate(MailPosition mailPosition) {
        CcsSubSecAccount subSec;
        mailPosition.setMarketName(MarketUtils.getMarketNameById((String)mailPosition.getMarket()));
        RefItem item = null;
        item = "SHSC".equals(mailPosition.getMarket()) || "SZSC".equals(mailPosition.getMarket()) ? this.refMng.getItem(String.valueOf(mailPosition.getSecurityType()) + mailPosition.getMarket(), mailPosition.getMarket(), mailPosition.getSecurityId()) : this.refMng.getItem(mailPosition.getSecurityType(), mailPosition.getMarket(), mailPosition.getSecurityId());
        if (item != null) {
            mailPosition.setSecName(item.getName());
        }
        if ((subSec = this.secMap.get(mailPosition.getSubSecAccntId())) != null) {
            mailPosition.setInvestorId(subSec.getInverstorId());
            mailPosition.setInvestorSecId(subSec.getInverstorSecId());
            mailPosition.setPortfolioId(subSec.getPortfolioId());
            mailPosition.setPortfolioName(subSec.getPortfolioName());
        }
    }

    private void update(List<MailPosition> listQuery) {
        this.list.setAll(listQuery);
        this.changed();
    }

    public List<MailPosition> getList() {
        return this.list.getList();
    }
}

