/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.entity.web.workflow.GetWorkflowTemplateReq;
import cms.tmx.entity.web.workflow.GetWorkflowTemplateResp;
import cms.tmx.entity.web.workflow.Node;
import cms.tmx.entity.web.workflow.WorkflowTemplate;
import cms.tmx.http.instruction.dto.AccntSecInfo;
import cms.tmx.http.instruction.dto.SimpleDetail;
import cms.tmx.javafx.MxModel;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.MarginAccountMap;
import cms.tmx.web.api.workflow.WorkflowTemplateApi;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class InstructionAccountModelNew
extends MxModel {
    @Inject
    private IBaseApi baseApi;
    @Inject
    private WorkflowTemplateApi workflowTemplateApi;
    @Inject
    protected CcsAccountMap ccsAccountMap;
    @Inject
    private MarginAccountMap marginAccountMap;
    private Map<String, WorkflowTemplate> mapWorkflow = new HashMap<String, WorkflowTemplate>();
    private Map<String, List<WorkflowTemplate>> mapWorkflowTemplate = new HashMap<String, List<WorkflowTemplate>>();
    private Map<CcsFundAccount, List<SecAccount>> neeqOriginAccountMap = new HashMap<CcsFundAccount, List<SecAccount>>();
    private Map<CcsFundAccount, List<SecAccount>> marginOriginAccountMap = new HashMap<CcsFundAccount, List<SecAccount>>();
    private Map<String, Map<CcsFundAccount, List<SecAccount>>> mapPanelNeeqFundAccount = new HashMap<String, Map<CcsFundAccount, List<SecAccount>>>();
    private Map<String, Map<CcsFundAccount, List<SecAccount>>> mapPanelMarginFundAccount = new HashMap<String, Map<CcsFundAccount, List<SecAccount>>>();
    private boolean finished = false;

    public synchronized void createAccMap() {
        try {
            this.neeqOriginAccountMap = this.ccsAccountMap.getAccountMap().entrySet().stream().filter(map -> ((CcsFundAccount)map.getKey()).isNeeqEnable()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.marginOriginAccountMap = this.marginAccountMap.getAccountMap();
        }
        catch (MException e) {
            this.logger.error("\u52a0\u8f7d\u65b0\u6846\u67b6\u8d26\u53f7\u6811\u6a21\u578b \u521d\u59cb\u5316map\u62a5\u9519", (Throwable)e);
        }
        this.createPanelNeeqFundAccMap();
        this.createPanelMarginFundAccMap();
        this.finished = true;
    }

    private void createPanelMarginFundAccMap() {
        HashMap<CcsFundAccount, List<SecAccount>> mapUndefined = new HashMap<CcsFundAccount, List<SecAccount>>();
        this.mapPanelMarginFundAccount.put("4", mapUndefined);
        for (CcsFundAccount ccsFundAccount : this.marginOriginAccountMap.keySet()) {
            mapUndefined.put(ccsFundAccount, this.marginOriginAccountMap.get(ccsFundAccount));
            try {
                GetWorkflowTemplateReq req = new GetWorkflowTemplateReq();
                req.setOrg(this.baseApi.getPartyId());
                req.setUserId(this.baseApi.getUserId());
                req.setPostId(this.baseApi.getPostId());
                req.setObjType("2");
                req.setObjId(ccsFundAccount.getProductId());
                req.setAccntId(ccsFundAccount.getParentId());
                GetWorkflowTemplateResp resp = this.workflowTemplateApi.getWorkflowTemplate(req);
                if (resp.getList() == null || resp.getList().size() == 0) continue;
                List list = resp.getList();
                this.mapWorkflowTemplate.put(ccsFundAccount.getExtAccntId(), list);
                for (WorkflowTemplate workflowTemplate : list) {
                    Node node = workflowTemplate.getNode();
                    String orderType = node.getOrderType();
                    this.mapWorkflow.put(workflowTemplate.getInstanceId(), workflowTemplate);
                    if ("0".equals(orderType)) {
                        this.putInMapMargin("0", ccsFundAccount);
                        continue;
                    }
                    if (!"1".equals(orderType)) continue;
                    this.putInMapMargin("1", ccsFundAccount);
                }
            }
            catch (MException e) {
                this.logger.error("\u4e8c\u878d\u8d26\u53f7\u6811\u521d\u59cb\u5316\u67e5\u8be2\u5de5\u4f5c\u6d41\u5931\u8d25 \u8d26\u53f7:" + ccsFundAccount.getInvestId(), (Throwable)e);
            }
        }
    }

    private void createPanelNeeqFundAccMap() {
        HashMap<CcsFundAccount, List<SecAccount>> mapUndefined = new HashMap<CcsFundAccount, List<SecAccount>>();
        this.mapPanelNeeqFundAccount.put("4", mapUndefined);
        for (CcsFundAccount ccsFundAccount : this.neeqOriginAccountMap.keySet()) {
            mapUndefined.put(ccsFundAccount, this.neeqOriginAccountMap.get(ccsFundAccount));
            try {
                GetWorkflowTemplateReq req = new GetWorkflowTemplateReq();
                req.setOrg(this.baseApi.getPartyId());
                req.setUserId(this.baseApi.getUserId());
                req.setPostId(this.baseApi.getPostId());
                req.setObjType("2");
                req.setObjId(ccsFundAccount.getProductId());
                req.setAccntId(ccsFundAccount.getParentId());
                GetWorkflowTemplateResp resp = this.workflowTemplateApi.getWorkflowTemplate(req);
                if (resp.getList() == null || resp.getList().size() == 0) continue;
                List list = resp.getList();
                this.mapWorkflowTemplate.put(ccsFundAccount.getExtAccntId(), list);
                for (WorkflowTemplate workflowTemplate : list) {
                    Node node = workflowTemplate.getNode();
                    String orderType = node.getOrderType();
                    this.mapWorkflow.put(workflowTemplate.getInstanceId(), workflowTemplate);
                    if ("0".equals(orderType)) {
                        this.putInMapNeeq("0", ccsFundAccount);
                        continue;
                    }
                    if (!"1".equals(orderType)) continue;
                    this.putInMapNeeq("1", ccsFundAccount);
                }
            }
            catch (MException e) {
                this.logger.error("\u65b0\u4e09\u677f\u8d26\u53f7\u6811\u521d\u59cb\u5316\u67e5\u8be2\u5de5\u4f5c\u6d41\u5931\u8d25 \u8d26\u53f7:" + ccsFundAccount.getInvestId(), (Throwable)e);
            }
        }
    }

    private void putInMapNeeq(String instructionType, CcsFundAccount ccsFundAccount) {
        if (this.mapPanelNeeqFundAccount.get(instructionType) == null) {
            HashMap<CcsFundAccount, List<SecAccount>> fundAccList = new HashMap<CcsFundAccount, List<SecAccount>>();
            fundAccList.put(ccsFundAccount, this.neeqOriginAccountMap.get(ccsFundAccount));
            this.mapPanelNeeqFundAccount.put(instructionType, fundAccList);
        } else {
            this.mapPanelNeeqFundAccount.get(instructionType).put(ccsFundAccount, this.neeqOriginAccountMap.get(ccsFundAccount));
        }
    }

    private void putInMapMargin(String instructionType, CcsFundAccount ccsFundAccount) {
        if (this.mapPanelMarginFundAccount.get(instructionType) == null) {
            HashMap<CcsFundAccount, List<SecAccount>> fundAccList = new HashMap<CcsFundAccount, List<SecAccount>>();
            fundAccList.put(ccsFundAccount, this.marginOriginAccountMap.get(ccsFundAccount));
            this.mapPanelMarginFundAccount.put(instructionType, fundAccList);
        } else {
            this.mapPanelMarginFundAccount.get(instructionType).put(ccsFundAccount, this.marginOriginAccountMap.get(ccsFundAccount));
        }
    }

    public synchronized Map<CcsFundAccount, List<SecAccount>> getActiveAccMap(String instructType) {
        if (!this.finished) {
            this.createAccMap();
        }
        return this.mapPanelNeeqFundAccount.get(instructType);
    }

    public synchronized Map<CcsFundAccount, List<SecAccount>> getMarginActiveAccMap(String instructType) {
        if (!this.finished) {
            this.createAccMap();
        }
        return this.mapPanelMarginFundAccount.get(instructType);
    }

    public Map<CcsFundAccount, List<SecAccount>> getPassiveAccMap(ObSimpleInstruction instruction) {
        if ("SimpleDetail".equals(instruction.getType())) {
            return this.createPassiveFstMap(instruction.getOrderDetail());
        }
        return null;
    }

    public Map<CcsFundAccount, List<SecAccount>> getMarginPassiveAccMap(ObSimpleInstruction instruction) {
        if ("SimpleDetail".equals(instruction.getType())) {
            return this.createMarginPassiveMap(instruction.getOrderDetail());
        }
        return null;
    }

    private Map<CcsFundAccount, List<SecAccount>> createPassiveFstMap(SimpleDetail orderDetail) {
        HashMap<CcsFundAccount, List<SecAccount>> map = new HashMap<CcsFundAccount, List<SecAccount>>();
        if (this.neeqOriginAccountMap == null) {
            return null;
        }
        for (AccntSecInfo info : orderDetail.getAccntSecInfo()) {
            for (CcsFundAccount fundAcc : this.neeqOriginAccountMap.keySet()) {
                if (!fundAcc.getNewCashAccntId().equals(info.getAccountId().getCashAccntId())) continue;
                List secList = map.get(fundAcc) == null ? new LinkedList() : (List)map.get(fundAcc);
                this.neeqOriginAccountMap.get(fundAcc).forEach(secAcc -> {
                    if (info.getAccountId().getSecAccntId().equals(secAcc.getExtSecAccntId())) {
                        secList.add(secAcc);
                    }
                });
                map.put(fundAcc, secList);
            }
        }
        return map;
    }

    private Map<CcsFundAccount, List<SecAccount>> createMarginPassiveMap(SimpleDetail orderDetail) {
        HashMap<CcsFundAccount, List<SecAccount>> map = new HashMap<CcsFundAccount, List<SecAccount>>();
        if (this.marginOriginAccountMap == null) {
            return null;
        }
        for (AccntSecInfo info : orderDetail.getAccntSecInfo()) {
            for (CcsFundAccount fundAcc : this.marginOriginAccountMap.keySet()) {
                if (!fundAcc.getNewCashAccntId().equals(info.getAccountId().getCashAccntId())) continue;
                List secList = map.get(fundAcc) == null ? new LinkedList() : (List)map.get(fundAcc);
                this.marginOriginAccountMap.get(fundAcc).forEach(secAcc -> {
                    if (info.getAccountId().getSecAccntId().equals(secAcc.getExtSecAccntId())) {
                        secList.add(secAcc);
                    }
                });
                map.put(fundAcc, secList);
            }
        }
        return map;
    }

    public WorkflowTemplate getWorkflow(String id) {
        return this.mapWorkflow.get(id);
    }
}

