/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MException;
import cms.tmx.define.BsDict;
import cms.tmx.entity.AccntStepAttribute;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.CcsSubSecAccount;
import cms.tmx.entity.CtpFundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.WorkFlowDescriptor;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.IRoleService;
import cms.tmx.manage.IWorkFlowService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.CtpAccountMap;
import cms.tmx.query.current.models.PortfolioAccountModel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class InstructionAccountModel
extends MxModel {
    @Inject
    private IRoleService roleService;
    @Inject
    private IBaseApi baseApi;
    @Inject
    private PortfolioAccountModel portfolioModel;
    @Inject
    private IWorkFlowService wfService;
    @Inject
    protected CcsAccountMap accMng;
    @Inject
    protected CtpAccountMap ctpAccMng;
    private List<String> roleList = new LinkedList<String>();
    private List<Portfolio> portfolioOrgList = new LinkedList<Portfolio>();
    private List<Portfolio> extPortfolioOrgList = new LinkedList<Portfolio>();
    private Map<CcsFundAccount, List<SecAccount>> originAccountMap = new HashMap<CcsFundAccount, List<SecAccount>>();
    private Map<CtpFundAccount, List<SecAccount>> ctpOriginAccountMap = new HashMap<CtpFundAccount, List<SecAccount>>();
    private Map<String, List<Portfolio>> mapPanelPorfolio = new HashMap<String, List<Portfolio>>();
    private Map<String, List<Portfolio>> mapMailPanelPorfolio = new HashMap<String, List<Portfolio>>();
    private Map<String, Map<CcsFundAccount, List<SecAccount>>> mapPanelFundAccount = new HashMap<String, Map<CcsFundAccount, List<SecAccount>>>();
    private Map<String, Map<CtpFundAccount, List<SecAccount>>> ctpMapPanelFundAccount = new HashMap<String, Map<CtpFundAccount, List<SecAccount>>>();
    private Map<String, WorkFlowDescriptor> mapWorkflow = new HashMap<String, WorkFlowDescriptor>();
    private static final Logger logger = LogManager.getLogger(InstructionAccountModel.class);
    private boolean finished = false;

    @PostConstruct
    public void init() {
    }

    public synchronized void createAccMap() {
        try {
            this.originAccountMap = this.accMng.getAccountMap();
            this.ctpOriginAccountMap = this.ctpAccMng.getAccountMap();
        }
        catch (MException e) {
            logger.error("\u67e5\u8be2\u89d2\u8272\u6216\u8d26\u53f7\u5931\u8d25", (Throwable)e);
        }
        this.portfolioOrgList = this.portfolioModel.getPortfolios();
        this.extPortfolioOrgList = this.portfolioModel.getExternalPortfolios();
        this.createPanelPorfolioMap();
        this.createPanelFundAccMap();
        this.createCtpPanelFundAccMap();
        this.createMailPanelPorfolioMap();
        this.finished = true;
    }

    private void createPanelPorfolioMap() {
        LinkedList<Portfolio> listUndefined = new LinkedList<Portfolio>();
        this.mapPanelPorfolio.put("0", listUndefined);
        listUndefined.addAll(this.portfolioOrgList);
        for (Portfolio portfo : this.portfolioOrgList) {
            try {
                WorkFlowDescriptor wf = this.wfService.getFlowAssignInfoViaAccntId(portfo.getId(), BsDict.INSTRUCT_OBJ_TYPE_PORTFOLIO);
                if (wf == null) {
                    return;
                }
                this.mapWorkflow.put(wf.getPortfolioId(), wf);
                List stepList = wf.getSteps();
                block13: for (AccntStepAttribute step : stepList) {
                    if (!step.isDistributeFlag()) continue;
                    switch (step.getTarget().getRaw()) {
                        case "2": {
                            if (!step.getObjIds().contains(this.baseApi.getPostId())) break;
                            this.putInMap(step, portfo);
                            break;
                        }
                        case "1": {
                            for (String role : this.roleList) {
                                if (!step.getObjIds().contains(role)) continue;
                                this.putInMap(step, portfo);
                            }
                            continue block13;
                        }
                        case "3": {
                            if (!step.getObjIds().contains(this.baseApi.getOpUser().getUserId())) break;
                            this.putInMap(step, portfo);
                            break;
                        }
                    }
                }
            }
            catch (MException e) {
                logger.error("\u67e5\u8be2\u5de5\u4f5c\u6d41\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private void createMailPanelPorfolioMap() {
        for (Portfolio portfo : this.extPortfolioOrgList) {
            try {
                WorkFlowDescriptor wf = this.wfService.getFlowAssignInfoViaAccntId(portfo.getId(), BsDict.INSTRUCT_OBJ_TYPE_PORTFOLIO);
                if (wf == null) {
                    return;
                }
                this.mapWorkflow.put(wf.getPortfolioId(), wf);
                List stepList = wf.getSteps();
                block13: for (AccntStepAttribute step : stepList) {
                    if (!step.isDistributeFlag()) continue;
                    switch (step.getTarget().getRaw()) {
                        case "2": {
                            if (!step.getObjIds().contains(this.baseApi.getPostId())) break;
                            this.putInMailMap(step, portfo);
                            break;
                        }
                        case "1": {
                            for (String role : this.roleList) {
                                if (!step.getObjIds().contains(role)) continue;
                                this.putInMailMap(step, portfo);
                            }
                            continue block13;
                        }
                        case "3": {
                            if (!step.getObjIds().contains(this.baseApi.getOpUser().getUserId())) break;
                            this.putInMailMap(step, portfo);
                            break;
                        }
                    }
                }
            }
            catch (MException e) {
                logger.error("\u67e5\u8be2\u5de5\u4f5c\u6d41\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private void createPanelFundAccMap() {
        HashMap<CcsFundAccount, List<SecAccount>> mapUndefined = new HashMap<CcsFundAccount, List<SecAccount>>();
        this.mapPanelFundAccount.put("0", mapUndefined);
        HashMap<CcsFundAccount, List<SecAccount>> mapMultiCenter = new HashMap<CcsFundAccount, List<SecAccount>>();
        this.mapPanelFundAccount.put("10", mapMultiCenter);
        for (CcsFundAccount ccsFundAccount : this.originAccountMap.keySet()) {
            mapUndefined.put(ccsFundAccount, this.originAccountMap.get(ccsFundAccount));
            if (ccsFundAccount.getInvestId().contains("@")) {
                mapMultiCenter.put(ccsFundAccount, this.originAccountMap.get(ccsFundAccount));
            }
            try {
                WorkFlowDescriptor wf = this.wfService.getFlowAssignInfoViaAccntId(ccsFundAccount.getParentId(), BsDict.INSTRUCT_OBJ_TYPE_ACCOUNT);
                if (wf == null) {
                    return;
                }
                this.mapWorkflow.put(wf.getAccntId(), wf);
                List stepList = wf.getSteps();
                block13: for (AccntStepAttribute step : stepList) {
                    if (!step.isDistributeFlag()) continue;
                    switch (step.getTarget().getRaw()) {
                        case "2": {
                            if (!step.getObjIds().contains(this.baseApi.getOpUser().getPostId())) break;
                            this.putInMap(step, ccsFundAccount);
                            break;
                        }
                        case "1": {
                            for (String role : this.roleList) {
                                if (!step.getObjIds().contains(role)) continue;
                                this.putInMap(step, ccsFundAccount);
                            }
                            continue block13;
                        }
                        case "3": {
                            if (!step.getObjIds().contains(this.baseApi.getOpUser().getUserId())) break;
                            this.putInMap(step, ccsFundAccount);
                            break;
                        }
                    }
                }
            }
            catch (MException e) {
                logger.error("\u67e5\u8be2\u5de5\u4f5c\u6d41\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private void createCtpPanelFundAccMap() {
        HashMap<CtpFundAccount, List<SecAccount>> ctpMapUndefined = new HashMap<CtpFundAccount, List<SecAccount>>();
        this.ctpMapPanelFundAccount.put("0", ctpMapUndefined);
        for (CtpFundAccount fundAccount : this.ctpOriginAccountMap.keySet()) {
            ctpMapUndefined.put(fundAccount, this.ctpOriginAccountMap.get(fundAccount));
            try {
                WorkFlowDescriptor wf = this.wfService.getFlowAssignInfoViaAccntId(fundAccount.getParentId(), BsDict.INSTRUCT_OBJ_TYPE_ACCOUNT);
                if (wf == null) {
                    return;
                }
                this.mapWorkflow.put(wf.getAccntId(), wf);
                List stepList = wf.getSteps();
                block13: for (AccntStepAttribute step : stepList) {
                    if (!step.isDistributeFlag()) continue;
                    switch (step.getTarget().getRaw()) {
                        case "2": {
                            if (!step.getObjIds().contains(this.baseApi.getOpUser().getPostId())) break;
                            this.putInMap(step, fundAccount);
                            break;
                        }
                        case "1": {
                            for (String role : this.roleList) {
                                if (!step.getObjIds().contains(role)) continue;
                                this.putInMap(step, fundAccount);
                            }
                            continue block13;
                        }
                        case "3": {
                            if (!step.getObjIds().contains(this.baseApi.getOpUser().getUserId())) break;
                            this.putInMap(step, fundAccount);
                            break;
                        }
                    }
                }
            }
            catch (MException e) {
                logger.error("\u67e5\u8be2\u5de5\u4f5c\u6d41\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private void putInMap(AccntStepAttribute step, Portfolio portfo) {
        String type = step.getInstructType().getRaw();
        if (this.mapPanelPorfolio.get(type) == null) {
            LinkedList<Portfolio> portfolioList = new LinkedList<Portfolio>();
            portfolioList.add(portfo);
            this.mapPanelPorfolio.put(type, portfolioList);
        } else if (!this.mapPanelPorfolio.get(type).contains(portfo)) {
            this.mapPanelPorfolio.get(type).add(portfo);
        }
    }

    private void putInMailMap(AccntStepAttribute step, Portfolio portfo) {
        String type = step.getInstructType().getRaw();
        if (this.mapMailPanelPorfolio.get(type) == null) {
            LinkedList<Portfolio> portfolioList = new LinkedList<Portfolio>();
            portfolioList.add(portfo);
            this.mapMailPanelPorfolio.put(type, portfolioList);
        } else if (!this.mapMailPanelPorfolio.get(type).contains(portfo)) {
            this.mapMailPanelPorfolio.get(type).add(portfo);
        }
    }

    private void putInMap(AccntStepAttribute step, CcsFundAccount ccsFundAccount) {
        String type = step.getInstructType().getRaw();
        if (this.mapPanelFundAccount.get(type) == null) {
            HashMap<CcsFundAccount, List<SecAccount>> fundAccList = new HashMap<CcsFundAccount, List<SecAccount>>();
            fundAccList.put(ccsFundAccount, this.originAccountMap.get(ccsFundAccount));
            this.mapPanelFundAccount.put(type, fundAccList);
        } else {
            this.mapPanelFundAccount.get(type).put(ccsFundAccount, this.originAccountMap.get(ccsFundAccount));
        }
    }

    private void putInMap(AccntStepAttribute step, CtpFundAccount ctpFundAccount) {
        String type = step.getInstructType().getRaw();
        if (this.ctpMapPanelFundAccount.get(type) == null) {
            HashMap<CtpFundAccount, List<SecAccount>> fundAccList = new HashMap<CtpFundAccount, List<SecAccount>>();
            fundAccList.put(ctpFundAccount, this.ctpOriginAccountMap.get(ctpFundAccount));
            this.ctpMapPanelFundAccount.put(type, fundAccList);
        } else {
            this.ctpMapPanelFundAccount.get(type).put(ctpFundAccount, this.ctpOriginAccountMap.get(ctpFundAccount));
        }
    }

    public synchronized Map<CcsFundAccount, List<SecAccount>> getActiveAccMap(String instructType) {
        if (!this.finished) {
            this.createAccMap();
        }
        return this.mapPanelFundAccount.get(instructType);
    }

    public synchronized Map<CtpFundAccount, List<SecAccount>> getCtpActiveAccMap(String instructType) {
        if (!this.finished) {
            this.createAccMap();
        }
        return this.ctpMapPanelFundAccount.get(instructType);
    }

    public synchronized List<Portfolio> getActivePortfolios(String instructType) {
        if (!this.finished) {
            this.createAccMap();
        }
        return this.mapPanelPorfolio.get(instructType);
    }

    public synchronized List<Portfolio> getExtActivePortfolios(String instructType) {
        if (!this.finished) {
            this.createAccMap();
        }
        return this.mapMailPanelPorfolio.get(instructType);
    }

    public List<Portfolio> getPassivePortfolios(String portId) {
        LinkedList<Portfolio> list = new LinkedList<Portfolio>();
        for (Portfolio portfolio : this.portfolioOrgList) {
            if (!portfolio.getId().equals(portId)) continue;
            list.add(portfolio);
        }
        return list;
    }

    public List<Portfolio> getPassiveExtPortfolios(String portId) {
        LinkedList<Portfolio> list = new LinkedList<Portfolio>();
        for (Portfolio portfolio : this.extPortfolioOrgList) {
            if (!portfolio.getId().equals(portId)) continue;
            list.add(portfolio);
        }
        return list;
    }

    public Map<CcsFundAccount, List<SecAccount>> getPassiveAccMap(Instruction instruction) {
        if ("3".equals(instruction.getType().getRaw())) {
            return this.createPassiveSecMap(instruction.getOrderAdvice());
        }
        if ("9".equals(instruction.getType().getRaw())) {
            return this.createPassiveSecMap(instruction.getAlgoParam());
        }
        if ("2".equals(instruction.getType().getRaw())) {
            return this.createPassiveFstMap(instruction.getOrderAdvice());
        }
        if ("8".equals(instruction.getType().getRaw())) {
            return this.createPassiveFstMap(instruction.getAlgoParam());
        }
        return null;
    }

    public Map<CtpFundAccount, List<SecAccount>> getCtpPassiveAccMap(Instruction instruction) {
        if ("64".equals(instruction.getType().getRaw())) {
            return this.createCtpPassiveFstMap(instruction.getOrderAdvice());
        }
        return null;
    }

    private Map<CcsFundAccount, List<SecAccount>> createPassiveFstMap(OrderAdvice advice) {
        HashMap<CcsFundAccount, List<SecAccount>> map = new HashMap<CcsFundAccount, List<SecAccount>>();
        if (this.originAccountMap == null) {
            return null;
        }
        for (AccntSecInfo info : advice.getAccSecInfoList()) {
            for (CcsFundAccount fundAcc : this.originAccountMap.keySet()) {
                if (!fundAcc.getExtAccntId().equals(info.getAccntId())) continue;
                List secList = map.get(fundAcc) == null ? new LinkedList() : (List)map.get(fundAcc);
                this.originAccountMap.get(fundAcc).forEach(secAcc -> {
                    if (info.getSecAccntId().equals(secAcc.getExtSecAccntId())) {
                        secList.add(secAcc);
                    }
                });
                map.put(fundAcc, secList);
            }
        }
        return map;
    }

    private Map<CcsFundAccount, List<SecAccount>> createPassiveFstMap(AlgoParam advice) {
        HashMap<CcsFundAccount, List<SecAccount>> map = new HashMap<CcsFundAccount, List<SecAccount>>();
        if (this.originAccountMap == null) {
            return null;
        }
        for (AccntSecInfo info : advice.getAccSecInfoList()) {
            for (CcsFundAccount fundAcc : this.originAccountMap.keySet()) {
                if (!fundAcc.getExtAccntId().equals(info.getAccntId())) continue;
                List secList = map.get(fundAcc) == null ? new LinkedList() : (List)map.get(fundAcc);
                this.originAccountMap.get(fundAcc).forEach(secAcc -> {
                    if (info.getSecAccntId().equals(secAcc.getExtSecAccntId())) {
                        secList.add(secAcc);
                    }
                });
                map.put(fundAcc, secList);
            }
        }
        return map;
    }

    private Map<CcsFundAccount, List<SecAccount>> createPassiveSecMap(OrderAdvice advice) {
        return this.createPassiveSecMap(advice.getPortfolioId(), advice.getAccSecInfoList());
    }

    private Map<CcsFundAccount, List<SecAccount>> createPassiveSecMap(AlgoParam advice) {
        return this.createPassiveSecMap(advice.getPortfolio(), advice.getAccSecInfoList());
    }

    private Map<CcsFundAccount, List<SecAccount>> createPassiveSecMap(String portfolioId, List<AccntSecInfo> list) {
        HashMap<CcsFundAccount, List<SecAccount>> map = new HashMap<CcsFundAccount, List<SecAccount>>();
        Map<CcsFundAccount, List<SecAccount>> originMap = this.portfolioModel.getMap(portfolioId);
        if (originMap == null) {
            return null;
        }
        for (AccntSecInfo info : list) {
            for (CcsFundAccount fundAcc : originMap.keySet()) {
                CcsSubFundAccount subfundAcc;
                if (!(fundAcc instanceof CcsSubFundAccount) || !(subfundAcc = (CcsSubFundAccount)CcsSubFundAccount.class.cast(fundAcc)).getSubAccntId().equals(info.getAccntId())) continue;
                List secList = map.get(subfundAcc) == null ? new LinkedList() : (List)map.get(subfundAcc);
                originMap.get(subfundAcc).forEach(secAcc -> {
                    if (secAcc instanceof CcsSubSecAccount) {
                        CcsSubSecAccount subsecAcc = (CcsSubSecAccount)CcsSubSecAccount.class.cast(secAcc);
                        if (info.getSecAccntId().equals(subsecAcc.getSubSecAccntId())) {
                            secList.add(subsecAcc);
                        }
                    }
                });
                map.put((CcsFundAccount)subfundAcc, secList);
            }
        }
        return map;
    }

    private Map<CtpFundAccount, List<SecAccount>> createCtpPassiveFstMap(OrderAdvice advice) {
        HashMap<CtpFundAccount, List<SecAccount>> map = new HashMap<CtpFundAccount, List<SecAccount>>();
        if (this.ctpOriginAccountMap == null) {
            return null;
        }
        for (AccntSecInfo info : advice.getAccSecInfoList()) {
            for (CtpFundAccount fundAcc : this.ctpOriginAccountMap.keySet()) {
                if (!fundAcc.getExtAccntId().equals(info.getAccntId())) continue;
                List secList = map.get(fundAcc) == null ? new LinkedList() : (List)map.get(fundAcc);
                this.ctpOriginAccountMap.get(fundAcc).forEach(secAcc -> {
                    if (info.getSecAccntId().equals(secAcc.getExtSecAccntId())) {
                        secList.add(secAcc);
                    }
                });
                map.put(fundAcc, secList);
            }
        }
        return map;
    }

    public WorkFlowDescriptor getWorkflow(String id) {
        return this.mapWorkflow.get(id);
    }
}

