/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionLog;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.query.current.mng.InstructionLogMng;
import cms.tmx.utils.StringUtils;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.List;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructLogModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(InstructLogModel.class);
    protected MxList<InstructionLog> list = new MxList();
    private static final int FULL_QUERY_INTERVAL = 3000;
    private Instruction instruction;
    private int type;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MObjFactory of;
    private static final String FORMAT_DATE = "yyyyMMdd";
    private DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final String FORMAT_HOUR = "yyyyMMdd HH:mm:ss";
    private DateTimeFormatter formatHour = DateTimeFormatter.ofPattern("yyyyMMdd HH:mm:ss");

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException e) {
                logger.error("instruction log query failed", (Throwable)e);
            }
        });
    }

    private void fullQuery() throws MException {
        String endTime = this.instruction.getResource().getEndTime();
        LocalDate expireDate = null;
        LocalDate endDate = null;
        LocalDate today = LocalDate.now();
        try {
            if (!StringUtils.isEmpty((String)this.instruction.getExpireDate())) {
                expireDate = LocalDate.parse(this.instruction.getExpireDate(), this.format);
            }
            if (!StringUtils.isEmpty((String)endTime)) {
                endDate = LocalDate.parse(endTime, this.formatHour);
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5ba1\u6279\u65e5\u5fd7\uff0c\u683c\u5f0f\u5316\u65e5\u671f\u51fa\u9519\uff0c\u4e0d\u5f71\u54cd\u67e5\u8be2" + e.getMessage());
        }
        this.type = expireDate == null || expireDate.isBefore(today) ? 2 : (!StringUtils.isEmpty((String)endTime) && endDate.isBefore(today) ? 2 : 1);
        LinkedList<InstructionLog> listExec = new LinkedList<InstructionLog>();
        InstructionLogMng logMng = this.getQuery(this.instruction);
        List<InstructionLog> listQuery = logMng.query();
        listExec.addAll(listQuery);
        this.update(listExec);
    }

    private synchronized InstructionLogMng getQuery(Instruction instruction) {
        if (instruction == null) {
            return null;
        }
        InstructionLogMng query = (InstructionLogMng)((Object)this.of.create(InstructionLogMng.class));
        query.setInstruction(instruction, this.type);
        return query;
    }

    public ObservableList<InstructionLog> getList() {
        return this.list.getList();
    }

    private synchronized void update(List<InstructionLog> listExec) {
        LinkedList<InstructionLog> listCcsOrder = new LinkedList<InstructionLog>();
        for (InstructionLog exec : listExec) {
            if (!(exec instanceof InstructionLog)) continue;
            listCcsOrder.add((InstructionLog)InstructionLog.class.cast(exec));
        }
        this.list.setAll(listCcsOrder);
        this.changed();
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(Instruction instruction, int type) {
        this.instruction = instruction;
        this.type = type;
    }

    public int getType() {
        return this.type;
    }
}

