/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.trade.instruction.BasketSecurityInst;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionExec;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.query.current.mng.InstructionExecMng;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructExecModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(InstructExecModel.class);
    protected MxList<InstructionExec> list = new MxList();
    private static final int FULL_QUERY_INTERVAL = 3000;
    private Instruction instruction;
    private int type;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MObjFactory of;

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException e) {
                logger.error("instruction execution query failed", (Throwable)e);
            }
        });
    }

    public void fullQuery() throws MException {
        LinkedList<InstructionExec> listExec = new LinkedList<InstructionExec>();
        InstructionExecMng execMng = this.getQuery(this.instruction);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
        Date date = null;
        try {
            date = format.parse(this.instruction.getBeginTime());
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        format = new SimpleDateFormat("yyyyMMdd");
        String tradeDay = "";
        if (this.type == 2) {
            tradeDay = format.format(date);
        }
        List<InstructionExec> listQuery = execMng.query(1, tradeDay);
        listExec.addAll(listQuery);
        this.update(listExec, this.instruction, execMng);
    }

    private synchronized InstructionExecMng getQuery(Instruction instruction) {
        if (instruction == null || instruction.getResource() == null) {
            return null;
        }
        InstructionExecMng query = (InstructionExecMng)((Object)this.of.create(InstructionExecMng.class));
        query.setInstruction(instruction);
        return query;
    }

    public ObservableList<InstructionExec> getList() {
        return this.list.getList();
    }

    /*
     * Exception decompiling
     */
    private synchronized void update(List<InstructionExec> listExec, Instruction ins, InstructionExecMng execMng) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[7] lbl51 : CaseStatement: default:\u000a, @NONE, blocks:[7] lbl51 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private synchronized void update(List<InstructionExec> listExec, Instruction ins) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[7] lbl51 : CaseStatement: default:\u000a, @NONE, blocks:[7] lbl51 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HashMap<String, Double> getUpperLowerLmtPriceMap(Instruction ins) {
        HashMap<String, Double> priceMap = new HashMap<String, Double>();
        for (BasketSecurityInst inst : ins.getBasketOrderAdvice().getItemList()) {
            priceMap.put(inst.getSecurityId(), inst.getSide() == 49 ? inst.getLimitPriceUp() : inst.getLimitPriceLow());
        }
        return priceMap;
    }

    private HashMap<String, Double> getLowerLmtPriceMap(Instruction ins) {
        HashMap<String, Double> priceMap = new HashMap<String, Double>();
        for (BasketSecurityInst inst : ins.getBasketOrderAdvice().getItemList()) {
            priceMap.put(inst.getSecurityId(), inst.getLimitPriceLow());
        }
        return priceMap;
    }

    private HashMap<String, Double> getUpperLmtPriceMap(Instruction ins) {
        HashMap<String, Double> priceMap = new HashMap<String, Double>();
        for (BasketSecurityInst inst : ins.getBasketOrderAdvice().getItemList()) {
            priceMap.put(inst.getSecurityId(), inst.getLimitPriceUp());
        }
        return priceMap;
    }

    private HashMap<String, Double> getFixedPriceMap(Instruction ins) {
        HashMap<String, Double> priceMap = new HashMap<String, Double>();
        for (BasketSecurityInst inst : ins.getBasketOrderAdvice().getItemList()) {
            priceMap.put(inst.getSecurityId(), inst.getOrderPrice());
        }
        return priceMap;
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(Instruction instruction, int type) {
        this.instruction = instruction;
        this.type = type;
    }

    public int getType() {
        return this.type;
    }
}

