/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.api.data.IRefItem;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.data.utils.Gears;
import cms.tmx.define.IDictMap;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.Order;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.web.settings.BaseSettings;
import cms.tmx.entity.web.settings.CcsTradeSettings;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.mng.InstructionMng;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.CcsCancelEntrust;
import cms.tmx.query.current.models.HkwolunOrderModel;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.service.IUserSettingsService;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class HkwolunUnfinishedOrderModel
extends HkwolunOrderModel {
    private ObjectProperty<MxNode> priceType = new SimpleObjectProperty();
    private StringProperty priceFloat = new SimpleStringProperty("0");
    private StringProperty floatUnit = new SimpleStringProperty();
    private boolean popBeforeCancel = true;
    private MxNode nodeHandicap;
    @Inject
    private MEventService es;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private IMarketDataMng marketMng;
    @Inject
    private IDictMap dictMap;
    @Inject
    private InstructionMng instructionMng;
    @Inject
    protected CcsAccountMap accntMap;
    @Inject
    private IUserSettingsService usMng;
    private String funcPanelType;
    private String menuId;
    private static final Logger logger = LogManager.getLogger(HkwolunUnfinishedOrderModel.class);

    @Override
    @PostConstruct
    public void init() {
        this.isUnfinishedOrder = true;
        super.init();
        this.nodeHandicap = MxNodeFactory.createNew((String)"handicap", (String)"0");
        this.initPriceType(this.nodeHandicap);
        this.setPriceType(this.nodeHandicap);
        this.es.subscribe("settingsRefresh", event -> this.doSet());
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("settingsRefresh", event -> this.doSet());
    }

    public void setType(String funcPanelType, String menuId) {
        this.funcPanelType = funcPanelType;
        this.menuId = menuId;
    }

    public void doSet() {
        try {
            if (this.funcPanelType == null || this.menuId == null) {
                return;
            }
            BaseSettings settings = this.usMng.getSettingsDetail(this.funcPanelType, this.menuId);
            if (settings instanceof CcsTradeSettings) {
                this.setPopBeforeCancel(((CcsTradeSettings)CcsTradeSettings.class.cast(settings)).getPopBeforeCancel().equals("1"));
            }
        }
        catch (MException e) {
            logger.error("\u52a0\u8f7d\u7528\u6237\u8bbe\u7f6e\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    private void initPriceType(MxNode node) {
        this.removeOthers(node, "-10");
        node.addNode("-9");
        node.addNode("-8");
        node.addNode("-7");
        node.addNode("-6");
        node.addNode("-5");
        node.addNode("-4");
        node.addNode("-3");
        node.addNode("-2");
        node.addNode("-1");
        node.addNode("0");
        node.addNode("1");
        node.addNode("2");
        node.addNode("3");
        node.addNode("4");
        node.addNode("5");
        node.addNode("6");
        node.addNode("7");
        node.addNode("8");
        node.addNode("9");
        node.addNode("10");
    }

    public void removeOthers(MxNode mxNode, String raw) {
        Iterator it = mxNode.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (node.getRaw().equals(raw)) continue;
            it.remove();
        }
    }

    public synchronized MEvent cancel(List<CcsOrder> list) {
        MEvent event = new MEvent();
        event.setObj(list);
        this.es.sendEvent("ccs.cancel.order", event);
        return event;
    }

    public synchronized MEvent cancelAndOrder(List<CcsOrder> list) {
        MEvent event = new MEvent();
        event.setObj(list);
        this.es.sendEvent("ccs.replace.order", event);
        return event;
    }

    public void queryMarketItem(List<CcsOrder> list) {
        LinkedList<RefItem> listItem = new LinkedList<RefItem>();
        for (CcsOrder order : list) {
            RefItem refItem = this.refMng.getItem(String.valueOf(order.getInstrument().getSecType()) + order.getInstrument().getMarket().getRaw(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
            if (refItem == null) continue;
            listItem.add(refItem);
        }
        Gears gears = new Gears();
        gears.setBuy(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        gears.setSell(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        if (!listItem.isEmpty()) {
            this.marketMng.query(listItem, gears);
        }
    }

    private MarketItem getMktItemByOrder(Order order) {
        RefItem refItem = this.refMng.getItem(String.valueOf(order.getInstrument().getSecType()) + order.getInstrument().getMarket().getRaw(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
        if (refItem == null) {
            return null;
        }
        MarketItem mktItem = this.marketMng.getInfo((IRefItem)refItem);
        return mktItem;
    }

    public double getNewPrice(Order order, int priceType, String floatUnit, String priceFloat) {
        double price = 0.0;
        MarketItem mktItem = this.getMktItemByOrder(order);
        if (mktItem == null) {
            return 0.0;
        }
        price = this.getPrice(priceType, mktItem);
        int scale = mktItem.getRefItem().getScale();
        BigDecimal bg = new BigDecimal(String.valueOf(price));
        price = bg.setScale(scale, 4).doubleValue();
        if (floatUnit.equals("\u5143")) {
            price += Double.parseDouble("".equals(priceFloat) ? "0" : priceFloat);
        } else if (floatUnit.equals("%")) {
            BigDecimal floatP = new BigDecimal(1).add(new BigDecimal(Double.parseDouble("".equals(priceFloat) ? "0" : priceFloat)).multiply(new BigDecimal(0.01)));
            price = new BigDecimal(price).multiply(floatP).doubleValue();
        }
        if (!"BOND".equals(order.getInstrument().getSecType()) && !"REPO".equals(order.getInstrument().getSecType()) && !"PLEDGE".equals(order.getInstrument().getSecType()) && mktItem.getUpLimitPrice() > 0.0 && price > mktItem.getUpLimitPrice()) {
            price = mktItem.getUpLimitPrice();
        } else if (!"BOND".equals(order.getInstrument().getSecType()) && !"REPO".equals(order.getInstrument().getSecType()) && !"PLEDGE".equals(order.getInstrument().getSecType()) && mktItem.getDownLimitPrice() > 0.0 && price < mktItem.getDownLimitPrice()) {
            price = mktItem.getDownLimitPrice();
        }
        bg = new BigDecimal(String.valueOf((double)Math.round(price * 10000.0) / 10000.0));
        if ("49".equals(order.getSide().getRaw())) {
            price = bg.setScale(scale, 1).doubleValue();
        } else if ("50".equals(order.getSide().getRaw())) {
            price = bg.setScale(scale, 0).doubleValue();
        }
        return price;
    }

    private double getPrice(int i, MarketItem mktItem) {
        double price = 0.0;
        if (i == 0) {
            price = mktItem.getNowPrice() > 0.0 ? mktItem.getNowPrice() : mktItem.getClosePrice();
        } else if (i == 100) {
            price = mktItem.getUpLimitPrice() > 0.0 ? mktItem.getUpLimitPrice() : mktItem.getClosePrice();
            if (mktItem.getRefItem() != null && "BOND".equals(mktItem.getRefItem().getType())) {
                price = 0.0;
            }
        } else if (i == -100) {
            price = mktItem.getDownLimitPrice() > 0.0 ? mktItem.getDownLimitPrice() : mktItem.getClosePrice();
            if (mktItem.getRefItem() != null && "BOND".equals(mktItem.getRefItem().getType())) {
                price = 0.0;
            }
        } else if (i > 0) {
            do {
                price = 0.0;
                if (i <= 0 || mktItem.getListBuyHandicap().size() <= i - 1) continue;
                price = ((HandicapInfo)mktItem.getListBuyHandicap().get(i - 1)).getPrice();
                --i;
            } while (price <= 0.0 && i > 0);
            if (price <= 0.0 && i == 0) {
                price = mktItem.getNowPrice() > 0.0 ? mktItem.getNowPrice() : mktItem.getClosePrice();
            }
        } else if (i < 0) {
            i = Math.abs(i);
            do {
                price = 0.0;
                if (i <= 0 || mktItem.getListSellHandicap().size() <= i - 1) continue;
                price = ((HandicapInfo)mktItem.getListSellHandicap().get(i - 1)).getPrice();
                --i;
            } while (price <= 0.0 && i > 0);
            if (price <= 0.0 && i == 0) {
                price = mktItem.getNowPrice() > 0.0 ? mktItem.getNowPrice() : mktItem.getClosePrice();
            }
        }
        return price;
    }

    public void checkInstructionPrice(Map<CcsCancelEntrust, CcsOrder> enOrMap, List<String> referenceIds) throws MException {
        List<Instruction> instructions = this.instructionMng.query(referenceIds);
        Map<String, Instruction> insMap = instructions.stream().collect(Collectors.toMap(Instruction::getId, t -> t));
        for (CcsCancelEntrust entrust : enOrMap.keySet()) {
            Instruction instruction = insMap.get(entrust.getReference());
            if (instruction == null) continue;
            this.checkPriceByType(entrust, enOrMap.get((Object)entrust), instruction);
        }
    }

    private void checkPriceByType(CcsCancelEntrust entrust, CcsOrder ccsOrder, Instruction ins) {
        switch (ins.getType().getRaw()) {
            case "4": 
            case "5": {
                this.resetBasketInsPrice(entrust, ccsOrder, ins);
                break;
            }
            case "8": 
            case "9": {
                this.resetAlgoInsPrice(entrust, ccsOrder, ins);
                break;
            }
            case "2": 
            case "3": {
                this.resetCommonInsPrice(entrust, ccsOrder, ins);
                break;
            }
        }
    }

    private void resetCommonInsPrice(CcsCancelEntrust entrust, CcsOrder ccsOrder, Instruction ins) {
        switch (ins.getOrderAdvice().getOrdType()) {
            case 50: {
                this.resetCommonFixedPrice(entrust, ccsOrder, ins.getOrderAdvice().getPriceLimit(), ins.getOrderAdvice().getPrice());
                break;
            }
            case 49: {
                this.resetCommonMarketPrice(entrust, ccsOrder, ins);
                break;
            }
            case 99: {
                entrust.setOrderTypeStr("\u76d8\u540e\u56fa\u5b9a\u4ef7");
                if (ccsOrder.getNewPrice() != ccsOrder.getPrice()) {
                    ccsOrder.setNewPrice(ccsOrder.getPrice());
                    entrust.setTip("\u76d8\u540e\u56fa\u5b9a\u4ef7\u53ea\u80fd\u4ee5\u56fa\u5b9a\u4ef7\u683c\u59d4\u6258\uff0c\u5df2\u7ecf\u8c03\u6574\u3002" + entrust.getTip());
                }
                entrust.setPrice(ccsOrder.getPrice());
                entrust.setIsModified(true);
                break;
            }
            case 0: {
                double limitPice = this.getNewPrice((Order)ccsOrder, ins.getOrderAdvice().getPriceTypeBidAsk(), "", "");
                if (ins.getOrderAdvice().getSide() == 49 || ins.getOrderAdvice().getSide() == 71) {
                    if (!(ccsOrder.getNewPrice() > limitPice)) break;
                    this.resetOrderPriceByInsLimit(entrust, ccsOrder, limitPice);
                    entrust.setTip("\u64a4\u4e0b\u4ef7\u683c\u5927\u4e8e\u6307\u4ee4\u76d8\u53e3\u4ef7\u9650\u5236\uff0c\u5df2\u7ecf\u8c03\u6574\u3002" + entrust.getTip());
                    break;
                }
                if (ins.getOrderAdvice().getSide() != 50 && ins.getOrderAdvice().getSide() != 70 || !(ccsOrder.getNewPrice() < limitPice)) break;
                this.resetOrderPriceByInsLimit(entrust, ccsOrder, limitPice);
                entrust.setTip("\u64a4\u4e0b\u4ef7\u683c\u5c0f\u4e8e\u6307\u4ee4\u76d8\u53e3\u4ef7\u9650\u5236\uff0c\u5df2\u7ecf\u8c03\u6574\u3002" + entrust.getTip());
                break;
            }
        }
    }

    private void resetOrderPriceByInsLimit(CcsCancelEntrust entrust, CcsOrder ccsOrder, double limitPice) {
        ccsOrder.setNewPrice(limitPice);
        entrust.setPrice(limitPice);
        if ("XSHG".equals(ccsOrder.getInstrument().getMarket().getRaw()) && "BOND".equals(ccsOrder.getInstrument().getSecType())) {
            entrust.setAmt((double)entrust.getQuantity() * entrust.getPrice() * 10.0);
        } else {
            entrust.setAmt((double)entrust.getQuantity() * entrust.getPrice());
        }
        entrust.setIsModified(true);
    }

    private void resetCommonMarketPrice(CcsCancelEntrust entrust, CcsOrder ccsOrder, Instruction ins) {
        if (ccsOrder.getSecId().startsWith("688")) {
            ccsOrder.setNewPrice(ccsOrder.getPrice());
            entrust.setPrice(ccsOrder.getPrice());
        } else {
            ccsOrder.setNewPrice(0.0);
            entrust.setPrice(0.0);
            MarketItem mktItemByOrder = this.getMktItemByOrder((Order)ccsOrder);
            if (mktItemByOrder == null) {
                entrust.setAmt(0.0);
            } else if (ins.getOrderAdvice().getSide() == 49 || ins.getOrderAdvice().getSide() == 71) {
                entrust.setAmt((double)entrust.getQuantity() * mktItemByOrder.getUpLimitPrice());
            } else if (ins.getOrderAdvice().getSide() == 50 || ins.getOrderAdvice().getSide() == 70) {
                entrust.setAmt((double)entrust.getQuantity() * mktItemByOrder.getDownLimitPrice());
            }
        }
        ccsOrder.setOrdType(49);
        ccsOrder.setTif(ins.getOrderAdvice().getTif());
        ccsOrder.setMaxLevels(ins.getOrderAdvice().getMaxLevels());
        String marketPriceLimit = this.dictMap.get("cstr_price_type_mkt", ins.getOrderAdvice().getMarketPriceLimit());
        entrust.setOrderTypeStr("\u5e02\u4ef7-" + marketPriceLimit);
    }

    private void resetCommonFixedPrice(CcsCancelEntrust entrust, CcsOrder ccsOrder, int limitType, double price) {
        if (Integer.valueOf("1") == limitType) {
            if (ccsOrder.getNewPrice() > price) {
                this.resetOrderPriceByInsLimit(entrust, ccsOrder, price);
                entrust.setTip("\u8d85\u51fa\u6307\u4ee4\u4e0a\u9650\uff0c\u4ef7\u683c\u8c03\u6574\u4e3a\u4e0a\u9650\u503c\u3002" + entrust.getTip());
            }
        } else if (Integer.valueOf("2") == limitType) {
            this.resetZero(entrust, ccsOrder);
            entrust.setTip("\u6307\u4ee4\u6307\u5b9a\u4ef7\u59d4\u6258\uff0c\u4e0d\u4f1a\u89e6\u53d1\u64a4\u4e0b\u3002" + entrust.getTip());
        } else if (Integer.valueOf("4") == limitType && ccsOrder.getNewPrice() < price) {
            this.resetOrderPriceByInsLimit(entrust, ccsOrder, price);
            entrust.setTip("\u8d85\u51fa\u6307\u4ee4\u4e0b\u9650\uff0c\u4ef7\u683c\u8c03\u6574\u4e3a\u4e0b\u9650\u503c\u3002" + entrust.getTip());
        }
    }

    private void resetAlgoInsPrice(CcsCancelEntrust entrust, CcsOrder ccsOrder, Instruction ins) {
        this.resetZero(entrust, ccsOrder);
        entrust.setTip("\u7b97\u6cd5\u6307\u4ee4\uff0c\u4e0d\u4f1a\u89e6\u53d1\u64a4\u4e0b\u3002" + entrust.getTip());
    }

    private void resetBasketInsPrice(CcsCancelEntrust entrust, CcsOrder ccsOrder, Instruction ins) {
        switch (String.valueOf(ins.getBasketOrderAdvice().getPriceType())) {
            case "11": {
                this.resetZero(entrust, ccsOrder);
                entrust.setTip("\u6307\u4ee4\u6307\u5b9a\u4ef7\u59d4\u6258\uff0c\u4e0d\u4f1a\u89e6\u53d1\u64a4\u4e0b\u3002" + entrust.getTip());
                break;
            }
            default: {
                String floatUnit = "";
                String priceFloat = "";
                if (ins.getBasketOrderAdvice().getFloatPercent() != 0.0) {
                    floatUnit = "%";
                    priceFloat = String.valueOf(ins.getBasketOrderAdvice().getFloatPercent());
                } else {
                    floatUnit = "\u5143";
                    priceFloat = String.valueOf(ins.getBasketOrderAdvice().getFloatPrice());
                }
                double limitPice = this.getNewPrice((Order)ccsOrder, ins.getBasketOrderAdvice().getPriceType(), floatUnit, priceFloat);
                if (Integer.valueOf(ccsOrder.getSide().getRaw()) == 49) {
                    if (!(ccsOrder.getNewPrice() > limitPice)) break;
                    this.resetOrderPriceByInsLimit(entrust, ccsOrder, limitPice);
                    entrust.setTip("\u64a4\u4e0b\u4ef7\u683c\u5927\u4e8e\u6307\u4ee4\u76d8\u53e3\u4ef7\u9650\u5236\uff0c\u5df2\u7ecf\u8c03\u6574\u3002" + entrust.getTip());
                    break;
                }
                if (Integer.valueOf(ccsOrder.getSide().getRaw()) != 50 || !(ccsOrder.getNewPrice() < limitPice)) break;
                this.resetOrderPriceByInsLimit(entrust, ccsOrder, limitPice);
                entrust.setTip("\u64a4\u4e0b\u4ef7\u683c\u5c0f\u4e8e\u6307\u4ee4\u76d8\u53e3\u4ef7\u9650\u5236\uff0c\u5df2\u7ecf\u8c03\u6574\u3002" + entrust.getTip());
            }
            case "12": 
        }
    }

    private void resetZero(CcsCancelEntrust entrust, CcsOrder ccsOrder) {
        entrust.setPrice(0.0);
        entrust.setQuantity(0L);
        entrust.setAmt(0.0);
        ccsOrder.setCanCancelReplace(false);
        entrust.setIsModified(true);
    }

    public void checkSATPrice(Map<CcsCancelEntrust, CcsOrder> enOrMap) {
        for (Map.Entry<CcsCancelEntrust, CcsOrder> entry : enOrMap.entrySet()) {
            CcsCancelEntrust entrust = entry.getKey();
            CcsOrder ccsOrder = entry.getValue();
            if (!StringUtils.isEmpty((String)ccsOrder.getReference())) continue;
            if (Integer.valueOf(ccsOrder.getSide().getRaw()) == 49) {
                if (!(entrust.getPrice() > ccsOrder.getPrice())) continue;
                ccsOrder.setCanCancelReplace(false);
                entrust.setIsModified(true);
                entrust.setTip("\u64a4\u4e0b\u4ef7\u683c\u5927\u4e8e\u4fdd\u62a4\u4ef7\uff0c\u4e0d\u5141\u8bb8\u64a4\u5355\u91cd\u4e0b\u3002" + entrust.getTip());
                continue;
            }
            if (Integer.valueOf(ccsOrder.getSide().getRaw()) != 50 || !(entrust.getPrice() < ccsOrder.getPrice())) continue;
            ccsOrder.setCanCancelReplace(false);
            entrust.setIsModified(true);
            entrust.setTip("\u64a4\u4e0b\u4ef7\u683c\u5c0f\u4e8e\u4fdd\u62a4\u4ef7\uff0c\u4e0d\u5141\u8bb8\u64a4\u5355\u91cd\u4e0b\u3002" + entrust.getTip());
        }
    }

    public Set<String> getInvestorSecIds() {
        return this.accntMap.getInvestorSecIds();
    }

    public ObjectProperty<MxNode> priceTypeProperty() {
        return this.priceType;
    }

    public MxNode getPriceType() {
        return (MxNode)this.priceTypeProperty().get();
    }

    public void setPriceType(MxNode priceType) {
        this.priceTypeProperty().set((Object)priceType);
    }

    public StringProperty priceFloatProperty() {
        return this.priceFloat;
    }

    public String getPriceFloat() {
        return (String)this.priceFloatProperty().get();
    }

    public void setPriceFloat(String priceFloat) {
        this.priceFloatProperty().set((Object)priceFloat);
    }

    public StringProperty floatUnitProperty() {
        return this.floatUnit;
    }

    public String getFloatUnit() {
        return (String)this.floatUnitProperty().get();
    }

    public void setFloatUnit(String floatUnit) {
        this.floatUnitProperty().set((Object)floatUnit);
    }

    public boolean isPopBeforeCancel() {
        return this.popBeforeCancel;
    }

    public void setPopBeforeCancel(boolean popBeforeCancel) {
        this.popBeforeCancel = popBeforeCancel;
    }
}

