/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.datatype.message.PMessage;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.Order;
import cms.tmx.query.current.models.OrderQueryModel;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class HkwolunOrderModel
extends OrderQueryModel<CcsOrder> {
    public static String baseId = "";
    public static boolean isNormal = false;

    @Override
    @PostConstruct
    public void init() {
        this.setMarketGrp("CCS");
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void update(List<Order> listOrder) {
        List<CcsOrder> listCcsOrder = this.updateOrder(listOrder);
        ObservableList observableList = this.list.getList();
        synchronized (observableList) {
            listCcsOrder.addAll((Collection<CcsOrder>)this.list.getList());
        }
        this.list.update(listCcsOrder);
        this.changed();
    }

    public List<CcsOrder> updateOrder(List<Order> listOrder) {
        LinkedList<CcsOrder> list = new LinkedList<CcsOrder>();
        for (Order order : listOrder) {
            if (!"SHSC".equals(order.getInstrument().getMarket().getRaw()) && !"SZSC".equals(order.getInstrument().getMarket().getRaw()) || !(order instanceof CcsOrder)) continue;
            CcsOrder ccs = (CcsOrder)CcsOrder.class.cast(order);
            this.queryModel.afterUpdate(ccs);
            this.queryModel.getOrderPrice((Order)ccs);
            list.add(ccs);
        }
        return list;
    }

    @Override
    protected boolean careReport(PMessage.ExecutionReport report) {
        if (!report.hasSingleOrder()) {
            return false;
        }
        return "SHSC".equals(report.getInstrument().getMarket()) || "SZSC".equals(report.getInstrument().getMarket());
    }
}

