/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.api.data.IRefItem;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IFutureMarketMakingApi;
import cms.tmx.api.trade.INewOrderSingleApi;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.data.utils.Gears;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.datatype.proto.strategy.PStrategy;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.Order;
import cms.tmx.entity.web.settings.BaseSettings;
import cms.tmx.entity.web.settings.CtpTradeSettings;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.mng.OrderMng;
import cms.tmx.query.current.models.CtpAccountMap;
import cms.tmx.utils.MathUtils;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.service.IUserSettingsService;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class HedgeUnfinishedOrderListModel
extends MxModel {
    private ObjectProperty<MxNode> priceType = new SimpleObjectProperty();
    private StringProperty priceFloat = new SimpleStringProperty("0");
    private StringProperty floatUnit = new SimpleStringProperty();
    public static BooleanProperty isEditting = new SimpleBooleanProperty(false);
    private static final int FULL_QUERY_INTERVAL = 3000;
    private static final int SPEC_QUERY_INTERVAL = 2000;
    private MxNode nodePriceType;
    @Inject
    private OrderMng api;
    @Inject
    private MEventService es;
    @Inject
    private IUserSettingsService usMng;
    private String funcPanelType;
    private String menuId;
    private boolean popBeforeCancel = true;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private IMarketDataMng marketMng;
    private MarketItem mktItem;
    @Inject
    private INewOrderSingleApi newOrderSingleApi;
    @Inject
    private IFutureMarketMakingApi futureMarketMakingApi;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MScheduler sdSpecQuery;
    private List<CtpOrder> list = new CopyOnWriteArrayList<CtpOrder>();
    private MEventHandler pushHandler = event -> {
        if (!event.get((Object)"push_type").equals("153")) {
            return;
        }
        this.sdSpecQuery.schedule(evt -> {
            if (!isEditting.get()) {
                try {
                    this.query();
                }
                catch (MException e) {
                    e.printStackTrace();
                    this.logger.error(e.getMessage());
                }
            }
        });
    };
    private MEventHandler queryHandler = event -> this.sdFullQuery.schedule(evt -> {
        if (!isEditting.get()) {
            try {
                this.query();
            }
            catch (MException e) {
                e.printStackTrace();
                this.logger.error(e.getMessage());
            }
        }
    });
    @Inject
    private CtpAccountMap accountMap;
    @Inject
    private IBaseApi baseApi;

    @PostConstruct
    public void init() {
        this.nodePriceType = MxNodeFactory.create((String)"futures_hedge_order_price_type", (String)"origin_price");
        this.initPriceType(this.nodePriceType);
        this.setPriceType(this.nodePriceType);
        this.sdFullQuery.setInterval(3000);
        this.sdSpecQuery.setInterval(2000);
        this.es.subscribe("settingsRefresh", event -> this.doSet());
        this.es.subscribe("server.sub", this.pushHandler);
        this.es.subscribe("unfinished.hedge.query", this.queryHandler);
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("settingsRefresh", event -> this.doSet());
        this.es.unSubscribe("server.sub", this.pushHandler);
        this.es.unSubscribe("unfinished.hedge.query", this.queryHandler);
    }

    public void doSet() {
        try {
            if (this.funcPanelType == null || this.menuId == null) {
                return;
            }
            BaseSettings settings = this.usMng.getSettingsDetail(this.funcPanelType, this.menuId);
            if (settings instanceof CtpTradeSettings) {
                this.setPopBeforeCancel(((CtpTradeSettings)CtpTradeSettings.class.cast(settings)).getPopBeforeCancel().equals("1"));
            }
        }
        catch (MException e) {
            this.logger.error("\u52a0\u8f7d\u7528\u6237\u8bbe\u7f6e\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    private void initPriceType(MxNode node) {
        this.removeOthers(node, "origin_price");
        node.addNode("origin_price");
        node.addNode("sell1");
        node.addNode("newp");
        node.addNode("buy1");
        node.addNode("opp");
    }

    public void removeOthers(MxNode mxNode, String raw) {
        Iterator it = mxNode.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (node.getRaw().equals(raw)) continue;
            it.remove();
        }
    }

    public List<CtpOrder> getList() {
        return this.list;
    }

    public void query() throws MException {
        ArrayList secAcct = new ArrayList();
        this.accountMap.getAccountMap().entrySet().forEach(t -> {
            boolean bl = secAcct.addAll((Collection)t.getValue());
        });
        ArrayList<String> list = new ArrayList<String>();
        secAcct.forEach(t -> {
            boolean bl = list.add(t.getExtSecAccntId());
        });
        this.list.clear();
        for (CtpOrder order : this.api.queryHedgeByPage(list, 2)) {
            this.list.add(order);
        }
        this.changed();
    }

    public synchronized void order(CtpOrder order) throws MException {
        PMessage.NewOrderSingle.Builder builder = PMessage.NewOrderSingle.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setOrderId(order.getSysOrderId());
        builder.setPrice(order.getPrice());
        builder.setOrderQty((double)order.getOrderQty());
        if (!StringUtils.isEmpty((String)order.getReference()) && !StringUtils.isEmpty((String)order.getResourceId()) && 49 == order.getOrdType()) {
            builder.setOrdTypeValue(49);
            builder.setTif(PField.TimeInForce.forNumber((int)order.getTif()));
            builder.setMaxPriceLevels(order.getMaxLevels());
        } else {
            builder.setOrdTypeValue(50);
        }
        builder.setReference(order.getReference());
        builder.setResourceId(order.getResourceId());
        PComponent.Instrument.Builder inst = PComponent.Instrument.newBuilder();
        inst.setMarket(order.getInstrument().getMarket().getRaw());
        inst.setSecurityId(order.getInstrument().getSecId());
        inst.setSecurityType(order.getInstrument().getSecType());
        builder.setExtAccntId(order.getExtAccntId());
        builder.setExtSecAccntId(order.getExtSecAccntId());
        builder.setPositionEffect(PField.PositionEffect.PE_FIFO);
        builder.setPositionEffectValue(Integer.parseInt(order.getOcFlag().getRaw()));
        builder.setPurpose(Integer.parseInt(order.getShFlag().getRaw()));
        builder.setSideValue(Integer.parseInt(order.getSide().getRaw()));
        builder.setInstrument(inst);
        builder.setClOrdId(order.getClContractId());
        PComponent.ExecMode.Builder exec = PComponent.ExecMode.newBuilder();
        exec.setEmName(order.getSource());
        exec.setEmType(PField.ExecModeType.EXEC_MODE_TYPE_HEDGE_MANUAL);
        builder.setHostCrossId(order.getClOrdId());
        builder.setExecMode(exec.build());
        builder.setAttachment(order.getAttachment());
        builder.setCrossId(order.getClOrdId());
        this.newOrderSingleApi.submit(builder.build());
    }

    public synchronized void hedge(CtpOrder order) throws MException {
        PStrategy.UpdateSingleOrdersReq.Builder builder = PStrategy.UpdateSingleOrdersReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setOrderId(order.getOrderId());
        builder.setHedgeStatus(true);
        this.futureMarketMakingApi.hedge(builder.build());
    }

    public void queryMarketItem(List<CtpOrder> list) {
        LinkedList<RefItem> listItem = new LinkedList<RefItem>();
        for (CtpOrder order : list) {
            RefItem refItem = this.refMng.getItem(order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
            if (refItem == null) continue;
            listItem.add(refItem);
        }
        Gears gears = new Gears();
        gears.setBuy(new int[]{1});
        gears.setSell(new int[]{1});
        if (!listItem.isEmpty()) {
            this.marketMng.query(listItem, gears);
        }
    }

    public double getNewPrice(Order order) {
        double price = 0.0;
        double mkPrice = 0.0;
        CtpRefItem refItem = (CtpRefItem)this.refMng.getItem(order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
        if (refItem == null) {
            return 0.0;
        }
        int scale = refItem.getScale();
        this.mktItem = this.marketMng.getInfo((IRefItem)refItem);
        if (this.mktItem == null) {
            return 0.0;
        }
        mkPrice = this.getPrice(order);
        double priceTick = refItem.getPriceTick();
        double changePrice = 0.0;
        if (this.getFloatUnit().equals("\u5143")) {
            changePrice = Double.parseDouble("".equals(this.getPriceFloat()) ? "0" : this.getPriceFloat());
        } else if (this.getFloatUnit().equals("%")) {
            changePrice = mkPrice * Double.parseDouble("".equals(this.getPriceFloat()) ? "0" : this.getPriceFloat()) * 0.01;
        }
        BigDecimal b1 = new BigDecimal(Double.toString(changePrice));
        BigDecimal b2 = new BigDecimal(Double.toString(priceTick));
        BigDecimal b3 = b1.divideAndRemainder(b2)[1];
        if (order.getSide().getRaw().equals("49")) {
            changePrice = b3.doubleValue() > 0.0 ? changePrice - b3.doubleValue() : changePrice;
        } else if (order.getSide().getRaw().equals("50")) {
            changePrice = b3.doubleValue() > 0.0 ? changePrice - b3.doubleValue() + priceTick : changePrice;
        }
        price = BigDecimal.valueOf(mkPrice + changePrice).setScale(scale, 4).doubleValue();
        if (this.mktItem.getUpLimitPrice() > 0.0 && price > this.mktItem.getUpLimitPrice()) {
            price = this.mktItem.getUpLimitPrice();
        } else if (this.mktItem.getDownLimitPrice() > 0.0 && price < this.mktItem.getDownLimitPrice()) {
            price = this.mktItem.getDownLimitPrice();
        }
        price = MathUtils.roundPrice((Double)price, (int)scale);
        return price;
    }

    public double getPrice(Order order) {
        double dRet = 0.0;
        dRet = this.getPriceType().getRaw().equals("origin_price") ? order.getPrice() : (this.getPriceType().getRaw().equals("opp") ? (order.getSide().getRaw().equals("49") ? (((HandicapInfo)this.mktItem.getListSellHandicap().get(0)).getPrice() > 0.0 ? ((HandicapInfo)this.mktItem.getListSellHandicap().get(0)).getPrice() : (this.mktItem.getNowPrice() > 0.0 ? this.mktItem.getNowPrice() : this.mktItem.getClosePrice())) : (((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).getPrice() > 0.0 ? ((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).getPrice() : (this.mktItem.getNowPrice() > 0.0 ? this.mktItem.getNowPrice() : this.mktItem.getClosePrice()))) : (this.getPriceType().getRaw().equals("newp") ? (this.mktItem.getNowPrice() > 0.0 ? this.mktItem.getNowPrice() : this.mktItem.getClosePrice()) : (this.getPriceType().getRaw().equals("buy1") ? (((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).getPrice() > 0.0 ? ((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).getPrice() : (this.mktItem.getNowPrice() > 0.0 ? this.mktItem.getNowPrice() : this.mktItem.getClosePrice())) : (((HandicapInfo)this.mktItem.getListSellHandicap().get(0)).getPrice() > 0.0 ? ((HandicapInfo)this.mktItem.getListSellHandicap().get(0)).getPrice() : (this.mktItem.getNowPrice() > 0.0 ? this.mktItem.getNowPrice() : this.mktItem.getClosePrice())))));
        return dRet;
    }

    public ObjectProperty<MxNode> priceTypeProperty() {
        return this.priceType;
    }

    public MxNode getPriceType() {
        return (MxNode)this.priceTypeProperty().get();
    }

    public void setPriceType(MxNode priceType) {
        this.priceTypeProperty().set((Object)priceType);
    }

    public StringProperty priceFloatProperty() {
        return this.priceFloat;
    }

    public String getPriceFloat() {
        return (String)this.priceFloatProperty().get();
    }

    public void setPriceFloat(String priceFloat) {
        this.priceFloatProperty().set((Object)priceFloat);
    }

    public StringProperty floatUnitProperty() {
        return this.floatUnit;
    }

    public String getFloatUnit() {
        return (String)this.floatUnitProperty().get();
    }

    public void setFloatUnit(String floatUnit) {
        this.floatUnitProperty().set((Object)floatUnit);
    }

    public void setType(String funcPanelType, String menuId) {
        this.funcPanelType = funcPanelType;
        this.menuId = menuId;
    }

    public boolean isPopBeforeCancel() {
        return this.popBeforeCancel;
    }

    public void setPopBeforeCancel(boolean popBeforeCancel) {
        this.popBeforeCancel = popBeforeCancel;
    }
}

