/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.ObSingleOrderNeeq;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.api.OrderServiceNewApi;
import cms.tmx.http.api.strategy.api.TradeServiceNewApi;
import cms.tmx.http.api.strategy.dto.GetOrdersReq;
import cms.tmx.http.api.strategy.dto.GetOrdersResp;
import cms.tmx.http.api.strategy.dto.NewOrderCancelRequest;
import cms.tmx.http.api.strategy.dto.OrdEvent;
import cms.tmx.http.api.strategy.dto.Order;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.http.data.dto.Fragment;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.IUserService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.utils.QueryUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class HKOrderModel
extends MxModel {
    @Inject
    protected MScheduler sdPushChange;
    @Inject
    protected HttpBaseApi baseApi;
    @Inject
    private TradeServiceNewApi api;
    @Inject
    protected MEventService es;
    @Inject
    protected IUserService userService;
    @Inject
    protected CcsAccountMap accntMap;
    @Inject
    protected ScheduledExecutorService ses;
    protected MxList<Order> list = new MxList();
    protected static final int FULL_PUSH_CHANGE_INTERVAL = 1000;
    protected MEventHandler handler = event -> this.onPush(event);
    protected Gson gson = new Gson();
    protected boolean isUnfinishedOrder = false;
    protected Map<String, Order> map = new HashMap<String, Order>();
    protected ConcurrentHashMap<String, Integer> statusMap = new ConcurrentHashMap();
    private static ArrayList<String> markets = new ArrayList<String>(Arrays.asList("XHKG", "XNAS", "XNYS"));
    @Inject
    private OrderServiceNewApi newApi;

    public void changed() {
        this.sdPushChange.schedule(e -> super.changed());
    }

    protected Integer getStatusNo(SingleOrder order) {
        if (order.getCanCancelFlag() != 1) {
            return 99999;
        }
        if (order.getOrdStatus() == null) {
            return -1;
        }
        if (order.getOrdStatus().getValue().equals("87")) {
            return 0;
        }
        if (order.getOrdStatus().getValue().equals("65")) {
            return 1;
        }
        if (order.getOrdStatus().getValue().equals("48")) {
            return 2;
        }
        if (order.getOrdStatus().getValue().equals("49")) {
            return (int)(1000.0 + order.getCumQty());
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        OrdEvent ordEvent = (OrdEvent)this.gson.fromJson((JsonElement)obj, OrdEvent.class);
        for (SingleOrder order : ordEvent.getOrder()) {
            if (!markets.contains(order.getInstrument().getMarket())) {
                return;
            }
            order.setExtraFields();
            order.setUnit(QueryUtils.getUnit(order.getInstrument().getSecurityType(), order.getInstrument().getMarket()));
            order.setUserName((String)this.userService.getUserName(order.getUserId()).get());
            this.afterUpdate(order);
            ConcurrentHashMap<String, Integer> concurrentHashMap = this.statusMap;
            synchronized (concurrentHashMap) {
                String sysOrderId = order.getOrderId();
                Integer statusOld = this.statusMap.get(sysOrderId);
                Integer statusNow = this.getStatusNo(order);
                if (statusOld == null) {
                    this.statusMap.put(sysOrderId, statusNow);
                } else {
                    if (statusNow < statusOld) {
                        this.logger.error(String.valueOf(this.isUnfinishedOrder ? "\u672a\u5b8c\u6210\u63a8\u9001" : "\u59d4\u6258\u63a8\u9001") + ", \u4e22\u5f03\u672c\u6b21\u63a8\u9001:" + " hashCode:" + System.identityHashCode((Object)this) + "_" + order.getOrderId());
                        return;
                    }
                    this.statusMap.put(sysOrderId, statusNow);
                }
                if (this.isUnfinishedOrder) {
                    if (order.getCanCancelFlag() == 1) {
                        this.list.updatePart((MxObject)order.convert());
                    } else if (this.list.getListMap().get(order.convert()) != null) {
                        this.list.remove((MxObject)order.convert());
                    }
                } else {
                    this.list.updatePart((MxObject)order.convert());
                }
            }
        }
        this.changed();
    }

    private void afterUpdate(SingleOrder o) {
        if ("XHKG".equals(o.getMarket())) {
            o.setMarket("\u6e2f\u4ea4\u6240");
        }
        try {
            for (CcsFundAccount acc : this.accntMap.getHkAccountMap().keySet()) {
                if ("".equals(acc.getNewCashAccntId()) || o.getExtCashAccntId() == null) continue;
                if (o.getExtCashAccntId().equals(acc.getNewCashAccntId())) {
                    o.setInvestorId(acc.getInvestId());
                    List<SecAccount> listAcc = this.accntMap.getHkAccountMap().get(acc);
                    for (SecAccount sec : listAcc) {
                        if (!o.getExtSecAccntId().equals(sec.getExtSecAccntId())) continue;
                        o.setInvestorSecId(sec.getInverstorSecId());
                    }
                    continue;
                }
                break;
            }
        }
        catch (MException e) {
            this.logger.error("\u6e2f\u80a1\u59d4\u6258\u67e5\u8be2-\u8d44\u91d1\u8d26\u53f7\u8f6c\u6362\u5f02\u5e38" + (Object)((Object)e));
        }
    }

    @PostConstruct
    protected void init() {
        this.sdPushChange.setInterval(1000);
        this.es.subscribe("uap.push.OrdEvent", this.handler);
        this.es.subscribe("requery_data", event -> {
            ScheduledFuture<?> scheduledFuture = this.ses.schedule(() -> {
                try {
                    this.query();
                }
                catch (MException | IOException e) {
                    this.logger.error((Object)e, e);
                }
            }, 30L, TimeUnit.SECONDS);
        });
    }

    @PreDestroy
    private void destory() {
        this.es.unSubscribe("uap.push.OrdEvent", this.handler);
    }

    public void query() throws IOException, MException {
        GetOrdersReq req = new GetOrdersReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGroup("OTC");
        req.setCanCancelFlag(this.isUnfinishedOrder ? 1 : 0);
        String time = new SimpleDateFormat("yyyyMMdd").format(new Date());
        req.setBeginDate(time);
        req.setEndDate(time);
        ArrayList<String> extAcc = new ArrayList<String>();
        for (CcsFundAccount acc : this.accntMap.getHkAccountMap().keySet()) {
            if ("".equals(acc.getNewCashAccntId())) continue;
            extAcc.add(acc.getNewCashAccntId());
        }
        req.setExtCashAccntId(extAcc);
        Fragment fragment = this.getFragment(req);
        if (!extAcc.isEmpty()) {
            GetOrdersResp resp = this.newApi.getOrders(req);
            this.list.clear();
            this.list.addAll(resp.getData());
            int queryTimes = (int)Math.ceil((double)resp.getTotal() * 1.0 / (double)fragment.getSize());
            while (--queryTimes > 0) {
                fragment.setOffset(fragment.getSize() + fragment.getOffset());
                req.setFragment(fragment);
                GetOrdersResp res = this.newApi.getOrders(req);
                this.list.addAll(res.getData());
            }
        }
        for (Order order : this.list.getList()) {
            order.setWthQty((int)order.getCxlQty());
            order.setAvalQty(order.getOrderQty() - order.getCumQty() - order.getCxlQty());
            for (CcsFundAccount acc : this.accntMap.getHkAccountMap().keySet()) {
                if ("".equals(acc.getNewCashAccntId()) || !order.getExtAccntId().getCashAccntId().equals(acc.getNewCashAccntId())) continue;
                order.setInvestorId(acc.getInvestId());
                List<SecAccount> listAcc = this.accntMap.getHkAccountMap().get(acc);
                for (SecAccount sec : listAcc) {
                    if (!order.getExtAccntId().getSecAccntId().equals(sec.getExtSecAccntId())) continue;
                    order.setInvestorSecId(sec.getInverstorSecId());
                }
            }
            order.setExtraFields();
            order.setUnit(QueryUtils.getUnit(order.getInstrument().getSecurityType(), order.getInstrument().getMarket()));
            order.setUserName((String)this.userService.getUserName(order.getUserId()).get());
            if ("XHKG".equals(order.getMarket())) {
                order.setMarket("\u6e2f\u4ea4\u6240");
            }
            if ("XNYS".equals(order.getMarket())) {
                order.setMarket("\u7ebd\u7ea6\u8bc1\u5238\u4ea4\u6613\u6240");
            }
            if ("XNAS".equals(order.getMarket())) {
                order.setMarket("\u7eb3\u65af\u8fbe\u514b\u4ea4\u6613\u6240");
            }
            this.map.put(order.getOrderId(), order);
        }
        this.changed();
    }

    private Fragment getFragment(GetOrdersReq req) {
        Fragment fragment = new Fragment();
        fragment.setOffset(1);
        fragment.setSize(200);
        req.setFragment(fragment);
        return fragment;
    }

    public List<Order> getList() {
        return this.list.getList();
    }

    public void setUnfinishedOrder(boolean isUnfinishedOrder) {
        this.isUnfinishedOrder = isUnfinishedOrder;
    }

    public void cancelOrder(ObSingleOrderNeeq item) throws MException {
        NewOrderCancelRequest order = new NewOrderCancelRequest();
        order.setOpUser(this.baseApi.getHttpOpUser());
        Instrument security = new Instrument();
        security.setSecurityId(item.getSecurityId());
        security.setMarket(item.getMarketString());
        security.setMarket("XHKG");
        security.setSecurityType("STOCK");
        CcsFundAccount account = new CcsFundAccount();
        for (CcsFundAccount acc : this.accntMap.getHkAccountMap().keySet()) {
            if (!acc.getNewCashAccntId().equals(item.getExtCashAccntId())) continue;
            account = acc;
        }
        order.setAccount(account.getParentId());
        order.setInstrument(security);
        order.setOrderId(item.getOrderId());
        order.setOrderQty((int)item.getOrderQty());
        order.setTradePlatformId(account.getCounterId());
        order.setInvestorId(item.getInvestorId());
        this.api.newCancelOrder(order);
    }
}

