/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.instruction.ObInstruction;
import cms.tmx.http.api.core.SecSubType;
import cms.tmx.http.api.strategy.dto.ExecEvent;
import cms.tmx.http.api.strategy.dto.Execution;
import cms.tmx.http.api.strategy.dto.ObExecutionOtc;
import cms.tmx.http.query.GetExecutionsReq;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IUserService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.OtcPortfolioAccountModel;
import cms.tmx.query.otc.api.OtcFundExecutionApi;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class HKExecutionModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(HKExecutionModel.class);
    @Inject
    protected MObjFactory of;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    private OtcPortfolioAccountModel otcAccountModel;
    @Inject
    protected CcsAccountMap accntMap;
    @Inject
    private MEventService es;
    @Inject
    private IUserService userService;
    protected static final int FULL_QUERY_INTERVAL = 3000;
    protected MxList<ObExecutionOtc> list = new MxList();
    private ObInstruction obInstruction;
    private static final Gson gson = new Gson();

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.es.subscribe("uap.push.ExecEvent", e -> this.onPush(e));
    }

    private void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        ExecEvent execEvent = (ExecEvent)gson.fromJson((JsonElement)obj, ExecEvent.class);
        for (Execution each : execEvent.getExecution()) {
            if (!"OTC".equals(each.getInstrument().getMarketGroup())) continue;
            if (!StringUtils.isEmpty((String)each.getInstrument().getSecuritySubType())) {
                each.setSecSubType(SecSubType.get((String)each.getInstrument().getSecuritySubType()));
            }
            ObExecutionOtc exec = new ObExecutionOtc();
            exec.update((Object)each);
            exec.setUserId(this.userService.getUserName(exec.getUserId()).getValue());
            this.afterUpdate(exec);
            this.list.add((MxObject)exec);
        }
        this.changed();
    }

    private void afterUpdate(ObExecutionOtc o) {
        if ("XHKG".equals(o.getMarket())) {
            o.setMarket("\u6e2f\u4ea4\u6240");
        }
        try {
            for (CcsFundAccount acc : this.accntMap.getHkAccountMap().keySet()) {
                if ("".equals(acc.getNewCashAccntId()) || o.getExtCashAccntId() == null || !o.getExtCashAccntId().equals(acc.getNewCashAccntId())) continue;
                o.setInvestorId(acc.getInvestId());
                List<SecAccount> listAcc = this.accntMap.getHkAccountMap().get(acc);
                for (SecAccount sec : listAcc) {
                    if (!o.getExtSecAccntId().equals(sec.getExtSecAccntId())) continue;
                    o.setInvestorSecId(sec.getInverstorSecId());
                }
            }
        }
        catch (MException e) {
            logger.error("\u6e2f\u80a1\u6210\u4ea4\u67e5\u8be2\u8d44\u91d1\u8d26\u53f7\u8f6c\u6362\u5931\u8d25" + (Object)((Object)e));
        }
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.list.clear();
                if (this.obInstruction != null) {
                    this.instructionQuery("", "", this.obInstruction.getId());
                } else {
                    this.fullQuery();
                }
            }
            catch (MException | Exception e) {
                logger.error("full query execution failed", e);
            }
        });
    }

    private void fullQuery() throws MException {
        ObservableList fundList = FxUtils.newList();
        ObservableList list1 = FxUtils.newList();
        fundList.addAll(this.otcAccountModel.getFundAccounts());
        for (CcsFundAccount account : this.accntMap.getHkAccountMap().keySet()) {
            list1.add((Object)account);
        }
        for (CcsFundAccount fund : list1) {
            if (!"OTC".equals(fund.getMarketGrp())) continue;
            this.instructionQuery(fund.getNewCashAccntId(), "", "");
        }
    }

    private void instructionQuery(String extAccntId, String subAccntId, String instructionId) throws MException {
        ArrayList<Execution> listSrc = new ArrayList<Execution>();
        ArrayList<ObExecutionOtc> listOb = new ArrayList<ObExecutionOtc>();
        GetExecutionsReq req = (GetExecutionsReq)this.of.create(GetExecutionsReq.class);
        req.setInstructionId(instructionId);
        req.setExtCashAccntId(Arrays.asList(extAccntId));
        req.setMarketGrp("OTC");
        OtcFundExecutionApi service = (OtcFundExecutionApi)((Object)this.of.create(OtcFundExecutionApi.class));
        listSrc.addAll(service.getExecution(req));
        listSrc.forEach(each -> {
            if (!StringUtils.isEmpty((String)each.getInstrument().getSecuritySubType())) {
                each.setSecSubType(SecSubType.get((String)each.getInstrument().getSecuritySubType()));
            }
            ObExecutionOtc exec = new ObExecutionOtc();
            exec.update(each);
            exec.setUserId(this.userService.getUserName(exec.getUserId()).getValue());
            this.afterUpdate(exec);
            listOb.add(exec);
        });
        this.updateList(listOb);
    }

    protected void updateList(List<ObExecutionOtc> list) {
        this.list.updatePart(list);
        this.changed();
    }

    public ObservableList<ObExecutionOtc> getList() {
        return this.list.getList();
    }

    public ObInstruction getObInstruction() {
        return this.obInstruction;
    }

    public void setObInstruction(ObInstruction obInstruction) {
        this.obInstruction = obInstruction;
    }
}

