/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.CrossOrder;
import cms.tmx.entity.web.settings.BaseSettings;
import cms.tmx.entity.web.settings.EtfTradeSettings;
import cms.tmx.javafx.obj.MxChgObj;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.web.service.IUserSettingsService;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class EtfRefreshModel
extends MxChgObj {
    private StringProperty fundAcc = new SimpleStringProperty("");
    private StringProperty secAcc = new SimpleStringProperty("");
    private StringProperty currency = new SimpleStringProperty("");
    private StringProperty parentId = new SimpleStringProperty("");
    private StringProperty startDate = new SimpleStringProperty("");
    private StringProperty endDate = new SimpleStringProperty("");
    private BooleanProperty selectChange = new SimpleBooleanProperty();
    private BooleanProperty queryChange = new SimpleBooleanProperty();
    private BooleanProperty tableChange = new SimpleBooleanProperty();
    private ObservableList<CrossOrder> orderList = FxUtils.newList();
    private boolean popBeforeCancel = true;
    private static final Logger logger = LogManager.getLogger(EtfRefreshModel.class);
    private String funcPanelType;
    private String menuId;
    @Inject
    private IUserSettingsService usMng;
    @Inject
    private MEventService es;
    private MEventHandler reload = event -> {
        try {
            this.doSet();
        }
        catch (MException mException) {
            logger.error("\u52a0\u8f7d\u7528\u6237\u8bbe\u7f6e\u6570\u636e\u5931\u8d25");
        }
    };

    @PostConstruct
    public void init() {
        this.es.subscribe("settingsRefresh", this.reload);
        this.es.subscribe("etf.query.refresh", event -> this.refresh(event));
    }

    public void setType(String funcPanelType, String menuId) {
        this.funcPanelType = funcPanelType;
        this.menuId = menuId;
    }

    public void doSet() throws MException {
        if (this.funcPanelType == null || this.menuId == null) {
            return;
        }
        BaseSettings settings = this.usMng.getSettingsDetail(this.funcPanelType, this.menuId);
        if (settings instanceof EtfTradeSettings) {
            this.setPopBeforeCancel(((EtfTradeSettings)EtfTradeSettings.class.cast(settings)).getPopBeforeCancel().equals("1"));
        }
    }

    public void refresh(MEvent event) {
        this.setFundAcc(event.getStr("fundAccount"));
        this.setSecAcc(event.getStr("secAccount"));
        this.setCurrency(event.getStr("currency"));
        this.changed();
    }

    public StringProperty fundAccProperty() {
        return this.fundAcc;
    }

    public String getFundAcc() {
        return (String)this.fundAccProperty().get();
    }

    public void setFundAcc(String fundAcc) {
        this.fundAccProperty().set((Object)fundAcc);
    }

    public StringProperty secAccProperty() {
        return this.secAcc;
    }

    public String getSecAcc() {
        return (String)this.secAccProperty().get();
    }

    public void setSecAcc(String secAcc) {
        this.secAccProperty().set((Object)secAcc);
    }

    public final StringProperty parentIdProperty() {
        return this.parentId;
    }

    public final String getParentId() {
        return (String)this.parentIdProperty().get();
    }

    public final void setParentId(String parentId) {
        this.parentIdProperty().set((Object)parentId);
    }

    public final BooleanProperty selectChangeProperty() {
        return this.selectChange;
    }

    public void selectChange() {
        this.setSelectChange(!this.selectChange.get());
    }

    public final void setSelectChange(boolean selectChange) {
        this.selectChangeProperty().set(selectChange);
    }

    public final BooleanProperty queryChangeProperty() {
        return this.queryChange;
    }

    public void queryChange() {
        this.setQueryChange(!this.queryChange.get());
    }

    public final void setTableChange(boolean tableChange) {
        this.tableChangeProperty().set(tableChange);
    }

    public final BooleanProperty tableChangeProperty() {
        return this.tableChange;
    }

    public void tableChange() {
        this.setTableChange(!this.tableChange.get());
    }

    public final void setQueryChange(boolean queryChange) {
        this.queryChangeProperty().set(queryChange);
    }

    public ObservableList<CrossOrder> getOrderList() {
        return this.orderList;
    }

    public void setOrderList(ObservableList<CrossOrder> orderList) {
        this.orderList = orderList;
    }

    public final StringProperty currencyProperty() {
        return this.currency;
    }

    public final String getCurrency() {
        return (String)this.currencyProperty().get();
    }

    public final void setCurrency(String currency) {
        this.currencyProperty().set((Object)currency);
    }

    public final StringProperty startDateProperty() {
        return this.startDate;
    }

    public final String getStartDate() {
        return (String)this.startDateProperty().get();
    }

    public final void setStartDate(String startDate) {
        this.startDateProperty().set((Object)startDate);
    }

    public final StringProperty endDateProperty() {
        return this.endDate;
    }

    public final String getEndDate() {
        return (String)this.endDateProperty().get();
    }

    public final void setEndDate(String endDate) {
        this.endDateProperty().set((Object)endDate);
    }

    public boolean isPopBeforeCancel() {
        return this.popBeforeCancel;
    }

    public void setPopBeforeCancel(boolean popBeforeCancel) {
        this.popBeforeCancel = popBeforeCancel;
    }
}

