/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.factory.DealFactory;
import cms.tmx.entity.notice.ExecutionReport;
import cms.tmx.entity.trade.CcsDeal;
import cms.tmx.entity.trade.CtpDeal;
import cms.tmx.entity.trade.Deal;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.mng.DealMng;
import cms.tmx.query.utils.QueryModel;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.MarketUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class DealQueryModel<T extends Deal>
extends MxModel {
    private static final Logger logger = LogManager.getLogger(DealQueryModel.class);
    protected Map<FundAccount, DealMng> mapQuery = new HashMap<FundAccount, DealMng>();
    protected MxList<T> list = new MxList();
    protected String marketGroup;
    @Inject
    protected IFundAccountService serviceFundAcc;
    @Inject
    protected MObjFactory of;
    @Inject
    protected MEventService es;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MScheduler sdPushChange;
    @Inject
    protected QueryModel queryModel;
    private static final int FULL_QUERY_INTERVAL = 3000;
    private static final int FULL_PUSH_CHANGE_INTERVAL = 1000;
    @Inject
    protected DealFactory fDeal;
    protected CopyOnWriteArraySet<String> dirtySet = new CopyOnWriteArraySet();
    protected ReentrantLock dirtyLock = new ReentrantLock();
    private volatile boolean querying = false;

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.sdPushChange.setInterval(1000);
        this.es.subscribe("server.sub", event -> this.onPush(event));
        this.es.subscribe("requery_data", event -> this.query());
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException e) {
                logger.error("deal full query failed", (Throwable)e);
            }
            catch (Exception ee) {
                logger.error("order deal failed", (Throwable)ee);
            }
        });
    }

    protected void fullQuery() throws MException {
        ObservableList accList = this.serviceFundAcc.getFundAccountList();
        ArrayList accs = new ArrayList(accList);
        List filteredAccs = accs.stream().filter(item -> item.getMarketGrp().equals(this.marketGroup)).collect(Collectors.toList());
        this.querying = true;
        try {
            LinkedList<Deal> listDeal = new LinkedList<Deal>();
            for (FundAccount acc : filteredAccs) {
                DealMng query = this.getQuery(acc);
                try {
                    Set<Deal> setAccDeal = query.query();
                    if (setAccDeal == null) continue;
                    listDeal.addAll(setAccDeal);
                }
                catch (MException e) {
                    logger.error("query fund account deals failed", (Throwable)e);
                }
            }
            this.updateList(listDeal);
        }
        finally {
            this.querying = false;
        }
    }

    protected void onPush(MEvent event) {
        if (!(event.getObj() instanceof ExecutionReport)) {
            return;
        }
        ExecutionReport report = (ExecutionReport)ExecutionReport.class.cast(event.getObj());
        if (!this.careReport(report.getReport())) {
            return;
        }
        if (!report.getReport().hasExecution()) {
            return;
        }
        POrderService.Execution execution = report.getReport().getExecution();
        if (execution == null) {
            logger.error("\u63a8\u9001\u6210\u4ea4\u4fe1\u606f\u4e3a\u7a7a, orderId: " + report.getReport().getOrderId());
            return;
        }
        Deal deal = this.fDeal.create(execution);
        this.updateDeal(deal);
        this.list.updatePart((MxObject)deal);
        this.changed();
    }

    protected boolean careReport(PMessage.ExecutionReport report) {
        if (!report.hasExecution()) {
            return false;
        }
        String market = report.getInstrument().getMarket();
        String marketGroup = MarketUtils.getMarketGroup((String)market);
        return marketGroup.equals(this.marketGroup);
    }

    protected void updateDeal(Deal deal) {
        if (deal instanceof CtpDeal) {
            CtpDeal ctp = (CtpDeal)CtpDeal.class.cast(deal);
            this.queryModel.afterUpdate(ctp);
        } else if (deal instanceof CcsDeal) {
            CcsDeal ccs = (CcsDeal)CcsDeal.class.cast(deal);
            this.queryModel.afterUpdate(ccs);
            this.queryModel.getDealPrice((Deal)ccs);
        }
    }

    public synchronized DealMng getQuery(FundAccount acc) {
        System.out.println("DealModel    |  " + Thread.currentThread().getName());
        if (this.mapQuery.containsKey(acc)) {
            return this.mapQuery.get(acc);
        }
        DealMng query = (DealMng)((Object)this.of.create(DealMng.class));
        query.setAccount(acc);
        this.mapQuery.put(acc, query);
        return query;
    }

    protected boolean careReport(String marketGroup, String type) {
        if (!marketGroup.equals(this.marketGroup)) {
            return false;
        }
        return type.equals("70");
    }

    protected void updateList(List<Deal> listDeal) {
        this.changed();
    }

    protected void updateDirty(List<Deal> listDeal) {
        this.changed();
    }

    public ObservableList<T> getList() {
        return this.list.getList();
    }

    public String getMarketGrp() {
        return this.marketGroup;
    }

    public void setMarketGrp(String marketGroup) {
        this.marketGroup = marketGroup;
    }

    protected String getUnit(String secType, String market) {
        return QueryUtils.getUnit(secType, market);
    }

    public boolean isQuerying() {
        return this.querying;
    }

    public void changed() {
        this.sdPushChange.schedule(e -> super.changed());
    }
}

