/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.factory.DealFactory;
import cms.tmx.entity.notice.ExecutionReport;
import cms.tmx.entity.notice.ListStatusReport;
import cms.tmx.entity.trade.Deal;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.mng.DealMng;
import cms.tmx.query.utils.QueryModel;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.MarketUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class DealModel<T extends Deal>
extends MxModel {
    private static final Logger logger = LogManager.getLogger(DealModel.class);
    protected Map<FundAccount, DealMng> mapQuery = new HashMap<FundAccount, DealMng>();
    protected MxList<T> list = new MxList();
    private String marketGroup;
    @Inject
    protected IFundAccountService serviceFundAcc;
    @Inject
    protected MObjFactory of;
    @Inject
    protected MEventService es;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MScheduler sdSpecQuery;
    @Inject
    protected QueryModel queryModel;
    private static final int FULL_QUERY_INTERVAL = 3000;
    private static final int SPEC_QUERY_INTERVAL = 1000;
    @Inject
    protected DealFactory fDeal;
    protected CopyOnWriteArraySet<String> dirtySet = new CopyOnWriteArraySet();
    protected ReentrantLock dirtyLock = new ReentrantLock();
    private volatile boolean querying = false;

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.sdSpecQuery.setInterval(1000);
        this.es.subscribe("server.sub", event -> this.onPush(event));
        this.es.subscribe("requery_data", event -> this.query());
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException e) {
                logger.error("deal full query failed", (Throwable)e);
            }
            catch (Exception ee) {
                logger.error("order deal failed", (Throwable)ee);
            }
        });
    }

    private void querySpec() throws MException {
        logger.info("\u63a8\u9001\u89e6\u53d1\u4e86\u4e00\u7ea7\u8d26\u53f7\u6210\u4ea4\u67e5\u8be2");
        LinkedList<Deal> list = new LinkedList<Deal>();
        for (DealMng query : this.mapQuery.values()) {
            List<Deal> listQuery = query.queryToBeQuery();
            if (listQuery == null) continue;
            list.addAll(listQuery);
        }
        this.updateDirty(list);
    }

    private void runSpecQuery() {
        this.sdSpecQuery.schedule(event -> {
            try {
                this.querySpec();
            }
            catch (MException | Exception e) {
                logger.error("deal spec query failed", e);
            }
        });
    }

    protected void fullQuery() throws MException {
        ObservableList accList = this.serviceFundAcc.getFundAccountList();
        ArrayList accs = new ArrayList(accList);
        List filteredAccs = accs.stream().filter(item -> item.getMarketGrp().equals(this.marketGroup)).collect(Collectors.toList());
        this.querying = true;
        try {
            LinkedList<Deal> listDeal = new LinkedList<Deal>();
            for (FundAccount acc : filteredAccs) {
                DealMng query = this.getQuery(acc);
                try {
                    Set<Deal> setAccDeal = query.query();
                    if (setAccDeal == null) continue;
                    listDeal.addAll(setAccDeal);
                }
                catch (MException e) {
                    logger.error("query fund account deals failed", (Throwable)e);
                }
            }
            this.updateList(listDeal);
        }
        finally {
            this.querying = false;
        }
    }

    protected boolean careReport(String marketGroup, String type) {
        if (!marketGroup.equals(this.marketGroup)) {
            return false;
        }
        return type.equals("70");
    }

    private void runSynQuery(String parentAccountID) {
        LinkedList<Deal> listDeal = new LinkedList<Deal>();
        for (DealMng dealMng : this.mapQuery.values()) {
            if (dealMng.getAccount() instanceof CcsSubFundAccount || !dealMng.getAccount().getParentId().equals(parentAccountID)) continue;
            try {
                LinkedList<Deal> listQuery = new LinkedList<Deal>(dealMng.query());
                listDeal.addAll(listQuery);
            }
            catch (MException | Exception e) {
                logger.error("query fund account deal failed: ", e);
            }
        }
        this.updateDirty(listDeal);
    }

    private void onListReport(MEvent event) {
        String type = event.getStr("push_type");
        if (!type.equals("123")) {
            return;
        }
        if (!(event.getObj() instanceof ListStatusReport)) {
            return;
        }
        ListStatusReport report = (ListStatusReport)ListStatusReport.class.cast(event.getObj());
        if (!("2".equals(String.valueOf(report.getReport().getStatusValue())) || "3".equals(String.valueOf(report.getReport().getStatusValue())) || "4".equals(String.valueOf(report.getReport().getStatusValue())))) {
            return;
        }
        this.sdFullQuery.schedule(e -> this.runSynQuery(report.getReport().getParentExtAccntId()));
    }

    protected void onPush(MEvent event) {
        String type;
        this.onListReport(event);
        if (!(event.getObj() instanceof ExecutionReport)) {
            return;
        }
        ExecutionReport report = (ExecutionReport)ExecutionReport.class.cast(event.getObj());
        String market = report.getReport().getInstrument().getMarket();
        String marketGroup = MarketUtils.getMarketGroup((String)market);
        if (!this.careReport(marketGroup, type = Integer.toString(report.getType()))) {
            return;
        }
        FundAccount acc = this.serviceFundAcc.getFundAccount(report.getReport().getExtAccntId(), marketGroup);
        if (acc == null) {
            return;
        }
        String id = report.getReport().getExecId();
        String date = report.getReport().getTradeDate();
        String sysId = report.getReport().getOrderId();
        String mktGrp = MarketUtils.getMarketGroup((String)report.getReport().getInstrument().getMarket());
        Deal deal = this.fDeal.create(mktGrp);
        deal.setExecId(id);
        deal.setExecDate(date);
        deal.setSysOrderId(sysId);
        DealMng query = this.getQuery(acc);
        if (query != null) {
            query.addToBeQuery(deal);
        }
        this.runSpecQuery();
    }

    public synchronized DealMng getQuery(FundAccount acc) {
        System.out.println("DealModel    |  " + Thread.currentThread().getName());
        if (this.mapQuery.containsKey(acc)) {
            return this.mapQuery.get(acc);
        }
        DealMng query = (DealMng)((Object)this.of.create(DealMng.class));
        query.setAccount(acc);
        this.mapQuery.put(acc, query);
        return query;
    }

    protected void updateList(List<Deal> listDeal) {
        this.changed();
    }

    protected void updateDirty(List<Deal> listDeal) {
        this.changed();
    }

    public ObservableList<T> getList() {
        return this.list.getList();
    }

    public String getMarketGrp() {
        return this.marketGroup;
    }

    public void setMarketGrp(String marketGroup) {
        this.marketGroup = marketGroup;
    }

    protected String getUnit(String secType, String market) {
        return QueryUtils.getUnit(secType, market);
    }

    public boolean isQuerying() {
        return this.querying;
    }
}

