/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.api.data.IRefItem;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.data.utils.Gears;
import cms.tmx.entity.data.CtpContract;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.Order;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.web.settings.BaseSettings;
import cms.tmx.entity.web.settings.CtpTradeSettings;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.mng.InstructionMng;
import cms.tmx.query.current.models.CtpOrderModel;
import cms.tmx.query.current.models.FutureCancelEntrust;
import cms.tmx.utils.MathUtils;
import cms.tmx.web.service.IUserSettingsService;
import cmx.tmx.data.IContractService;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class CtpUnfinishedOrderModel
extends CtpOrderModel {
    private static final Logger logger = LogManager.getLogger(CtpUnfinishedOrderModel.class);
    private ObjectProperty<MxNode> priceType = new SimpleObjectProperty();
    private StringProperty priceFloat = new SimpleStringProperty("0");
    private StringProperty floatUnit = new SimpleStringProperty();
    private MxNode nodePriceType;
    @Inject
    private MEventService es;
    @Inject
    private IUserSettingsService usMng;
    private String funcPanelType;
    private String menuId;
    private boolean popBeforeCancel = true;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private IMarketDataMng marketMng;
    private MarketItem mktItem;
    @Inject
    private InstructionMng instructionMng;
    @Inject
    private IContractService contractService;

    @Override
    @PostConstruct
    public void init() {
        this.isUnfinishedOrder = true;
        super.init();
        this.nodePriceType = MxNodeFactory.create((String)"futures_order_price_type", (String)"sell1");
        this.initPriceType(this.nodePriceType);
        this.setPriceType(this.nodePriceType);
        this.es.subscribe("settingsRefresh", event -> this.doSet());
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("settingsRefresh", event -> this.doSet());
    }

    public void doSet() {
        try {
            if (this.funcPanelType == null || this.menuId == null) {
                return;
            }
            BaseSettings settings = this.usMng.getSettingsDetail(this.funcPanelType, this.menuId);
            if (settings instanceof CtpTradeSettings) {
                this.setPopBeforeCancel(((CtpTradeSettings)CtpTradeSettings.class.cast(settings)).getPopBeforeCancel().equals("1"));
            }
        }
        catch (MException e) {
            logger.error("\u52a0\u8f7d\u7528\u6237\u8bbe\u7f6e\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    private void initPriceType(MxNode node) {
        this.removeOthers(node, "sell1");
        node.addNode("newp");
        node.addNode("buy1");
        node.addNode("opp");
    }

    public void removeOthers(MxNode mxNode, String raw) {
        Iterator it = mxNode.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (node.getRaw().equals(raw)) continue;
            it.remove();
        }
    }

    public synchronized MEvent cancel(List<CtpOrder> list) {
        MEvent event = new MEvent();
        event.setObj(list);
        this.es.sendEvent("ctp.cancel.order", event);
        return event;
    }

    public synchronized MEvent cancelAndOrder(List<CtpOrder> list) {
        MEvent event = new MEvent();
        event.setObj(list);
        this.es.sendEvent("ctp.replace.order", event);
        return event;
    }

    public void queryMarketItem(List<CtpOrder> list) {
        LinkedList<RefItem> listItem = new LinkedList<RefItem>();
        for (CtpOrder order : list) {
            RefItem refItem = this.refMng.getItem(order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
            if (refItem == null) continue;
            listItem.add(refItem);
        }
        Gears gears = new Gears();
        gears.setBuy(new int[]{1});
        gears.setSell(new int[]{1});
        if (!listItem.isEmpty()) {
            this.marketMng.query(listItem, gears);
        }
    }

    public double getNewPrice(Order order, Integer priceType, String floatUnit, String priceFloat) {
        double price = 0.0;
        double mkPrice = 0.0;
        CtpRefItem refItem = (CtpRefItem)this.refMng.getItem(order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
        if (refItem == null) {
            return 0.0;
        }
        int scale = refItem.getScale();
        this.mktItem = this.marketMng.getInfo((IRefItem)refItem);
        if (this.mktItem == null) {
            return 0.0;
        }
        mkPrice = priceType != null ? this.getPrice(priceType) : this.getPrice(order);
        double priceTick = refItem.getPriceTick();
        double changePrice = 0.0;
        if (floatUnit.equals("\u5143")) {
            changePrice = Double.parseDouble("".equals(priceFloat) ? "0" : priceFloat);
        } else if (floatUnit.equals("%")) {
            changePrice = mkPrice * Double.parseDouble("".equals(priceFloat) ? "0" : priceFloat) * 0.01;
        }
        BigDecimal b1 = new BigDecimal(Double.toString(changePrice));
        BigDecimal b2 = new BigDecimal(Double.toString(priceTick));
        BigDecimal b3 = new BigDecimal(0);
        if (priceTick != 0.0) {
            b3 = b1.divideAndRemainder(b2)[1];
        }
        if (order.getSide().getRaw().equals("49")) {
            changePrice = b3.doubleValue() > 0.0 ? changePrice - b3.doubleValue() : changePrice;
        } else if (order.getSide().getRaw().equals("50")) {
            changePrice = b3.doubleValue() > 0.0 ? changePrice - b3.doubleValue() + priceTick : changePrice;
        }
        price = BigDecimal.valueOf(mkPrice + changePrice).setScale(scale, 4).doubleValue();
        if (this.mktItem.getUpLimitPrice() > 0.0 && price > this.mktItem.getUpLimitPrice()) {
            price = this.mktItem.getUpLimitPrice();
        } else if (this.mktItem.getDownLimitPrice() > 0.0 && price < this.mktItem.getDownLimitPrice()) {
            price = this.mktItem.getDownLimitPrice();
        }
        price = MathUtils.roundPrice((Double)price, (int)scale);
        return price;
    }

    public double getPrice(Order order) {
        double dRet = 0.0;
        dRet = this.getPriceType().getRaw().equals("opp") ? (order.getSide().getRaw().equals("49") ? (((HandicapInfo)this.mktItem.getListSellHandicap().get(0)).getPrice() > 0.0 ? ((HandicapInfo)this.mktItem.getListSellHandicap().get(0)).getPrice() : (this.mktItem.getNowPrice() > 0.0 ? this.mktItem.getNowPrice() : this.mktItem.getClosePrice())) : (((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).getPrice() > 0.0 ? ((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).getPrice() : (this.mktItem.getNowPrice() > 0.0 ? this.mktItem.getNowPrice() : this.mktItem.getClosePrice()))) : (this.getPriceType().getRaw().equals("newp") ? (this.mktItem.getNowPrice() > 0.0 ? this.mktItem.getNowPrice() : this.mktItem.getClosePrice()) : (this.getPriceType().getRaw().equals("buy1") ? (((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).getPrice() > 0.0 ? ((HandicapInfo)this.mktItem.getListBuyHandicap().get(0)).getPrice() : (this.mktItem.getNowPrice() > 0.0 ? this.mktItem.getNowPrice() : this.mktItem.getClosePrice())) : (((HandicapInfo)this.mktItem.getListSellHandicap().get(0)).getPrice() > 0.0 ? ((HandicapInfo)this.mktItem.getListSellHandicap().get(0)).getPrice() : (this.mktItem.getNowPrice() > 0.0 ? this.mktItem.getNowPrice() : this.mktItem.getClosePrice()))));
        return dRet;
    }

    private double getPrice(int i) {
        double price = 0.0;
        if (i == 0) {
            price = this.mktItem.getNowPrice() > 0.0 ? this.mktItem.getNowPrice() : this.mktItem.getClosePrice();
        } else if (i == 100) {
            price = this.mktItem.getUpLimitPrice() > 0.0 ? this.mktItem.getUpLimitPrice() : this.mktItem.getClosePrice();
        } else if (i == -100) {
            price = this.mktItem.getDownLimitPrice() > 0.0 ? this.mktItem.getDownLimitPrice() : this.mktItem.getClosePrice();
        } else if (i > 0) {
            do {
                price = 0.0;
                if (i <= 0 || this.mktItem.getListBuyHandicap().size() <= i - 1) continue;
                price = ((HandicapInfo)this.mktItem.getListBuyHandicap().get(i - 1)).getPrice();
                --i;
            } while (price <= 0.0 && i > 0);
            if (price <= 0.0 && i == 0) {
                price = this.mktItem.getNowPrice() > 0.0 ? this.mktItem.getNowPrice() : this.mktItem.getClosePrice();
            }
        } else if (i < 0) {
            i = Math.abs(i);
            do {
                price = 0.0;
                if (i <= 0 || this.mktItem.getListSellHandicap().size() <= i - 1) continue;
                price = ((HandicapInfo)this.mktItem.getListSellHandicap().get(i - 1)).getPrice();
                --i;
            } while (price <= 0.0 && i > 0);
            if (price <= 0.0 && i == 0) {
                price = this.mktItem.getNowPrice() > 0.0 ? this.mktItem.getNowPrice() : this.mktItem.getClosePrice();
            }
        }
        return price;
    }

    public double getAmt(Order or, String offsetFlag, double price, long quantity) {
        CtpRefItem refItem = (CtpRefItem)this.refMng.getItem(or.getInstrument().getMarket().getRaw(), or.getInstrument().getSecId());
        CtpContract con = this.contractService.getContract("FUTURES", or.getInstrument().getMarket().getRaw(), or.getInstrument().getSecId(), or.getBrokerId(), or.getInvestorId());
        if (con == null) {
            return 0.0;
        }
        if ("79".equals(offsetFlag)) {
            BigDecimal amt = BigDecimal.valueOf(price).multiply(BigDecimal.valueOf(quantity)).multiply(BigDecimal.valueOf(con.getUnderlyingMultiple())).multiply(BigDecimal.valueOf(con.getLongMarginRatio())).multiply(BigDecimal.valueOf(con.getVolumeMultiple())).setScale(refItem.getScale(), RoundingMode.HALF_UP);
            return amt.doubleValue();
        }
        if ("67".equals(offsetFlag) || "84".equals(offsetFlag)) {
            BigDecimal amt = BigDecimal.valueOf(price).multiply(BigDecimal.valueOf(quantity)).multiply(BigDecimal.valueOf(con.getUnderlyingMultiple())).multiply(BigDecimal.valueOf(con.getShortMarginRatio())).multiply(BigDecimal.valueOf(con.getVolumeMultiple())).setScale(refItem.getScale(), RoundingMode.HALF_UP);
            return amt.doubleValue();
        }
        return 0.0;
    }

    public ObjectProperty<MxNode> priceTypeProperty() {
        return this.priceType;
    }

    public MxNode getPriceType() {
        return (MxNode)this.priceTypeProperty().get();
    }

    public void setPriceType(MxNode priceType) {
        this.priceTypeProperty().set((Object)priceType);
    }

    public StringProperty priceFloatProperty() {
        return this.priceFloat;
    }

    public String getPriceFloat() {
        return (String)this.priceFloatProperty().get();
    }

    public void setPriceFloat(String priceFloat) {
        this.priceFloatProperty().set((Object)priceFloat);
    }

    public StringProperty floatUnitProperty() {
        return this.floatUnit;
    }

    public String getFloatUnit() {
        return (String)this.floatUnitProperty().get();
    }

    public void setFloatUnit(String floatUnit) {
        this.floatUnitProperty().set((Object)floatUnit);
    }

    public void setType(String funcPanelType, String menuId) {
        this.funcPanelType = funcPanelType;
        this.menuId = menuId;
    }

    public boolean isPopBeforeCancel() {
        return this.popBeforeCancel;
    }

    public void setPopBeforeCancel(boolean popBeforeCancel) {
        this.popBeforeCancel = popBeforeCancel;
    }

    public void checkInstructionPrice(Map<FutureCancelEntrust, CtpOrder> enOrMap, List<String> referenceIds) throws MException {
        List<Instruction> list = this.instructionMng.query(referenceIds);
        Map<String, Instruction> map = list.stream().collect(Collectors.toMap(Instruction::getId, t -> t));
        for (FutureCancelEntrust entrust : enOrMap.keySet()) {
            Instruction instruction = map.get(entrust.getReference());
            if (instruction == null) continue;
            this.checkPriceByType(entrust, enOrMap.get((Object)entrust), instruction);
        }
    }

    private void checkPriceByType(FutureCancelEntrust entrust, CtpOrder ctpOrder, Instruction ins) {
        switch (ins.getType().getRaw()) {
            case "64": {
                this.resetCommonInsPrice(entrust, ctpOrder, ins);
                break;
            }
        }
    }

    private void resetCommonInsPrice(FutureCancelEntrust entrust, CtpOrder ctpOrder, Instruction ins) {
        switch (ins.getOrderAdvice().getOrdType()) {
            case 50: {
                this.resetCommonFixedPrice(entrust, ctpOrder, ins.getOrderAdvice().getPriceLimit(), ins.getOrderAdvice().getPrice());
                break;
            }
            case 0: {
                double limitPice = this.getNewPrice((Order)ctpOrder, ins.getOrderAdvice().getPriceTypeBidAsk(), "", "");
                if (ins.getOrderAdvice().getSide() == 49) {
                    if (!(ctpOrder.getNewPrice() > limitPice)) break;
                    this.resetOrderPriceByInsLimit(entrust, ctpOrder, limitPice);
                    entrust.setTip("\u64a4\u4e0b\u4ef7\u683c\u5927\u4e8e\u6307\u4ee4\u76d8\u53e3\u4ef7\u9650\u5236\uff0c\u5df2\u7ecf\u8c03\u6574\u3002" + entrust.getTip());
                    break;
                }
                if (ins.getOrderAdvice().getSide() != 50 || !(ctpOrder.getNewPrice() < limitPice)) break;
                this.resetOrderPriceByInsLimit(entrust, ctpOrder, limitPice);
                entrust.setTip("\u64a4\u4e0b\u4ef7\u683c\u5c0f\u4e8e\u6307\u4ee4\u76d8\u53e3\u4ef7\u9650\u5236\uff0c\u5df2\u7ecf\u8c03\u6574\u3002" + entrust.getTip());
                break;
            }
        }
    }

    private void resetCommonFixedPrice(FutureCancelEntrust entrust, CtpOrder ctpOrder, int limitType, double price) {
        if (Integer.valueOf("1") == limitType) {
            if (ctpOrder.getNewPrice() > price) {
                this.resetOrderPriceByInsLimit(entrust, ctpOrder, price);
                entrust.setTip("\u8d85\u51fa\u6307\u4ee4\u4e0a\u9650\uff0c\u4ef7\u683c\u8c03\u6574\u4e3a\u4e0a\u9650\u503c\u3002" + entrust.getTip());
            }
        } else if (Integer.valueOf("2") == limitType) {
            this.resetZero(entrust, ctpOrder);
            entrust.setTip("\u6307\u4ee4\u6307\u5b9a\u4ef7\u59d4\u6258\uff0c\u4e0d\u4f1a\u89e6\u53d1\u64a4\u4e0b\u3002" + entrust.getTip());
        } else if (Integer.valueOf("4") == limitType && ctpOrder.getNewPrice() < price) {
            this.resetOrderPriceByInsLimit(entrust, ctpOrder, price);
            entrust.setTip("\u8d85\u51fa\u6307\u4ee4\u4e0b\u9650\uff0c\u4ef7\u683c\u8c03\u6574\u4e3a\u4e0b\u9650\u503c\u3002" + entrust.getTip());
        }
    }

    private void resetOrderPriceByInsLimit(FutureCancelEntrust entrust, CtpOrder or, double limitPice) {
        or.setNewPrice(limitPice);
        entrust.setPrice(limitPice);
        entrust.setAmt(this.getAmt((Order)or, or.getOcFlag().getRaw(), entrust.getPrice(), entrust.getQuantity()));
        entrust.setIsModified(true);
    }

    private void resetZero(FutureCancelEntrust entrust, CtpOrder ctpOrder) {
        entrust.setPrice(0.0);
        entrust.setQuantity(0L);
        entrust.setAmt(0.0);
        ctpOrder.setCanCancelReplace(false);
        entrust.setIsModified(true);
    }
}

