/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.api.data.IRefItem;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.data.utils.Gears;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.CtpContract;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CtpPosition;
import cms.tmx.entity.trade.Position;
import cms.tmx.http.secaccnt.dto.SecAccnt;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.PositionQueryModel;
import cmx.tmx.data.IContractService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class CtpPositionModel
extends PositionQueryModel<CtpPosition> {
    private List<FundAccount> fundsList = new ArrayList<FundAccount>();
    @Inject
    private IContractService contractService;

    @Override
    @PostConstruct
    public void init() {
        this.setMarketGrp("FUTURES");
        this.setSetType(1);
        super.init();
        this.fundsList.addAll(this.fundMng.getFundAccountList(this.getMarketGrp()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void update(List<Position> listSrc) {
        List<CtpPosition> list = this.updatePosition(listSrc);
        ObservableList observableList = this.list.getList();
        synchronized (observableList) {
            this.list.setAll(list);
        }
        this.changed();
    }

    @Override
    protected void updateDirty(List<Position> listSrc) {
        List<CtpPosition> listPosition = this.updatePosition(listSrc);
        this.list.updatePart(listPosition);
        this.changed();
    }

    protected List<CtpPosition> updatePosition(List<Position> listSrc) {
        List<Object> objects;
        LinkedList<CtpPosition> listPosition = new LinkedList<CtpPosition>();
        Object[] object = listSrc.toArray();
        List<Object> list = objects = Arrays.asList(object);
        this.queryMarketItem(list);
        for (Position position : listSrc) {
            if (!(position instanceof CtpPosition)) continue;
            CtpPosition posi = this.updateOne(position);
            listPosition.add(posi);
        }
        return listPosition;
    }

    @Override
    protected CtpPosition updateOne(Position position) {
        CtpPosition posi = (CtpPosition)CtpPosition.class.cast(position);
        this.queryModel.afterUpdate((Position)posi);
        String market = position.getMarket().getRaw();
        String secId = position.getSecId();
        RefItem refItem = this.refMng.getItem(market, secId);
        MarketItem marketItem = null;
        if (refItem != null) {
            marketItem = this.marketMng.getInfo((IRefItem)refItem);
        }
        CtpContract con = this.contractService.getContract("FUTURES", position.getMarket().getRaw(), position.getSecId(), position.getBrokerId(), position.getInvestorId());
        double volumeMultiple = 0.0;
        double price = 0.0;
        if (marketItem != null && con != null) {
            volumeMultiple = con.getVolumeMultiple();
            if (marketItem.getSettlementPrice() > 0.0 && marketItem.getSettlementPrice() < Double.MAX_VALUE) {
                price = marketItem.getSettlementPrice();
            } else if (marketItem.getNowPrice() > 0.0 && marketItem.getNowPrice() < Double.MAX_VALUE) {
                price = marketItem.getNowPrice();
            } else if (marketItem.getPreSettlementPrice() > 0.0 && marketItem.getPreSettlementPrice() < Double.MAX_VALUE) {
                price = marketItem.getPreSettlementPrice();
            } else if (marketItem.getOpenPrice() > 0.0 && marketItem.getOpenPrice() < Double.MAX_VALUE) {
                price = marketItem.getOpenPrice();
            }
        }
        posi.setSecValue(BigDecimal.valueOf((double)posi.getPosition() * price * volumeMultiple).setScale(2, 4).doubleValue());
        return posi;
    }

    public synchronized void queryMarketItem(List<CtpPosition> listSrc) {
        LinkedList<RefItem> listItem = new LinkedList<RefItem>();
        LinkedList<CtpPosition> listTmp = new LinkedList<CtpPosition>();
        listTmp.addAll(listSrc);
        for (Position position : listTmp) {
            RefItem item = this.refMng.getItem(position.getMarket().getRaw(), position.getSecId());
            if (item == null) continue;
            listItem.add(item);
        }
        Gears gears = new Gears();
        gears.setBuy(new int[]{1});
        gears.setSell(new int[]{1});
        if (!listItem.isEmpty()) {
            this.marketMng.query(listItem, gears);
        }
    }

    public double getNewPrice(CtpPosition po) throws MException {
        String market = po.getMarket().getRaw();
        String secId = po.getSecId();
        String posiDirection = po.getPosiDirection().getRaw();
        RefItem refItem = this.refMng.getItem(market, secId);
        if (refItem == null) {
            throw new MException(999997, "no ref item " + secId);
        }
        MarketItem marketItem = this.marketMng.getInfo((IRefItem)refItem);
        if (marketItem == null) {
            throw new MException(999997, "no market item " + secId);
        }
        double price = 0.0;
        if ("1".equals(posiDirection)) {
            price = marketItem.getBuyPrice(0);
        } else if ("2".equals(posiDirection)) {
            price = marketItem.getSellPrice(0);
        }
        if (price <= 0.0) {
            price = marketItem.getNowPrice() > 0.0 ? marketItem.getNowPrice() : marketItem.getClosePrice();
        }
        if (price < 0.0) {
            throw new MException(999997, "\u8be5\u4ee3\u7801\u65e0\u884c\u60c5 ");
        }
        return price;
    }

    public double getAmt(CtpPosition pos, double price, long quantity) {
        CtpRefItem refItem = (CtpRefItem)this.refMng.getItem(pos.getMarket().getRaw(), pos.getSecId());
        CtpContract con = this.contractService.getContract("FUTURES", pos.getMarket().getRaw(), pos.getSecId(), pos.getBrokerId(), pos.getInvestorId());
        if (con == null) {
            return 0.0;
        }
        BigDecimal amt = BigDecimal.valueOf(price).multiply(BigDecimal.valueOf(quantity)).multiply(BigDecimal.valueOf(con.getUnderlyingMultiple())).multiply(BigDecimal.valueOf(con.getShortMarginRatio())).multiply(BigDecimal.valueOf(con.getVolumeMultiple())).setScale(refItem.getScale(), RoundingMode.HALF_UP);
        return amt.doubleValue();
    }

    public MEvent close(CtpPosition pos) {
        LinkedList<CtpPosition> list = new LinkedList<CtpPosition>();
        list.add(pos);
        return this.clear(list);
    }

    public MEvent clear(List<CtpPosition> listClear) {
        MEvent eCall = new MEvent();
        eCall.setObj(listClear);
        this.es.sendEvent("trade.close.position", eCall);
        return eCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObservableList<CtpPosition> getPositionList(SecAccount fund, String code) {
        ObservableList listPos = FxUtils.newList();
        ObservableList observableList = this.list.getList();
        synchronized (observableList) {
            for (CtpPosition pos : this.getList()) {
                if (!fund.getExtSecAccntId().equals(pos.getExtSecAccId()) || !code.equals(pos.getSecId())) continue;
                listPos.add((Object)pos);
            }
        }
        return listPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObservableList<CtpPosition> getPositionList(SecAccnt fund, String code) {
        ObservableList listPos = FxUtils.newList();
        ObservableList observableList = this.list.getList();
        synchronized (observableList) {
            for (CtpPosition pos : this.getList()) {
                if (!fund.getInvestorSecId().equals(pos.getExtSecAccId()) || !code.equals(pos.getSecId())) continue;
                listPos.add((Object)pos);
            }
        }
        return listPos;
    }

    public List<FundAccount> getFundsList() {
        return this.fundsList;
    }
}

