/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.entity.FundAccount;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.Order;
import cms.tmx.query.current.models.OrderQueryModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class CtpOrderModel
extends OrderQueryModel<CtpOrder> {
    private List<FundAccount> fundsList = new ArrayList<FundAccount>();

    @Override
    @PostConstruct
    public void init() {
        this.setMarketGrp("FUTURES");
        super.init();
        this.fundsList.addAll(this.faccService.getFundAccountList(this.marketGroup));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void update(List<Order> listOrder) {
        List<CtpOrder> listCtpOrder = this.updateOrder(listOrder);
        ObservableList observableList = this.list.getList();
        synchronized (observableList) {
            listCtpOrder.addAll((Collection<CtpOrder>)this.list.getList());
        }
        this.list.update(listCtpOrder);
        this.changed();
    }

    @Override
    protected synchronized void updateDirty(List<Order> listOrder) {
        List<CtpOrder> listCtpOrder = this.updateOrder(listOrder);
        this.list.updatePart(listCtpOrder);
        this.changed();
    }

    protected List<CtpOrder> updateOrder(List<Order> listOrder) {
        LinkedList<CtpOrder> list = new LinkedList<CtpOrder>();
        for (Order order : listOrder) {
            if (!(order instanceof CtpOrder)) continue;
            CtpOrder ctp = (CtpOrder)CtpOrder.class.cast(order);
            this.queryModel.afterUpdate(ctp);
            this.queryModel.getOrderPrice(order);
            list.add(ctp);
        }
        return list;
    }

    public List<FundAccount> getFundList() {
        return this.fundsList;
    }
}

