/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.entity.FundAccount;
import cms.tmx.entity.trade.CtpDeal;
import cms.tmx.entity.trade.Deal;
import cms.tmx.query.current.models.DealQueryModel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class CtpDealModel
extends DealQueryModel<CtpDeal> {
    private List<FundAccount> fundsList = new ArrayList<FundAccount>();

    @Override
    @PostConstruct
    public void init() {
        this.setMarketGrp("FUTURES");
        super.init();
        this.initFundsAcc();
    }

    private void initFundsAcc() {
        ObservableList accList = this.serviceFundAcc.getFundAccountList();
        ArrayList accs = new ArrayList(accList);
        this.getFundsList().addAll(accs.stream().filter(item -> item.getMarketGrp().equals(this.marketGroup)).collect(Collectors.toList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void updateList(List<Deal> listDeal) {
        List<CtpDeal> list = this.updateDeal(listDeal);
        ObservableList observableList = this.list.getList();
        synchronized (observableList) {
            this.list.setAll(list);
        }
        this.changed();
    }

    @Override
    protected synchronized void updateDirty(List<Deal> listDeal) {
        List<CtpDeal> list = this.updateDeal(listDeal);
        this.list.updatePart(list);
        this.changed();
    }

    protected List<CtpDeal> updateDeal(List<Deal> listDeal) {
        LinkedList<CtpDeal> list = new LinkedList<CtpDeal>();
        for (Deal deal : listDeal) {
            if (!(deal instanceof CtpDeal)) continue;
            CtpDeal ctp = (CtpDeal)CtpDeal.class.cast(deal);
            this.queryModel.getDealPrice(deal);
            this.queryModel.afterUpdate(ctp);
            list.add(ctp);
        }
        return list;
    }

    public List<FundAccount> getFundsList() {
        return this.fundsList;
    }
}

