/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.CtpFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.ISecAccountService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class CtpAccountMap
extends MxModel {
    @Inject
    ISecAccountService secAccService;
    @Inject
    private MEventService es;
    private Map<CtpFundAccount, List<SecAccount>> futureMapAccount = FxUtils.newMap();
    private Map<String, CtpFundAccount> mapFundAcc = new HashMap<String, CtpFundAccount>();
    private Map<String, SecAccount> mapSecAcc = new HashMap<String, SecAccount>();
    private Map<String, CtpFundAccount> ctpAccountMap = FxUtils.newMap();
    private Map<String, SecAccount> ctpSecAccountMap = FxUtils.newMap();
    private MEventHandler handler = event -> this.initAccount(event);

    @PostConstruct
    public void init() {
        this.es.subscribe("stage.after.login", this.handler);
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("stage.after.login", this.handler);
    }

    private void initAccount(MEvent event) {
        try {
            Map<CtpFundAccount, List<SecAccount>> mapAcc = this.getAccountMap();
            for (CtpFundAccount fund : mapAcc.keySet()) {
                if (mapAcc.get(fund) == null || mapAcc.get(fund).size() == 0) continue;
                this.mapFundAcc.put(fund.getInvestId(), fund);
                for (SecAccount sec : mapAcc.get(fund)) {
                    this.mapSecAcc.put(String.valueOf(sec.getInverstorSecId()) + sec.getInverstorId(), sec);
                }
            }
            this.logger.debug("CtpAccountMap changed!" + this.mapFundAcc.size());
            this.changed();
        }
        catch (MException e) {
            this.logger.error((Object)e, (Throwable)e);
        }
    }

    public synchronized Map<CtpFundAccount, List<SecAccount>> getAccountMap() throws MException {
        if (this.futureMapAccount.isEmpty()) {
            Map mapAccount = this.secAccService.getSecAccountMap();
            mapAccount.keySet().forEach(account -> {
                if (account.getMarketGrp().equals("FUTURES") && account instanceof CtpFundAccount && !account.isExternalAsset()) {
                    CtpFundAccount ctpAccount = (CtpFundAccount)CtpFundAccount.class.cast(account);
                    this.futureMapAccount.put(ctpAccount, (List)mapAccount.get(account));
                }
            });
        }
        return this.futureMapAccount;
    }

    public CtpFundAccount getFundAcc(String fundAccId) {
        return this.mapFundAcc.get(fundAccId);
    }

    public SecAccount getSecAcc(String secAccId) {
        return this.mapSecAcc.get(secAccId);
    }

    public List<String> getFundAccList() {
        ArrayList<String> list = new ArrayList<String>();
        this.mapFundAcc.keySet().forEach(each -> {
            boolean bl = list.add((String)each);
        });
        return list;
    }

    public List<String> getExtAccList() throws MException {
        ArrayList<String> list = new ArrayList<String>();
        this.getAccountMap().keySet().forEach(each -> {
            boolean bl = list.add(each.getExtAccntId());
        });
        return list;
    }

    public List<String> getSecAccList(String fundAccId) throws MException {
        ArrayList<String> list = new ArrayList<String>();
        CtpFundAccount account = this.getFundAcc(fundAccId);
        for (SecAccount sec : this.getAccountMap().get(account)) {
            list.add(sec.getInverstorSecId());
        }
        return list;
    }

    public synchronized Map<String, CtpFundAccount> getCtpAccountMap() {
        if (this.ctpAccountMap.isEmpty()) {
            try {
                Map mapAccount = this.secAccService.getSecAccountMap();
                mapAccount.keySet().forEach(account -> {
                    if (account.getMarketGrp().equals("FUTURES") && account instanceof CtpFundAccount && !account.isExternalAsset()) {
                        CtpFundAccount ccsAccount = (CtpFundAccount)CtpFundAccount.class.cast(account);
                        this.ctpAccountMap.put(ccsAccount.getExtAccntId(), ccsAccount);
                    }
                });
            }
            catch (MException e) {
                this.logger.error("\u83b7\u53d6\u4e00\u7ea7\u8d44\u91d1\u8d26\u53f7map\u5931\u8d25", (Throwable)e);
            }
        }
        return this.ctpAccountMap;
    }

    public synchronized Map<String, SecAccount> getCtpSecAccountMap() {
        if (this.ctpSecAccountMap.isEmpty()) {
            try {
                Map mapAccount = this.secAccService.getSecAccountMap();
                mapAccount.keySet().forEach(account -> {
                    if (account.getMarketGrp().equals("FUTURES") && account instanceof CtpFundAccount && !account.isExternalAsset()) {
                        List secList = (List)mapAccount.get(account);
                        secList.forEach(sec -> this.ctpSecAccountMap.put(sec.getExtSecAccntId(), (SecAccount)sec));
                    }
                });
            }
            catch (MException e) {
                this.logger.error("\u83b7\u53d6\u4e00\u7ea7\u8bc1\u5238\u8d26\u53f7map\u5931\u8d25", (Throwable)e);
            }
        }
        return this.ctpSecAccountMap;
    }

    public String getCtpInvestId(String extAccntId) {
        CtpFundAccount account = this.getCtpAccountMap().get(extAccntId);
        if (account != null && !account.getInvestId().isEmpty()) {
            return account.getInvestId();
        }
        return extAccntId;
    }

    public CtpFundAccount getCtpAccountByExtAccntId(String extAccntId) {
        CtpFundAccount account = this.getCtpAccountMap().get(extAccntId);
        return account;
    }

    public String getCtpBrokerId(String extAccntId) {
        CtpFundAccount account = this.getCtpAccountMap().get(extAccntId);
        if (account != null && !account.getInvestId().isEmpty()) {
            return account.getBrokerId();
        }
        return "";
    }

    public String getCtpInverstorSecId(String extSecAccntId) {
        SecAccount account = this.getCtpSecAccountMap().get(extSecAccntId);
        if (account != null && !account.getInverstorSecId().isEmpty()) {
            return account.getInverstorSecId();
        }
        return extSecAccntId;
    }
}

