/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.api.data.IRefItem;
import cms.tmx.core.MEvent;
import cms.tmx.core.MScheduler;
import cms.tmx.data.utils.Gears;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.Position;
import cms.tmx.entity.trade.basket.BasketItem;
import cms.tmx.entity.trade.basket.BasketSubmitResult;
import cms.tmx.entity.trade.basket.BasketTradeItem;
import cms.tmx.javafx.obj.MxDirtyObj;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.PositionModel;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

@Creatable
@Singleton
public class CcsPositionModel
extends PositionModel<CcsPosition> {
    private static final Logger logger = LogManager.getLogger(CcsPositionModel.class);
    private Map<String, CcsPosition> ccsPstMap;
    @Inject
    protected MScheduler sdFullQuery;
    private static final int FULL_QUERY_INTERVAL = 3000;
    @Inject
    protected ExecutorService exe;
    private static final List<String> parts = Arrays.asList("cms.tmx.instructions.part.regular.position.query", "cms.tmx.instructions.part.shortcut.position.query", "cms.tmx.block.part.position", "cms.tmx.instructions.part.regular.position.carried.forward.query.zy", "cms.tmx.block.part.fixedIncome.position", "cms.tmx.bond.part.position", "cms.tmx.bond.part.repo.position", "cms.tmx.fund.part.position", "cms.tmx.fund.part.query.position", "cms.tmx.instructions.part.basket.position.query", "cms.tmx.stock.part.position", "cms.tmx.instructions.part.regular.position.carried.forward.query", "cms.tmx.instructions.part.regular.stdbondposition.query");
    @Inject
    private EPartService eps;
    private InvalidationListener lst = ob -> {
        ObservableList observableList = this.getList();
        synchronized (observableList) {
            this.ccsPstMap = this.getList().stream().collect(Collectors.toMap(CcsPosition::unique, p -> p, (oldValue, newValue) -> oldValue));
        }
        this.mapChange();
    };
    @Inject
    private CcsAccountMap cssAccountMap;

    @Override
    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.setMarketGrp("CCS");
        this.setPositionType("BOND");
        this.setSetType(1);
        super.init();
        this.changed.addListener(this.lst);
    }

    public void queryNewPrice() {
        block7: {
            try {
                try {
                    boolean isVisible = false;
                    for (String partId : parts) {
                        MPart findPart = this.eps.findPart(partId);
                        if (findPart == null || !this.eps.isPartVisible(findPart)) continue;
                        isVisible = true;
                        logger.info(String.valueOf(partId) + "\u53ef\u89c1");
                        break;
                    }
                    if (isVisible) {
                        this.queryAndGetNewPrice((List<CcsPosition>)this.getList());
                        break block7;
                    }
                    logger.info("\u65e0\u8d44\u91d1\u8d26\u53f7\u6301\u4ed3\u9875\u9762\u53ef\u89c1");
                }
                catch (Exception e) {
                    logger.error("\u6301\u4ed3\u8f6e\u8be2\u6700\u65b0\u4ef7\u5931\u8d25", (Throwable)e);
                    this.changed();
                }
            }
            finally {
                this.changed();
            }
        }
    }

    private Map<String, CcsPosition> getMap() {
        return this.ccsPstMap;
    }

    @Override
    protected void update(List<Position> listSrc) {
        List<CcsPosition> listPosition = this.updatePosition(listSrc, true);
        this.list.update(listPosition);
        this.changed();
    }

    public List<CcsPosition> updatePosition(List<Position> listSrc, boolean isAll) {
        LinkedList<CcsPosition> listPosition = new LinkedList<CcsPosition>();
        for (Position position : listSrc) {
            if (!"XSHG".equals(position.getMarket().getRaw()) && !"XSHE".equals(position.getMarket().getRaw()) || !(position instanceof CcsPosition)) continue;
            CcsPosition posi = (CcsPosition)CcsPosition.class.cast(position);
            this.queryModel.getPositionPrice(posi);
            this.queryModel.afterUpdate((Position)posi);
            listPosition.add(posi);
            CcsPosition ccsPosition = (CcsPosition)this.list.get((MxDirtyObj)posi);
            posi.updateCalValue(ccsPosition);
        }
        this.exe.execute(() -> {
            if (isAll) {
                this.queryAndGetNewPrice(listPosition);
                this.list.update(listPosition);
            }
            this.changed();
        });
        return listPosition;
    }

    public List<CcsPosition> updateCcsPosition(List<CcsPosition> listSrc) {
        LinkedList<CcsPosition> listPosition = new LinkedList<CcsPosition>();
        for (Position position : listSrc) {
            if (!(position instanceof CcsPosition)) continue;
            CcsPosition posi = (CcsPosition)CcsPosition.class.cast(position);
            this.queryModel.getPositionPrice(posi);
            this.queryModel.afterUpdate((Position)posi);
            listPosition.add(posi);
        }
        this.exe.execute(() -> {
            this.queryAndGetNewPrice(listPosition);
            this.changed();
        });
        return listPosition;
    }

    @Override
    protected void updateDirty(List<Position> listSrc) {
        List<CcsPosition> listPosition = this.updatePosition(listSrc, false);
        this.list.updateDirty(listPosition);
        this.changed();
    }

    public MEvent close(CcsPosition pos) {
        LinkedList<CcsPosition> list = new LinkedList<CcsPosition>();
        list.add(pos);
        return this.clear(list);
    }

    private MEvent clear(List<CcsPosition> listClear) {
        MEvent eCall = new MEvent();
        eCall.setObj(listClear);
        this.es.sendEvent("trade.close.position", eCall);
        return eCall;
    }

    public BasketSubmitResult clearAll(List<CcsPosition> listClear) {
        ArrayList<BasketTradeItem> tradeItems = new ArrayList<BasketTradeItem>();
        int noRefCount = 0;
        for (CcsPosition po : listClear) {
            String market = po.getMarket().getRaw();
            String securityId = po.getSecId();
            RefItem refItem = null;
            refItem = "SHSC".equals(po.getMarket().getRaw()) || "SZSC".equals(po.getMarket().getRaw()) ? this.refMng.getItem(String.valueOf(po.getSecType()) + market, market, securityId) : this.refMng.getItem(po.getSecType(), market, securityId);
            if (refItem == null || this.marketMng.getInfo((IRefItem)refItem) == null || po.getNewPrice() <= 0.0) {
                ++noRefCount;
                logger.error("\u6e05\u4ed3 no ref item " + securityId);
                continue;
            }
            BasketTradeItem item = new BasketTradeItem();
            BasketItem bi = new BasketItem();
            bi.setSecurityId(securityId);
            bi.setSecurityName(refItem.getName());
            bi.getMarket().setRaw(market);
            bi.setSecurityType(refItem.getType());
            bi.setRefItem(refItem);
            item.setItem(bi);
            item.getBsTrade().setRaw("50");
            item.setSellPrice(po.getNewPrice());
            item.setSellCount(po.getCanVol());
            item.setTargetCount(po.getCanVol());
            CcsFundAccount fundAcc = this.cssAccountMap.getAllCcsAccountMap().get(po.getExtAccId());
            SecAccount secAcc = this.cssAccountMap.getAllCcsSecAccountMap().get(po.getExtSecAccId());
            if (fundAcc != null) {
                item.setAcc(fundAcc);
            }
            if (secAcc != null) {
                item.setSecAcc(secAcc);
            }
            tradeItems.add(item);
        }
        MEvent eCall = new MEvent();
        eCall.setObj(tradeItems);
        eCall.put((Object)"isPortfolio", (Object)false);
        this.es.sendEvent("trade.close.basket.position", eCall);
        BasketSubmitResult result = (BasketSubmitResult)eCall.get("clear.basket", BasketSubmitResult.class);
        if (noRefCount > 0) {
            result.getFailedTimes().getAndAdd(noRefCount);
        }
        return result;
    }

    @Override
    public double getCanSell(SecAccount account, String code) {
        CcsPosition pos = this.getPosition(account, code);
        if (pos != null) {
            return pos.getCanVol();
        }
        return 0.0;
    }

    @Override
    public CcsPosition getPosition(SecAccount account, String code) {
        return this.getPosition(account.getExtSecAccntId(), code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CcsPosition getPosition(String account, String code) {
        CcsPosition item = null;
        if (this.ccsPstMap == null || this.ccsPstMap.isEmpty()) {
            ObservableList observableList = this.list.getList();
            synchronized (observableList) {
                for (CcsPosition pos : this.getList()) {
                    if (!account.equals(pos.getExtSecAccId()) || !code.equals(pos.getSecId())) continue;
                    item = pos;
                    break;
                }
            }
        } else {
            item = this.ccsPstMap.get(String.valueOf(account) + code);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CcsPosition getPositionInMap(SecAccount account, String code) {
        CcsPosition item = null;
        ObservableList observableList = this.list.getList();
        synchronized (observableList) {
            if (this.getMap() != null) {
                item = this.getMap().get(String.valueOf(account.getExtSecAccntId()) + code);
            }
        }
        return item;
    }

    public synchronized void queryMarketItem(List<CcsPosition> posList) {
        LinkedList<RefItem> listItem = new LinkedList<RefItem>();
        for (CcsPosition t : posList) {
            RefItem item = this.refMng.getItem(t.getSecType(), t.getMarket().getRaw(), t.getSecId());
            if (item == null) continue;
            listItem.add(item);
        }
        Gears gears = new Gears();
        gears.setBuy(new int[]{1});
        if (!listItem.isEmpty()) {
            this.marketMng.query(listItem, gears);
        }
    }

    public synchronized void queryAndGetNewPrice(List<CcsPosition> posList) {
        LinkedList<RefItem> listItem = new LinkedList<RefItem>();
        for (CcsPosition t : posList) {
            RefItem item = this.refMng.getItem(t.getSecType(), t.getMarket().getRaw(), t.getSecId());
            if (item == null) continue;
            listItem.add(item);
        }
        Gears gears = new Gears();
        gears.setBuy(new int[]{0});
        if (!listItem.isEmpty()) {
            this.marketMng.queryNewPriceIn5Seconds(listItem, gears);
        }
        for (CcsPosition posi : posList) {
            RefItem refItem = this.refMng.getItem(posi.getSecType(), posi.getMarket().getRaw(), posi.getSecId());
            if (refItem == null) {
                if ("STD_BOND".equals(posi.getSecType())) {
                    posi.setNowPrice(100.0);
                    posi.setClosePrice(100.0);
                    double capitalization = QueryUtils.calAmountByMarketAndSecType(posi.getMarket().getRaw(), posi.getSecType(), posi.getTotalVol(), posi.getNowPrice());
                    posi.setCapitalization(this.formatScale(capitalization, 4));
                }
            } else {
                MarketItem marketItem = this.marketMng.getInfo((IRefItem)refItem);
                if (marketItem != null) {
                    posi.setClosePrice(marketItem.getClosePrice());
                    if (marketItem.getNowPrice() == 0.0) {
                        posi.setNowPrice(marketItem.getClosePrice());
                    } else {
                        posi.setNowPrice(marketItem.getNowPrice());
                    }
                } else {
                    logger.error(String.valueOf(posi.getSecId()) + "\u6ca1\u6709\u83b7\u53d6\u5230\u52a8\u6001\u884c\u60c5");
                }
            }
            BigDecimal buy = new BigDecimal(posi.getBuyCost());
            double buyCost = buy.setScale(4, 4).doubleValue();
            if (posi.getNowPrice() == 0.0 || buyCost == 0.0 || "STD_BOND".equals(posi.getSecType())) {
                posi.setYield(0.0);
            } else {
                double yield = (posi.getNowPrice() - buyCost) * 100.0 / buyCost;
                posi.setYield(Double.parseDouble(StringUtils.toStr((double)yield, (int)2).replaceAll(",", "")));
            }
            BigDecimal b = new BigDecimal(posi.getCost());
            double cost = b.setScale(4, 4).doubleValue();
            if (posi.getNowPrice() == 0.0 || cost == 0.0 || "STD_BOND".equals(posi.getSecType())) {
                posi.setPercent(0.0);
            } else {
                double percent = (posi.getNowPrice() - cost) * 100.0 / cost;
                posi.setPercent(Double.parseDouble(StringUtils.toStr((double)percent, (int)2).replaceAll(",", "")));
            }
            if (refItem != null && posi.getNowPrice() != 0.0) {
                double capitalization = QueryUtils.calAmountByMarketAndSecType(posi.getMarket().getRaw(), posi.getSecType(), posi.getTotalVol(), posi.getNowPrice());
                posi.setCapitalization(this.formatScale(capitalization, 4));
                if (posi.getClosePrice() != 0.0) {
                    double priceFloatPrecent = (posi.getNowPrice() - posi.getClosePrice()) * 100.0 / posi.getClosePrice();
                    posi.setPriceFloatPercent(this.formatScale(priceFloatPrecent, 2));
                }
            } else {
                posi.setPriceFloatPercent(0.0);
            }
            posi.updateProfit();
        }
        for (CcsPosition posi : posList) {
            posi.setTodayTotalPl(this.formatScale(posi.getTodayFloatPl() + posi.getTodayRealPl(), 2));
        }
    }

    private double formatScale(double d, int scale) {
        return new BigDecimal(d).setScale(scale, 4).doubleValue();
    }
}

