/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.datatype.message.PMessage;
import cms.tmx.entity.trade.CcsDeal;
import cms.tmx.entity.trade.Deal;
import cms.tmx.query.current.models.DealQueryModel;
import cms.tmx.utils.MarketUtils;
import java.util.LinkedList;
import java.util.List;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class CcsDealModel
extends DealQueryModel<CcsDeal> {
    public static String baseId = "";
    public static boolean isNormal = false;

    @Override
    @PostConstruct
    public void init() {
        this.setMarketGrp("CCS");
        super.init();
    }

    @Override
    protected boolean careReport(PMessage.ExecutionReport report) {
        if (!report.hasExecution()) {
            return false;
        }
        String market = report.getInstrument().getMarket();
        if (!"XSHE".equals(market) && !"XSHG".equals(market)) {
            return false;
        }
        String marketGroup = MarketUtils.getMarketGroup((String)market);
        return marketGroup.equals(this.marketGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateList(List<Deal> listDeal) {
        List<CcsDeal> list = this.updateDeal(listDeal);
        ObservableList observableList = this.list.getList();
        synchronized (observableList) {
            this.list.setAll(list);
        }
        this.changed();
    }

    public List<CcsDeal> updateDeal(List<Deal> listDeal) {
        LinkedList<CcsDeal> list = new LinkedList<CcsDeal>();
        for (Deal deal : listDeal) {
            if (!"XSHG".equals(deal.getInstrument().getMarket().getRaw()) && !"XSHE".equals(deal.getInstrument().getMarket().getRaw()) || !(deal instanceof CcsDeal)) continue;
            CcsDeal ccs = (CcsDeal)CcsDeal.class.cast(deal);
            this.queryModel.getDealPrice(deal);
            this.queryModel.afterUpdate(ccs);
            list.add(ccs);
        }
        return list;
    }

    public List<CcsDeal> updateDealWithoutPrice(List<Deal> listDeal) {
        LinkedList<CcsDeal> list = new LinkedList<CcsDeal>();
        for (Deal deal : listDeal) {
            if (!(deal instanceof CcsDeal)) continue;
            CcsDeal ccs = (CcsDeal)CcsDeal.class.cast(deal);
            this.queryModel.afterUpdate(ccs);
            list.add(ccs);
        }
        return list;
    }

    @Override
    protected void updateDirty(List<Deal> listDeal) {
        List<CcsDeal> list = this.updateDeal(listDeal);
        this.list.updatePart(list);
        this.changed();
    }
}

