/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.Account;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CfetsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.ISecAccountService;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class CcsAccountMap
extends MxModel {
    @Inject
    private ISecAccountService secAccService;
    @Inject
    private IFundAccountService fundAccountService;
    @Inject
    private MEventService es;
    private Map<CcsFundAccount, List<SecAccount>> ccsMapAccount = FxUtils.newMap();
    private Map<CcsFundAccount, List<SecAccount>> hkMapAccount = FxUtils.newMap();
    private Map<String, CcsFundAccount> mapFundAcc = new ConcurrentHashMap<String, CcsFundAccount>();
    private Map<String, SecAccount> mapSecAcc = new ConcurrentHashMap<String, SecAccount>();
    private Map<String, CcsFundAccount> ccsAccountMap = FxUtils.newMap();
    private Map<String, SecAccount> ccsSecAccountMap = FxUtils.newMap();
    private Map<String, CcsFundAccount> ccsAllAccountMap = FxUtils.newMap();
    private Map<String, SecAccount> ccsAllSecAccountMap = FxUtils.newMap();
    private static final Logger logger = LogManager.getLogger(CcsAccountMap.class);
    private MEventHandler handler = event -> {
        this.initAccount(event);
        MEvent e = new MEvent();
        ArrayList<String> cfetsAccount = new ArrayList<String>();
        for (CfetsFundAccount account : this.getCfetsAccountMap().values()) {
            cfetsAccount.add(account.getParentId());
        }
        e.put((Object)"CFETS_ACCNT", cfetsAccount);
        this.es.postEvent("cfets.accnt.sub", e);
    };
    private MEventHandler handlerneeq = event -> {
        this.initAccount(event);
        MEvent e = new MEvent();
        try {
            ArrayList<String> neeqAccount = new ArrayList<String>();
            for (CcsFundAccount account : this.getAccountMap().keySet()) {
                neeqAccount.add(account.getParentId());
            }
            e.put((Object)"NEEQ_ACCNT", neeqAccount);
        }
        catch (MException exception) {
            logger.error((Object)exception, (Throwable)exception);
        }
        this.es.postEvent("neeq.accnt.sub", e);
    };
    private MEventHandler hkAccntHander = event -> {
        this.initAccount(event);
        ArrayList<String> hkAccntIds = new ArrayList<String>();
        try {
            Map<CcsFundAccount, List<SecAccount>> hkAccountMap = this.getHkAccountMap();
            for (CcsFundAccount fund : hkAccountMap.keySet()) {
                hkAccntIds.add(fund.getParentId());
            }
            event.setObj(hkAccntIds);
        }
        catch (MException e) {
            logger.error("\u83b7\u53d6\u6e2f\u80a1\u8d26\u53f7\u5931\u8d25", (Throwable)e);
        }
    };
    private MEventHandler handlerhk = event -> {
        this.initAccount(event);
        ArrayList<String> hkAccntIds = new ArrayList<String>();
        MEvent e = new MEvent();
        try {
            Map<CcsFundAccount, List<SecAccount>> hkAccountMap = this.getHkAccountMap();
            for (CcsFundAccount fund : hkAccountMap.keySet()) {
                hkAccntIds.add(fund.getParentId());
            }
            e.put((Object)"HK_ACCNT", hkAccntIds);
        }
        catch (MException exception) {
            logger.error((Object)exception, (Throwable)exception);
        }
        this.es.postEvent("hk.accnt.sub", e);
    };
    private Map<String, CfetsFundAccount> cfetsAccountMap = FxUtils.newMap();
    private Map<String, SecAccount> cfetsSecAccountMap = FxUtils.newMap();

    @PostConstruct
    public void init() {
        this.es.subscribe("stage.after.login", this.handler);
        this.es.subscribe("stage.after.login", this.handlerneeq);
        this.es.subscribe("stage.after.login", this.handlerhk);
        this.es.subscribe("hk.accnt.get", this.hkAccntHander);
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("stage.after.login", this.handler);
        this.es.unSubscribe("stage.after.login", this.handlerneeq);
        this.es.unSubscribe("stage.after.login", this.handlerhk);
        this.es.unSubscribe("hk.accnt.get", this.hkAccntHander);
    }

    private void initAccount(MEvent event) {
        try {
            Map<CcsFundAccount, List<SecAccount>> mapAcc = this.getAccountMap();
            for (CcsFundAccount fund : mapAcc.keySet()) {
                if (mapAcc.get(fund) == null || mapAcc.get(fund).size() == 0) continue;
                this.mapFundAcc.put(fund.getInvestId(), fund);
                for (SecAccount sec : mapAcc.get(fund)) {
                    this.mapSecAcc.put(String.valueOf(sec.getInverstorSecId()) + sec.getExchange().getRaw(), sec);
                }
            }
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public synchronized Map<CcsFundAccount, List<SecAccount>> getAccountMap() throws MException {
        if (this.ccsMapAccount.isEmpty()) {
            logger.info("create account map");
            Map mapAccount = this.secAccService.getSecAccountMap();
            mapAccount.keySet().forEach(account -> {
                if (!"99999-02-01".equals(account.getCounterId()) && !"99999-02-02".equals(account.getCounterId()) && !"99999-02-03".equals(account.getCounterId()) && account.getMarketGrp().equals("CCS") && account instanceof CcsFundAccount && !account.isExternalAsset()) {
                    CcsFundAccount ccsAccount = (CcsFundAccount)CcsFundAccount.class.cast(account);
                    this.ccsMapAccount.put(ccsAccount, (List)mapAccount.get(account));
                }
            });
        }
        return this.ccsMapAccount;
    }

    public synchronized Map<CcsFundAccount, List<SecAccount>> getHkAccountMap() throws MException {
        if (this.hkMapAccount.isEmpty()) {
            logger.info("create account map");
            Map mapAccount = this.secAccService.getAllSecAccountMap();
            mapAccount.keySet().forEach(account -> {
                if (account.getMarketGrp().equals("OTC") && ("66668-01-01".equals(account.getCounterId()) || "99988-01-01".equals(account.getCounterId()) || "99988-01-02".equals(account.getCounterId())) && account instanceof CcsFundAccount) {
                    CcsFundAccount ccsAccount = (CcsFundAccount)CcsFundAccount.class.cast(account);
                    this.hkMapAccount.put(ccsAccount, (List)mapAccount.get(account));
                }
            });
        }
        return this.hkMapAccount;
    }

    public CcsFundAccount getFundAcc(String fundAccId) {
        return this.mapFundAcc.get(fundAccId);
    }

    public SecAccount getSecAcc(String secAccId, String market) {
        if (StringUtils.isEmpty((String)market)) {
            SecAccount xsheSec = this.mapSecAcc.get(String.valueOf(secAccId) + "XSHE");
            return xsheSec == null ? this.mapSecAcc.get(String.valueOf(secAccId) + "XSHG") : xsheSec;
        }
        return this.mapSecAcc.get(String.valueOf(secAccId) + market);
    }

    public List<String> getFundAccList() {
        ArrayList<String> list = new ArrayList<String>();
        this.mapFundAcc.keySet().forEach(each -> {
            boolean bl = list.add((String)each);
        });
        return list;
    }

    public List<String> getExtAccList() throws MException {
        ArrayList<String> list = new ArrayList<String>();
        this.getAccountMap().keySet().forEach(each -> {
            boolean bl = list.add(each.getExtAccntId());
        });
        return list;
    }

    public List<String> getParentId() throws MException {
        ArrayList<String> list = new ArrayList<String>();
        this.getAccountMap().keySet().forEach(each -> {
            boolean bl = list.add(each.getParentId());
        });
        return list;
    }

    public List<String> getSecAccIdList(String fundAccId) throws MException {
        ArrayList<String> list = new ArrayList<String>();
        CcsFundAccount account = this.getFundAcc(fundAccId);
        if (account == null) {
            return list;
        }
        for (SecAccount sec : this.getAccountMap().get(account)) {
            list.add(sec.getInverstorSecId());
        }
        return list;
    }

    public List<SecAccount> getSecAccntsByFundAccnt(FundAccount accnt) throws MException {
        List<SecAccount> secAccnts = this.getAccountMap().get(accnt);
        if (secAccnts == null) {
            return new ArrayList<SecAccount>();
        }
        return secAccnts;
    }

    public synchronized Map<String, CcsFundAccount> getCcsAccountMap() {
        if (this.ccsAccountMap.isEmpty()) {
            try {
                Map mapAccount = this.secAccService.getSecAccountMap();
                mapAccount.keySet().forEach(account -> {
                    if (account.getMarketGrp().equals("CCS") && account instanceof CcsFundAccount && !account.isExternalAsset()) {
                        CcsFundAccount ccsAccount = (CcsFundAccount)CcsFundAccount.class.cast(account);
                        this.ccsAccountMap.put(ccsAccount.getExtAccntId(), ccsAccount);
                    }
                });
            }
            catch (MException e) {
                logger.error("\u83b7\u53d6\u4e00\u7ea7\u8d44\u91d1\u8d26\u53f7map\u5931\u8d25", (Throwable)e);
            }
        }
        return this.ccsAccountMap;
    }

    public synchronized Map<String, CfetsFundAccount> getCfetsAccountMap() {
        if (this.cfetsAccountMap.isEmpty()) {
            try {
                Map mapAccount = this.secAccService.getSecAccountMap();
                mapAccount.keySet().forEach(account -> {
                    if (account.getMarketGrp().equals("IB") && account instanceof CfetsFundAccount && !account.isExternalAsset()) {
                        CfetsFundAccount ccsAccount = (CfetsFundAccount)CfetsFundAccount.class.cast(account);
                        this.cfetsAccountMap.put(ccsAccount.getExtAccntId(), ccsAccount);
                    }
                });
            }
            catch (MException e) {
                logger.error("\u83b7\u53d6\u4e00\u7ea7\u8d44\u91d1\u8d26\u53f7map\u5931\u8d25", (Throwable)e);
            }
        }
        return this.cfetsAccountMap;
    }

    public synchronized Map<String, SecAccount> getCfetsSecAccountMap() {
        if (this.cfetsSecAccountMap.isEmpty()) {
            try {
                Map mapAccount = this.secAccService.getSecAccountMap();
                mapAccount.keySet().forEach(account -> {
                    if (account.getMarketGrp().equals("IB") && account instanceof CfetsFundAccount && !account.isExternalAsset()) {
                        List secList = (List)mapAccount.get(account);
                        secList.forEach(sec -> this.cfetsSecAccountMap.put(sec.getExtSecAccntId(), (SecAccount)sec));
                    }
                });
            }
            catch (MException e) {
                logger.error("\u83b7\u53d6getCfetsSecAccountMap\u5931\u8d25", (Throwable)e);
            }
        }
        return this.cfetsSecAccountMap;
    }

    public Set<String> getInvestorSecIds() {
        Collection<SecAccount> secAccs = this.getCcsSecAccountMap().values();
        HashSet<String> ids = new HashSet<String>();
        for (SecAccount sec : secAccs) {
            ids.add(sec.getInverstorSecId());
        }
        return ids;
    }

    public Set<String> getNewSecAccntIds(String ... market) {
        Collection<SecAccount> secAccs = this.getCcsSecAccountMap().values();
        HashSet<String> ids = new HashSet<String>();
        for (SecAccount sec : secAccs) {
            if (market.length != 0 && !Arrays.asList(market).contains(sec.getExchange().getRaw())) continue;
            ids.add(sec.getNewSecAccntId());
        }
        return ids;
    }

    public synchronized Map<String, SecAccount> getCcsSecAccountMap() {
        if (this.ccsSecAccountMap.isEmpty()) {
            try {
                Map mapAccount = this.secAccService.getSecAccountMap();
                mapAccount.forEach((account, secList) -> {
                    if (account.getMarketGrp().equals("CCS") && account instanceof CcsFundAccount) {
                        secList.forEach(sec -> this.ccsSecAccountMap.put(sec.getExtSecAccntId(), (SecAccount)sec));
                    }
                });
            }
            catch (MException e) {
                logger.error("\u83b7\u53d6\u4e00\u7ea7\u8bc1\u5238\u8d26\u53f7map\u5931\u8d25", (Throwable)e);
            }
        }
        return this.ccsSecAccountMap;
    }

    public synchronized Map<String, CcsFundAccount> getAllCcsAccountMap() {
        if (this.ccsAllAccountMap.isEmpty()) {
            try {
                Map mapAccount = this.secAccService.getAllSecAccountMap();
                mapAccount.keySet().forEach(account -> {
                    if (account.getMarketGrp().equals("CCS") && account instanceof CcsFundAccount) {
                        CcsFundAccount ccsAccount = (CcsFundAccount)CcsFundAccount.class.cast(account);
                        this.ccsAllAccountMap.put(ccsAccount.getExtAccntId(), ccsAccount);
                    }
                });
            }
            catch (MException e) {
                logger.error("\u83b7\u53d6\u4e00\u7ea7\u8d44\u91d1\u8d26\u53f7map\u5931\u8d25", (Throwable)e);
            }
        }
        return this.ccsAllAccountMap;
    }

    public synchronized Map<String, SecAccount> getAllCcsSecAccountMap() {
        if (this.ccsAllSecAccountMap.isEmpty()) {
            try {
                Map mapAccount = this.secAccService.getAllSecAccountMap();
                mapAccount.forEach((account, secList) -> {
                    if (account.getMarketGrp().equals("CCS") && account instanceof CcsFundAccount) {
                        secList.forEach(sec -> {
                            this.ccsAllSecAccountMap.put(sec.getExtSecAccntId(), (SecAccount)sec);
                            this.ccsAllSecAccountMap.put(sec.getNewSecAccntId(), (SecAccount)sec);
                        });
                    }
                });
            }
            catch (MException e) {
                logger.error("\u83b7\u53d6\u4e00\u7ea7\u8bc1\u5238\u8d26\u53f7map\u5931\u8d25", (Throwable)e);
            }
        }
        return this.ccsAllSecAccountMap;
    }

    public String getCcsInvestId(String extAccntId) {
        CcsFundAccount account = this.getCcsAccountMap().get(extAccntId);
        if (account != null && !account.getInvestId().isEmpty()) {
            return account.getInvestId();
        }
        return extAccntId;
    }

    public String getCcsInverstorSecId(String extSecAccntId) {
        SecAccount account = this.getCcsSecAccountMap().get(extSecAccntId);
        if (account != null && !account.getInverstorSecId().isEmpty()) {
            return account.getInverstorSecId();
        }
        return extSecAccntId;
    }

    public String getAllCcsInvestId(String extAccntId) {
        CcsFundAccount account = this.getAllCcsAccountMap().get(extAccntId);
        if (account != null && !account.getInvestId().isEmpty()) {
            return account.getInvestId();
        }
        if (extAccntId.contains("_CNY")) {
            extAccntId = extAccntId.replace("_CNY", "");
        }
        return extAccntId;
    }

    public String getCcsExtAccntName(String extAccntId) {
        Account account = (Account)this.fundAccountService.getAccountMap().get(extAccntId);
        if (account != null && !account.getName().isEmpty()) {
            return account.getName();
        }
        return "";
    }

    public String getAllCcsInverstorSecId(String extSecAccntId) {
        SecAccount account = this.getAllCcsSecAccountMap().get(extSecAccntId);
        if (account != null && !account.getInverstorSecId().isEmpty()) {
            return account.getInverstorSecId();
        }
        if (extSecAccntId.contains("_CNY")) {
            extSecAccntId = extSecAccntId.replace("_CNY", "");
        }
        return extSecAccntId;
    }

    public void setCfetsSecAccountMap(Map<String, SecAccount> cfetsSecAccountMap) {
        this.cfetsSecAccountMap = cfetsSecAccountMap;
    }

    public String getCfetsInverstorSecId(String extSecAccntId) {
        SecAccount account = this.getCfetsSecAccountMap().get(extSecAccntId);
        if (account != null && !account.getInverstorSecId().isEmpty()) {
            return account.getInverstorSecId();
        }
        if (extSecAccntId.contains("_CNY")) {
            extSecAccntId = extSecAccntId.replace("_CNY", "");
        }
        return extSecAccntId;
    }
}

