/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.factory.OrderFactory;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.ObCcsOrder;
import cms.tmx.entity.trade.Order;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionExec;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxPageList;
import cms.tmx.query.current.models.InstructExecModel;
import cms.tmx.query.current.models.InstructionModel;
import cms.tmx.query.current.models.InstructionOrderModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class BasketQueryModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(BasketQueryModel.class);
    @Inject
    protected InstructionModel model;
    @Inject
    protected InstructionOrderModel instructionOrderModel;
    @Inject
    private InstructExecModel executionModel;
    @Inject
    protected MxAlert alert;
    @Inject
    private OrderFactory orderFactory;
    @Inject
    private MScheduler msd;
    private static final Integer PAGE_SIZE = 500;
    protected MxPageList<CcsOrder, ObCcsOrder> mxOrderList = new MxPageList(PAGE_SIZE.intValue(), ObCcsOrder.class);
    protected MxPageList<CcsOrder, ObCcsOrder> mxCcsOrderList = new MxPageList(PAGE_SIZE.intValue(), ObCcsOrder.class);
    private MxList<InstructionExec> execuMxList = new MxList();
    protected Map<String, CcsOrder> orderMap = new HashMap<String, CcsOrder>();
    protected Map<String, List<CcsOrder>> orderListMap = new HashMap<String, List<CcsOrder>>();
    private Instruction inst = new Instruction();
    private InvalidationListener lstnOrderModel = ob -> this.updateOrder();

    @PostConstruct
    private void init() {
        this.instructionOrderModel.changedProperty().addListener(this.lstnOrderModel);
        this.msd.setInterval(2000);
    }

    @PreDestroy
    protected void close() {
        this.instructionOrderModel.changedProperty().removeListener(this.lstnOrderModel);
        this.setInst(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOrder() {
        List<Order> newList = Collections.synchronizedList(new ArrayList());
        ObservableList<Order> observableList = this.instructionOrderModel.getList();
        synchronized (observableList) {
            newList.addAll((Collection<Order>)this.instructionOrderModel.getList());
        }
        Instruction selectedItem = this.getInst();
        this.orderMap.clear();
        this.orderListMap.clear();
        this.mxOrderList.clear();
        for (Order od : newList) {
            if (!(od instanceof CcsOrder)) continue;
            if ("17".equals(selectedItem.getType().getRaw()) || "16".equals(selectedItem.getType().getRaw())) {
                ((CcsOrder)od).setBasketName(selectedItem.getAdjustPosAdvice().getBasketName());
                ((CcsOrder)od).setBasketId(selectedItem.getAdjustPosAdvice().getBasketId());
            } else {
                ((CcsOrder)od).setBasketId(selectedItem.getBasketOrderAdvice().getBasketId());
                ((CcsOrder)od).setBasketName(selectedItem.getName());
            }
            this.createCcsMap((CcsOrder)od);
        }
        ArrayList<CcsOrder> newCcsList = new ArrayList<CcsOrder>();
        for (String key : this.orderMap.keySet()) {
            this.execuMxList.getList();
            for (InstructionExec instructionExec : this.execuMxList.getList()) {
                if (!this.orderMap.get(key).getSecId().equals(instructionExec.getSecId())) continue;
                this.orderMap.get(key).setExecExpectAmt(instructionExec.getOrderAmount());
                this.orderMap.get(key).setExecExpectQty(instructionExec.getExpectQty());
                this.orderMap.get(key).setDonePercent((double)Math.round((double)this.orderMap.get(key).getCumQty() * 1.0 / (double)instructionExec.getExpectQty() * 100.0 * 100.0) / 100.0);
                break;
            }
            ObservableList<Order> observableList2 = this.instructionOrderModel.getList();
            synchronized (observableList2) {
                newCcsList.add(this.orderMap.get(key));
            }
        }
        this.mxOrderList.update(newCcsList);
        this.mxOrderList.updatePageList();
        this.changed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query(Instruction selectedItem) {
        this.mxCcsOrderList.clear();
        this.mxCcsOrderList.getPageList().clear();
        this.execuMxList.clear();
        this.setInst(selectedItem);
        long startTime = System.currentTimeMillis();
        this.queryBasketItems(selectedItem);
        this.instructionOrderModel.setInstruction(selectedItem, 1, selectedItem.getMarketGrp());
        this.executionModel.setInstruction(selectedItem, 1);
        try {
            this.executionModel.fullQuery();
        }
        catch (MException e1) {
            e1.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        System.err.println("\u67e5\u6210\u5206\u80a1\u7a0b\u5e8f\u8fd0\u884c\u65f6\u95f4\uff1a " + (endTime - startTime) + "ms");
        List<InstructionExec> execList = Collections.synchronizedList(new ArrayList());
        ObservableList<InstructionExec> observableList = this.executionModel.getList();
        synchronized (observableList) {
            execList.addAll((Collection<InstructionExec>)this.executionModel.getList());
        }
        this.execuMxList.update(execList);
        long startTime1 = System.currentTimeMillis();
        try {
            this.instructionOrderModel.fullQuery();
        }
        catch (MException e) {
            e.printStackTrace();
        }
        long endTime1 = System.currentTimeMillis();
        System.err.println("\u67e5\u59d4\u6258\u7a0b\u5e8f\u8fd0\u884c\u65f6\u95f4\uff1a " + (endTime1 - startTime1) + "ms");
        List<Order> newList = Collections.synchronizedList(new ArrayList());
        List<CcsOrder> newCcsList = Collections.synchronizedList(new ArrayList());
        ObservableList<Order> observableList2 = this.instructionOrderModel.getList();
        synchronized (observableList2) {
            newList.addAll((Collection<Order>)this.instructionOrderModel.getList());
        }
        this.orderMap.clear();
        this.orderListMap.clear();
        long startTime2 = System.currentTimeMillis();
        for (Order od : newList) {
            if (!(od instanceof CcsOrder)) continue;
            if ("17".equals(selectedItem.getType().getRaw()) || "16".equals(selectedItem.getType().getRaw())) {
                ((CcsOrder)od).setBasketName(selectedItem.getAdjustPosAdvice().getBasketName());
                ((CcsOrder)od).setBasketId(selectedItem.getAdjustPosAdvice().getBasketId());
            } else {
                ((CcsOrder)od).setBasketId(selectedItem.getBasketOrderAdvice().getBasketId());
                ((CcsOrder)od).setBasketName(selectedItem.getName());
            }
            this.createCcsMap((CcsOrder)od);
        }
        for (String key : this.orderMap.keySet()) {
            this.execuMxList.getList();
            for (InstructionExec instructionExec : this.execuMxList.getList()) {
                if (!this.orderMap.get(key).getSecId().equals(instructionExec.getSecId())) continue;
                this.orderMap.get(key).setExecExpectAmt(instructionExec.getOrderAmount());
                this.orderMap.get(key).setExecExpectQty(instructionExec.getExpectQty());
                this.orderMap.get(key).setDonePercent((double)Math.round((double)this.orderMap.get(key).getCumQty() * 1.0 / (double)instructionExec.getExpectQty() * 100.0 * 100.0) / 100.0);
                break;
            }
            ObservableList<Order> observableList3 = this.instructionOrderModel.getList();
            synchronized (observableList3) {
                newCcsList.add(this.orderMap.get(key));
            }
        }
        long endTime2 = System.currentTimeMillis();
        System.err.println("\u5269\u4f59\u7a0b\u5e8f\u8fd0\u884c\u65f6\u95f4\uff1a " + (endTime2 - startTime2) + "ms");
        this.mxOrderList.update(newCcsList);
        this.mxOrderList.updatePageList();
    }

    private void createCcsMap(CcsOrder ccsOrder) {
        String key = this.getKey(ccsOrder);
        List<CcsOrder> newCcsList = Collections.synchronizedList(new ArrayList());
        if (this.orderMap.get(key) == null) {
            CcsOrder newOrder = (CcsOrder)CcsOrder.class.cast(this.orderFactory.create("CCS"));
            CcsOrder newCcsOrder = (CcsOrder)CcsOrder.class.cast(this.orderFactory.create("CCS"));
            newOrder.update((Object)ccsOrder);
            newCcsOrder.update((Object)ccsOrder);
            this.orderMap.put(key, newOrder);
            newCcsList.add(newCcsOrder);
            this.orderListMap.put(key, newCcsList);
        } else {
            this.orderListMap.get(key).add(ccsOrder);
            CcsOrder oldOrder = this.orderMap.get(key);
            int qty = ccsOrder.getOrderQty();
            double amount = ccsOrder.getOrderAmt();
            double frozenMargin = ccsOrder.getFrozenMargin();
            int cumQty = ccsOrder.getCumQty();
            double totalValue = ccsOrder.getTotalValue();
            double filledAvgPrice = ccsOrder.getFilledAvgPrice();
            long wthQtyNum = ccsOrder.getWthQty();
            ccsOrder.getNowPrice();
            int oldQty = oldOrder.getOrderQty();
            double oldAmount = oldOrder.getOrderAmt();
            double oldFrozenMargin = oldOrder.getFrozenMargin();
            int oldCumQty = oldOrder.getCumQty();
            double oldTotalValue = oldOrder.getTotalValue();
            double oldProductOfAvgAndQty = oldOrder.getProductOfAvgAndQty();
            long oldWthQtyNum = oldOrder.getWthQty();
            oldOrder.setOrderQty(oldQty + qty);
            oldOrder.setOrderAmt(oldAmount + amount);
            oldOrder.setFrozenMargin(frozenMargin + oldFrozenMargin);
            oldOrder.setCumQty(oldCumQty + cumQty);
            oldOrder.setTotalValue(oldTotalValue + totalValue);
            oldOrder.setProductOfAvgAndQty(oldProductOfAvgAndQty + filledAvgPrice * (double)cumQty);
            oldOrder.setWthQty(wthQtyNum + oldWthQtyNum);
        }
    }

    private String getKey(CcsOrder order) {
        String key = String.valueOf(order.getInvestorId()) + order.getSecId();
        return key;
    }

    private String getKey(CtpOrder order) {
        String key = String.valueOf(order.getInvestorId()) + order.getSecId();
        return key;
    }

    protected void queryBasketItems(Instruction instruction) {
        try {
            this.model.queryBasketItems(instruction);
        }
        catch (MException e) {
            Platform.runLater(() -> {
                this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u7bee\u5b50\u6307\u4ee4\u8d44\u6e90\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
                logger.error("\u67e5\u8be2\u7bee\u5b50\u6307\u4ee4\u8d44\u6e90\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            });
        }
    }

    public List<CcsOrder> getMxOrderList() {
        return this.mxOrderList.getList();
    }

    public void setMxOrderList(MxPageList<CcsOrder, ObCcsOrder> mxOrderList) {
        this.mxOrderList = mxOrderList;
    }

    public Map<String, CcsOrder> getOrderMap() {
        return this.orderMap;
    }

    public void setOrderMap(Map<String, CcsOrder> orderMap) {
        this.orderMap = orderMap;
    }

    public Map<String, List<CcsOrder>> getOrderListMap() {
        return this.orderListMap;
    }

    public void setOrderListMap(Map<String, List<CcsOrder>> orderListMap) {
        this.orderListMap = orderListMap;
    }

    public Instruction getInst() {
        return this.inst;
    }

    public void setInst(Instruction inst) {
        this.inst = inst;
    }
}

