/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.trade.AlgoBaseOrder;
import cms.tmx.entity.trade.basket.AdjPositonParam;
import cms.tmx.entity.trade.basket.AlgoStrategyDetails;
import cms.tmx.entity.trade.basket.BasketAlgoStrategy;
import cms.tmx.entity.trade.instruction.AdjustPosAdvice;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.mng.AlgoMiseMng;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.current.views.AlgoStrategyQueryPart;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

@Singleton
@Creatable
public class AlgoStrategyQueryModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(AlgoStrategyQueryModel.class);
    @Inject
    private ScheduledExecutorService ses;
    @Inject
    private CcsAccountMap accMng;
    @Inject
    private PortfolioAccountModel portfMng;
    @Inject
    private AlgoMiseMng miseMng;
    private ObservableList<BasketAlgoStrategy> listBase = FxUtils.newList();
    private List<MEvent> listEvent = new CopyOnWriteArrayList<MEvent>();
    private Map<String, BasketAlgoStrategy> mapValid = new HashMap<String, BasketAlgoStrategy>();
    @Inject
    protected MScheduler sdFullQuery;
    private static final int FULL_QUERY_INTERVAL = 3000;
    @Inject
    @Named(value="fixed.mise.pool")
    protected ExecutorService exe;
    @Inject
    private MEventService es;
    @Inject
    private EPartService eps;
    private static final List<String> parts = Arrays.asList("cms.tmx.instructions.part.portfolio.algo.query", "cms.tmx.instructions.part.regular.algo.query", "cms.tmx.instructions.part.portfolio.basket.algorithm.query", "cms.tmx.instructions.part.basket.algo.query", "cms.tmx.instructions.part.ccs.adj.query", "cms.tmx.instructions.part.port.adj.query", "cms.tmx.instructions.part.portfolio.repo.algo.query", "cms.tmx.instructions.part.regular.instruct.query", "cms.tmx.instructions.part.portfolio.instruct.query", "cms.tmx.instructions.cp.portfolio.basket", "cms.tmx.instructions.part.basket.instruction.query", "cms.tmx.instructions.part.ccs.adj.instruction.query", "cms.tmx.instructions.part.port.adj.instruction.query", "cms.tmx.instructions.part.shortcut.instruct.query", "cms.tmx.instructions.part.hkwolun.instruction.query", "cms.tmx.instructions.part.portfolio.hkwolun.instruction.query", "cms.tmx.instructions.part.hkwolun.algo.query", "cms.tmx.instructions.part.portfolio.hkwolun.algo.query");
    private MEventHandler cancelOrder = event -> {
        Instruction inst = (Instruction)event.getObj(Instruction.class);
        AdjustPosAdvice advice = inst.getAdjustPosAdvice();
        String investorId = advice.getInvestorId();
        BasketAlgoStrategy strategy = this.mapValid.get(investorId);
        if (this.isRunningStatus(investorId)) {
            try {
                this.miseCancelOrder(strategy);
            }
            catch (MException e) {
                event.setObj((Object)e);
            }
        }
    };

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.es.subscribe("algo.refresh", event -> {
            try {
                boolean isVisible = false;
                for (String partId : parts) {
                    MPart findPart = this.eps.findPart(partId);
                    if (findPart == null || !this.eps.isPartVisible(findPart)) continue;
                    isVisible = true;
                    break;
                }
                if (isVisible) {
                    this.queryOnce();
                }
            }
            catch (Exception e) {
                logger.error("\u7b97\u6cd5\u8f6e\u8be2\u5931\u8d25", (Throwable)e);
            }
        });
        this.es.subscribe(AlgoStrategyQueryPart.class.getName(), event -> this.queryOnce());
        this.es.subscribe("adjust.cancel.order", this.cancelOrder);
    }

    private void queryOnce() {
        try {
            this.queryBaseOrder();
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public void query() {
        this.sdFullQuery.schedule(event -> this.queryOnce());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void queryBaseOrder() throws MException {
        Set<CcsFundAccount> funds = this.accMng.getAccountMap().keySet();
        List<CcsSubFundAccount> subs = this.portfMng.getFundAccounts();
        int size = funds.size() + subs.size();
        CountDownLatch latch = new CountDownLatch(size);
        Semaphore semaphore = new Semaphore(5);
        this.listEvent.clear();
        LinkedList<BasketAlgoStrategy> list = new LinkedList<BasketAlgoStrategy>();
        for (CcsFundAccount observableList : funds) {
            this.query(observableList.getInvestId(), latch, semaphore, list, observableList.getInvestId());
        }
        for (CcsSubFundAccount ccsSubFundAccount : subs) {
            this.query(ccsSubFundAccount.getSubAccntId(), latch, semaphore, list, ccsSubFundAccount.getInvestId());
        }
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)interruptedException, (Throwable)interruptedException);
        }
        ObservableList<BasketAlgoStrategy> observableList = this.listBase;
        synchronized (observableList) {
            this.checkRunningStatus(list);
            this.listBase.setAll(list);
            this.changed();
        }
    }

    public void query(String inverstId, CountDownLatch latch, Semaphore sema, List<BasketAlgoStrategy> list, String investorId) {
        this.exe.execute(() -> {
            long begin;
            block7: {
                begin = System.currentTimeMillis();
                try {
                    try {
                        sema.acquire();
                        List<MEvent> resp = this.miseMng.queryAlgoMevent(inverstId, "", "");
                        for (MEvent event : resp) {
                            BasketAlgoStrategy b = new BasketAlgoStrategy();
                            if ("BasketPosAdj".equals(event.getStr("algo_type"))) {
                                b.update((Object)event);
                                list.add(b);
                            }
                            event.put((Object)"investorId", (Object)investorId);
                        }
                        this.listEvent.addAll(resp);
                    }
                    catch (MException | Exception e) {
                        logger.error((Object)e, e);
                        sema.release();
                        latch.countDown();
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    sema.release();
                    latch.countDown();
                    throw throwable;
                }
                sema.release();
                latch.countDown();
            }
            logger.debug("====== query take : " + (System.currentTimeMillis() - begin));
        });
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    private void checkRunningStatus(List<BasketAlgoStrategy> list) {
        HashMap<String, BasketAlgoStrategy> map = new HashMap<String, BasketAlgoStrategy>();
        MEvent event = new MEvent();
        block9: for (BasketAlgoStrategy strategy : list) {
            if (strategy.isDerict()) continue;
            MxNode status = strategy.getStatus();
            switch (status.getRaw()) {
                default: {
                    map.put(strategy.getBizAcct(), strategy);
                    if (strategy.getInstructionId().isEmpty()) continue block9;
                    event.put((Object)strategy.getInstructionId(), (Object)strategy);
                    break;
                }
                case "2": 
                case "3": 
                case "4": 
                case "5": 
            }
        }
        this.mapValid = map;
        this.es.sendEvent("adj.algo.refresh", event);
    }

    public boolean isRunningStatus(String accntId) {
        return this.mapValid.get(accntId) != null;
    }

    public List<AlgoStrategyDetails> queryAlgoDetail(String accntId, String startTime, String endTime, String algoOrderId) throws MException {
        return this.miseMng.queryAlgoDetail(accntId, startTime, endTime, algoOrderId);
    }

    public void miseCancelOrder(BasketAlgoStrategy bsk) throws MException {
        this.miseMng.miseCancelOrder(bsk.getBizAcct(), bsk.getId());
        String accountId = bsk.getBizAcct();
        if (accountId.contains("SF")) {
            accountId = this.portfMng.getFundAccount(accountId, "CCS").getInvestId();
        }
    }

    public AdjPositonParam queryMiseParam(String accntId, String startTime, String endTime, String algoOrderId) throws MException {
        return this.miseMng.queryMiseParam(accntId, startTime, endTime, algoOrderId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObservableList<BasketAlgoStrategy> getList() {
        ObservableList<BasketAlgoStrategy> observableList = this.listBase;
        synchronized (observableList) {
            return this.listBase;
        }
    }

    public List<MEvent> getListEvent() {
        return this.listEvent;
    }

    public void afterUpdate(AlgoBaseOrder baseOrder) {
        this.miseMng.afterUpdate(baseOrder);
    }
}

