/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.notice.CancelRejectReport;
import cms.tmx.entity.notice.ExecutionReport;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.basket.BasketAlgoItem;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionExec;
import cms.tmx.entity.trade.instruction.InstructionExecMonitor;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.CcsOrderModel;
import cms.tmx.query.current.models.CcsPositionModel;
import cms.tmx.query.current.models.InstructExecModel;
import cms.tmx.query.current.models.InstructionModel;
import cms.tmx.utils.MarketUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class AdjExecMonitorModel
extends MxModel {
    @Inject
    protected InstructionModel instModel;
    @Inject
    protected InstructExecModel execModel;
    @Inject
    protected CcsPositionModel posModel;
    @Inject
    private CcsOrderModel ordModel;
    @Inject
    protected MEventService es;
    @Inject
    private ScheduledExecutorService ses;
    ObservableList<InstructionExecMonitor> list = FxUtils.newList();
    private ObjectProperty<Instruction> inst = new SimpleObjectProperty();
    private Map<String, InstructionExecMonitor> map = new HashMap<String, InstructionExecMonitor>();
    private static final int INTERVAL = 5;
    public boolean isStart = false;

    @PostConstruct
    private void init() {
        if (this.posModel.getList().isEmpty()) {
            this.posModel.query();
        }
        if (this.ordModel.getList().isEmpty()) {
            this.ordModel.query();
        }
        this.execModel.changedProperty().addListener(ob -> this.monitorRefresh());
        this.inst.addListener(ob -> this.map.clear());
        this.es.subscribe("server.sub", event -> this.onPush(event));
    }

    public void startLoopQuery() {
        if (!this.isStart) {
            this.isStart = true;
            this.ses.scheduleAtFixedRate(() -> this.query(), 5L, 5L, TimeUnit.SECONDS);
        }
    }

    public void query(Instruction inst) {
        this.setInst(inst);
        this.query();
    }

    private void query() {
        this.startLoopQuery();
        this.execModel.setInstruction(this.getInst(), 1);
        try {
            this.execModel.fullQuery();
        }
        catch (MException e) {
            this.logger.error("instruction execution query failed", (Throwable)e);
        }
    }

    private void monitorRefresh() {
        InstructionExecMonitor monitor;
        List<BasketAlgoItem> listItem = this.getInst().getAdjustPosAdvice().getItems();
        if (listItem.isEmpty()) {
            listItem = this.instModel.getInsAdjItems(this.getInst().getId());
            this.getInst().getAdjustPosAdvice().setItems(listItem);
        }
        for (BasketAlgoItem item : listItem) {
            monitor = new InstructionExecMonitor();
            CcsPosition pos = this.posModel.getPosition(item.getExtSecAccntId(), item.getCode());
            if (pos != null) {
                item.setNowPos(pos.getTotalVol());
                item.setCapitalization(pos.getCapitalization());
            }
            monitor.update(item);
            monitor.setDiffAmount(this.formatScale(item.getTargetMktValue() - item.getCapitalization(), 2));
            monitor.setDiffCount(item.getNowPos() - item.getDestPos());
            this.map.put(item.getCode(), monitor);
        }
        for (InstructionExec exec : this.execModel.getList()) {
            monitor = this.map.get(exec.getSecId());
            if (monitor == null) continue;
            monitor.update(exec);
        }
        this.ordModel.getList().forEach(ord -> {
            InstructionExecMonitor monitor = this.map.get(ord.getSecId());
            if (monitor != null) {
                CcsOrder oldOrd;
                String accntId = monitor.getAdjItem().getExtAccntId();
                String secAccntId = monitor.getAdjItem().getExtSecAccntId();
                if (ord.getExtAccntId().equals(accntId) && ord.getExtSecAccntId().endsWith(secAccntId) && !ord.getErrInfo().isEmpty() && (oldOrd = monitor.getOrder()) != null && ord.getOrdTime().compareTo(oldOrd.getOrdTime()) > 0) {
                    monitor.setOrder(ord);
                }
            }
        });
        this.list.setAll(this.map.values());
        this.changed();
    }

    private double formatScale(double d, int scale) {
        return new BigDecimal(d).setScale(scale, 4).doubleValue();
    }

    protected void onPush(MEvent event) {
        if (event.getObj() instanceof ExecutionReport) {
            this.onExecutionReport(event);
        } else if (event.getObj() instanceof CancelRejectReport) {
            this.onOrderCancelPush(event);
        }
    }

    protected boolean careReport(String marketGroup, String type) {
        if (!marketGroup.equals("CCS")) {
            return false;
        }
        return "48".equals(type) || "52".equals(type) || "56".equals(type) || "70".equals(type) || "65".equals(type) || "73".equals(type);
    }

    private void onExecutionReport(MEvent event) {
        String type;
        ExecutionReport report = (ExecutionReport)ExecutionReport.class.cast(event.getObj());
        String market = report.getReport().getInstrument().getMarket();
        String marketGroup = MarketUtils.getMarketGroup((String)market);
        if (!this.careReport(marketGroup, type = Integer.toString(report.getType()))) {
            return;
        }
    }

    private void onOrderCancelPush(MEvent event) {
        CancelRejectReport orderCancelReject = (CancelRejectReport)CancelRejectReport.class.cast(event.getObj());
        String market = orderCancelReject.getReport().getInstrument().getMarket();
        MarketUtils.getMarketGroup((String)market);
    }

    public ObservableList<InstructionExecMonitor> getItems() {
        return this.list;
    }

    public final ObjectProperty<Instruction> instProperty() {
        return this.inst;
    }

    public final Instruction getInst() {
        return (Instruction)this.instProperty().get();
    }

    public final void setInst(Instruction inst) {
        this.instProperty().set((Object)inst);
    }
}

