/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.mng.sge;

import cms.tmx.core.MException;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.query.Condition;
import cms.tmx.http.query.QueryFilter;
import cms.tmx.http.query.sge.GetSgeStorageReq;
import cms.tmx.http.query.sge.GetSgeStorageResp;
import cms.tmx.http.query.sge.ObSgeStorage;
import cms.tmx.http.query.sge.SgeStorage;
import cms.tmx.http.query.sge.api.SgeStorageServiceApi;
import cms.tmx.javafx.MxModel;
import cms.tmx.utils.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class SgeStorageMng
extends MxModel {
    @Inject
    private HttpBaseApi httpBase;
    @Inject
    private SgeStorageServiceApi sgeStorageServiceApi;
    private Set<ObSgeStorage> setQuery = new HashSet<ObSgeStorage>();
    private ReentrantLock lock = new ReentrantLock();
    private GetSgeStorageReq getSgeStorageReq;

    public void addQuery(ObSgeStorage pos) {
        this.lock.lock();
        try {
            this.setQuery.add(pos);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearQuery() {
        this.lock.lock();
        try {
            this.setQuery.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void markDirty(ObSgeStorage dirty) {
        if (dirty != null) {
            dirty.setDirty(true);
        }
    }

    public List<SgeStorage> queryDirty() {
        this.lock.lock();
        LinkedList<ObSgeStorage> listSrc = new LinkedList<ObSgeStorage>();
        try {
            listSrc.addAll(this.setQuery);
            this.setQuery.clear();
        }
        finally {
            this.lock.unlock();
        }
        LinkedList<SgeStorage> listResults = new LinkedList<SgeStorage>();
        for (ObSgeStorage po : listSrc) {
            if (!this.getSgeStorageReq.getAccntId().contains(po.getSecAccntId())) continue;
            try {
                List<SgeStorage> set;
                this.markDirty(po);
                if (!StringUtils.isEmpty((String)po.getInstrument().getSecId())) {
                    QueryFilter filter = new QueryFilter();
                    HashMap<String, Condition> arg = new HashMap<String, Condition>();
                    Condition securityId = new Condition();
                    securityId.setStringVal(po.getInstrument().getSecId());
                    securityId.setOp(Condition.OP.EQ);
                    arg.put("security_id", securityId);
                    filter.setArg(arg);
                    this.getSgeStorageReq.setFilter(filter);
                }
                if ((set = this.queryByPage(this.getSgeStorageReq)) == null) continue;
                listResults.addAll(set);
            }
            catch (MException e) {
                this.logger.error("\u63a8\u9001\u67e5\u8be2\u8d35\u91d1\u5c5e\u5e93\u5b58query sge storage failed", (Throwable)e);
            }
        }
        return listResults;
    }

    private List<SgeStorage> queryByPage(GetSgeStorageReq req) throws MException {
        LinkedList<SgeStorage> list = new LinkedList<SgeStorage>();
        Page pageReq = this.httpBase.getHttpDefPage();
        req.setOpUser(this.httpBase.getHttpOpUser());
        req.setPage(pageReq);
        req.setBeginDate("");
        req.setEndDate("");
        req.setIncludeZero(Boolean.valueOf(true));
        GetSgeStorageResp resp = this.sgeStorageServiceApi.getSgeStorageReq(req);
        list.clear();
        list.addAll(resp.getData());
        while (!resp.isLast()) {
            pageReq.setStartRow(resp.getOffset() + resp.getSize());
            req.setPage(pageReq);
            GetSgeStorageResp res = this.sgeStorageServiceApi.getSgeStorageReq(req);
            list.addAll(res.getData());
        }
        return list;
    }

    public SgeStorageServiceApi getSgeStorageServiceApi() {
        return this.sgeStorageServiceApi;
    }

    public void setSgeStorageServiceApi(SgeStorageServiceApi sgeStorageServiceApi) {
        this.sgeStorageServiceApi = sgeStorageServiceApi;
    }

    public GetSgeStorageReq getGetSgeStorageReq() {
        return this.getSgeStorageReq;
    }

    public void setGetSgeStorageReq(GetSgeStorageReq getSgeStorageReq) {
        this.getSgeStorageReq = getSgeStorageReq;
    }
}

