/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.mng.sge;

import cms.tmx.core.MException;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.query.Condition;
import cms.tmx.http.query.QueryFilter;
import cms.tmx.http.query.sge.GetSgePositionsReq;
import cms.tmx.http.query.sge.GetSgePositionsResp;
import cms.tmx.http.query.sge.ObSgePosition;
import cms.tmx.http.query.sge.SgePosition;
import cms.tmx.http.query.sge.api.SgePositionServiceApi;
import cms.tmx.javafx.MxModel;
import cms.tmx.utils.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class SgePositionMng
extends MxModel {
    @Inject
    private HttpBaseApi httpBase;
    private Set<ObSgePosition> setQuery = new HashSet<ObSgePosition>();
    private ReentrantLock lock = new ReentrantLock();
    private GetSgePositionsReq getSgePositionsReq;
    @Inject
    private SgePositionServiceApi posApi;

    public void addQuery(ObSgePosition pos) {
        this.lock.lock();
        try {
            this.setQuery.add(pos);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearQuery() {
        this.lock.lock();
        try {
            this.setQuery.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void markDirty(ObSgePosition dirty) {
        if (dirty != null) {
            dirty.setDirty(true);
        }
    }

    public List<SgePosition> queryDirty() {
        this.lock.lock();
        LinkedList<ObSgePosition> listSrc = new LinkedList<ObSgePosition>();
        try {
            listSrc.addAll(this.setQuery);
            this.setQuery.clear();
        }
        finally {
            this.lock.unlock();
        }
        LinkedList<SgePosition> listResults = new LinkedList<SgePosition>();
        for (ObSgePosition po : listSrc) {
            if (!this.getSgePositionsReq.getAccntId().contains(po.getSecAccntId())) continue;
            try {
                List<SgePosition> set;
                this.markDirty(po);
                if (!StringUtils.isEmpty((String)po.getInstrument().getSecId())) {
                    QueryFilter filter = new QueryFilter();
                    HashMap<String, Condition> arg = new HashMap<String, Condition>();
                    Condition securityId = new Condition();
                    securityId.setStringVal(po.getInstrument().getSecId());
                    securityId.setOp(Condition.OP.EQ);
                    arg.put("security_id", securityId);
                    filter.setArg(arg);
                    this.getSgePositionsReq.setFilter(filter);
                }
                if ((set = this.queryByPage(this.getSgePositionsReq)) == null) continue;
                listResults.addAll(set);
            }
            catch (MException e) {
                this.logger.error("\u63a8\u9001\u67e5\u8be2\u8d35\u91d1\u5c5e\u6301\u4ed3query sge position failed", (Throwable)e);
            }
        }
        return listResults;
    }

    private List<SgePosition> queryByPage(GetSgePositionsReq req) throws MException {
        LinkedList<SgePosition> list = new LinkedList<SgePosition>();
        Page pageReq = this.httpBase.getHttpDefPage();
        req.setOpUser(this.httpBase.getHttpOpUser());
        req.setPage(pageReq);
        req.setBeginDate("");
        req.setEndDate("");
        req.setIncludeZero(Boolean.valueOf(false));
        req.setMarketGroup("SGE");
        req.setAccntLevel("ACCNT_LEVEL_EXT");
        req.setAccntType("ACCNT_TYPE_SEC");
        GetSgePositionsResp resp = this.posApi.getSgePositionsReq(req);
        list.clear();
        list.addAll(resp.getData());
        while (!resp.isLast()) {
            pageReq.setStartRow(resp.getOffset() + resp.getSize());
            req.setPage(pageReq);
            GetSgePositionsResp res = this.posApi.getSgePositionsReq(req);
            list.addAll(res.getData());
        }
        return list;
    }

    public GetSgePositionsReq getGetSgePositionsReq() {
        return this.getSgePositionsReq;
    }

    public void setGetSgePositionsReq(GetSgePositionsReq getSgePositionsReq) {
        this.getSgePositionsReq = getSgePositionsReq;
    }
}

