/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.mng;

import cms.tmx.api.instruction.IInstructionApi;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PInstruction;
import cms.tmx.datatype.proto.workflow.PInstructionManagement;
import cms.tmx.define.IDictMap;
import cms.tmx.entity.Post;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.ObTopSpeedInstruction;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IPostService;
import cms.tmx.manage.IProductService;
import cms.tmx.manage.IUserService;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.current.models.ResourceModel;
import cms.tmx.query.utils.FundAccName;
import cms.tmx.query.utils.QueryUtils;
import cmx.tmx.data.IRefDataMng;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class TopSpeedInstructionMng {
    @Inject
    private IInstructionApi<Instruction> ins;
    @Inject
    private PortfolioAccountModel protfAccntModel;
    @Inject
    private IProductService productService;
    @Inject
    private ResourceModel resourceModel;
    @Inject
    private IPostService postService;
    @Inject
    private IBaseApi baseApi;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private IUserService userService;
    @Inject
    private FundAccName fundName;
    @Inject
    private IDictMap dictMap;
    public static final int FIRST_SETP_ID = 1;
    private Map<String, Post> postMap = FxUtils.newMap();
    private static final Logger logger = LogManager.getLogger(TopSpeedInstructionMng.class);
    private static final String FORMAT_HOUR = "yyyyMMdd HH:mm:ss";
    private static DateTimeFormatter formatHour = DateTimeFormatter.ofPattern("yyyyMMdd HH:mm:ss");

    public List<ObTopSpeedInstruction> query() throws MException {
        PInstructionManagement.GetFastInstructionReq.Builder fastB = PInstructionManagement.GetFastInstructionReq.newBuilder();
        fastB.setOpUser(this.baseApi.getOpUser());
        List fastInstructions = this.ins.getFastInstructions(fastB);
        ArrayList<ObTopSpeedInstruction> instructionList = new ArrayList<ObTopSpeedInstruction>();
        HashSet<ObTopSpeedInstruction> instructionSet = new HashSet<ObTopSpeedInstruction>();
        for (PInstruction.Instruction instruction : fastInstructions) {
            ObTopSpeedInstruction ins = new ObTopSpeedInstruction();
            ins.update((Object)instruction);
            this.transferField(ins);
            instructionSet.add(ins);
        }
        instructionList.addAll(instructionSet);
        return instructionList;
    }

    public void transferField(ObTopSpeedInstruction ins) {
        String investorId = "";
        switch (ins.getType().getRaw()) {
            case "2": {
                try {
                    ins.setProductName(this.productService.getProductDetailFromCache(ins.getProductId()).getName());
                }
                catch (MException e) {
                    logger.error("\u67e5\u8be2\u4ea7\u54c1\u540d\u79f0\u51fa\u9519", (Throwable)e);
                }
                investorId = ((AccntSecInfo)ins.getOrderAdvice().getAccSecInfoList().get(0)).getInvestorId();
                ins.setBelongTo(String.valueOf(ins.getProductName()) + "(" + investorId + " " + this.fundName.getFundName(investorId) + ")");
                ins.setSide(this.dictMap.get("side", ins.getOrderAdvice().getSide()));
                ins.setUnit(QueryUtils.getUnit(ins.getOrderAdvice().getSecType(), ins.getOrderAdvice().getMarket()));
                this.transferCommonPrice(ins);
                break;
            }
        }
        ins.setInvestId(investorId);
    }

    private RefItem caculateCumData(Instruction ins) {
        RefItem item;
        String secCode = ins.getSecurityCode();
        String secType = ins.getSecurityType();
        String market = ins.getMarket();
        if ("SHSC".equals(market) || "SZSC".equals(market)) {
            secType = String.valueOf(secType) + market;
        }
        if ((item = this.refMng.getItem(secType, market, secCode)) != null && ins.getResource() != null) {
            ins.setAvgPx(ins.getResource().getAvgPx());
            if ("REPO".equals(secType)) {
                if ("XSHG".equals(market)) {
                    ins.setCumAmount((double)(ins.getResource().getCumQty() * 1000L));
                    ins.getResource().setOrderAmt((double)(ins.getResource().getOrderQty() * 1000L));
                } else if ("XSHE".equals(market)) {
                    ins.setCumAmount((double)(ins.getResource().getCumQty() * 100L));
                    ins.getResource().setOrderAmt((double)(ins.getResource().getOrderQty() * 100L));
                }
            } else if ("FUT".equals(secType)) {
                ins.setCumAmount(ins.getResource().getAvgPx() * (double)ins.getResource().getCumQty() * 10.0);
                ins.getResource().setOrderAmt(ins.getResource().getOrderAvg() * (double)ins.getResource().getOrderQty() * 10.0);
            } else {
                int i = "XSHG".equals(market) && "BOND".equals(secType) ? 10 : 1;
                ins.setCumAmount(ins.getResource().getAvgPx() * (double)ins.getResource().getCumQty() * (double)i);
                ins.getResource().setOrderAmt(ins.getResource().getOrderAvg() * (double)ins.getResource().getOrderQty() * (double)i);
            }
        }
        return item;
    }

    private void transferCommonPrice(ObTopSpeedInstruction ins) {
        if (ins.getOrderAdvice().getOrdType() == 49) {
            ins.setInsPrice("\u5e02\u4ef7-" + this.dictMap.get("cstr_price_type_mkt", ins.getOrderAdvice().getMarketPriceLimit()));
        } else if (ins.getOrderAdvice().getOrdType() == 50) {
            if (ins.getOrderAdvice().getPrice() > 0.0 && !"3".equals(Integer.toString(ins.getOrderAdvice().getPriceLimit()))) {
                ins.setInsPrice(String.valueOf(this.dictMap.get("cstr_price_type_limited", ins.getOrderAdvice().getPriceLimit())) + "-" + new BigDecimal(String.valueOf(ins.getOrderAdvice().getPrice())).toPlainString());
            } else {
                ins.setInsPrice(this.dictMap.get("cstr_price_type_limited", ins.getOrderAdvice().getPriceLimit()));
            }
        } else if (ins.getOrderAdvice().getOrdType() == 0) {
            ins.setInsPrice("\u76d8\u53e3-" + this.dictMap.get("instr_handicap", ins.getOrderAdvice().getPriceTypeBidAsk()));
        } else if (ins.getOrderAdvice().getOrdType() == 99) {
            ins.setInsPrice("\u76d8\u540e\u56fa\u5b9a\u4ef7-" + ins.getOrderAdvice().getPrice());
        }
    }
}

