/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.mng;

import cms.tmx.api.trade.IQueryPositionsApi;
import cms.tmx.api.trade.info.IPageInTurn;
import cms.tmx.api.trade.info.IPositionQueryInfo;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PPositionService;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.factory.PositionFactory;
import cms.tmx.entity.trade.Position;
import cms.tmx.javafx.MxModel;
import cms.tmx.query.utils.QueryByPage;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class PositionMng
extends MxModel {
    private static final Logger logger = LogManager.getLogger(PositionMng.class);
    @Inject
    protected IQueryPositionsApi apiPosition;
    @Inject
    protected PositionFactory fPosition;
    @Inject
    protected MObjFactory of;
    private FundAccount fund;
    private int setType = 1;
    private String positionType;
    private Set<Position> setQuery = new HashSet<Position>();
    private ReentrantLock lock = new ReentrantLock();

    public void addQuery(Position pos) {
        this.lock.lock();
        try {
            this.setQuery.add(pos);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearQuery() {
        this.lock.lock();
        try {
            this.setQuery.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<Position> queryDirty() {
        this.lock.lock();
        LinkedList<Position> listSrc = new LinkedList<Position>();
        try {
            listSrc.addAll(this.setQuery);
            this.setQuery.clear();
        }
        finally {
            this.lock.unlock();
        }
        LinkedList<Position> listResults = new LinkedList<Position>();
        for (Position pos : listSrc) {
            try {
                List<Position> list = this.query(pos);
                if (list == null) continue;
                listResults.addAll(list);
            }
            catch (MException e) {
                logger.error("query spec position failed", (Throwable)e);
            }
        }
        return listResults;
    }

    public List<Position> query(Position position) throws MException {
        return this.createPositionList(this.apiPosition.query((IPositionQueryInfo)position));
    }

    public Set<Position> query() throws MException {
        this.clearQuery();
        return this.queryByPage();
    }

    public Set<Position> exportQuery() throws MException {
        return this.queryByPage();
    }

    private Set<Position> queryByPage() throws MException {
        Set<Position> setPosition = Collections.synchronizedSet(new HashSet());
        QueryByPage query = (QueryByPage)((Object)this.of.create(QueryByPage.class));
        query.queryByPage(page -> {
            this.apiPosition.queryPositionsInTurn(page, this.fund.getExtAccntId(), this.getMarketGrp());
            this.transferPosition(setPosition, (IPageInTurn<String, String, PPositionService.ExtPosition>)page);
        });
        return setPosition;
    }

    private void transferPosition(Set<Position> setPosition, IPageInTurn<String, String, PPositionService.ExtPosition> page) {
        for (PPositionService.ExtPosition pPosition : page.getResList()) {
            Position position = this.fPosition.create(pPosition);
            if (position == null) continue;
            setPosition.add(position);
        }
    }

    private List<Position> createPositionList(List<PPositionService.ExtPosition> listSrc) {
        LinkedList<Position> listPosition = new LinkedList<Position>();
        for (PPositionService.ExtPosition item : listSrc) {
            Position position = this.fPosition.create(item);
            if (position == null) continue;
            listPosition.add(position);
        }
        return listPosition;
    }

    public String getMarketGrp() {
        return this.getFund() == null ? "" : this.getFund().getMarketGrp();
    }

    public int getSetType() {
        return this.setType;
    }

    public void setSetType(int setType) {
        this.setType = setType;
    }

    public String getPositionType() {
        return this.positionType;
    }

    public void setPositionType(String positionType) {
        this.positionType = positionType;
    }

    public FundAccount getFund() {
        return this.fund;
    }

    public void setFund(FundAccount fund) {
        this.fund = fund;
    }
}

