/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.mng;

import cms.tmx.api.trade.IQueryOrderApi;
import cms.tmx.api.trade.info.IPageInTurn;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.datatype.proto.strategy.PStrategy;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.factory.OrderFactory;
import cms.tmx.entity.notice.CancelRejectReport;
import cms.tmx.entity.notice.ExecutionReport;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.Order;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.IUserService;
import cms.tmx.query.current.models.CtpAccountMap;
import cms.tmx.query.utils.QueryByPage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class OrderMng
extends MxModel {
    @Inject
    private OrderFactory ftOrder;
    @Inject
    private IQueryOrderApi apiOrderQuery;
    @Inject
    private IUserService userService;
    private FundAccount fund;
    private String subAccId;
    private String resourceId;
    private String reference;
    @Inject
    private MObjFactory of;
    private Set<String> setToBeQuery = new HashSet<String>();
    private ReentrantLock lockTobeQuery = new ReentrantLock();
    @Inject
    private CtpAccountMap accountMap;

    public void addToBeQuery(ExecutionReport report) {
        String id = report.getReport().getOrderId();
        this.lockTobeQuery.lock();
        this.setToBeQuery.add(id);
        this.lockTobeQuery.unlock();
    }

    public void addToBeQuery(CancelRejectReport report) {
        String id = report.getReport().getOrderId();
        this.lockTobeQuery.lock();
        this.setToBeQuery.add(id);
        this.lockTobeQuery.unlock();
    }

    public List<Order> queryToBeQuery(boolean fullQueryting) throws MException {
        this.lockTobeQuery.lock();
        LinkedList<String> listIDs = new LinkedList<String>(this.setToBeQuery);
        if (!fullQueryting) {
            this.setToBeQuery.clear();
        }
        this.lockTobeQuery.unlock();
        if (listIDs.isEmpty()) {
            return null;
        }
        this.logger.info(String.valueOf(this.subAccId) + "\u67e5\u8be2id" + listIDs);
        return this.query(listIDs);
    }

    private List<Order> query(List<String> ids) throws MException {
        return this.createOrders(this.apiOrderQuery.queryOrders(this.getMarketGrp(), this.fund.getExtAccntId(), ids));
    }

    public Set<Order> query(boolean isUnfinishedOrder) throws MException {
        this.lockTobeQuery.lock();
        this.setToBeQuery.clear();
        this.lockTobeQuery.unlock();
        return this.queryByPage(this.getMarketGrp(), this.fund.getExtAccntId(), "", "", "", isUnfinishedOrder);
    }

    private Set<Order> queryByPage(String marketGrp, String extAccntId, String subAccId, String resourceId, String reference, boolean isUnfinishedOrder) throws MException {
        Set<Order> setOrder = Collections.synchronizedSet(new HashSet());
        QueryByPage query = (QueryByPage)((Object)this.of.create(QueryByPage.class));
        query.queryByPage(page -> {
            this.apiOrderQuery.queryOrdersInTurn(page, marketGrp, extAccntId, subAccId, resourceId, reference, isUnfinishedOrder);
            this.transferOrder(setOrder, (IPageInTurn<String, String, POrderService.SingleOrder>)page);
        });
        return setOrder;
    }

    private void transferOrder(Set<Order> setOrder, IPageInTurn<String, String, POrderService.SingleOrder> page) throws MException {
        for (POrderService.SingleOrder pOrder : page.getResList()) {
            Order order = this.ftOrder.create(pOrder);
            if ("52".equals(order.getOrdStatus().getRaw()) || "70".equals(order.getOrdStatus().getRaw())) {
                order.setWthUserName(this.getWthUserName(pOrder));
                order.setErrInfo(order.transferErrInfo());
                setOrder.add(order);
                continue;
            }
            pOrder = null;
            setOrder.add(order);
        }
    }

    public List<CtpOrder> queryHedgeByPage(List<String> extSecAcct, int selectFlag) throws MException {
        List<CtpOrder> setOrder = Collections.synchronizedList(new ArrayList());
        QueryByPage query = (QueryByPage)((Object)this.of.create(QueryByPage.class));
        query.queryByPage(page -> {
            this.apiOrderQuery.queryHedgeOrdersInTurn(page, extSecAcct, selectFlag);
            for (PStrategy.SingleOrder pOrder : page.getResList()) {
                CtpOrder order = this.ftOrder.createCtpOrder();
                order.update((Object)pOrder);
                order.setInvestorId(this.accountMap.getCtpInvestId(order.getExtAccntId()));
                order.setBrokerId(this.accountMap.getCtpBrokerId(order.getExtAccntId()));
                order.setInverstorSecId(this.accountMap.getCtpInverstorSecId(order.getExtSecAccntId()));
                setOrder.add(order);
            }
        });
        return setOrder;
    }

    public Set<Order> queryPortf(boolean isUnfinishedOrder) throws MException {
        this.lockTobeQuery.lock();
        this.setToBeQuery.clear();
        this.lockTobeQuery.unlock();
        return this.queryByPage(this.getMarketGrp(), this.fund.getExtAccntId(), this.getSubAccId(), "", "", isUnfinishedOrder);
    }

    public Set<Order> queryInstrustion(boolean isUnfinishedOrder) throws MException {
        this.lockTobeQuery.lock();
        this.setToBeQuery.clear();
        this.lockTobeQuery.unlock();
        return this.queryByPage(this.getMarketGrp(), this.fund.getExtAccntId(), this.getSubAccId(), this.getResourceId(), this.getReference(), isUnfinishedOrder);
    }

    private List<Order> createOrders(List<POrderService.SingleOrder> orderList) throws MException {
        LinkedList<Order> listOrder = new LinkedList<Order>();
        for (POrderService.SingleOrder pOrder : orderList) {
            Order order = this.ftOrder.create(pOrder);
            if ("52".equals(order.getOrdStatus().getRaw()) || "70".equals(order.getOrdStatus().getRaw())) {
                order.setWthUserName(this.getWthUserName(pOrder));
                order.setErrInfo(order.transferErrInfo());
                listOrder.add(order);
                continue;
            }
            listOrder.add(order);
        }
        return listOrder;
    }

    private String getWthUserName(POrderService.SingleOrder pOrder) throws MException {
        String wthName = this.userService.getCachedUser(pOrder.getWthUserId()).getName().equals("") ? pOrder.getWthUserId() : this.userService.getCachedUser(pOrder.getWthUserId()).getName();
        return wthName;
    }

    public FundAccount getFund() {
        return this.fund;
    }

    public void setFund(FundAccount fund) {
        this.fund = fund;
    }

    public String getSubAccId() {
        return this.subAccId;
    }

    public void setSubAccId(String subAccId) {
        this.subAccId = subAccId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getMarketGrp() {
        return this.fund == null ? "" : this.fund.getMarketGrp();
    }
}

