/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.mng;

import cms.tmx.core.MException;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.notice.ExecutionReport;
import cms.tmx.entity.notice.InstructionReport;
import cms.tmx.entity.notice.MxNotice;
import cms.tmx.entity.trade.instruction.ObInstruction;
import cms.tmx.entity.web.workflow.WorkflowTask;
import cms.tmx.entity.web.workflow.WorkflowTaskList;
import cms.tmx.http.instruction.api.InstructionServiceApi;
import cms.tmx.http.instruction.dto.AccntSecInfo;
import cms.tmx.http.instruction.dto.GetInstructionsReq;
import cms.tmx.http.instruction.dto.Instruction;
import cms.tmx.manage.models.UserMngServiceImpl;
import cms.tmx.query.current.models.OtcPortfolioAccountModel;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.workflow.WorkflowTemplateApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class NewInstructionMng {
    @Inject
    private InstructionServiceApi ins;
    @Inject
    private UserMngServiceImpl userService;
    @Inject
    private OtcPortfolioAccountModel portfolioModel;
    @Inject
    private WorkflowTemplateApi workflowApi;
    public static final int FIRST_SETP_ID = 1;
    private static final String SELL = "\u76f4\u9500";
    private static final String HCJK = "\u6c47\u6210\u91d1\u79d1";
    private static final String FOCUS = "\u4e00\u6237\u901a";
    private static final Logger logger = LogManager.getLogger(NewInstructionMng.class);
    private Map<String, MxNotice> mapToBeQuery = new HashMap<String, MxNotice>();
    private ReentrantLock lockTobeQuery = new ReentrantLock();
    private static final List<String> TODO_OPTS = Arrays.asList("0", "1", "2", "4", "5", "6", "8", "11");

    public List<ObInstruction> query(List<String> portfolioIds) throws MException {
        ArrayList<ObInstruction> instructionList = new ArrayList<ObInstruction>();
        if (portfolioIds.isEmpty()) {
            return instructionList;
        }
        GetInstructionsReq req = new GetInstructionsReq();
        req.setPortfolioId(portfolioIds);
        req.setInstructionType("FundDetail");
        List instructions = this.ins.getInstructions(req);
        if (instructions == null) {
            return instructionList;
        }
        for (Instruction instruction : instructions) {
            ObInstruction obIns = new ObInstruction();
            instruction.setCreatorName((String)this.userService.getCreditUserName(instruction.getCreator()).get());
            obIns.update((Object)instruction);
            this.getTradePlatform(obIns);
            instructionList.add(obIns);
        }
        this.getWorkflow(instructionList);
        return instructionList;
    }

    public void addToBeQuery(MxNotice report) {
        this.lockTobeQuery.lock();
        try {
            if (report instanceof InstructionReport) {
                InstructionReport instReport = (InstructionReport)InstructionReport.class.cast(report);
                instReport.getReport().getInstructionList().forEach(each -> {
                    String id = each.getInstructionId();
                    this.mapToBeQuery.put(id, report);
                });
            }
            if (report instanceof ExecutionReport) {
                ExecutionReport exeReport = (ExecutionReport)ExecutionReport.class.cast(report);
                String id = exeReport.getReport().getReference();
                this.mapToBeQuery.put(id, report);
            }
        }
        finally {
            this.lockTobeQuery.unlock();
        }
    }

    public void addToBeQuery(ObInstruction instruction) {
        this.lockTobeQuery.lock();
        try {
            this.mapToBeQuery.put(instruction.getId(), (MxNotice)new InstructionReport());
        }
        finally {
            this.lockTobeQuery.unlock();
        }
    }

    public List<ObInstruction> queryToBeQuery() throws MException {
        this.lockTobeQuery.lock();
        LinkedList<String> listIDs = null;
        try {
            listIDs = new LinkedList<String>(this.mapToBeQuery.keySet());
            this.mapToBeQuery.clear();
        }
        finally {
            this.lockTobeQuery.unlock();
        }
        if (listIDs.isEmpty()) {
            return new ArrayList<ObInstruction>();
        }
        return this.queryByIds(listIDs);
    }

    public List<ObInstruction> queryByIds(List<String> ids) throws MException {
        ArrayList<ObInstruction> instructionList = new ArrayList<ObInstruction>();
        GetInstructionsReq req = new GetInstructionsReq();
        req.setInstructionId(ids);
        List instructions = this.ins.getInstructions(req);
        for (Instruction instruction : instructions) {
            ObInstruction ins = new ObInstruction();
            instruction.setCreatorName((String)this.userService.getCreditUserName(instruction.getCreator()).get());
            ins.update((Object)instruction);
            this.getTradePlatform(ins);
            instructionList.add(ins);
        }
        try {
            this.getWorkflow(instructionList);
        }
        catch (MException | Exception e) {
            logger.error("\u6307\u4ee4\u67e5\u8be2\u5de5\u4f5c\u6d41\u4fe1\u606f\u51fa\u9519", e);
        }
        return instructionList;
    }

    private void getWorkflow(List<ObInstruction> instructionList) throws MException {
        ArrayList<String> workflowIds = new ArrayList<String>();
        for (ObInstruction ins : instructionList) {
            workflowIds.add(ins.getEntryId());
        }
        Map workflowCurrentTasks = this.workflowApi.getWorkflowCurrentTasks(workflowIds);
        for (ObInstruction ins : instructionList) {
            if ("202005070000000003".equals(ins.getId())) {
                System.out.println();
            }
            if (workflowCurrentTasks.get(ins.getEntryId()) == null) continue;
            ins.setCanCancel(((WorkflowTaskList)workflowCurrentTasks.get(ins.getEntryId())).isCanCancel());
            ins.fillTask(((WorkflowTaskList)workflowCurrentTasks.get(ins.getEntryId())).getTaskList());
            this.transferField(ins);
        }
    }

    private void transferField(ObInstruction ins) throws MException {
        boolean todo = false;
        List workflowTasks = ins.getWorkflowTasks();
        for (WorkflowTask workflowTask : workflowTasks) {
            String[] opts;
            if (workflowTask.getPermissibleList().contains("4")) {
                ins.setIsOrderStep(true);
            } else if (workflowTask.getPermissibleList().contains("2") || workflowTask.getPermissibleList().contains("6")) {
                ins.setIsApproveStep(true);
            }
            String[] stringArray = opts = workflowTask.getPermissibleList().split(",");
            int n = opts.length;
            int n2 = 0;
            while (n2 < n) {
                String opt = stringArray[n2];
                if (TODO_OPTS.contains(opt)) {
                    todo = true;
                }
                ++n2;
            }
        }
        ins.setTodo(todo);
    }

    public static void main(String[] args) {
        String[] split = "1".split(",");
        System.out.println(split.length);
    }

    private void getTradePlatform(ObInstruction obIns) {
        block15: {
            block13: {
                CcsSubFundAccount subFund = this.portfolioModel.getSubFundAccountById(((AccntSecInfo)obIns.getOtcOrderDetail().getAccntSecInfo().get(0)).getAccountId().getCashAccntId());
                if (subFund == null || StringUtils.isEmpty((String)subFund.getCounterId())) break block13;
                obIns.setCounterId(subFund.getCounterId());
                switch (subFund.getCounterId()) {
                    case "99999-04-01": {
                        obIns.setTradePlatform(SELL);
                        break;
                    }
                    case "55555-04-01": {
                        obIns.setTradePlatform(HCJK);
                        break;
                    }
                    case "99999-01-01": {
                        obIns.setTradePlatform(FOCUS);
                        break;
                    }
                }
                break block15;
            }
            logger.error(String.valueOf(obIns.getId()) + "\u6839\u636e\u6307\u4ee4\u8be6\u60c5\u4ece\u6295\u7ec4\u6a21\u578b\u83b7\u53d6\u4e8c\u7ea7\u8d26\u53f7\u5931\u8d25\uff0c\u83b7\u53d6\u4ea4\u6613\u5e73\u53f0\u540d\u79f0\u5931\u8d25" + ((AccntSecInfo)obIns.getOtcOrderDetail().getAccntSecInfo().get(0)).getAccountId().getCashAccntId());
        }
    }
}

