/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.mng;

import cms.tmx.api.instruction.IInstructionApi;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PInstruction;
import cms.tmx.datatype.proto.workflow.PInstructionManagement;
import cms.tmx.define.IDictMap;
import cms.tmx.entity.Post;
import cms.tmx.entity.User;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.notice.ExecutionReport;
import cms.tmx.entity.notice.InstructionReport;
import cms.tmx.entity.notice.MxNotice;
import cms.tmx.entity.notice.ResourceReport;
import cms.tmx.entity.trade.HisQueryPage;
import cms.tmx.entity.trade.WorkflowTemplete;
import cms.tmx.entity.trade.basket.BasketAlgoItem;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.entity.trade.instruction.ActionInfo;
import cms.tmx.entity.trade.instruction.BasketSecurityInst;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IPostService;
import cms.tmx.manage.IProductService;
import cms.tmx.manage.IUserService;
import cms.tmx.query.current.models.AlgoStrategyQueryModel;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.current.models.ResourceModel;
import cms.tmx.query.utils.FundAccName;
import cms.tmx.query.utils.QueryModel;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.DateTimeUtils;
import cms.tmx.utils.ListUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class InstructionMng {
    @Inject
    private IInstructionApi<Instruction> ins;
    @Inject
    private PortfolioAccountModel protfAccntModel;
    @Inject
    private IProductService productService;
    @Inject
    private ResourceModel resourceModel;
    @Inject
    private IPostService postService;
    @Inject
    private IBaseApi baseApi;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private IUserService userService;
    @Inject
    private FundAccName fundName;
    @Inject
    private IDictMap dictMap;
    @Inject
    private AlgoStrategyQueryModel adjQueryModel;
    public static final int FIRST_SETP_ID = 1;
    private static final Set<Integer> actionIds = new HashSet<Integer>(Arrays.asList(8, 9, 22));
    private Map<String, User> userMap = FxUtils.newMap();
    private Map<String, Post> postMap = FxUtils.newMap();
    private static final Logger logger = LogManager.getLogger(InstructionMng.class);
    private static final String FORMAT_HOUR = "yyyyMMdd HH:mm:ss";
    private static DateTimeFormatter formatHour = DateTimeFormatter.ofPattern("yyyyMMdd HH:mm:ss");
    private LocalDate beginTime = null;
    private StringBuilder beginDate = new StringBuilder("");
    private Map<String, MxNotice> mapToBeQuery = new HashMap<String, MxNotice>();
    private ReentrantLock lockTobeQuery = new ReentrantLock();
    @Inject
    private PortfolioAccountModel portfModel;
    @Inject
    private QueryModel queryModel;

    public List<Instruction> query() throws MException {
        List instructions = this.ins.getInstructions(1);
        ArrayList<String> ids = new ArrayList<String>();
        for (PInstruction.Instruction ins : instructions) {
            ids.add(ins.getInstructionId());
        }
        return this.query(ids);
    }

    public void query(HisQueryPage<Instruction> queryPage) throws MException {
        ArrayList<Instruction> instructionList = new ArrayList<Instruction>();
        List instructions = this.ins.queryHisInstructions(queryPage, 2, Integer.valueOf(0));
        HashMap<String, Integer> mapHis = new HashMap<String, Integer>();
        HashMap<String, Integer> mapToday = new HashMap<String, Integer>();
        for (PInstruction.Instruction instr : instructions) {
            this.beginTime = LocalDate.parse(instr.getBeginTime(), formatHour);
            if (this.beginTime.isEqual(LocalDate.now()) || DateTimeUtils.getDate().compareTo(instr.getExpireDate()) <= 0) {
                mapToday.put(instr.getInstructionId(), instr.getType());
                mapHis.put(instr.getInstructionId(), instr.getType());
                continue;
            }
            mapHis.put(instr.getInstructionId(), instr.getType());
        }
        if (mapToday.size() > 0) {
            this.resourceModel.query(mapToday, "", "");
        }
        this.resourceModel.query(mapHis, queryPage.getBeginDate(), queryPage.getEndDate());
        for (PInstruction.Instruction instruction : instructions) {
            Instruction ins = new Instruction();
            ins.update((Object)instruction);
            try {
                this.transferField(ins);
                this.beginTime = LocalDate.parse(ins.getBeginTime(), formatHour);
                if (this.beginTime.isEqual(LocalDate.now())) {
                    this.getHisResource(ins, "", "");
                } else {
                    this.beginDate.delete(0, this.beginDate.length());
                    this.beginDate.append(this.beginTime.getYear()).append(this.beginTime.getMonthValue()).append(this.beginTime.getDayOfMonth());
                    this.getHisResource(ins, this.beginDate.toString(), this.beginDate.toString());
                }
                this.setOprAndStatus(instruction, ins);
            }
            catch (MException | Exception e) {
                logger.error(e.getMessage(), e);
            }
            instructionList.add(ins);
        }
        queryPage.updateData(instructionList);
    }

    public List<Instruction> exportIns(HisQueryPage<Instruction> pageCcs) throws MException {
        HisQueryPage page = new HisQueryPage();
        page.setCurrentPage(Integer.valueOf(1));
        page.setPageSize(Integer.valueOf(1));
        page.setBeginDate(pageCcs.getBeginDate());
        page.setEndDate(pageCcs.getEndDate());
        page.setAccountIdList(pageCcs.getAccountIdList());
        page.setMarketGrp(pageCcs.getMarketGrp());
        page.setDimension(pageCcs.getDimension());
        page.setPortfolioIdList(pageCcs.getPortfolioIdList());
        this.query((HisQueryPage<Instruction>)page);
        int pageCount = page.getPageCount();
        if (pageCount > 1) {
            page.setPageSize(page.getTotalCount());
            page.setDefaultQuerySize(200);
            page.setCurrentPage(Integer.valueOf(1));
            this.query((HisQueryPage<Instruction>)page);
        }
        return page.getDataList();
    }

    private void setOprAndStatus(PInstruction.Instruction instruction, Instruction ins) {
        if (!StringUtils.isEmpty((String)ins.getStatus().getValue())) {
            StringBuilder operator = new StringBuilder();
            if (instruction.getDescId() == 7 || "7".equals(String.valueOf(instruction.getStatusValue())) || !"61".equals(ins.getStatus().getRaw()) && !"4".equals(ins.getStatus().getRaw())) {
                if (!instruction.getCurrentUserIdsList().isEmpty()) {
                    for (String userId : instruction.getCurrentUserIdsList()) {
                        operator.append(this.getUser(userId).getName()).append(",");
                    }
                }
                if (!operator.toString().isEmpty()) {
                    operator.replace(operator.length() - 1, operator.length(), "-");
                }
            }
            if (instruction.getDescId() == 8 && ("7".equals(String.valueOf(instruction.getStatusValue())) || "61".equals(String.valueOf(instruction.getStatusValue()))) && instruction.getTransferInfo().getCurrentStepId() >= 3) {
                ins.setOprAndStatus(operator.append("\u64a4\u9500\u5df2\u53d1\u9001").toString());
            } else {
                ins.setOprAndStatus(operator.append(ins.getStatus().getValue()).toString());
            }
        }
    }

    private User getUser(String userId) {
        try {
            if (this.userMap.get(userId) == null) {
                this.userMap.put(userId, this.userService.getUserDetail(userId));
            }
        }
        catch (MException e) {
            logger.error("\u83b7\u53d6\u7528\u6237\u5931\u8d25", (Throwable)e);
        }
        return this.userMap.get(userId);
    }

    private Post getPost(String postId) {
        try {
            if (this.postMap.get(postId) == null) {
                this.postMap.put(postId, this.postService.getPostDetail(postId));
            }
        }
        catch (MException e) {
            logger.error("\u83b7\u53d6\u804c\u4f4d\u5931\u8d25", (Throwable)e);
        }
        return this.postMap.get(postId);
    }

    public void addToBeQuery(MxNotice report) {
        this.lockTobeQuery.lock();
        try {
            String id;
            if (report instanceof InstructionReport) {
                InstructionReport instReport = (InstructionReport)InstructionReport.class.cast(report);
                instReport.getReport().getInstructionList().forEach(each -> {
                    String id = each.getInstructionId();
                    this.mapToBeQuery.put(id, report);
                });
            }
            if (report instanceof ExecutionReport) {
                ExecutionReport exeReport = (ExecutionReport)ExecutionReport.class.cast(report);
                id = exeReport.getReport().getReference();
                this.mapToBeQuery.put(id, report);
            }
            if (report instanceof ResourceReport) {
                ResourceReport resReport = (ResourceReport)ResourceReport.class.cast(report);
                id = resReport.getReport().getReference();
                this.mapToBeQuery.put(id, (MxNotice)resReport);
            }
        }
        finally {
            this.lockTobeQuery.unlock();
        }
    }

    public void addToBeQuery(Instruction instruction) {
        this.lockTobeQuery.lock();
        try {
            this.mapToBeQuery.put(instruction.getId(), (MxNotice)new InstructionReport());
        }
        finally {
            this.lockTobeQuery.unlock();
        }
    }

    public List<Instruction> queryToBeQuery() throws MException {
        this.lockTobeQuery.lock();
        LinkedList<String> listIDs = null;
        try {
            listIDs = new LinkedList<String>(this.mapToBeQuery.keySet());
            this.mapToBeQuery.clear();
        }
        finally {
            this.lockTobeQuery.unlock();
        }
        if (listIDs.isEmpty()) {
            return new ArrayList<Instruction>();
        }
        return this.query(listIDs);
    }

    public List<Instruction> query(List<String> ids) throws MException {
        ArrayList<Instruction> instructionList = new ArrayList<Instruction>();
        List instructions = this.ins.getInstructions(1, ids, null);
        HashMap<String, Integer> mapPara = new HashMap<String, Integer>();
        for (PInstruction.Instruction instr : instructions) {
            mapPara.put(instr.getInstructionId(), instr.getType());
        }
        this.resourceModel.query(mapPara, "", "");
        for (PInstruction.Instruction instruction : instructions) {
            Instruction ins = new Instruction();
            ins.update((Object)instruction);
            try {
                this.getResource(ins);
            }
            catch (MException | Exception e) {
                logger.error(String.valueOf(ins.getId()) + "\u6307\u4ee4\u4fe1\u606f\u8f6c\u6362\u51fa\u9519(\u5305\u62ec\u83b7\u53d6\u8d44\u6e90):", e);
            }
            this.setOprAndStatus(instruction, ins);
            instructionList.add(ins);
        }
        return instructionList;
    }

    public List<Instruction> queryByClInsIds(List<String> clIds) throws MException {
        ArrayList<Instruction> instructionList = new ArrayList<Instruction>();
        List instructions = this.ins.getInstructions(1, null, clIds);
        HashMap<String, Integer> mapPara = new HashMap<String, Integer>();
        for (PInstruction.Instruction instr : instructions) {
            mapPara.put(instr.getInstructionId(), instr.getType());
        }
        this.resourceModel.query(mapPara, "", "");
        for (PInstruction.Instruction instruction : instructions) {
            Instruction ins = new Instruction();
            ins.update((Object)instruction);
            try {
                this.getResource(ins);
            }
            catch (MException | Exception e) {
                logger.error(String.valueOf(ins.getId()) + "\u6307\u4ee4\u4fe1\u606f\u8f6c\u6362\u51fa\u9519(\u5305\u62ec\u83b7\u53d6\u8d44\u6e90):", e);
            }
            instructionList.add(ins);
        }
        return instructionList;
    }

    private void getResource(Instruction ins) throws MException {
        this.resourceModel.getResource(ins);
        this.transferField(ins);
    }

    private void getHisResource(Instruction ins, String beginDate, String endDate) throws MException {
        this.resourceModel.getHisResource(ins, beginDate, endDate);
        this.transferField(ins);
    }

    private void setStrategy(Instruction ins) {
        if (ins.getBasketOrderAdvice() != null) {
            if (ins.getBasketOrderAdvice().getStrategyType() == 1) {
                ins.setStrategyString("\u4efd\u6570");
            } else {
                ins.setStrategyString("\u91d1\u989d");
            }
        }
        if (ins.getAdjustPosAdvice() != null) {
            if (Integer.valueOf(ins.getAdjustPosAdvice().getAdjWay().getRaw()) == 1) {
                ins.setStrategyString("\u4efd\u6570");
            } else {
                ins.setStrategyString("\u91d1\u989d");
            }
        }
    }

    public void transferField(Instruction ins) throws MException {
        ins.getLock().lock();
        try {
            Iterator iterator = ins.getTransferInfo().getActionInfoList().iterator();
            while (iterator.hasNext()) {
                ActionInfo actionInfo = (ActionInfo)iterator.next();
                if (actionIds.contains(actionInfo.getActionId())) {
                    iterator.remove();
                }
                if (!ins.getType().getRaw().equals("2") || ins.getOrderAdvice().getSide() != 72 || 4 != actionInfo.getActionId()) continue;
                iterator.remove();
            }
            if (ins.getResource() != null && (ins.isWorkFlowDone() || "7".equals(ins.getStatus().getRaw()))) {
                if (!"16".equals(ins.getStatus().getRaw())) {
                    ins.getStatus().setRaw(ins.getResource().getStatus());
                }
                if (!"61".equals(ins.getResource().getStatus()) && !"4".equals(ins.getResource().getStatus())) {
                    this.checkTradeOrder(ins);
                    this.checkDistribute(ins);
                    if (1 != ins.getDescId() && 2 != ins.getDescId()) {
                        this.checkTradeCancel(ins);
                    }
                    this.checkUpdateInst(ins);
                } else {
                    ins.getStatus().setRaw(ins.getResource().getStatus());
                    ins.setTradeDone(true);
                    ins.getTransferInfo().getActionInfoList().clear();
                }
                ins.setInsEndTime(ins.getResource().getEndTime());
                ins.setLeavesAmt(ins.getResource().getLeavesAmt());
                if (ins.getResource().getLeavesQty() > 0L) {
                    ActionInfo tradeCancelOrder = new ActionInfo();
                    tradeCancelOrder.setActionId(Integer.valueOf(22));
                    tradeCancelOrder.setActionName("\u5168\u90e8\u64a4\u5355");
                    if (!ins.getTransferInfo().getActionInfoList().contains(tradeCancelOrder)) {
                        ins.getTransferInfo().getActionInfoList().add(tradeCancelOrder);
                    }
                }
                long cumQty = ins.getResource().getCumQty();
                ins.setCumQty(cumQty);
                ins.setRatio(ins.getResource().getRatio());
                if (ins.getResource().getAvailOrderQty() != 0L) {
                    ins.setOrdRatio((double)(ins.getResource().getOrderQty() / ins.getResource().getAvailOrderQty() * 100L));
                } else {
                    ins.setOrdRatio(0.0);
                }
                long leavesQty = ins.getResource().getLeavesQty();
                ins.setLeavesQty(leavesQty);
                ins.setTradeAmount(ins.getResource().getTradeAmount());
                ins.setCumAmount(ins.getResource().getTradeAmount());
            } else if (!(ins.isWorkFlowDone() || "6".equals(ins.getStatus().getRaw()) || "7".equals(ins.getStatus().getRaw()))) {
                this.checkUpdateInst(ins);
            }
            if (ins.getResource() != null) {
                ins.setAvailOrderQty(ins.getResource().getAvailOrderQty());
            }
            RefItem item = null;
            String investorId = "";
            if (ins.getResource() != null && ins.getTotalExpectationQty() != 0L) {
                ins.setOrdRatio((double)ins.getResource().getOrderQty() * 1.0 / ((double)ins.getTotalExpectationQty() * 1.0) * 100.0);
                ins.getResource().setOrdAmt(Double.valueOf("".equals(ins.getResource().getLeavesAmt()) ? "0" : ins.getResource().getLeavesAmt()) + ins.getResource().getTradeAmount());
            }
            ins.setAuthorizers(this.getUsersName(ins.getAuthorizer()));
            this.getLastCaller(ins);
            switch (ins.getType().getRaw()) {
                case "2": {
                    ins.setProductName(this.productService.getProductDetailFromCache(ins.getProductId()).getName());
                    investorId = ((AccntSecInfo)ins.getOrderAdvice().getAccSecInfoList().get(0)).getInvestorId();
                    ins.setBelongTo(String.valueOf(ins.getProductName()) + "(" + investorId + " " + this.fundName.getFundName(investorId) + ")");
                    ins.setSide(this.dictMap.get("side", ins.getOrderAdvice().getSide()));
                    ins.setUnit(QueryUtils.getUnit(ins.getOrderAdvice().getSecType(), ins.getOrderAdvice().getMarket()));
                    this.transferCommonPrice(ins);
                    item = this.caculateCumData(ins);
                    if (ins.getResource() == null || 201 != ins.getOrderAdvice().getSide()) break;
                    ins.setRatio(0.0);
                    ins.getResource().setOrdAmt(0.0);
                    break;
                }
                case "8": {
                    if (!ins.getProductId().isEmpty()) {
                        ins.setProductName(this.productService.getProductDetailFromCache(ins.getProductId()).getName());
                        investorId = ((AccntSecInfo)ins.getAlgoParam().getAccSecInfoList().get(0)).getInvestorId();
                        ins.setBelongTo(String.valueOf(ins.getProductName()) + "(" + investorId + " " + this.fundName.getFundName(investorId) + ")");
                    }
                    ins.setSide(this.dictMap.get("side", ins.getAlgoParam().getSide()));
                    ins.setUnit(QueryUtils.getUnit(ins.getAlgoParam().getType(), ins.getAlgoParam().getMarket()));
                    if (ins.getResource() != null && ins.getTotalExpectationQty() != 0L) {
                        ins.setOrdRatio((double)ins.getEffectOrderQty() * 1.0 / ((double)ins.getTotalExpectationQty() * 1.0) * 100.0);
                    }
                    item = this.caculateCumData(ins);
                    break;
                }
                case "4": 
                case "12": {
                    this.setStrategy(ins);
                    ins.setProductName(this.productService.getProductDetailFromCache(ins.getProductId()).getName());
                    investorId = ins.getBasketOrderAdvice().getInvestorId();
                    ins.setBelongTo(String.valueOf(ins.getProductName()) + "(" + investorId + " " + this.fundName.getFundName(investorId) + ")");
                    ins.setSide(this.dictMap.get("basket_side", ins.getBasketOrderAdvice().getSide()));
                    if (ins.getResource() != null && ins.getTotalExpectationQty() != 0L) {
                        ins.setOrdRatio((double)ins.getEffectOrderQty() * 1.0 / ((double)ins.getTotalExpectationQty() * 1.0) * 100.0);
                    }
                    this.transferBasketPrice(ins);
                    break;
                }
                case "3": {
                    this.fillBelongTo(ins);
                    ins.setSide(this.dictMap.get("side", ins.getOrderAdvice().getSide()));
                    ins.setUnit(QueryUtils.getUnit(ins.getOrderAdvice().getSecType(), ins.getOrderAdvice().getMarket()));
                    this.transferCommonPrice(ins);
                    item = this.caculateCumData(ins);
                    if (ins.getResource() != null && ins.getTotalExpectationQty() != 0L) {
                        ins.setOrdRatio((double)ins.getEffectOrderQty() * 1.0 / ((double)ins.getTotalExpectationQty() * 1.0) * 100.0);
                    }
                    if (ins.getDescId() != 8) break;
                    ins.setExType("\u90ae\u4ef6\u6307\u4ee4");
                    break;
                }
                case "5": 
                case "13": {
                    this.setStrategy(ins);
                    this.fillBelongTo(ins);
                    ins.setSide(this.dictMap.get("basket_side", ins.getBasketOrderAdvice().getSide()));
                    this.transferBasketPrice(ins);
                    if (ins.getResource() != null && ins.getTotalExpectationQty() != 0L) {
                        ins.setOrdRatio((double)ins.getEffectOrderQty() * 1.0 / ((double)ins.getTotalExpectationQty() * 1.0) * 100.0);
                    }
                    if (ins.getDescId() != 8) break;
                    ins.setExType("\u7bee\u5b50\u90ae\u4ef6\u6307\u4ee4");
                    break;
                }
                case "9": {
                    this.fillBelongTo(ins);
                    ins.setSide(this.dictMap.get("side", ins.getAlgoParam().getSide()));
                    ins.setUnit(QueryUtils.getUnit(ins.getAlgoParam().getType(), ins.getAlgoParam().getMarket()));
                    if (ins.getResource() != null && ins.getTotalExpectationQty() != 0L) {
                        ins.setOrdRatio((double)ins.getEffectOrderQty() * 1.0 / ((double)ins.getTotalExpectationQty() * 1.0) * 100.0);
                    }
                    item = this.caculateCumData(ins);
                    break;
                }
                case "16": {
                    this.setStrategy(ins);
                    ins.setProductName(this.productService.getProductDetailFromCache(ins.getProductId()).getName());
                    investorId = ins.getAdjustPosAdvice().getInvestorId();
                    ins.setBelongTo(String.valueOf(ins.getProductName()) + "(" + investorId + " " + this.fundName.getFundName(investorId) + ")");
                    ins.setSide("\u4e70\u5356");
                    if (ins.getResource() == null || ins.getTotalExpectationQty() == 0L) break;
                    ins.setOrdRatio((double)ins.getEffectOrderQty() * 1.0 / ((double)ins.getTotalExpectationQty() * 1.0) * 100.0);
                    break;
                }
                case "17": {
                    this.setStrategy(ins);
                    this.fillBelongTo(ins);
                    ins.setSide("\u4e70\u5356");
                    if (ins.getResource() == null || ins.getTotalExpectationQty() == 0L) break;
                    ins.setOrdRatio((double)ins.getEffectOrderQty() * 1.0 / ((double)ins.getTotalExpectationQty() * 1.0) * 100.0);
                    break;
                }
                case "32": 
                case "34": {
                    ins.setProductName(this.productService.getProductDetailFromCache(ins.getProductId()).getName());
                    investorId = ((AccntSecInfo)ins.getTrdCtrRptAdvice().getAccSecInfoList().get(0)).getInvestorId();
                    ins.setBelongTo(String.valueOf(ins.getProductName()) + "(" + investorId + " " + this.fundName.getFundName(investorId) + ")");
                    ins.setSide(this.dictMap.get("side", ins.getTrdCtrRptAdvice().getSide()));
                    int scale = 2;
                    item = this.caculateCumData(ins);
                    if (item != null) {
                        scale = item.getScale();
                    }
                    scale = 3;
                    ins.setInsPrice(new BigDecimal(ins.getTrdCtrRptAdvice().getPrice()).setScale(scale, 4).toPlainString());
                    if ("3".equals(String.valueOf(ins.getTrdCtrRptAdvice().getApplType())) || "4".equals(String.valueOf(ins.getTrdCtrRptAdvice().getApplType()))) {
                        ins.getType().setRaw("34");
                        ins.setExType(ins.getType().getValue());
                    }
                    if (ins.getResource() == null || ins.getTotalExpectationQty() == 0L) break;
                    ins.getResource().setOrdAmt(ins.getResource().getOrderAmt());
                    break;
                }
                case "64": {
                    ins.setProductName(this.productService.getProductDetailFromCache(ins.getProductId()).getName());
                    investorId = ((AccntSecInfo)ins.getOrderAdvice().getAccSecInfoList().get(0)).getInvestorId();
                    ins.setBelongTo(String.valueOf(ins.getProductName()) + "(" + investorId + " " + this.fundName.getFundName(investorId) + ")");
                    ins.setSide(String.valueOf(this.dictMap.get("side", ins.getOrderAdvice().getSide())) + this.dictMap.get("oc_flag", ins.getOrderAdvice().getOcFlag()));
                    item = this.caculateCumData(ins);
                    this.transferFuturesPrice(ins);
                    if (ins.getResource() == null || ins.getTotalExpectationQty() == 0L) break;
                    ins.setOrdRatio((double)ins.getEffectOrderQty() * 1.0 / ((double)ins.getTotalExpectationQty() * 1.0) * 100.0);
                    ins.getResource().setOrdAmt(0.0);
                    break;
                }
            }
            ins.setInvestId(investorId);
            ins.setCreator(ins.getCreator());
            ins.setCreatorName((String)this.userService.getUserName(ins.getCreator()).get());
            ArrayList actions = new ArrayList(ins.getTransferInfo().getActionInfoList());
            if (!ListUtils.checkDiffrent((List)ins.getActionList(), actions) || actions.isEmpty()) {
                ins.setActionList(actions);
            }
            ins.setStatusName(ins.getStatus().getValue());
            ins.setAvailOrderAmt(ins.getAvailOrderAmt());
            ins.setAvailOrderNum(ins.getAvailOrderNum());
        }
        finally {
            ins.getLock().unlock();
        }
    }

    private void getLastCaller(Instruction ins) {
        if ("9".equals(ins.getStatus().getRaw()) || "2".equals(ins.getStatus().getRaw()) || "4".equals(ins.getStatus().getRaw()) || "60".equals(ins.getStatus().getRaw()) || "61".equals(ins.getStatus().getRaw()) || "7".equals(ins.getStatus().getRaw()) || "3".equals(ins.getStatus().getRaw())) {
            if (ins.getLastCaller() != null) {
                System.err.println("12\u540d\u79f0" + ins.getLastCaller() + "\u72b6\u6001" + ins.getStatus().getRaw());
                ins.setLastCaller("".equals(this.userService.getUserName(ins.getLastCaller()).get()) ? ins.getLastCaller() : (String)this.userService.getUserName(ins.getLastCaller()).get());
            }
        } else {
            ins.setLastCaller("");
        }
    }

    private String getUsersName(List<String> authorizer) {
        String authors = "";
        if (!authorizer.isEmpty()) {
            int i = 0;
            while (i < authorizer.size()) {
                authors = String.valueOf(authors) + (i == authorizer.size() - 1 ? (String)this.userService.getUserName(authorizer.get(i)).get() : String.valueOf((String)this.userService.getUserName(authorizer.get(i)).get()) + ",");
                ++i;
            }
        }
        return "".equals(authors) ? "" : authors;
    }

    private void checkDistribute(Instruction ins) {
        if (!StringUtils.isEmpty((String)ins.getEndTime()) && !"60".equals(ins.getResource().getStatus()) && WorkflowTemplete.DISTRIBUTE.getId() == ins.getDescId()) {
            ins.getLock().lock();
            try {
                ActionInfo tradeDistributeAction = new ActionInfo();
                tradeDistributeAction.setActionId(Integer.valueOf(16));
                tradeDistributeAction.setActionName("\u8f6c\u53d1");
                if (!ins.getTransferInfo().getActionInfoList().contains(tradeDistributeAction)) {
                    ins.getTransferInfo().getActionInfoList().add(tradeDistributeAction);
                }
            }
            finally {
                ins.getLock().unlock();
            }
        }
    }

    private RefItem caculateCumData(Instruction ins) {
        RefItem item;
        String secCode = ins.getSecurityCode();
        String secType = ins.getSecurityType();
        String market = ins.getMarket();
        if ("SHSC".equals(market) || "SZSC".equals(market)) {
            secType = String.valueOf(secType) + market;
        }
        if ((item = this.refMng.getItem(secType, market, secCode)) != null && ins.getResource() != null) {
            int i;
            ins.setAvgPx((double)Math.round(ins.getResource().getAvgPx() * 10000.0) / 10000.0);
            if ("REPO".equals(secType)) {
                if ("XSHG".equals(market)) {
                    ins.setCumAmount((double)(ins.getResource().getCumQty() * 1000L));
                    ins.getResource().setOrderAmt((double)(ins.getResource().getOrderQty() * 1000L));
                } else if ("XSHE".equals(market)) {
                    ins.setCumAmount((double)(ins.getResource().getCumQty() * 100L));
                    ins.getResource().setOrderAmt((double)(ins.getResource().getOrderQty() * 100L));
                }
            } else if ("FUT".equals(secType)) {
                ins.setCumAmount(ins.getResource().getAvgPx() * (double)ins.getResource().getCumQty() * 10.0);
                ins.getResource().setOrderAmt(ins.getResource().getOrderAvg() * (double)ins.getResource().getOrderQty() * 10.0);
            } else {
                i = "XSHG".equals(market) && "BOND".equals(secType) ? 10 : 1;
                ins.setCumAmount(ins.getResource().getAvgPx() * (double)ins.getResource().getCumQty() * (double)i);
                ins.getResource().setOrderAmt(ins.getResource().getOrderAvg() * (double)ins.getResource().getOrderQty() * (double)i);
            }
            if ("32".equals(ins.getType().getRaw()) || "34".equals(ins.getType().getRaw())) {
                i = "XSHG".equals(market) && "BOND".equals(secType) ? 10 : 1;
                ins.setTradeAmount(ins.getResource().getAvgPx() * (double)ins.getResource().getCumQty() * (double)i);
            }
        }
        return item;
    }

    private void transferCommonPrice(Instruction ins) {
        if (ins.getOrderAdvice().getOrdType() == 49) {
            ins.setInsPrice("\u5e02\u4ef7-" + this.dictMap.get("cstr_price_type_mkt", ins.getOrderAdvice().getMarketPriceLimit()));
            ins.setPriceType("\u5e02\u4ef7");
            ins.setPriceLimit(this.dictMap.get("cstr_price_type_mkt", ins.getOrderAdvice().getMarketPriceLimit()));
        } else if (ins.getOrderAdvice().getOrdType() == 50) {
            if (ins.getOrderAdvice().getPrice() > 0.0 && !"3".equals(Integer.toString(ins.getOrderAdvice().getPriceLimit()))) {
                ins.setInsPrice(String.valueOf(this.dictMap.get("cstr_price_type_limited", ins.getOrderAdvice().getPriceLimit())) + "-" + new BigDecimal(String.valueOf(ins.getOrderAdvice().getPrice())).toPlainString());
                ins.setPriceLimit(this.dictMap.get("cstr_price_type_limited", ins.getOrderAdvice().getPriceLimit()));
            } else {
                ins.setInsPrice(this.dictMap.get("cstr_price_type_limited", ins.getOrderAdvice().getPriceLimit()));
                ins.setPriceLimit(this.dictMap.get("cstr_price_type_limited", ins.getOrderAdvice().getPriceLimit()));
            }
            ins.setPriceType("\u9650\u4ef7\u59d4\u6258");
        } else if (ins.getOrderAdvice().getOrdType() == 0) {
            ins.setInsPrice("\u76d8\u53e3-" + this.dictMap.get("instr_handicap", ins.getOrderAdvice().getPriceTypeBidAsk()));
            ins.setPriceType("\u76d8\u53e3\u4ef7");
            ins.setPriceLimit(this.dictMap.get("instr_handicap", ins.getOrderAdvice().getPriceTypeBidAsk()));
        } else if (ins.getOrderAdvice().getOrdType() == 99) {
            ins.setInsPrice("\u76d8\u540e\u56fa\u5b9a\u4ef7-" + ins.getOrderAdvice().getPrice());
            ins.setPriceType("\u76d8\u540e\u56fa\u5b9a\u4ef7");
            ins.setPriceLimit("\u9650\u5b9a");
        }
    }

    private void transferFuturesPrice(Instruction ins) {
        if (ins.getOrderAdvice().getOrdType() == 50) {
            if (ins.getOrderAdvice().getPrice() > 0.0 && !"3".equals(Integer.toString(ins.getOrderAdvice().getPriceLimit()))) {
                ins.setInsPrice(String.valueOf(this.dictMap.get("cstr_price_type_limited", ins.getOrderAdvice().getPriceLimit())) + "-" + new BigDecimal(String.valueOf(ins.getOrderAdvice().getPrice())).toPlainString());
            } else {
                ins.setInsPrice(this.dictMap.get("cstr_price_type_limited", ins.getOrderAdvice().getPriceLimit()));
            }
        } else if (ins.getOrderAdvice().getOrdType() == 0) {
            ins.setInsPrice("\u76d8\u53e3-" + this.dictMap.get("instr_handicap", ins.getOrderAdvice().getPriceTypeBidAsk()));
        }
    }

    private void transferBasketPrice(Instruction ins) {
        StringBuilder preText = new StringBuilder();
        preText.append(this.dictMap.get("basket_price_type", ins.getBasketOrderAdvice().getFixedPriceLimit())).append("-");
        if (ins.getBasketOrderAdvice().getPriceType() <= 10 && ins.getBasketOrderAdvice().getPriceType() >= -10) {
            preText.append("\u76d8\u53e3-");
        }
        preText.append(this.dictMap.get("bsk_handicap", ins.getBasketOrderAdvice().getPriceType()));
        if (ins.getBasketOrderAdvice().getFloatPrice() > 0.0) {
            preText.append("\u6d6e\u52a8").append(ins.getBasketOrderAdvice().getFloatPrice()).append("\u5143");
        }
        if (ins.getBasketOrderAdvice().getFloatPercent() > 0.0) {
            preText.append("\u6d6e\u52a8").append(ins.getBasketOrderAdvice().getFloatPercent()).append("%");
        }
        ins.setInsPrice(preText.toString());
    }

    private void fillBelongTo(Instruction ins) {
        ins.setPortfolioName(this.protfAccntModel.getPortfolioNameById(ins.getPortfolioId()));
        ins.setBelongTo(ins.getPortfolioName());
    }

    private void checkUpdateInst(Instruction ins) {
        if (this.baseApi.getPostId().equals(ins.getFirstOne())) {
            ActionInfo tradeCancelAction = new ActionInfo();
            tradeCancelAction.setActionId(Integer.valueOf(999));
            tradeCancelAction.setActionName("\u4fee\u6539");
            ins.getLock().lock();
            try {
                if (!ins.getTransferInfo().getActionInfoList().contains(tradeCancelAction)) {
                    ins.getTransferInfo().getActionInfoList().add(tradeCancelAction);
                }
            }
            finally {
                ins.getLock().unlock();
            }
        }
    }

    private void checkTradeCancel(Instruction ins) {
        if ("2".equals(ins.getType().getRaw()) && ins.getSecurityType().equals("OIS") && ins.getResource().getAvailOrderQty() == 0L) {
            return;
        }
        if (this.baseApi.getPostId().equals(ins.getFirstOne()) && ins.getResource().getTotalExpectationQty() - ins.getResource().getCumQty() > 0L) {
            ActionInfo tradeCancelAction = new ActionInfo();
            tradeCancelAction.setActionId(Integer.valueOf(8));
            tradeCancelAction.setActionName("\u64a4\u9500");
            ins.getLock().lock();
            try {
                if (!ins.getTransferInfo().getActionInfoList().contains(tradeCancelAction)) {
                    ins.getTransferInfo().getActionInfoList().add(tradeCancelAction);
                }
                ins.setCancelSelected(true);
                ins.setCanCancel(true);
            }
            finally {
                ins.getLock().unlock();
            }
        }
    }

    private void checkTradeOrder(Instruction ins) {
        if (ins.getDescId() == 7) {
            Set<String> traderPostIds;
            if (!StringUtils.isEmpty((String)ins.getEndTime()) && !"60".equals(ins.getResource().getStatus()) && ins.getResource().getAvailOrderQty() > 0L && ins.getAuthorizer() != null && ins.getAuthorizer().contains(this.baseApi.getUserId()) && (traderPostIds = this.portfModel.getTradersByWorkflowId(ins.getFlowAttrId())) != null && traderPostIds.contains(this.baseApi.getPostId())) {
                this.setCanExecute(ins);
            }
            return;
        }
        if (!StringUtils.isEmpty((String)ins.getEndTime()) && !"60".equals(ins.getResource().getStatus()) && ins.getResource().getAvailOrderQty() > 0L) {
            if (WorkflowTemplete.THREE_STEP_RISK.getId() == ins.getDescId()) {
                Set<String> traderPostIds = this.portfModel.getTradersByWorkflowId(ins.getFlowAttrId());
                if (traderPostIds != null && traderPostIds.contains(this.baseApi.getPostId())) {
                    this.setCanExecute(ins);
                }
            } else if (this.baseApi.getPostId().equals(ins.getLastOne())) {
                this.setCanExecute(ins);
            }
        }
    }

    private void setCanExecute(Instruction ins) {
        ActionInfo tradeExecuteAction = new ActionInfo();
        tradeExecuteAction.setActionId(Integer.valueOf(9));
        tradeExecuteAction.setActionName("\u6267\u884c");
        ins.getLock().lock();
        try {
            if (!ins.getTransferInfo().getActionInfoList().contains(tradeExecuteAction)) {
                ins.getTransferInfo().getActionInfoList().add(tradeExecuteAction);
            }
            ins.setIsOrderStep(true);
        }
        finally {
            ins.getLock().unlock();
        }
    }

    public void updateInstruction(Instruction instruction, int action) throws MException {
        this.ins.updateInstruction(instruction.getPbInstruction(), action);
    }

    public List<BasketSecurityInst> getInsBasketItems(String instructionId, int type) throws MException {
        ArrayList<BasketSecurityInst> basketItems = new ArrayList<BasketSecurityInst>();
        List list = this.ins.queryInsBasketItems(instructionId, type);
        list.forEach(resp -> {
            for (PInstruction.BasketSecurityInst item : resp.getBasketSecurityInstList()) {
                BasketSecurityInst bsItem = new BasketSecurityInst();
                bsItem.update((Object)item);
                basketItems.add(bsItem);
            }
        });
        return basketItems;
    }

    public List<BasketAlgoItem> getInsAdjuctItems(String instructionId, int type) throws MException {
        ArrayList<BasketAlgoItem> list = new ArrayList<BasketAlgoItem>();
        List listResp = this.ins.queryInsBasketItems(instructionId, type);
        listResp.forEach(resp -> {
            for (PInstruction.AdjustPosSecInst inst : resp.getAdjustPosInstList()) {
                BasketAlgoItem adj = new BasketAlgoItem();
                adj.update((Object)inst);
                this.queryModel.afterUpdate(adj, inst);
                list.add(adj);
            }
        });
        return list;
    }

    public List<PInstructionManagement.CheckResult> checkAvalidPosition(String portfolioId, String extAccntId, String subAccntId, List<PInstructionManagement.CheckItem> items) throws MException {
        PInstructionManagement.CheckAvalidPositionReq.Builder builder = PInstructionManagement.CheckAvalidPositionReq.newBuilder();
        builder.addAllCheckItem(items);
        builder.setExtAccntId(extAccntId);
        builder.setSubAccntId(subAccntId);
        builder.setPortfolioId(portfolioId);
        List listResp = this.ins.checkAvalidPosition(builder);
        return listResp;
    }
}

