/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.mng;

import cms.tmx.api.instruction.IInstructLogApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.workflow.PInstructionManagement;
import cms.tmx.entity.Post;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionLog;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IPostService;
import cms.tmx.manage.IUserService;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionLogMng
extends MxModel {
    @Inject
    private IInstructLogApi instLogApi;
    @Inject
    private IPostService postService;
    @Inject
    private IUserService userService;
    private Instruction instruction;
    private int type;
    private Set<InstructionLog> setToBeQuery = new HashSet<InstructionLog>();
    private ReentrantLock lockSet = new ReentrantLock();
    private Map<String, Post> postMap = FxUtils.newMap();
    private static final Logger logger = LogManager.getLogger(InstructionLogMng.class);

    public List<InstructionLog> query() throws MException {
        this.lockSet.lock();
        this.setToBeQuery.clear();
        this.lockSet.unlock();
        List list = this.instLogApi.getInstructLog(this.instruction.getId(), this.type);
        return this.createList(list);
    }

    private synchronized Post getPost(String postId) {
        try {
            if (this.postMap.get(postId) == null) {
                this.postMap.put(postId, this.postService.getPostDetail(postId));
            }
        }
        catch (MException e) {
            logger.error("\u83b7\u53d6\u804c\u4f4d\u5931\u8d25", (Throwable)e);
        }
        return this.postMap.get(postId);
    }

    public List<InstructionLog> createList(List<PInstructionManagement.TransferLog> list) throws MException {
        LinkedList<InstructionLog> listExec = new LinkedList<InstructionLog>();
        for (PInstructionManagement.TransferLog tranLog : list) {
            InstructionLog log = new InstructionLog();
            log.update((Object)tranLog);
            log.setPost(this.getPost(tranLog.getPostId()).getName());
            log.setUserName(this.userService.getCachedUser(tranLog.getCaller()).getName());
            log.setStepDesc(String.join((CharSequence)"-", this.getPost(tranLog.getPostId()).getName(), tranLog.getActionName()));
            listExec.add(log);
        }
        return listExec;
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(Instruction instruction, int type) {
        this.instruction = instruction;
        this.type = type;
    }

    public int getType() {
        return this.type;
    }
}

