/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.mng;

import cms.tmx.api.instruction.IInstructExecApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.PResource;
import cms.tmx.datatype.proto.trade.PResourceService;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.factory.InstructExecFactory;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionExec;
import cms.tmx.javafx.MxModel;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionExecMng
extends MxModel {
    @Inject
    private InstructExecFactory execFactory;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private IInstructExecApi instExecApi;
    private Instruction instruction;
    private Set<InstructionExec> setToBeQuery = new HashSet<InstructionExec>();
    private ReentrantLock lockSet = new ReentrantLock();

    public List<InstructionExec> query(int type, String tradeDay) throws MException {
        return this.query(null, type, tradeDay);
    }

    public List<InstructionExec> query(Instruction ins, int type, String tradeDay) throws MException {
        this.lockSet.lock();
        this.setToBeQuery.clear();
        this.lockSet.unlock();
        List list = new ArrayList();
        list = ins != null ? this.instExecApi.getInstructExec(ins.getResource().getId(), ins.getMarketGrp(), tradeDay, type) : this.instExecApi.getInstructExec(this.instruction.getResource().getId(), this.instruction.getMarketGrp(), tradeDay, type);
        return this.createList(list);
    }

    public List<InstructionExec> createList(List<PResourceService.GetResourceDetailsResp> list) {
        LinkedList<InstructionExec> listExec = new LinkedList<InstructionExec>();
        for (PResourceService.GetResourceDetailsResp resp : list) {
            PResource.Resource source = resp.getResource();
            PResource.ResourceDetails datail = resp.getDetails();
            for (PResource.LegDetails leg : datail.getLegList()) {
                InstructionExec instExec = this.execFactory.create(source, datail, leg);
                String type = instExec.getInstrument().getSecType();
                String market = instExec.getInstrument().getMarket().getRaw();
                boolean isHK = "SHSC".equals(market) || "SZSC".equals(market);
                type = isHK ? String.valueOf(type) + market : type;
                RefItem refItem = this.refMng.getItem(type, market, instExec.getInstrument().getSecId());
                if (refItem != null) {
                    instExec.getInstrument().setSymbol(refItem.getName());
                }
                if (this.instruction != null) {
                    instExec.getInstructionType().setRaw(this.instruction.getType().getRaw());
                }
                listExec.add(instExec);
            }
        }
        return listExec;
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(Instruction instruction) {
        this.instruction = instruction;
    }
}

