/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.mng;

import cms.tmx.core.MException;
import cms.tmx.define.IDictMap;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.notice.ExecutionReport;
import cms.tmx.entity.notice.InstructionReport;
import cms.tmx.entity.notice.MxNotice;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.entity.web.workflow.WorkflowOptEnum;
import cms.tmx.entity.web.workflow.WorkflowTask;
import cms.tmx.entity.web.workflow.WorkflowTaskList;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.base.AccountId;
import cms.tmx.http.instruction.api.InstructionServiceApi;
import cms.tmx.http.instruction.dto.AccntSecInfo;
import cms.tmx.http.instruction.dto.GetInstructionsReq;
import cms.tmx.http.instruction.dto.Instruction;
import cms.tmx.manage.IProductService;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.manage.models.UserMngServiceImpl;
import cms.tmx.utils.MarketUtils;
import cms.tmx.web.api.workflow.WorkflowTemplateApi;
import cmx.tmx.data.INewRefMng;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class HKInstructionMng {
    @Inject
    protected InstructionServiceApi ins;
    @Inject
    protected UserMngServiceImpl userService;
    @Inject
    protected WorkflowTemplateApi workflowApi;
    @Inject
    protected FundAccountMngServiceImpl fundService;
    @Inject
    protected IProductService productService;
    @Inject
    protected INewRefMng refMng;
    @Inject
    protected IDictMap dictMap;
    public static final int FIRST_SETP_ID = 1;
    protected static final Logger logger = LogManager.getLogger(HKInstructionMng.class);
    protected Map<String, MxNotice> mapToBeQuery = new HashMap<String, MxNotice>();
    protected ReentrantLock lockTobeQuery = new ReentrantLock();

    public List<ObSimpleInstruction> query(List<FundAccount> list, String marketGrp) throws MException {
        ArrayList<ObSimpleInstruction> instructionList = new ArrayList<ObSimpleInstruction>();
        if (list == null || list.isEmpty()) {
            return instructionList;
        }
        GetInstructionsReq req = new GetInstructionsReq();
        req.setMarketGroup(marketGrp);
        List extCashAccntIds = list.stream().map(item -> item.getNewCashAccntId()).collect(Collectors.toList());
        req.setExtCashAccntId(extCashAccntIds);
        List instructions = this.ins.getInstructions(req);
        if (instructions == null) {
            return instructionList;
        }
        for (Instruction instruction : instructions) {
            ObSimpleInstruction obIns = new ObSimpleInstruction();
            instruction.setCreatorName((String)this.userService.getCreditUserName(instruction.getCreator()).get());
            obIns.update((Object)instruction);
            instructionList.add(obIns);
        }
        this.getWorkflow(instructionList);
        return instructionList;
    }

    public void addToBeQuery(MxNotice report) {
        this.lockTobeQuery.lock();
        try {
            if (report instanceof InstructionReport) {
                InstructionReport instReport = (InstructionReport)InstructionReport.class.cast(report);
                instReport.getReport().getInstructionList().forEach(each -> {
                    String id = each.getInstructionId();
                    this.mapToBeQuery.put(id, report);
                });
            }
            if (report instanceof ExecutionReport) {
                ExecutionReport exeReport = (ExecutionReport)ExecutionReport.class.cast(report);
                String id = exeReport.getReport().getReference();
                this.mapToBeQuery.put(id, report);
            }
        }
        finally {
            this.lockTobeQuery.unlock();
        }
    }

    public void addToBeQuery(ObSimpleInstruction instruction) {
        this.lockTobeQuery.lock();
        try {
            this.mapToBeQuery.put(instruction.getId(), (MxNotice)new InstructionReport());
        }
        finally {
            this.lockTobeQuery.unlock();
        }
    }

    public List<ObSimpleInstruction> queryToBeQuery() throws MException {
        this.lockTobeQuery.lock();
        LinkedList<String> listIDs = null;
        try {
            listIDs = new LinkedList<String>(this.mapToBeQuery.keySet());
            this.mapToBeQuery.clear();
        }
        finally {
            this.lockTobeQuery.unlock();
        }
        if (listIDs.isEmpty()) {
            return new ArrayList<ObSimpleInstruction>();
        }
        return this.queryByIds(listIDs);
    }

    public List<ObSimpleInstruction> queryByIds(List<String> ids) throws MException {
        ArrayList<ObSimpleInstruction> instructionList = new ArrayList<ObSimpleInstruction>();
        GetInstructionsReq req = new GetInstructionsReq();
        req.setInstructionId(ids);
        List instructions = this.ins.getInstructions(req);
        for (Instruction instruction : instructions) {
            ObSimpleInstruction ins = new ObSimpleInstruction();
            instruction.setCreatorName((String)this.userService.getCreditUserName(instruction.getCreator()).get());
            ins.update((Object)instruction);
            instructionList.add(ins);
        }
        try {
            this.getWorkflow(instructionList);
        }
        catch (MException | Exception e) {
            logger.error("\u6307\u4ee4\u67e5\u8be2\u5de5\u4f5c\u6d41\u4fe1\u606f\u51fa\u9519", e);
        }
        return instructionList;
    }

    protected void getWorkflow(List<ObSimpleInstruction> instructionList) throws MException {
        List workflowIds = instructionList.stream().map(item -> item.getEntryId()).collect(Collectors.toList());
        Map workflowCurrentTasks = this.workflowApi.getWorkflowCurrentTasks(workflowIds);
        for (ObSimpleInstruction ins : instructionList) {
            try {
                if ("202010200000000005".equals(ins.getId())) {
                    System.out.println();
                }
                if (workflowCurrentTasks.get(ins.getEntryId()) == null) {
                    this.transferField(ins);
                    continue;
                }
                ins.setCanCancel(((WorkflowTaskList)workflowCurrentTasks.get(ins.getEntryId())).isCanCancel());
                ins.fillTask(((WorkflowTaskList)workflowCurrentTasks.get(ins.getEntryId())).getTaskList());
                this.transferField(ins);
            }
            catch (MException e) {
                logger.error(String.valueOf(ins.getId()) + " \u4fe1\u606f\u8f6c\u6362\u51fa\u9519\uff1a", (Throwable)e);
            }
        }
    }

    protected void transferField(ObSimpleInstruction ins) throws MException {
        List workflowTasks = ins.getWorkflowTasks();
        for (WorkflowTask workflowTask : workflowTasks) {
            if (workflowTask.getPermissibleList().contains(WorkflowOptEnum.NEW_WORKFLOW_COMMON_EXECUTE.actionId)) {
                ins.setIsOrderStep(true);
                continue;
            }
            if (!workflowTask.getPermissibleList().contains("2") && !workflowTask.getPermissibleList().contains("6")) continue;
            ins.setIsApproveStep(true);
        }
        RefItem refItem = this.refMng.getItem(ins.getSecType(), ins.getSecMarket(), ins.getSecurityCode());
        if (refItem != null) {
            if (refItem.isNeeqQuery()) {
                this.refMng.queryStockInfo(refItem);
            }
            ins.setLevelInfo(refItem.getLevelInfo());
            ins.setTransferMethod(refItem.getTransferMethod());
        }
        String marketGrp = MarketUtils.getMarketGroup((String)ins.getSecMarket());
        if (!ins.getOrderDetail().getAccntSecInfo().isEmpty()) {
            AccountId accountId = ((AccntSecInfo)ins.getOrderDetail().getAccntSecInfo().get(0)).getAccountId();
            FundAccount fundAcc = this.fundService.getFundAccountByCashAccntId(accountId.getCashAccntId(), marketGrp);
            if (ins.getMarket().getRaw().equals("XHKG")) {
                fundAcc = this.fundService.getCcsFundAccount(accountId.getCashAccntId());
            }
            String investorId = "";
            if (fundAcc != null) {
                investorId = fundAcc.getInvestId();
            }
            if (ins.getProductId() != null && !ins.getProductId().isEmpty()) {
                ins.setBelongTo(String.valueOf(this.productService.getProductDetailFromCache(ins.getProductId()).getName()) + "(" + investorId + ")");
            }
        }
        if (ins.getAvgPx() != 0.0) {
            ins.setCumQty(ins.getCumAmount() / ins.getAvgPx());
        } else {
            ins.setCumQty(0.0);
        }
        double price = (double)Math.round(ins.getOrderDetail().getPrice() * 1000.0) / 1000.0;
        if (ins.getOrderDetail().getPlateLevels() != 0) {
            ins.getOrderDetail().setPlateLevels(ins.getOrderDetail().getPlateLevels() - 11);
            ins.setInsPriceStr("\u76d8\u53e3-" + this.dictMap.get("instr_handicap", ins.getOrderDetail().getPlateLevels()));
            ins.getOrderDetail().setOrdType(OrdType.ORD_TYPE_UNDEFINED);
        } else if ("49".equals(ins.getOrderDetail().getOrdType().getValue())) {
            if (ins.getOrderDetail().getTif() != null) {
                ins.setInsPriceStr("\u5e02\u4ef7");
            }
        } else if ("50".equals(ins.getOrderDetail().getOrdType().getValue())) {
            if (price > 0.0 && !"3".equals(Integer.toString(ins.getOrderDetail().getPriceRestriction()))) {
                ins.setInsPriceStr(String.valueOf(this.dictMap.get("cstr_price_type_limited", ins.getOrderDetail().getPriceRestriction())) + "-" + new BigDecimal(String.valueOf(price)).toPlainString());
            } else {
                ins.setInsPriceStr(this.dictMap.get("cstr_price_type_limited", ins.getOrderDetail().getPriceRestriction()));
            }
        } else if ("99".equals(ins.getOrderDetail().getOrdType().getValue())) {
            ins.setInsPriceStr("\u76d8\u540e\u56fa\u5b9a\u4ef7-" + price);
        }
    }
}

