/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.mng;

import cms.tmx.api.trade.ICancelOrderApi;
import cms.tmx.api.trade.IQueryOrderApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.entity.CtpFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.notice.ExecutionReport;
import cms.tmx.entity.trade.FutureCrossOrder;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.CtpAccountMap;
import cms.tmx.utils.MarketUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class FutureCrossOrderModel
extends MxModel {
    @Inject
    protected MScheduler scheduler;
    @Inject
    private ICancelOrderApi cancel;
    @Inject
    private IQueryOrderApi query;
    @Inject
    private MObjFactory of;
    private List<FutureCrossOrder> orderList = Collections.synchronizedList(new ArrayList());
    private Map<String, FutureCrossOrder> map = new HashMap<String, FutureCrossOrder>();
    @Inject
    protected IFundAccountService fundMng;
    @Inject
    protected MEventService es;
    private static final Logger logger = LogManager.getLogger(FutureCrossOrderModel.class);
    Map<String, List<String>> mapPush = new HashMap<String, List<String>>();
    @Inject
    private CtpAccountMap accMng;

    @PostConstruct
    public void init() {
        this.scheduler.setInterval(3000);
        this.es.subscribe("server.sub", event -> this.onPush(event));
        this.es.subscribe("requery_data", event -> this.query());
    }

    protected void onPush(MEvent event) {
        if (event.getObj() == null) {
            return;
        }
        if (event.getObj() instanceof ExecutionReport) {
            ExecutionReport report = (ExecutionReport)ExecutionReport.class.cast(event.getObj());
            if (!report.getReport().hasCrossOrder()) {
                return;
            }
            POrderService.CrossOrder crossOrder = report.getReport().getCrossOrder();
            FutureCrossOrder futureCrossOrder = this.map.get(crossOrder.getCrossId());
            if (futureCrossOrder == null) {
                FutureCrossOrder order = new FutureCrossOrder();
                order.update((Object)crossOrder);
                this.afterUpdate(order);
                this.orderList.add(order);
                this.map.put(crossOrder.getCrossId(), order);
            } else {
                futureCrossOrder.update((Object)crossOrder);
            }
            this.scheduler.schedule(e -> this.changed());
        }
    }

    private void afterUpdate(FutureCrossOrder futureCrossOrder) {
        futureCrossOrder.setInvestorId(this.accMng.getCtpInvestId(futureCrossOrder.getAccntId()));
        futureCrossOrder.setInvestorSecId(this.accMng.getCtpInverstorSecId(futureCrossOrder.getSecAccntId()));
    }

    public synchronized void query() {
        ArrayList list = new ArrayList();
        ArrayList<CtpFundAccount> fundList = new ArrayList<CtpFundAccount>();
        try {
            Map<CtpFundAccount, List<SecAccount>> accMap = this.accMng.getAccountMap();
            fundList.addAll(accMap.keySet());
            for (FundAccount fundAccount : fundList) {
                for (SecAccount sec : accMap.get(fundAccount)) {
                    try {
                        list.addAll(this.query.queryFutureCrossOrder(fundAccount.getExtAccntId(), sec.getExtSecAccntId(), true));
                    }
                    catch (MException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (MException e1) {
            e1.printStackTrace();
            logger.error(e1.getMessage());
        }
        this.map.clear();
        ArrayList crossOrderList = new ArrayList();
        list.forEach(item -> {
            FutureCrossOrder order = new FutureCrossOrder();
            order.update(item);
            order.setInvestorId(this.accMng.getCtpInvestId(order.getAccntId()));
            order.setInvestorSecId(this.accMng.getCtpInverstorSecId(order.getSecAccntId()));
            crossOrderList.add(order);
            this.map.put(order.getId(), order);
        });
        this.orderList.clear();
        this.orderList.addAll(crossOrderList);
        this.changed();
    }

    public synchronized List<FutureCrossOrder> queryOnePage() {
        ArrayList list = new ArrayList();
        ArrayList<CtpFundAccount> fundList = new ArrayList<CtpFundAccount>();
        try {
            Map<CtpFundAccount, List<SecAccount>> accMap = this.accMng.getAccountMap();
            fundList.addAll(accMap.keySet());
            for (FundAccount fundAccount : fundList) {
                for (SecAccount sec : accMap.get(fundAccount)) {
                    try {
                        list.addAll(this.query.queryFutureCrossOrder(fundAccount.getExtAccntId(), sec.getExtSecAccntId(), false));
                    }
                    catch (MException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (MException e1) {
            e1.printStackTrace();
            logger.error(e1.getMessage());
        }
        ArrayList<FutureCrossOrder> crossOrderList = new ArrayList<FutureCrossOrder>();
        list.forEach(item -> {
            FutureCrossOrder FutureCrossOrder2 = (FutureCrossOrder)this.of.create(FutureCrossOrder.class);
            FutureCrossOrder2.update(item);
            FutureCrossOrder2.setInvestorId(this.accMng.getCtpInvestId(FutureCrossOrder2.getAccntId()));
            FutureCrossOrder2.setInvestorSecId(this.accMng.getCtpInverstorSecId(FutureCrossOrder2.getSecAccntId()));
            crossOrderList.add(FutureCrossOrder2);
        });
        return crossOrderList;
    }

    public int cancelOrder(String accntId, String secAccntId, int buynum, String secId, String market, String secType, FutureCrossOrder order) throws MException {
        POrderService.CrossOrder.Builder ccsBuilder = POrderService.CrossOrder.newBuilder();
        ccsBuilder.setCrossId(order.getId());
        ccsBuilder.setCrossType(order.getCrossType().intValue());
        PComponent.Instrument.Builder builder = PComponent.Instrument.newBuilder();
        builder.setSecurityId(secId);
        builder.setMarket(market);
        builder.setSecurityType(secType);
        builder.setMarketGroup(MarketUtils.getMarketGroup((String)market));
        int status = this.cancel.etfCancelOrder(accntId, secAccntId, buynum, ccsBuilder.build(), builder.build());
        return status;
    }

    public List<FutureCrossOrder> getOrderList() {
        return this.orderList;
    }

    public void setOrderList(ObservableList<FutureCrossOrder> orderList) {
        this.orderList = orderList;
    }
}

