/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.mng;

import cms.tmx.api.trade.ICancelOrderApi;
import cms.tmx.api.trade.IQueryOrderApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.factory.CrossOrderFactory;
import cms.tmx.entity.notice.ExecutionReport;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.CrossOrder;
import cms.tmx.entity.trade.EtfStrategy;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.OrderModel;
import cms.tmx.query.utils.QueryUtils;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class EtfManualMng
extends OrderModel<CcsOrder> {
    @Inject
    private ICancelOrderApi cancel;
    @Inject
    private IQueryOrderApi query;
    @Inject
    private CrossOrderFactory of;
    private List<EtfStrategy> strategylist = new ArrayList<EtfStrategy>();
    private ObservableList<CrossOrder> orderList = FxUtils.newList();
    @Inject
    protected IFundAccountService fundMng;
    private static final Logger logger = LogManager.getLogger(EtfManualMng.class);

    @Override
    @PostConstruct
    public void init() {
        this.es.subscribe("server.sub", event -> this.onPush(event));
    }

    @Override
    protected void onPush(MEvent event) {
        ExecutionReport report;
        String exe_type;
        if (event.getObj() == null) {
            return;
        }
        if (event.getObj() instanceof ExecutionReport && ("48".equals(exe_type = Integer.toString((report = (ExecutionReport)ExecutionReport.class.cast(event.getObj())).getType())) || "52".equals(exe_type) || "56".equals(exe_type) || "70".equals(exe_type) || "73".equals(exe_type))) {
            String crossId = report.getReport().getHostCrossId();
            String accId = report.getReport().getExtAccntId();
            String tradeDate = report.getReport().getTradeDate();
            String mktGrp = QueryUtils.findMarketGrp(report.getReport().getInstrument().getMarket());
            FundAccount fundAcc = this.fundMng.getFundAccount(accId, mktGrp);
            if (fundAcc == null) {
                return;
            }
            if (crossId != null && !crossId.isEmpty()) {
                Platform.runLater(() -> {
                    try {
                        this.queryOneOrder(crossId, false, fundAcc.getExtAccntId(), tradeDate);
                    }
                    catch (MException e) {
                        logger.error(e.getMessage());
                    }
                });
            }
        }
    }

    public void queryOneOrder(String crossId, boolean flag, String extAccntId, String tradeDate) throws MException {
        if (!flag) {
            CrossOrder crossOrder = this.of.create();
            crossOrder.setId(crossId);
            crossOrder.setOrdDate(tradeDate);
            if (this.orderList.contains((Object)crossOrder)) {
                POrderService.CrossOrder item = this.query.queryOneEtfOrder(crossId, flag, extAccntId);
                ((CrossOrder)this.orderList.get(this.orderList.indexOf((Object)crossOrder))).update((Object)item);
                this.queryModel.afterUpdate(crossOrder);
                this.changed();
            } else {
                POrderService.CrossOrder item = this.query.queryOneEtfOrder(crossId, flag, extAccntId);
                crossOrder.update((Object)item);
                this.orderList.add((Object)crossOrder);
                this.queryModel.afterUpdate(crossOrder);
                this.changed();
            }
        } else if (flag) {
            this.orderList.clear();
            CrossOrder crossOrder = this.of.create();
            POrderService.CrossOrder item = this.query.queryOneEtfOrder(crossId, flag, extAccntId);
            crossOrder.update((Object)item);
            this.queryModel.afterUpdate(crossOrder);
            this.orderList.add((Object)crossOrder);
            this.changed();
        }
    }

    public synchronized List<CrossOrder> queryOrder(boolean flag) throws MException {
        ArrayList list = new ArrayList();
        ArrayList fundList = new ArrayList();
        fundList.addAll(this.fundMng.getFundAccountList("CCS"));
        if (fundList.size() > 0) {
            for (FundAccount fund : fundList) {
                list.addAll(this.query.queryEtfOrders(flag, fund.getExtAccntId()));
            }
        }
        if (!flag) {
            list.forEach(newItem -> {
                CrossOrder crossOrder = this.of.create();
                crossOrder.setId(newItem.getCrossId());
                crossOrder.setOrdDate(newItem.getOrdDate());
                if (this.orderList.contains((Object)crossOrder)) {
                    ((CrossOrder)this.orderList.get(this.orderList.indexOf((Object)crossOrder))).update(newItem);
                } else {
                    crossOrder.update(newItem);
                    this.orderList.add((Object)crossOrder);
                }
            });
        } else if (flag) {
            this.orderList.clear();
            list.forEach(item -> {
                CrossOrder crossOrder = this.of.create();
                crossOrder.update(item);
                this.queryModel.afterUpdate(crossOrder);
                this.orderList.add((Object)crossOrder);
            });
        }
        this.changed();
        return this.orderList;
    }

    public int cancelOrder(String accntId, String secAccntId, int buynum, String secId, String market, String secType, CrossOrder order) throws MException {
        POrderService.CrossOrder.Builder ccsBuilder = POrderService.CrossOrder.newBuilder();
        ccsBuilder.setCrossId(order.getId());
        ccsBuilder.setCrossType(order.getCrossType());
        PComponent.Instrument.Builder builder = PComponent.Instrument.newBuilder();
        builder.setSecurityId(secId);
        builder.setMarket(market);
        builder.setSecurityType(secType);
        builder.setApplId("010");
        int status = this.cancel.etfCancelOrder(accntId, secAccntId, buynum, ccsBuilder.build(), builder.build());
        return status;
    }

    public List<EtfStrategy> setAutoList(ObservableList<EtfStrategy> list) {
        this.strategylist = new ArrayList<EtfStrategy>();
        this.strategylist = list.filtered(each -> each.getStatus().getRaw().equals("1") || each.getStatus().getRaw().equals("3"));
        return this.strategylist;
    }

    public List<EtfStrategy> getAutoList() {
        return this.strategylist;
    }

    public ObservableList<CrossOrder> getOrderList() {
        return this.orderList;
    }

    public void setOrderList(ObservableList<CrossOrder> orderList) {
        this.orderList = orderList;
    }
}

