/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.mng;

import cms.tmx.api.trade.IQueryDealApi;
import cms.tmx.api.trade.info.IPageInTurn;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.factory.DealFactory;
import cms.tmx.entity.trade.Deal;
import cms.tmx.javafx.MxModel;
import cms.tmx.query.utils.QueryByPage;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class DealMng
extends MxModel {
    private static final Logger logger = LogManager.getLogger(DealMng.class);
    private FundAccount acc;
    private String subAccId;
    @Inject
    private IQueryDealApi dealApi;
    @Inject
    protected DealFactory fDeal;
    @Inject
    protected MObjFactory of;
    private Set<Deal> setToBeQuery = new HashSet<Deal>();
    private ReentrantLock lockSet = new ReentrantLock();

    public void addToBeQuery(Deal deal) {
        this.lockSet.lock();
        this.setToBeQuery.add(deal);
        this.lockSet.unlock();
    }

    public void clearToBeQuery() {
        this.lockSet.lock();
        this.setToBeQuery.clear();
        this.lockSet.unlock();
    }

    public List<Deal> queryToBeQuery() {
        this.lockSet.lock();
        LinkedList<Deal> ids = new LinkedList<Deal>(this.setToBeQuery);
        this.setToBeQuery.clear();
        this.lockSet.unlock();
        LinkedList<Deal> listDeal = new LinkedList<Deal>();
        for (Deal id : ids) {
            try {
                List<Deal> list = this.query(id);
                if (list == null) continue;
                listDeal.addAll(list);
            }
            catch (MException e) {
                logger.error("query deal failed: " + id, (Throwable)e);
            }
        }
        return listDeal;
    }

    private List<Deal> query(Deal deal) throws MException {
        List list = this.dealApi.queryDeals(this.getMarketGrp(), this.acc.getExtAccntId(), deal.getExecId());
        return this.createList(list);
    }

    public Set<Deal> query() throws MException {
        this.clearToBeQuery();
        return this.queryByPage(this.getMarketGrp(), this.acc.getExtAccntId(), "");
    }

    public Set<Deal> exportQuery() throws MException {
        return this.queryByPage(this.getMarketGrp(), this.acc.getExtAccntId(), "");
    }

    private Set<Deal> queryByPage(String marketGrp, String extAccntId, String subAccntId) throws MException {
        Set<Deal> setDeal = Collections.synchronizedSet(new HashSet());
        QueryByPage query = (QueryByPage)((Object)this.of.create(QueryByPage.class));
        query.queryByPage(page -> {
            this.dealApi.queryDealsInTurn(page, marketGrp, extAccntId, subAccntId);
            this.transferDeal(setDeal, (IPageInTurn<String, String, POrderService.Execution>)page);
        });
        return setDeal;
    }

    private void transferDeal(Set<Deal> setDeal, IPageInTurn<String, String, POrderService.Execution> page) {
        for (POrderService.Execution pDeal : page.getResList()) {
            Deal deal = this.fDeal.create(pDeal);
            setDeal.add(deal);
        }
    }

    public Set<Deal> queryPortf() throws MException {
        this.clearToBeQuery();
        return this.queryByPage(this.getMarketGrp(), this.acc.getExtAccntId(), this.getSubAccId());
    }

    public List<Deal> createList(List<POrderService.Execution> list) {
        LinkedList<Deal> listDeals = new LinkedList<Deal>();
        for (POrderService.Execution pDeal : list) {
            Deal deal = this.fDeal.create(pDeal);
            listDeals.add(deal);
        }
        return listDeals;
    }

    public FundAccount getAccount() {
        return this.acc;
    }

    public void setAccount(FundAccount acc) {
        this.acc = acc;
    }

    public String getMarketGrp() {
        return this.acc.getMarketGrp();
    }

    public String getSubAccId() {
        return this.subAccId;
    }

    public void setSubAccId(String subAccId) {
        this.subAccId = subAccId;
    }
}

