/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.mng;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.mng.IPortfolioApi;
import cms.tmx.api.trade.info.ICcsPortfPostQueryInfo;
import cms.tmx.api.trade.info.IPageInTurn;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PPositionService;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.trade.CcsPortfPosition;
import cms.tmx.entity.trade.Position;
import cms.tmx.query.current.mng.PositionMng;
import cms.tmx.query.utils.QueryByPage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CcsPortfPositionMng
extends PositionMng {
    @Inject
    private IPortfolioApi portFolioApi;
    @Inject
    private IBaseApi iba;

    @Override
    public List<Position> query(Position position) throws MException {
        if (!(position instanceof CcsPortfPosition)) {
            return new ArrayList<Position>();
        }
        CcsPortfPosition portfPosition = (CcsPortfPosition)CcsPortfPosition.class.cast(position);
        return this.createPositionList(this.apiPosition.portfQuery((ICcsPortfPostQueryInfo)portfPosition));
    }

    @Override
    public Set<Position> query() throws MException {
        this.clearQuery();
        FundAccount fund = this.getFund();
        if (!(fund instanceof CcsSubFundAccount)) {
            return new HashSet<Position>();
        }
        CcsSubFundAccount ccsSubFundAccount = (CcsSubFundAccount)CcsSubFundAccount.class.cast(fund);
        return this.queryByPage(ccsSubFundAccount.getSubAccntId());
    }

    private Set<Position> queryByPage(String subAccntId) throws MException {
        Set<Position> setPosition = Collections.synchronizedSet(new HashSet());
        QueryByPage query = (QueryByPage)((Object)this.of.create(QueryByPage.class));
        query.queryByPage((IPageInTurn<KEY, PARAM, RESULT> page) -> {
            this.apiPosition.querySubPositionsInTurn(page, subAccntId, this.getMarketGrp());
            this.transferSubPosition(setPosition, (IPageInTurn<String, String, PPositionService.SubPosition>)page);
        });
        return setPosition;
    }

    private void transferSubPosition(Set<Position> setPosition, IPageInTurn<String, String, PPositionService.SubPosition> page) {
        for (PPositionService.SubPosition pSubPosition : page.getResList()) {
            CcsPortfPosition position = this.fPosition.create(pSubPosition);
            if (position == null) continue;
            setPosition.add((Position)position);
        }
    }

    public List<Position> query(String subFund, String subSec, String mktGrp) throws MException {
        return this.createPositionList(this.apiPosition.portfQuery(subFund, subSec, mktGrp));
    }

    private List<Position> createPositionList(List<PPositionService.SubPosition> listSrc) {
        LinkedList<Position> listPosition = new LinkedList<Position>();
        for (PPositionService.SubPosition item : listSrc) {
            CcsPortfPosition position = this.fPosition.create(item);
            if (position == null) continue;
            listPosition.add((Position)position);
        }
        return listPosition;
    }
}

