/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.mng;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IBlockQueryApi;
import cms.tmx.api.trade.info.IHisQueryPageInfo;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.message.PMarketService;
import cms.tmx.datatype.message.PPostTrade;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.trade.BlockDeal;
import cms.tmx.entity.trade.BlockOrder;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.query.utils.QueryModel;
import java.time.LocalDate;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class BlockQueryMng {
    @Inject
    private IBlockQueryApi queryApi;
    @Inject
    private IBaseApi baseApi;
    @Inject
    private QueryModel queryMd;

    public List<BlockOrder> queryOrder(List<FundAccount> listAccnt, Instruction ins) throws MException {
        return this.queryAll(listAccnt, PMarketService.GetTradeCaptureReportsReq.QUERY_TYPE.QUERY_TYPE_ALL, ins);
    }

    public List<BlockOrder> queryUnfinished(List<FundAccount> listAccnt, Instruction ins) throws MException {
        return this.queryAll(listAccnt, PMarketService.GetTradeCaptureReportsReq.QUERY_TYPE.QUERY_TYPE_UNFINISH, ins);
    }

    public List<BlockDeal> queryDeal(List<FundAccount> listAccnt, Instruction ins) throws MException {
        PMarketService.GetTradeCaptureReportsReq.Builder builder = PMarketService.GetTradeCaptureReportsReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setMarketGrp("CCS");
        if (ins != null && ins.getTrdCtrRptAdvice() != null) {
            builder.setResourceId(ins.getResource().getId());
            builder.setReference(ins.getId());
        }
        builder.setOrdStatus(PField.TradeRptStatus.TRADE_RPT_STATUS_MATCHED);
        listAccnt.forEach(accnt -> {
            PMarketService.GetTradeCaptureReportsReq.Builder builder2 = builder.addExtAccntId(accnt.getExtAccntId());
        });
        PBase.Page.Builder page = PBase.Page.newBuilder();
        page.setStartRow(1);
        page.setPageSize(200);
        builder.setPage(page.build());
        LinkedList listResp = new LinkedList();
        PMarketService.GetTradeCaptureReportsResp resp = null;
        do {
            resp = this.queryApi.queryOrders(builder.build());
            List listOne = resp.getTrdCptRptList();
            listResp.addAll(listOne);
            page.setStartRow(page.getStartRow() + listOne.size());
        } while (resp.getPage().getIsLast());
        LinkedList<BlockDeal> list = new LinkedList<BlockDeal>();
        for (PPostTrade.TradeCaptureReport report : listResp) {
            BlockDeal order = new BlockDeal();
            order.update(report);
            this.queryMd.afterUpdate(order);
            list.add(order);
        }
        return list;
    }

    public List<BlockDeal> queryHisDeals(IHisQueryPageInfo<BlockDeal> page) throws MException {
        LinkedList<BlockDeal> list = new LinkedList<BlockDeal>();
        PMarketService.GetTradeCaptureReportsReq.Builder builder = PMarketService.GetTradeCaptureReportsReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setMarketGrp(page.getMarketGrp());
        builder.setBeginDatetime(page.getBeginDate());
        builder.setEndDatetime(page.getEndDate());
        PComponent.Instrument.Builder instrument = PComponent.Instrument.newBuilder();
        instrument.setSecurityId(page.getSecurityId());
        builder.setInstrument(instrument.build());
        String dimension = page.getDimension();
        if (dimension.equals("1")) {
            builder.addAllExtAccntId((Iterable)page.getExtAccntIdList());
        } else if (dimension.equals("2")) {
            return list;
        }
        builder.setOrdStatus(PField.TradeRptStatus.TRADE_RPT_STATUS_MATCHED);
        PBase.Page.Builder pageBuilder = PBase.Page.newBuilder();
        page.initParam();
        page.updatePage(pageBuilder);
        builder.setPage(pageBuilder.build());
        LinkedList listResp = new LinkedList();
        PMarketService.GetTradeCaptureReportsResp resp = null;
        do {
            resp = this.queryApi.queryOrders(builder.build());
            List listOne = resp.getTrdCptRptList();
            listResp.addAll(listOne);
            pageBuilder.setStartRow(pageBuilder.getStartRow() + listOne.size());
            page.setTotalCount(Integer.valueOf(resp.getPage().getTotalRow()));
        } while (resp.getPage().getIsLast());
        for (PPostTrade.TradeCaptureReport report : listResp) {
            BlockDeal deal = new BlockDeal();
            deal.update(report);
            this.queryMd.afterUpdate(deal);
            list.add(deal);
        }
        return list;
    }

    public List<BlockOrder> queryHisOrders(IHisQueryPageInfo<BlockOrder> page) throws MException {
        LinkedList<BlockOrder> list = new LinkedList<BlockOrder>();
        PMarketService.GetTradeCaptureReportsReq.Builder builder = PMarketService.GetTradeCaptureReportsReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setMarketGrp(page.getMarketGrp());
        builder.setBeginDatetime(page.getBeginDate());
        builder.setEndDatetime(page.getEndDate());
        PComponent.Instrument.Builder instrument = PComponent.Instrument.newBuilder();
        instrument.setSecurityId(page.getSecurityId());
        builder.setInstrument(instrument.build());
        builder.setQueryType(PMarketService.GetTradeCaptureReportsReq.QUERY_TYPE.QUERY_TYPE_ALL);
        String dimension = page.getDimension();
        if (dimension.equals("1")) {
            builder.addAllExtAccntId((Iterable)page.getExtAccntIdList());
        } else if (dimension.equals("2")) {
            return list;
        }
        PBase.Page.Builder pageBuilder = PBase.Page.newBuilder();
        page.initParam();
        page.updatePage(pageBuilder);
        builder.setPage(pageBuilder.build());
        LinkedList listResp = new LinkedList();
        PMarketService.GetTradeCaptureReportsResp resp = null;
        do {
            resp = this.queryApi.queryOrders(builder.build());
            List listOne = resp.getTrdCptRptList();
            listResp.addAll(listOne);
            pageBuilder.setStartRow(pageBuilder.getStartRow() + listOne.size());
            page.setTotalCount(Integer.valueOf(resp.getPage().getTotalRow()));
        } while (resp.getPage().getIsLast());
        for (PPostTrade.TradeCaptureReport report : listResp) {
            BlockOrder order = new BlockOrder();
            order.update(report);
            this.queryMd.afterUpdate(order);
            list.add(order);
        }
        return list;
    }

    public List<BlockOrder> queryAll(List<FundAccount> listAccnt, PMarketService.GetTradeCaptureReportsReq.QUERY_TYPE queryType, Instruction ins) throws MException {
        PMarketService.GetTradeCaptureReportsReq.Builder builder = PMarketService.GetTradeCaptureReportsReq.newBuilder();
        builder.setOpUser(this.baseApi.getOpUser());
        builder.setMarketGrp("CCS");
        if (ins != null && ins.getTrdCtrRptAdvice() != null) {
            builder.setResourceId(ins.getResource().getId());
            builder.setReference(ins.getId());
            String begin = ins.getBeginTime().substring(0, 8);
            String end = ins.getEndTime().isEmpty() ? LocalDate.now().toString().replace("-", "") : ins.getEndTime().substring(0, 8);
            builder.setBeginDatetime(begin);
            builder.setEndDatetime(end);
        }
        builder.setQueryType(queryType);
        listAccnt.forEach(accnt -> {
            PMarketService.GetTradeCaptureReportsReq.Builder builder2 = builder.addExtAccntId(accnt.getExtAccntId());
        });
        PBase.Page.Builder page = PBase.Page.newBuilder();
        page.setStartRow(1);
        page.setPageSize(200);
        builder.setPage(page.build());
        LinkedList listResp = new LinkedList();
        PMarketService.GetTradeCaptureReportsResp resp = null;
        do {
            resp = this.queryApi.queryOrders(builder.build());
            List listOne = resp.getTrdCptRptList();
            listResp.addAll(listOne);
            page.setStartRow(page.getStartRow() + listOne.size());
        } while (resp.getPage().getIsLast());
        LinkedList<BlockOrder> list = new LinkedList<BlockOrder>();
        for (PPostTrade.TradeCaptureReport report : listResp) {
            BlockOrder order = new BlockOrder();
            order.update(report);
            this.queryMd.afterUpdate(order);
            list.add(order);
        }
        return list;
    }
}

