/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.current.mng;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IAlgoMiseTradeApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.AlgoBaseOrder;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.basket.AdjPositonParam;
import cms.tmx.entity.trade.basket.AlgoStrategyDetails;
import cms.tmx.entity.trade.basket.BasketAlgoStrategy;
import cms.tmx.javafx.MxModel;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class AlgoMiseMng
extends MxModel {
    private static final Logger logger = LogManager.getLogger(AlgoMiseMng.class);
    @Inject
    private IAlgoMiseTradeApi api;
    @Inject
    private IBaseApi baseApi;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private MObjFactory of;
    @Inject
    protected PortfolioAccountModel portfolioModel;
    @Inject
    private MEventService es;

    public List<BasketAlgoStrategy> queryAlgo(String accntId, String startTime, String endTime) throws MException {
        LinkedList<BasketAlgoStrategy> list = new LinkedList<BasketAlgoStrategy>();
        String index = "";
        do {
            MEvent e;
            String retCode;
            if (!"0".equals(retCode = (e = this.api.queryMise(accntId, startTime, endTime, index)).getStr("ret_code"))) continue;
            String remain = e.getStr("has_remain");
            if (e.get((Object)"DATA") == null) continue;
            List events = (List)e.get((Object)"DATA");
            for (MEvent item : events) {
                if ("BasketPosAdj".equals(item.getStr("algo_type"))) {
                    BasketAlgoStrategy b = new BasketAlgoStrategy();
                    b.update((Object)item);
                    list.add(b);
                }
                index = "1".equals(remain) ? item.getStr("algo_order_id") : "";
            }
        } while (!index.isEmpty());
        return list;
    }

    public List<MEvent> queryAlgoMevent(String accntId, String startTime, String endTime) throws MException {
        LinkedList<MEvent> list = new LinkedList<MEvent>();
        String index = "";
        do {
            MEvent e;
            String retCode;
            if (!"0".equals(retCode = (e = this.api.queryMise(accntId, startTime, endTime, index)).getStr("ret_code"))) continue;
            String remain = e.getStr("has_remain");
            if (e.get((Object)"DATA") == null) continue;
            List events = (List)e.get((Object)"DATA");
            for (MEvent item : events) {
                list.add(item);
                index = "1".equals(remain) ? item.getStr("algo_order_id") : "";
            }
        } while (!index.isEmpty());
        return list;
    }

    public List<AlgoStrategyDetails> queryAlgoDetail(String accntId, String startTime, String endTime, String algoOrderId) throws MException {
        LinkedList<AlgoStrategyDetails> list = new LinkedList<AlgoStrategyDetails>();
        String index = "";
        block0: do {
            MEvent e;
            String retCode;
            if (!"0".equals(retCode = (e = this.api.queryMiseDetails(accntId, startTime, endTime, index, algoOrderId)).getStr("ret_code"))) continue;
            String remain = e.getStr("has_remain");
            if (e.get((Object)"DATA") == null) continue;
            List events = (List)e.get((Object)"DATA");
            for (MEvent item : events) {
                String extra = item.getStr("extra_fields");
                JsonObject json = (JsonObject)new Gson().fromJson(extra, JsonObject.class);
                if (json.get("basket") == null) continue block0;
                JsonArray basketArr = json.get("basket").getAsJsonArray();
                for (JsonElement ele : basketArr) {
                    AlgoStrategyDetails b = (AlgoStrategyDetails)this.of.create(AlgoStrategyDetails.class);
                    b.update((Object)item);
                    b.update((Object)ele);
                    b.setInvestorId(accntId);
                    JsonArray arr = ele.getAsJsonArray();
                    RefItem ref = this.getRefItem(arr);
                    if (ref != null) {
                        b.setSecName(ref.getName());
                    }
                    list.add(b);
                }
                index = "1".equals(remain) ? item.getStr("algo_order_id") : "";
            }
        } while (!index.isEmpty());
        return list;
    }

    private RefItem getRefItem(JsonArray arr) {
        String marketCode = arr.get(0).getAsString();
        String market = "";
        switch (marketCode) {
            case "1": {
                market = "XSHG";
                break;
            }
            case "2": {
                market = "XSHE";
                break;
            }
            case "5": {
                market = "SHSC";
                break;
            }
            case "A": {
                market = "SZSC";
            }
        }
        return this.refMng.getItem(market, arr.get(1).getAsString());
    }

    public void miseCancelOrder(BasketAlgoStrategy bsk) throws MException {
        JsonObject para = new JsonObject();
        para.add("biz_acct", (JsonElement)new JsonPrimitive(bsk.getBizAcct()));
        para.add("branch_code", (JsonElement)new JsonPrimitive(""));
        para.add("client_ip", (JsonElement)new JsonPrimitive(this.baseApi.getOpUser().getIp()));
        para.add("mac_addr", (JsonElement)new JsonPrimitive(this.baseApi.getOpUser().getMac()));
        para.add("algo_order_id", (JsonElement)new JsonPrimitive(bsk.getId()));
        para.add("gateway_id", (JsonElement)new JsonPrimitive("0"));
        JsonObject obj = new JsonObject();
        obj.add("PARA", (JsonElement)para);
        this.api.miseCancelOrder(obj);
    }

    public void miseCancelOrder(String accnt, String orderId) throws MException {
        JsonObject para = new JsonObject();
        para.add("biz_acct", (JsonElement)new JsonPrimitive(accnt));
        para.add("branch_code", (JsonElement)new JsonPrimitive(""));
        para.add("client_ip", (JsonElement)new JsonPrimitive(this.baseApi.getOpUser().getIp()));
        para.add("mac_addr", (JsonElement)new JsonPrimitive(this.baseApi.getOpUser().getMac()));
        para.add("algo_order_id", (JsonElement)new JsonPrimitive(orderId));
        para.add("gateway_id", (JsonElement)new JsonPrimitive("0"));
        JsonObject obj = new JsonObject();
        obj.add("PARA", (JsonElement)para);
        this.api.miseCancelOrder(obj);
        if (accnt.contains("SF")) {
            accnt = this.portfolioModel.getFundAccount(accnt, "CCS").getInvestId();
        }
        try {
            String orderid = orderId;
            MEvent event = new MEvent();
            event.put((Object)"inst_id", (Object)accnt);
            event.put((Object)"order_id", (Object)orderid);
            this.es.postEvent("mise_cancel", event);
        }
        catch (Exception e) {
            MEvent event = new MEvent();
            event.setObj((Object)e);
            this.es.postEvent("mise_cancel", event);
            throw e;
        }
    }

    public AdjPositonParam queryMiseParam(String accntId, String startTime, String endTime, String algoOrderId) throws MException {
        AdjPositonParam param = new AdjPositonParam();
        String index = "";
        do {
            MEvent e;
            String retCode;
            if (!"0".equals(retCode = (e = this.api.queryMiseDetails(accntId, startTime, endTime, index, algoOrderId)).getStr("ret_code"))) continue;
            String remain = e.getStr("has_remain");
            if (e.get((Object)"DATA") == null) continue;
            List events = (List)e.get((Object)"DATA");
            for (MEvent item : events) {
                param.update(item);
                index = "1".equals(remain) ? item.getStr("algo_order_id") : "";
            }
        } while (!index.isEmpty());
        return param;
    }

    public AlgoParam queryMiseParamBasket(String accntId, String startTime, String endTime, String algoOrderId) throws MException {
        AlgoParam param = (AlgoParam)this.of.create(AlgoParam.class);
        String index = "";
        do {
            MEvent e;
            String retCode;
            if (!"0".equals(retCode = (e = this.api.queryMiseDetails(accntId, startTime, endTime, index, algoOrderId)).getStr("ret_code"))) continue;
            String remain = e.getStr("has_remain");
            if (e.get((Object)"DATA") == null) continue;
            List events = (List)e.get((Object)"DATA");
            for (MEvent item : events) {
                param.update((Object)item);
                index = "1".equals(remain) ? item.getStr("algo_order_id") : "";
            }
        } while (!index.isEmpty());
        return param;
    }

    public static boolean isMise(String type) {
        return StringUtils.belongto((String)type, (String[])new String[]{"14", "15", "16", "17", "150", "160", "19", "20", "190", "200", "21", "22", "210", "220", "23", "230"});
    }

    public void afterUpdate(AlgoBaseOrder baseOrder) {
        if (baseOrder.isMiseSingleSecuirty()) {
            try {
                List<AlgoStrategyDetails> listTemp = this.queryAlgoDetail(baseOrder.getSubAcct(), baseOrder.getOrderDate(), baseOrder.getOrderDate(), baseOrder.getBaseId());
                if (listTemp.size() == 1) {
                    AlgoStrategyDetails details = listTemp.get(0);
                    baseOrder.setDealCount((int)details.getDeal());
                    baseOrder.setAvgPrice(StringUtils.toThousands((Number)details.getAvgPrice(), (int)4));
                    baseOrder.setDealAmount(details.getDeal() * details.getAvgPrice());
                    double exe = details.getDeal() / (double)baseOrder.getCount() * 100.0;
                    baseOrder.setExe(new BigDecimal(exe).setScale(2, 4).doubleValue());
                }
            }
            catch (MException e) {
                logger.error((Object)e);
            }
        }
    }
}

